/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.util.EmuUtil;

public abstract class UDPRelay
implements Runnable {
    protected static Log log = LogFactory.getLog(UDPRelay.class);
    protected static ExecutorService threadPool = Executors.newCachedThreadPool();
    protected DatagramChannel listenChannel;
    protected int listenPort;
    protected InetSocketAddress serverSocketAddress;
    protected Map<InetSocketAddress, ClientHandler> clients = Collections.synchronizedMap(new HashMap());

    public UDPRelay(int listenPort, InetSocketAddress serverSocketAddress) throws Exception {
        this.listenPort = listenPort;
        this.serverSocketAddress = serverSocketAddress;
        this.listenChannel = DatagramChannel.open();
        this.listenChannel.socket().bind(new InetSocketAddress(InetAddress.getLocalHost(), this.listenPort));
        log.info((Object)("Bound to port " + listenPort));
        threadPool.execute(this);
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public DatagramChannel getListenChannel() {
        return this.listenChannel;
    }

    public InetSocketAddress getServerSocketAddress() {
        return this.serverSocketAddress;
    }

    protected abstract ByteBuffer processClientToServer(ByteBuffer var1, InetSocketAddress var2, InetSocketAddress var3);

    protected abstract ByteBuffer processServerToClient(ByteBuffer var1, InetSocketAddress var2, InetSocketAddress var3);

    public void run() {
        log.info((Object)("Main port " + this.listenPort + " thread running..."));
        try {
            try {
                while (true) {
                    ByteBuffer buffer;
                    InetSocketAddress clientAddress;
                    ClientHandler clientHandler;
                    if ((clientHandler = this.clients.get(clientAddress = (InetSocketAddress)this.listenChannel.receive(buffer = ByteBuffer.allocate(2048)))) == null) {
                        try {
                            clientHandler = new ClientHandler(clientAddress);
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to start new ClientHandler for " + EmuUtil.formatSocketAddress(clientAddress)), (Throwable)e);
                            continue;
                        }
                        this.clients.put(clientAddress, clientHandler);
                        threadPool.execute(clientHandler);
                    }
                    buffer.flip();
                    clientHandler.send(buffer);
                }
            }
            catch (Exception e) {
                log.error((Object)("Main port " + this.listenPort + " thread caught exception: " + e.getMessage()), (Throwable)e);
                try {
                    this.listenChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                threadPool.shutdownNow();
            }
        }
        catch (Throwable throwable) {
            try {
                this.listenChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            threadPool.shutdownNow();
            throw throwable;
        }
        log.info((Object)("Main port " + this.listenPort + " thread exiting..."));
    }

    protected class ClientHandler
    implements Runnable {
        protected InetSocketAddress clientSocketAddress;
        protected DatagramChannel clientChannel;

        protected ClientHandler(InetSocketAddress clientSocketAddress) throws Exception {
            this.clientSocketAddress = clientSocketAddress;
            this.clientChannel = DatagramChannel.open();
            this.clientChannel.socket().bind(null);
            log.info((Object)("ClientHandler for " + EmuUtil.formatSocketAddress(clientSocketAddress) + " bound to port " + this.clientChannel.socket().getPort()));
        }

        protected void send(ByteBuffer buffer) throws Exception {
            ByteBuffer newBuffer = UDPRelay.this.processClientToServer(buffer, this.clientSocketAddress, UDPRelay.this.serverSocketAddress);
            this.clientChannel.send(newBuffer, UDPRelay.this.serverSocketAddress);
        }

        public void run() {
            log.info((Object)("ClientHandler thread for " + EmuUtil.formatSocketAddress(this.clientSocketAddress) + " runnning..."));
            try {
                try {
                    while (true) {
                        ByteBuffer buffer;
                        InetSocketAddress receiveAddress;
                        if (!(receiveAddress = (InetSocketAddress)this.clientChannel.receive(buffer = ByteBuffer.allocate(2048))).getAddress().equals(UDPRelay.this.serverSocketAddress.getAddress())) {
                            continue;
                        }
                        buffer.flip();
                        ByteBuffer newBuffer = UDPRelay.this.processServerToClient(buffer, receiveAddress, this.clientSocketAddress);
                        UDPRelay.this.listenChannel.send(newBuffer, this.clientSocketAddress);
                    }
                }
                catch (Exception e) {
                    log.info((Object)("ClientHandler thread for " + EmuUtil.formatSocketAddress(this.clientSocketAddress) + " caught exception: " + e.getMessage()), (Throwable)e);
                    try {
                        this.clientChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    UDPRelay.this.clients.remove(this.clientSocketAddress);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.clientChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                UDPRelay.this.clients.remove(this.clientSocketAddress);
                throw throwable;
            }
            log.info((Object)("ClientHandler thread for " + EmuUtil.formatSocketAddress(this.clientSocketAddress) + " exiting..."));
        }
    }
}

