
/* SI.C -- V1.0 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <io.h>
#include <dos.h>
#include "Z80.h"
#include "allegro.h"

extern volatile char key[128];

int flag = 0;
word base = 0x2400; 
byte *RAM;
byte *code_map;

byte port2,port4;

BITMAP *piccie3;

unsigned char pal[3*256];

char *roms[][1] = {{"invaders.h"},{"invaders.g"},{"invaders.f"},{"invaders.e"}};

FILE *map_file;
FILE *F;

reg StartRegs;
word ExitAdress;


/* //////////////functions ///////////////////////// */

void setcolor(char red, char green, char blue, unsigned short color)
{
 color = 3*color;
 pal[color++]=red;
 pal[color++]=green;
 pal[color]=blue;
}


/////////////////////////////////////////////////

void setpallete () {

  int count;

  outportb(0x3c8,0x00);
  for(count=0;count<768;count++)
    outportb(0x3c9,pal[count]);
}


//////////////////////////////////////////////

void setupvideo () {
	int teller;
	int  count1,count2;

	set_gfx_mode(GFX_VESA1,640,480,0,0);

/*
	for (teller=0;teller<256;teller++)
	    setcolor(0,0,0,teller);

  setcolor(255,0,0,1);
  setcolor(0,255,0,2);
  setcolor(255,255,255,3);
  */
  
  piccie3 = create_bitmap(256,256);

  for (count1=0;count1<256;count1++)
    for (count2=0;count2<256;count2++)
      piccie3->line[count1][count2] = 0;

/*  setpallete(); */
}


//////////////////////// m a i n /////////////////////////

int main(int argc,char *argv[]) {  

  int count, handle, res;
  char c;

  /* simple intro/licensing agreement starts here! */

  printf("S P A C E  I N V A D E R S: the emulator (V 1.0)\n\n");
  printf("Emulator core by Allard VanDerBas\n\n");
  printf("Z80 engine by Marat Fayzullin\n\n");
  printf("Allegro library by Shawn Hargreaves, DJGPP c. 1995,1996 DJ Delorie\n\n");
  printf("Space Invaders implementation by Glenn A. Neidermeier (Gandalf)\n");
  printf("neidermg@coral.indstate.edu     http://thunder.indstate.edu/~neider\n\n");
  printf("Based on information provided by Nemoto Yohei, Ignacio Escalza, \n");
  printf("Neil Bradley, and others whom I may have neglected to mention.\n\n");
  printf("This work may not be distributed for profit by any means, electronic\n");
  printf("or otherwise. This licensing agreement will be enforced under any\n");
  printf("and all applicable local and/or international copyright laws.\n\n");
  printf("Furthermore, the ROM images required for the effective use of \n");
  printf("this software remain under copyright by their manufacturer. You are \n");
  printf("only licensed to use the ROM images if you own the hardware that \n");
  printf("the images were licensed for use with. \n\n");
  printf("Do you agree to these terms? **The appropriate response is 'Y'** \n");
  c = getch();
  if (c =='Y' || c =='y')
	printf("\n\nGreat.... let's play SPACE INVADERS!\n\n\n");
  else
	return(0);
  
  printf("The keys are: 3-insert coin, 1 and 2 - start one or two player game,\n");
  printf("		arrows-left or right, control key fires, F1-pause, F2-resume,\n");
  printf("		 ESC-back to DOS, T-tilt \n\n");


  printf("Starting emulation\n");
  printf("Allocating 64Kb memory...");

  if(!(RAM=malloc(0x10000)))
  { puts("FAILED");return(0); }

  for (count=0;count<0x10000;count++)
    RAM[count] = 0;

  for (count=0;count<4;count++)
	{
	  printf("OK\nOpening file : %s...",roms[count][0]);
	  if(!(F=fopen(roms[count][0],"rb")))
	  { puts("FAILED");return(0); }
	  
	  printf("OK\nReading from file...");
	  if(fread(RAM + count * 0x0800,1,0x0800,F)!=0x0800)
	  { puts("FAILED");return(0); }

	  fclose(F);
	} 


  printf("\nAllocating 8K byte op_code table...");

  if(!(code_map=malloc(0x2000)))
  { puts("FAILED\n");return(0); }

  count = 0;
  do{
    code_map[count] = 0;	}
	while(count++<0x1FFF);


  printf("Running Code...\n");
  printf("Hit a key to begin.....\n");
  getch();

  allegro_init();
  setupvideo();
  clear(screen);
  install_keyboard(); 

  ExitAdress=Z80(StartRegs); 

  destroy_bitmap(piccie3);  
  set_gfx_mode(GFX_TEXT,80,25,0,0);   

  printf("EXITED at PC = %Xh.\n",ExitAdress);



   /* open a file for update */
  printf("opening map file....");	

  if ((handle = open("MAP_FILE.MAP", O_WRONLY | O_CREAT | O_TRUNC,
			 S_IREAD | S_IWRITE)) == -1)
      printf("Error opening file.\n");

  else {
	   if ((res = _write(handle, code_map, 0x02000)) != 0x02000)
		      printf("Error writing to the file.\n");

	   printf("Wrote %d bytes to the file.\n", res);

	   _close(handle);
	}



  free(RAM);
  free(code_map);

  printf("\n...DOS again!! :-( but thanx for playing!  :G\n");  

  exit(1);
}


//////////////////////////// F u n c t i o n s (required for Marat's code /////

byte M_RDMEM (word A){
	return RAM[A];       }


/////////////////////////////////////////

void M_WRMEM (word A,byte V)
{ 
	byte byte1, tempbyte;
	int teller, y, offset;

	if(A < 0x2000)                    //We're reading from the ROMs
		return; 

	else if(A > 0x1fff && A < 0x4400) //We're reading from RAM
		RAM[A] = V;

	if (A > 0x23FF && A < 0x4400)
			{
			byte1 = V;
			offset = A - 0x2400;
			teller = offset / 32;
			y = offset - teller * 32;			

		    tempbyte = byte1 & 0x80;
		    tempbyte = tempbyte >> 6;
		    piccie3 ->line[256-(y*8+7)][teller]/*[y*8 + 0]*/ =  tempbyte;  

		    tempbyte = byte1 & 0x40;
		    tempbyte = tempbyte >> 5;
		    piccie3->line[256-(y*8+6)][teller]/*[y*8 + 1]*/ =  tempbyte;  

		    tempbyte = byte1 & 0x20;
		    tempbyte = tempbyte >> 4;
		    piccie3->line[256-(y*8+5)][teller]/*[y*8 + 2]*/ =  tempbyte;  

		    tempbyte = byte1 & 0x10;
		    tempbyte = tempbyte >> 3;
		    piccie3->line[256-(y*8+4)][teller]/*[y*8 + 3]*/ =  tempbyte;  

		    tempbyte = byte1 & 0x08;
		    tempbyte = tempbyte >> 2;
		    piccie3->line[256-(y*8+3)][teller]/*[y*8 + 4]*/ =  tempbyte;  

		    tempbyte = byte1 & 0x04;
		    tempbyte = tempbyte >> 1;
		    piccie3 ->line[256-(y*8+2)][teller]/*[y*8 + 5]*/ =  tempbyte;  

		    tempbyte = byte1 & 0x02;
		    tempbyte = tempbyte >> 0;
		    piccie3 ->line[256-(y*8+1)][teller]/*[y*8 + 6]*/ =  tempbyte;  

		    tempbyte = byte1 & 0x01;
		    tempbyte = tempbyte << 1;
		    piccie3 ->line[256-(y*8+0)][teller]/*[y*8 + 7]*/ =  tempbyte;  
			}
}


////////////////////////////////////////////

word Interrupt(reg *R)
{
	int pause=0;
	extern int NMIflag, INTflag;
	char string[6]; 

	if (key[KEY_ESC]) 	CPURunning = 0; 
	if (key[KEY_F1])	pause = 1;

	while(pause ==1){
		if (key[KEY_F2]) pause = 0; } 

/*
	 itoa(R->PC.W,string,16);

	 textout(screen, font, "    ", 320, 0, 2);
	 textout(screen, font, string, 320, 0, 2); 
*/

	// show something on the screen !

	if (NMIflag)
		{
		NMIflag = 0;

		blit(piccie3,screen,0,0,10,10,248/*256*/,256);   

		return (0x0010);
	} /* end if NMIflag */

	if (INTflag)
		{
		INTflag = 0;

		blit(piccie3,screen,0,0,10,10,248/*256*/,256);   

		return(0x0008);
		}                	

	return(0xFFFF);		/* default */

} /* end Interrupt */


///////////////////////////////////////

byte DoIn(byte A)
{ 
byte V;
	
	if (A == 1){
		V = 137;
		if (key[KEY_3]) V&=255-1; 
		if (key[KEY_1])	V|=4;
		if (key[KEY_2]) V|=2; 
		if (key[KEY_LEFT])	V|=32;
		if (key[KEY_RIGHT]) V|=64; 
		if (key[KEY_CONTROL])	V|=16;

		return(V);
		}

	else if (A == 2){
		V = 0;
		if (key[KEY_LEFT])	V|=32;
		if (key[KEY_RIGHT]) V|=64; 
		if (key[KEY_CONTROL])	V|=16;
        if (key[KEY_T])		V|=4;
		return(V); 
		}

	else if (A == 3){
		V = port4 << ((port2 & 7));	
		return(V);	}

/*	else	
		return 0; */

	return(1);
}


////////////////////////////////////////////

void DoOut(byte A,byte V)
{
	if (A == 2){
		port2 = V; }
	else if (A == 4){
		port4 = V; }
}


///////////////////////////////////////////

void Patch (reg *R)
{
}


