//  Version Dec/20/1996
//
//  New in this version : Sprites are implemented, and it's now more playable.
//                        Enemy bombs are now visible :-) .
//
//  Keys : 1 insert coin.
//         3 start play.
//         <cursor keys> Move around (left and right).
//         <ESC>  exit the emulator.
//         <CTRL> fire.
//
//  Arcade emulator framework built by : Allard van der Bas.
//  Z80 engine by : Marat Fayzullin.
//  Sprite support + play support by : Ville Laitinen 
//
//  If you find out something useful, don't hesitate to submit it to :
//  The arcade emultion programming repository.
//
//  So it will be available to everyone at :
//  http://valhalla.ph.tn.tudelft.nl/emul8
//
//  Send it by email to :
//  avdbas@wi.leidenuniv.nl
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Z80.h"
#include <allegro.h>

extern volatile char key[128];

//#define XLEN 640
#define XLEN 256      // Choose your own videomode
#define YLEN 256      // By altering XLEN and YLEN
//#define YLEN 480

word base = 0x4800;   // Start of screen is at 0x4800
		      // Color attributes are at 0x4800 + 0x0400
byte *RAM;
byte *orgchar1;

byte *char1;

BITMAP *piccie;       // Temporary screen in memory

BITMAP *chars[256];         // All the characters
BITMAP *sprites[65];        // All the sprites

unsigned char pal[3*256];   // Placeholder for 256 colors

char *rom1 ="IC13";         // Rom files containing code
char *rom2 ="IC14";
char *rom3 ="IC15";
char *rom4 ="IC16";
char *rom5 ="IC17";
char *rom6 ="IC18";

char *rom7 ="IC55";       // Rom files containing music data
char *rom8 ="IC56";       // and routines

char *charset1  = "IC30"; // Rom containing characters
char *charset2  = "IC31"; // Rom containing sprites

int dirtyrec[0x1000];      // Possible optimization for screen refreshes.
			   // Currently not used.

FILE *F;                // File pointer used in all file handling
reg StartRegs;          // Register file for the Z80 emulator
word ExitAdress;        // Temp var used when emulator exits

void setcolor(char red, char green, char blue, unsigned short color)
{
// Doesn't actually set a color, just places it in the color array.

 color = 3*color;
 pal[color++]=red;
 pal[color++]=green;
 pal[color]=blue;
}

void setpallete () {
// Copy the color values to the video board (256 colors are set)

  int count;

  outportb(0x3c8,0x00);
  for(count=0;count<768;count++)
    outportb(0x3c9,pal[count]);
}

void setupvideo () {
int teller;
int  count1,count2;

  set_gfx_mode(GFX_AUTODETECT,XLEN,YLEN,0,0);  // Allegro routine to start video

  for (teller=0;teller<256;teller++)           // set all colors to black
    setcolor(0,0,0,teller);

  setcolor(255,0,0,1);                         // Set 3 colors just to notice 'em
  setcolor(0,255,0,2);                         // Totaly wrong ,but will be fixed
  setcolor(255,255,255,3);
 
  piccie = create_bitmap(256,256);             // Allocate memory for temp screen (in memory)

  for(count1=0;count1<256;count1++)
	chars[count1]=create_bitmap(8,8);      // Allocate memory for charset

  for(count1=0;count1<65;count1++)
	sprites[count1]=create_bitmap(16,16);  // Allocate memory for sprites

  for (count1=0;count1<256;count1++)
    for (count2=0;count2<256;count2++)
      piccie->line[count1][count2] = 0;        // Clear the temp screen

  setpallete();                                // Set the colors
}

void warpchars () {

  byte byte1,byte2,tempbyte;
  word offset;
  word x,y;
  int teller,no;
  int count,count1,count2;
  word line,colum;

  no=0;
  for (teller=0;teller<256;teller++) {

    offset = teller * 8;
    no=teller;
    for (y=0;y<8;y++) {

      byte1=orgchar1[offset+ y];
      byte2=orgchar1[offset+ y + 0x800];

      tempbyte = byte1 & 0x80;
      tempbyte = tempbyte >> 6;
      tempbyte = tempbyte + ((byte2 & 0x80) >> 7);
      chars[no]->line[0][7-y]=tempbyte;

      tempbyte = byte1 & 0x40;
      tempbyte = tempbyte >> 5;
      tempbyte = tempbyte + ((byte2 & 0x40) >> 6);
      chars[no]->line[1][7-y]=tempbyte;

      tempbyte = byte1 & 0x20;
      tempbyte = tempbyte >> 4;
      tempbyte = tempbyte + ((byte2 & 0x20) >> 5);
      chars[no]->line[2][7-y]=tempbyte;

      tempbyte = byte1 & 0x10;
      tempbyte = tempbyte >> 3;
      tempbyte = tempbyte + ((byte2 & 0x10) >> 4);
      chars[no]->line[3][7-y]=tempbyte;


      tempbyte = byte1 & 0x08;
      tempbyte = tempbyte >> 2;
      tempbyte = tempbyte + ((byte2 & 0x8) >> 3);
      chars[no]->line[4][7-y]=tempbyte;

      tempbyte = byte1 & 0x04;
      tempbyte = tempbyte >> 1;
      tempbyte = tempbyte + ((byte2 & 0x4) >> 2);
      chars[no]->line[5][7-y]=tempbyte;

      tempbyte = byte1 & 0x02;
      tempbyte = tempbyte + ((byte2 & 0x2) >> 1);
      chars[no]->line[6][7-y]=tempbyte;

      tempbyte = byte1 & 0x01;
      tempbyte = tempbyte << 1;
      tempbyte = tempbyte + (byte2 & 0x1);
      chars[no]->line[7][7-y]=tempbyte;
   
    }
  }
  printf("Got the characters\n");

  // Built sprites from the characters
  // The End uses only 128 characters and 32 sprites.
  for(count1=0;count1<64;count1++){
	blit(chars[count1*4], sprites[count1],0,0,8,0,8,8);
	blit(chars[count1*4+1], sprites[count1],0,0,8,8,8,8);
	blit(chars[count1*4+2], sprites[count1],0,0,0,0,8,8);
	blit(chars[count1*4+3], sprites[count1],0,0,0,8,8,8);
}

//  Routine to show all the 16x16 sprites.
//
  for (count=0;count<65;count++) {
    colum = (count*16) % 256;
    line  = (count / 16)*16;
    draw_sprite(piccie,sprites[count], colum, line);
  }

// Blast em to the screen
  blit(piccie,screen,0,0,0,0,256,256);
  getch();

/* Now would be a nice time to clear the screen...
   -V-
*/
  clear(piccie);
  blit(piccie,screen,0,0,0,0,256,256);
}

int main(int argc,char *argv[]) { 

int count;
 
  allegro_init();                       // Initialization for allegro
 
  IPeriod = 10000; // Tweaking this value will speed things up.
		   // (or slow them down :-) ).

  printf("Starting emultion\n");

  printf("Allocating 64Kb memory...");

  if(!(RAM=malloc(0x10000)))            // Allocate memory for CPU
  { puts("FAILED");return(0); }

  for (count=0;count<0x10000;count++)   // Clear the memory
    RAM[count] = 0;

  printf("OK\nAllocating 4Kb memory for charset...");

  if(!(orgchar1=malloc(0x1000)))        // Temporary space for original
  { puts("FAILED");return(0); }         // unwarped charset.

// Read the romfiles , character data and sprite data into
// their place.

  printf("OK\nOpening file : %s...",rom1);
  if(!(F=fopen(rom1,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",rom2);
  if(!(F=fopen(rom2,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM + 0x800,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",rom3);
  if(!(F=fopen(rom3,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM + 0x1000,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",rom4);
  if(!(F=fopen(rom4,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM + 0x1800,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",rom5);
  if(!(F=fopen(rom5,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM + 0x2000,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",rom6);
  if(!(F=fopen(rom6,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM + 0x2800,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",rom7);
  if(!(F=fopen(rom5,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM + 0x3000,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",rom8);
  if(!(F=fopen(rom6,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(RAM + 0x3800,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",charset1);
  if(!(F=fopen(charset1,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(orgchar1,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

  printf("OK\nOpening file : %s...",charset2);
  if(!(F=fopen(charset2,"rb")))
  { puts("FAILED");return(0); }
 
  printf("OK\nReading from file...");
  if(fread(orgchar1 + 0x800,1,0x800,F)!=0x800)
  { puts("FAILED");return(0); }

  fclose(F);

//
//  All files are read in now start the show. 
//

  printf("OK\nWarping charset and sprites and turning on video...\n");
  setupvideo ();
  warpchars ();

//  printf("Installing keyboard handler...\n");
//  Actually this i sonly corrupting the screen which is not in text mode -V-

  install_keyboard();                   // Allegro keyboard handler

  ExitAdress=Z80(StartRegs);            // Startup the emulator

  destroy_bitmap(piccie);               // Clear up memory
// Other Bitmaps also have to be cleaned up.
// Allegro does this when it exits, or gets a SIG, but it's
// good programming practice to clean up your mess.

/*
   Well, after my flow-of-mind-programming, I'd have to delete the entire
   source file after 'patching' ;) -V-
*/


  set_gfx_mode(GFX_TEXT,80,25,0,0);    // Back to textmode

  printf("EXITED at PC = %Xh.\n",ExitAdress);

  exit(1);
}

byte M_RDMEM (word A)
{
    int Jst1=0;         // Used in joystick handling

    if(A==0x8100)
    {
	if(key[KEY_LEFT]) Jst1|=16;   /* OR was what I was after here ;) -V-*/
	if(key[KEY_RIGHT]) Jst1|=32;
	if(key[KEY_CONTROL])  Jst1|=8;
	if(key[KEY_1])     Jst1|=4;
	return Jst1;
    }
   
    if(A==0x8101)
	 if(key[KEY_3]) return 1;
	 else return 0xff;

    if(A==0x8102) return 0;   // I reckon these are dipswitch settings
			      // That's why you get 99 lives after 1 coin ???

    return (RAM[A]);
}

void M_WRMEM (word A,byte V)
{
  if(A<0x4000) {
     // It's ROM , don't write it
  }
  else {
    RAM[A] = V;
    if(A>base && A<(base+0x800))
	dirtyrec[A-base]=1;             // If a write to video memory
  }                                     // occurs , it's invalidated
}                                       // could be used to speed things up
					// currently not used.
word Interrupt(reg *R)
{

static int count;

int X,Y;
int count1,count2,count3;
int offset;
  
   count++;

   if (count) {
// I'm fairly sure this is not correct, usually there's a latch
// somewhere to tell the video-hardware when it is not the correct time
// to update the visible screen.

     // show something on the screen !
     // It's slow, but will do for now

     for (Y=0;Y<32;Y++) {
       for (X=0;X<5;X++) {
	 offset = RAM[base + (31-Y)*32 + X];
		blit(chars[offset], piccie, 0, 0, Y*8, X*8, 8, 8);
       }
     }
/* now we'll draw the mothership, shifted to correct position -V- */

     for (Y=0;Y<32;Y++) {
      for (X=5;X<7;X++)  {
	 offset = RAM[base + (31-Y)*32 + X];
	 blit(chars[offset], piccie, 0, 0, ((Y*8+(char)RAM[0x500c])%256), X*8, 8, 8);
      }
     }

//mothership done, now draw until player
     for (Y=0;Y<32;Y++) {
       for (X=7;X<0x18;X++) {
	 offset = RAM[base + (31-Y)*32 + X];
		blit(chars[offset], piccie, 0, 0, Y*8, X*8, 8, 8);
       }
     }

// now the player, four rows, shifted to right position
     for (Y=0;Y<32;Y++) {
       for (X=0x18;X<0x1c;X++) {
	 offset = RAM[base + (31-Y)*32 + X];
	 blit(chars[offset], piccie, 0, 0, (unsigned char)((Y*8)+(char)RAM[0x5030]%256), X*8, 8, 8);
       }
     }
    

     //then the rest of screen;
     for (Y=0;Y<32;Y++) {
       for (X=0x1c;X<32;X++) {
	 offset = RAM[base + (31-Y)*32 + X];
	 blit(chars[offset], piccie, 0, 0, Y*8, X*8, 8, 8);
       }
     }

//  The bullet too...
piccie->line[251-RAM[0x507f]][RAM[0x507d]]=2;

/*
  the bombs bugs drop...
*/
// Cool , I was missing those. got unexplainably killed every time -A-

for(offset=0;offset<20;offset+=4)
  piccie->line[251-RAM[0x5063+offset]][RAM[0x5061+offset]]=1;

//Blit the sprites. Since the background is updated every time there's
//really no need to copy the backgrounds.
//btw. there is quite possibly a latch somewhere to disable sprites,
//haven't looked very throroughly.

    for(count1=0x5040;count1<0x5060;count1+=4) {
       count2=RAM[count1+1];
       count3=count2 >> 6;

//count3 now holds the flipping info 0x80 vertical 0x40 horiz, or was
//it the other way around...

       count2&=0x3f;
//there's only 0x40 possible sprites, besides above 0x40 is only the
//flipping info mentioned above.

       X=RAM[count1];Y=RAM[count1+3];
//See if you can guess :-)
//RAM[count1+2] is colour, I haven't figured a way to do it nicely with
//allegro...

      if(X && Y && count2)
      switch(count3) {
	case (0):  draw_sprite(piccie,sprites[count2], RAM[count1],RAM[count1+3]);break;
	case (1):  draw_sprite_v_flip(piccie,sprites[count2],RAM[count1], RAM[count1+3]);break;
	case (2):  draw_sprite_h_flip(piccie,sprites[count2],RAM[count1], RAM[count1+3]);break;
	default:  draw_sprite_vh_flip(piccie,sprites[count2],RAM[count1], RAM[count1+3]);break;
       }
    }
//I guess the few lines above are quite self-explanatory ?
//(they probably aren't right either ;)
//OK, all done with screen buffer, now let's blast it on screen...

/* As the few lines from 'top' and 'bottom' of the crt do not fit on
   a real screen we don't show them either... -V-
*/
     blit(piccie,screen,16,0,0,0,224,256);
     count=0;       
   }

//And back to our scheduled program... i.e NMI at address 0x0066
   if(key[KEY_ESC])
      CPURunning = 0;

   return(0x0066);
}

byte DoIn(byte A)
{
  return 0;
}

void DoOut(byte A,byte V)
{
}

void Patch (reg *R)
{
}


