/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import thoto.jamyda.controller.MainController;
import thoto.jamyda.data.AppConstants;
import thoto.jamyda.data.AppData;
import thoto.jamyda.data.CategoryData;
import thoto.jamyda.gui.MainFrame;
import thoto.jamyda.utils.GUIFactory;

public class ContextMenuFactory {
    public static JPopupMenu createPopupMenu(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof CategoryData) {
            return ContextMenuFactory.createCategoryContextMenu((CategoryData)data);
        }
        if (data instanceof AppData) {
            return ContextMenuFactory.createApplicationContextMenu((AppData)data);
        }
        return null;
    }

    private static JPopupMenu createCategoryContextMenu(CategoryData category) {
        if (category == null) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        MainFrame mf = GUIFactory.getMainFrame();
        CategoryData selCategory = MainController.getInstance().getSelectedCategory();
        boolean isEditableCategory = selCategory != AppConstants.CATEGORY_ALL && selCategory != AppConstants.CATEGORY_FAVORITES;
        JMenuItem itemAdd = new JMenuItem(GUIFactory.getBundle().getString("label.new"), new ImageIcon(mf.getClass().getResource("/res/icons/16x16/Computer_File_060.gif")));
        itemAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryData parent = MainController.getInstance().getSelectedCategory();
                if (parent == AppConstants.CATEGORY_ALL || parent == AppConstants.CATEGORY_FAVORITES) {
                    parent = null;
                }
                MainController.getInstance().onEditCategory(parent, null);
            }
        });
        JMenuItem itemEdit = new JMenuItem(GUIFactory.getBundle().getString("label.edit"), new ImageIcon(mf.getClass().getResource("/res/icons/16x16/Computer_File_061.gif")));
        itemEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.getInstance().onEditCategory(null, MainController.getInstance().getSelectedCategory());
            }
        });
        itemEdit.setEnabled(isEditableCategory);
        JMenuItem itemRemove = new JMenuItem(GUIFactory.getBundle().getString("label.delete"), new ImageIcon(mf.getClass().getResource("/res/icons/16x16/Computer_File_062.gif")));
        itemRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.getInstance().onRemoveCategory(MainController.getInstance().getSelectedCategory());
            }
        });
        itemRemove.setEnabled(isEditableCategory);
        popupMenu.add(itemAdd);
        popupMenu.add(itemEdit);
        popupMenu.addSeparator();
        popupMenu.add(itemRemove);
        return popupMenu;
    }

    private static JPopupMenu createApplicationContextMenu(AppData appData) {
        if (appData == null) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        MainFrame mf = GUIFactory.getMainFrame();
        JMenuItem itemAdd = new JMenuItem(GUIFactory.getBundle().getString("label.new"), new ImageIcon(mf.getClass().getResource("/res/icons/16x16/Computer_File_050.gif")));
        itemAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.getInstance().onEditApplication(null);
            }
        });
        JMenuItem itemEdit = new JMenuItem(GUIFactory.getBundle().getString("label.edit"), new ImageIcon(mf.getClass().getResource("/res/icons/16x16/Computer_File_052.gif")));
        itemEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppData data = (AppData)GUIFactory.getMainFrame().getLstApplications().getSelectedValue();
                MainController.getInstance().onEditApplication(data);
            }
        });
        int[] selIndicesApp = GUIFactory.getMainFrame().getLstApplications().getSelectedIndices();
        boolean isSingleSel = selIndicesApp.length == 1;
        itemEdit.setEnabled(isSingleSel);
        JMenuItem itemRemove = new JMenuItem(GUIFactory.getBundle().getString("label.delete"), new ImageIcon(mf.getClass().getResource("/res/icons/16x16/Computer_File_051.gif")));
        itemRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.getInstance().onRemoveApplications();
            }
        });
        popupMenu.add(itemAdd);
        popupMenu.add(itemEdit);
        popupMenu.addSeparator();
        popupMenu.add(itemRemove);
        return popupMenu;
    }
}

