/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;
import thoto.jamyda.controller.BrowseAction;
import thoto.jamyda.controller.MainController;
import thoto.jamyda.data.AppData;
import thoto.jamyda.data.CategoryData;
import thoto.jamyda.data.DataFile;
import thoto.jamyda.gui.DlgAppSettings;
import thoto.jamyda.gui.DlgDosboxConfigurations;
import thoto.jamyda.utils.DataUtils;
import thoto.jamyda.utils.GUIFactory;
import thoto.jamyda.utils.IconFileFilter;

public class CtrlAppSettings {
    private DlgAppSettings dialog = new DlgAppSettings(GUIFactory.getMainFrame());
    private boolean isApplied;
    private AppData data;

    public CtrlAppSettings() {
        this.dialog.getBttApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlAppSettings.this.isApplied = true;
                CtrlAppSettings.this.getDialog().dispose();
            }
        });
        this.dialog.getBttCancel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlAppSettings.this.isApplied = false;
                CtrlAppSettings.this.getDialog().dispose();
            }
        });
        this.dialog.getBttOpenDosboxConfigurations().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlAppSettings.this.getData();
                GUIFactory.getCtrlDosboxConfigurations().setData(null);
                DlgDosboxConfigurations dlg = GUIFactory.getCtrlDosboxConfigurations().getDialog();
                dlg.setVisible(true);
                CtrlAppSettings.this.setData(CtrlAppSettings.this.data);
                if (dlg.getLstConfigurations().getSelectedIndices().length == 1) {
                    CtrlAppSettings.this.getDialog().getCmbDosBoxSettings().setSelectedIndex(dlg.getLstConfigurations().getSelectedIndex());
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CtrlAppSettings.this.onUpdateGUI();
            }
        };
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                CtrlAppSettings.this.onUpdateGUI();
            }
        };
        this.dialog.getTfAppName().addKeyListener(keyListener);
        this.dialog.getTfAppName().addCaretListener(caretListener);
        this.dialog.getTfAppIconPath().addKeyListener(keyListener);
        this.dialog.getTfAppIconPath().addCaretListener(caretListener);
        this.dialog.getTfAppPath().addKeyListener(keyListener);
        this.dialog.getTfAppPath().addCaretListener(caretListener);
        this.dialog.getCmbDosBoxSettings().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlAppSettings.this.onUpdateGUI();
            }
        });
        this.dialog.getBttBrowseIcon().setAction(new BrowseAction(false, this.dialog.getTfAppIconPath(), (FileFilter)new IconFileFilter()));
        this.dialog.getBttBrowseExecutable().setAction(new BrowseAction(false, this.dialog.getTfAppPath()));
        this.onUpdateGUI();
    }

    private void onUpdateGUI() {
        boolean isFullFilled;
        boolean bl = isFullFilled = DataUtils.isFilenameValid(this.dialog.getTfAppPath().getText(), true, false, this.dialog.getTfAppPath()) && this.dialog.getTfAppPath().getText().trim().length() > 0 && this.dialog.getCmbDosBoxSettings().getSelectedIndex() != -1 && (this.dialog.getTfAppName().getText().trim().length() > 0 || this.dialog.getTfAppIconPath().getText().trim().length() > 0);
        if (this.dialog.getTfAppIconPath().getText().trim().length() > 0) {
            isFullFilled &= DataUtils.isFilenameValid(this.dialog.getTfAppIconPath().getText(), true, false, this.dialog.getTfAppIconPath());
        } else {
            DataUtils.isFilenameValid(this.dialog.getTfAppIconPath().getText(), false, false, this.dialog.getTfAppIconPath());
        }
        this.dialog.getBttApply().setEnabled(isFullFilled);
    }

    public void setData(Object data) {
        this.data = null;
        if (data instanceof AppData) {
            this.data = (AppData)data;
        }
        this.dialog.getCmbCategory().removeAllItems();
        this.dialog.getCmbCategory().addItem(new CategoryData(" ", null));
        List<String> catPathList = DataUtils.getAvailableCategoryPathList();
        if (catPathList != null) {
            int a = 0;
            int z = catPathList.size();
            while (a < z) {
                this.dialog.getCmbCategory().addItem(catPathList.get(a));
                ++a;
            }
        }
        String dbConfig = "";
        int selDBSettingsIndex = -1;
        if (this.data != null && this.data.getDosboxConfigPath() != null) {
            dbConfig = this.data.getDosboxConfigPath();
        }
        this.dialog.getCmbDosBoxSettings().removeAllItems();
        List<DataFile> fileList = DataUtils.getAvailableDBConfigurations();
        if (fileList != null) {
            int a = 0;
            int z = fileList.size();
            while (a < z) {
                DataFile dataFile = fileList.get(a);
                if (selDBSettingsIndex == -1 && dbConfig != null && dbConfig.equals(dataFile.toString())) {
                    selDBSettingsIndex = a;
                }
                this.dialog.getCmbDosBoxSettings().addItem(dataFile);
                ++a;
            }
        }
        if (this.data != null) {
            this.dialog.getTfAppName().setText(this.data.getAppName());
            this.dialog.getTfAppIconPath().setText(this.data.getAppIconPath());
            this.dialog.getTfAppPath().setText(this.data.getAppPath());
            this.dialog.getCmbCategory().setSelectedItem(this.data.getCategoryPath());
            this.dialog.getChbAddToFavorites().setSelected(this.data.isAddedToFavorites());
            this.dialog.getTfAdditionalDBCommands().setText(this.data.getAdditionalDBCommands());
            this.dialog.getCmbDosBoxSettings().setSelectedIndex(selDBSettingsIndex);
            this.dialog.getTaRemark().setText(this.data.getRemark());
        } else {
            this.dialog.getTfAppName().setText(null);
            this.dialog.getTfAppIconPath().setText(null);
            this.dialog.getTfAppPath().setText(null);
            CategoryData selCat = MainController.getInstance().getSelectedCategory();
            if (selCat != null) {
                this.dialog.getCmbCategory().setSelectedItem(selCat.getPath());
            }
            this.dialog.getChbAddToFavorites().setSelected(false);
            this.dialog.getTfAdditionalDBCommands().setText(null);
            this.dialog.getTaRemark().setText(null);
        }
    }

    public Object getData() {
        if (this.data == null) {
            this.data = new AppData();
        }
        this.data.setAppName(this.getDialog().getTfAppName().getText());
        this.data.setAppIconPath(this.getDialog().getTfAppIconPath().getText());
        this.data.setAppPath(this.getDialog().getTfAppPath().getText());
        if (this.getDialog().getCmbCategory().getSelectedItem() != null) {
            this.data.setCategoryPath(this.getDialog().getCmbCategory().getSelectedItem().toString());
        } else {
            this.data.setCategoryPath(null);
        }
        this.data.setAddedToFavorites(this.getDialog().getChbAddToFavorites().isSelected());
        this.data.setAdditionalDBCommands(this.getDialog().getTfAdditionalDBCommands().getText());
        if (this.getDialog().getCmbDosBoxSettings().getSelectedItem() != null) {
            this.data.setDosboxConfigPath(this.getDialog().getCmbDosBoxSettings().getSelectedItem().toString());
        } else {
            this.data.setDosboxConfigPath(null);
        }
        this.data.setRemark(this.getDialog().getTaRemark().getText());
        return this.data;
    }

    public DlgAppSettings getDialog() {
        return this.dialog;
    }

    public boolean isApplied() {
        return this.isApplied;
    }
}

