/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.io.File;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import thoto.jamyda.data.JProperties;
import thoto.jamyda.utils.GUIFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppData
extends JLabel
implements Serializable,
Comparable<AppData> {
    private static final long serialVersionUID = -7769016934902298268L;
    private String appName;
    private String appIconPath;
    private String appPath;
    private String additionalDBCommands;
    private String dosboxConfigPath;
    private String remark;
    private String categoryPath;
    private boolean isAddedToFavorites;
    private Icon icon;
    private String filename;

    public AppData() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public boolean load(String filename) {
        try {
            JProperties p = new JProperties(filename);
            if (p.exists()) {
                this.setAppName(p.getString("appName"));
                this.setAppIconPath(p.getString("appIconPath"));
                this.setAppPath(p.getString("appPath"));
                this.setAdditionalDBCommands(p.getString("additionalDosboxCommands"));
                this.setDosboxConfigPath(p.getString("dosboxConfigPath"));
                this.setRemark(p.getString("remark"));
                this.setCategoryPath(p.getString("categoryPath"));
                this.setAddedToFavorites(p.getBoolean("isInFavorites"));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void save() {
        JProperties p = new JProperties(this.getFilename());
        p.setString("appName", this.getAppName());
        p.setString("appIconPath", this.getAppIconPath());
        p.setString("appPath", this.getAppPath());
        p.setString("additionalDosboxCommands", this.getAdditionalDBCommands());
        p.setString("dosboxConfigPath", this.getDosboxConfigPath());
        p.setString("remark", this.getRemark());
        p.setString("categoryPath", this.getCategoryPath());
        p.setBoolean("isInFavorites", this.isAddedToFavorites());
        p.save();
    }

    @Override
    public int compareTo(AppData o) {
        return this.getAppName().compareTo(o.getAppName());
    }

    @Override
    public String toString() {
        return this.getAppName();
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getText() {
        return this.getAppName();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
        this.filename = "config/apps/" + appName + ".jamyda";
    }

    public String getAppIconPath() {
        return this.appIconPath;
    }

    public void setAppIconPath(String appIconPath) {
        File f;
        this.appIconPath = appIconPath;
        this.icon = null;
        if (appIconPath != null && appIconPath.trim().length() > 0 && (f = new File(appIconPath)).exists()) {
            this.icon = new ImageIcon(appIconPath);
        }
        if (this.icon == null) {
            this.icon = GUIFactory.getDefaultAppIcon();
        }
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getDosboxConfigPath() {
        return this.dosboxConfigPath;
    }

    public void setDosboxConfigPath(String dosboxConfigPath) {
        this.dosboxConfigPath = dosboxConfigPath;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getAdditionalDBCommands() {
        return this.additionalDBCommands;
    }

    public void setAdditionalDBCommands(String additionalDBCommands) {
        this.additionalDBCommands = additionalDBCommands;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public void setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }

    public boolean isAddedToFavorites() {
        return this.isAddedToFavorites;
    }

    public void setAddedToFavorites(boolean isAddedToFavorites) {
        this.isAddedToFavorites = isAddedToFavorites;
    }
}

