/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.util.ArrayList;
import java.util.List;
import thoto.jamyda.data.AbstractData;
import thoto.jamyda.data.SectionData;
import thoto.jamyda.utils.DataUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupData
extends AbstractData {
    private List<SectionData> sectionList;

    public GroupData(String name) {
        super(name);
    }

    public void add(SectionData section) {
        if (section == null) {
            return;
        }
        if (this.sectionList == null) {
            this.sectionList = new ArrayList<SectionData>();
        }
        if (!this.sectionList.contains(section)) {
            this.sectionList.add(section);
        }
    }

    @Override
    public String toXML(String indent) {
        if (indent == null) {
            indent = "";
        }
        String s = "\n" + indent + "<" + "group" + " " + "name" + "=\"" + DataUtils.toValidXML(this.getName()) + "\"" + ">";
        if (this.sectionList != null) {
            int a = 0;
            int z = this.sectionList.size();
            while (a < z) {
                s = String.valueOf(s) + this.sectionList.get(a).toXML(String.valueOf(indent) + "  ");
                ++a;
            }
        }
        s = String.valueOf(s) + "\n" + indent + "</" + "group" + ">";
        return s;
    }

    @Override
    public AbstractData getClone() {
        GroupData clone = new GroupData(this.getName());
        if (this.getSectionList() != null) {
            int a = 0;
            int z = this.getSectionList().size();
            while (a < z) {
                clone.add((SectionData)this.getSectionList().get(a).getClone());
                ++a;
            }
        }
        return clone;
    }

    @Override
    public String toDosBox() {
        String str = "";
        if (this.getSectionList() != null) {
            int a = 0;
            int z = this.getSectionList().size();
            while (a < z) {
                str = String.valueOf(str) + this.getSectionList().get(a).toDosBox();
                ++a;
            }
        }
        return str;
    }

    @Override
    public int getElementCount() {
        if (this.sectionList != null) {
            return this.sectionList.size();
        }
        return 0;
    }

    public List<SectionData> getSectionList() {
        return this.sectionList;
    }
}

