/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.gui;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import thoto.jamyda.controller.ExceptionHandler;
import thoto.jamyda.controller.MainController;
import thoto.jamyda.data.AppConstants;
import thoto.jamyda.data.AppData;
import thoto.jamyda.data.AppTransferable;
import thoto.jamyda.data.CategoryData;

public class CategoryTree
extends JTree
implements DropTargetListener,
Autoscroll {
    private static final int AUTOSCROLL_MARGIN = 6;

    public CategoryTree() {
        this.setDropTarget(new DropTarget(this, this));
    }

    private CategoryData getCurrentDropCategory(DropTargetDragEvent dtde) {
        Point dropPoint = dtde.getLocation();
        TreePath dropPath = this.getPathForLocation(dropPoint.x, dropPoint.y);
        if (dropPath != null) {
            return (CategoryData)((DefaultMutableTreeNode)dropPath.getLastPathComponent()).getUserObject();
        }
        return null;
    }

    public void dragOver(DropTargetDragEvent dtde) {
        Point dragPoint = dtde.getLocation();
        TreePath path = this.getPathForLocation(dragPoint.x, dragPoint.y);
        this.setSelectionPath(path);
        this.repaint();
        CategoryData curCat = this.getCurrentDropCategory(dtde);
        if (AppConstants.CATEGORY_ALL != curCat) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        Point dropPoint = dtde.getLocation();
        TreePath dropPath = this.getPathForLocation(dropPoint.x, dropPoint.y);
        if (dropPath == null) {
            dtde.dropComplete(false);
            return;
        }
        CategoryData targetCategory = (CategoryData)((DefaultMutableTreeNode)dropPath.getLastPathComponent()).getUserObject();
        String newCategoryPath = CategoryData.getPath(dropPath);
        boolean dropped = false;
        try {
            dtde.acceptDrop(1);
            Object droppedObject = dtde.getTransferable().getTransferData(AppTransferable.LOCAL_OBJECT_FLAVOR);
            if (droppedObject instanceof List) {
                List appDataList = (List)droppedObject;
                int a = 0;
                int z = appDataList.size();
                while (a < z) {
                    AppData appData = (AppData)appDataList.get(a);
                    if (AppConstants.CATEGORY_FAVORITES == targetCategory) {
                        appData.setAddedToFavorites(true);
                    } else {
                        appData.setCategoryPath(newCategoryPath);
                    }
                    appData.save();
                    ++a;
                }
            }
            MainController.getInstance().updateApplicationList();
            dropped = true;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        dtde.dropComplete(dropped);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void autoscroll(Point cursorLocn) {
        int currentRow = this.getRowForLocation(cursorLocn.x, cursorLocn.y);
        Rectangle outerBounds = this.getBounds();
        currentRow = cursorLocn.y + outerBounds.y <= 6 ? (currentRow < 1 ? 0 : currentRow - 1) : (currentRow < this.getRowCount() - 1 ? currentRow + 1 : currentRow);
        this.scrollRowToVisible(currentRow);
    }

    public Insets getAutoscrollInsets() {
        Rectangle outerBounds = this.getBounds();
        Rectangle innerBounds = this.getParent().getBounds();
        return new Insets(innerBounds.y - outerBounds.y + 6, innerBounds.x - outerBounds.x + 6, outerBounds.height - innerBounds.height - innerBounds.y + outerBounds.y + 6, outerBounds.width - innerBounds.width - innerBounds.x + outerBounds.x + 6);
    }
}

