/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thoto.jamyda.controller.ExceptionHandler;
import thoto.jamyda.controller.MainController;
import thoto.jamyda.data.DataFile;
import thoto.jamyda.data.DosboxSettingsData;
import thoto.jamyda.gui.DlgDosBoxSettings;
import thoto.jamyda.gui.DlgDosboxConfigurations;
import thoto.jamyda.utils.DataUtils;
import thoto.jamyda.utils.GUIFactory;

public class CtrlDosboxConfigurations {
    private DlgDosboxConfigurations dialog = new DlgDosboxConfigurations(GUIFactory.getMainFrame());
    private boolean isApplied;
    private List<DataFile> dataFileList;

    public CtrlDosboxConfigurations() {
        this.dialog.getBttApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxConfigurations.this.isApplied = true;
                CtrlDosboxConfigurations.this.getDialog().dispose();
            }
        });
        this.dialog.getBttAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxConfigurations.this.onAddDefault();
            }
        });
        this.dialog.getBttEdit().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxConfigurations.this.onEdit();
            }
        });
        this.dialog.getBttDuplicate().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxConfigurations.this.onDuplicate();
            }
        });
        this.dialog.getBttDelete().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxConfigurations.this.onDelete();
            }
        });
        this.dialog.getLstConfigurations().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CtrlDosboxConfigurations.this.onUpdateGUI();
            }
        });
        this.dialog.getLstConfigurations().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    CtrlDosboxConfigurations.this.onEdit();
                }
            }
        });
        this.onUpdateGUI();
    }

    private void onUpdateGUI() {
        int[] selIndices = this.dialog.getLstConfigurations().getSelectedIndices();
        boolean isMultiSel = selIndices.length > 1;
        boolean isSel = selIndices.length > 0;
        this.dialog.getBttEdit().setEnabled(isSel && !isMultiSel);
        this.dialog.getBttDuplicate().setEnabled(isSel && !isMultiSel);
        this.dialog.getBttDelete().setEnabled(isSel);
    }

    private void onAddDefault() {
        DlgDosBoxSettings dlg = GUIFactory.getCtrlDosboxSettings().getDialog();
        DosboxSettingsData clonedData = (DosboxSettingsData)MainController.getInstance().getDefaultDosboxSettingsData().getClone();
        GUIFactory.getCtrlDosboxSettings().setData(clonedData);
        dlg.setVisible(true);
        if (GUIFactory.getCtrlDosboxSettings().isApplied()) {
            clonedData = GUIFactory.getCtrlDosboxSettings().getData();
            File file = new File("config/dosbox/" + clonedData.getName() + ".xml");
            DataUtils.storeDataToFile(clonedData, file, 0);
            this.setData(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onEdit() {
        GUIFactory.showWaitCursor(this.getDialog());
        try {
            if (this.getDialog().getLstConfigurations().getSelectedIndices().length > 1) {
                return;
            }
            DataFile dataFile = (DataFile)this.getDialog().getLstConfigurations().getSelectedValue();
            if (dataFile == null) {
                return;
            }
            DlgDosBoxSettings dlg = GUIFactory.getCtrlDosboxSettings().getDialog();
            DosboxSettingsData data = DataUtils.loadDBSettings(dataFile.getFile().getAbsolutePath());
            String oldName = data.getName();
            GUIFactory.getCtrlDosboxSettings().setData(data);
            dlg.setVisible(true);
            if (GUIFactory.getCtrlDosboxSettings().isApplied()) {
                File file;
                data = GUIFactory.getCtrlDosboxSettings().getData();
                if (!oldName.equals(data.getName())) {
                    file = new File("config/dosbox/" + oldName + ".xml");
                    file.delete();
                }
                file = new File("config/dosbox/" + data.getName() + ".xml");
                DataUtils.storeDataToFile(data, file, 0);
            }
            this.setData(null);
            return;
        }
        finally {
            GUIFactory.resetCursor(this.getDialog());
        }
    }

    private void onDuplicate() {
        if (this.getDialog().getLstConfigurations().getSelectedIndices().length > 1) {
            return;
        }
        DataFile dataFile = (DataFile)this.getDialog().getLstConfigurations().getSelectedValue();
        if (dataFile == null) {
            return;
        }
        DosboxSettingsData sourceData = DataUtils.loadDBSettings(dataFile.getFile().getAbsolutePath());
        DosboxSettingsData duplicateData = (DosboxSettingsData)sourceData.getClone();
        duplicateData.setName(String.valueOf(GUIFactory.getBundle().getString("label.copy.of")) + " " + duplicateData.getName());
        File file = new File("config/dosbox/" + duplicateData.getName() + ".xml");
        DataUtils.storeDataToFile(duplicateData, file, 0);
        this.setData(null);
    }

    private void onDelete() {
        int[] indices = this.getDialog().getLstConfigurations().getSelectedIndices();
        if (indices.length > 0 && this.dataFileList != null && JOptionPane.showConfirmDialog(GUIFactory.getMainFrame(), GUIFactory.getBundle().getString("message.delete.selected.elements"), GUIFactory.getBundle().getString("title.delete.elements"), 0) == 0) {
            try {
                int a = indices.length - 1;
                while (a >= 0) {
                    DataFile df = this.dataFileList.get(indices[a]);
                    if (df.getFile() != null) {
                        df.getFile().delete();
                    }
                    --a;
                }
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
            }
            this.setData(null);
        }
    }

    public void setData(Object data) {
        this.dataFileList = DataUtils.getAvailableDBConfigurations();
        this.dialog.getLstConfigurations().setListData(this.dataFileList.toArray());
    }

    public Object getData() {
        return this.dataFileList;
    }

    public DlgDosboxConfigurations getDialog() {
        return this.dialog;
    }

    public boolean isApplied() {
        return this.isApplied;
    }
}

