/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JOptionPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import thoto.jamyda.controller.BrowseAction;
import thoto.jamyda.data.JamydaData;
import thoto.jamyda.gui.DlgJamydaSettings;
import thoto.jamyda.utils.DataUtils;
import thoto.jamyda.utils.GUIFactory;

public class CtrlJamydaSettings {
    private DlgJamydaSettings dialog = new DlgJamydaSettings(GUIFactory.getMainFrame());
    private JamydaData data;
    private boolean isApplied;

    public CtrlJamydaSettings() {
        this.dialog.getBttApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlJamydaSettings.this.isApplied = true;
                CtrlJamydaSettings.this.getDialog().dispose();
            }
        });
        this.dialog.getBttCancel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlJamydaSettings.this.isApplied = false;
                CtrlJamydaSettings.this.getDialog().dispose();
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CtrlJamydaSettings.this.onUpdateGUI();
            }
        };
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                CtrlJamydaSettings.this.onUpdateGUI();
            }
        };
        this.dialog.getTfDosboxPath().addKeyListener(keyListener);
        this.dialog.getTfDosboxPath().addCaretListener(caretListener);
        this.dialog.getBttBrowseExecutable().setAction(new BrowseAction(false, this.dialog.getTfDosboxPath()));
        this.onUpdateGUI();
    }

    private void onUpdateGUI() {
        boolean isFullFilled = DataUtils.isFilenameValid(this.dialog.getTfDosboxPath().getText(), true, false, this.dialog.getTfDosboxPath());
        this.dialog.getBttApply().setEnabled(isFullFilled);
    }

    public void setData(Object data) {
        this.data = null;
        if (data instanceof JamydaData) {
            this.data = (JamydaData)data;
            this.getDialog().getTfDosboxPath().setText(this.data.getDosboxPath());
            this.getDialog().getCmbLanguage().removeAllItems();
            int selInd = 0;
            if (this.data.getLanguageList() != null) {
                int a = 0;
                int z = this.data.getLanguageList().size();
                while (a < z) {
                    String[] str = this.data.getLanguageList().get(a).split(";");
                    this.getDialog().getCmbLanguage().addItem(str[0]);
                    if (str.length > 1 && str[1].equalsIgnoreCase(this.data.getLanguage())) {
                        selInd = a;
                    }
                    ++a;
                }
            }
            if (selInd < this.getDialog().getCmbLanguage().getItemCount()) {
                this.getDialog().getCmbLanguage().setSelectedIndex(selInd);
            }
        }
    }

    public Object getData() {
        if (this.data != null) {
            this.data.setDosboxPath(this.getDialog().getTfDosboxPath().getText());
            String oldLanguage = this.data.getLanguage();
            int selInd = this.getDialog().getCmbLanguage().getSelectedIndex();
            String[] str = this.data.getLanguageList().get(selInd).split(";");
            if (str.length > 1) {
                this.data.setLanguage(str[1]);
            }
            if (!oldLanguage.equals(this.data.getLanguage())) {
                JOptionPane.showMessageDialog(GUIFactory.getMainFrame(), GUIFactory.getBundle().getString("message.language.changed"), GUIFactory.getBundle().getString("title.information"), 1);
            }
        }
        return this.data;
    }

    public DlgJamydaSettings getDialog() {
        return this.dialog;
    }

    public boolean isApplied() {
        return this.isApplied;
    }
}

