/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.util.ArrayList;
import java.util.List;
import thoto.jamyda.data.AbstractData;
import thoto.jamyda.data.GroupData;
import thoto.jamyda.utils.DataUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosboxSettingsData
extends AbstractData {
    private String dbVersion;
    private List<GroupData> groupList;

    public DosboxSettingsData(String name, String dbVersion) {
        super(name);
        this.dbVersion = dbVersion;
    }

    public void add(GroupData group) {
        if (group == null) {
            return;
        }
        if (this.groupList == null) {
            this.groupList = new ArrayList<GroupData>();
        }
        if (!this.groupList.contains(group)) {
            this.groupList.add(group);
        }
    }

    @Override
    public String toXML(String indent) {
        if (indent == null) {
            indent = "";
        }
        String s = "<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>\n" + indent + "<" + "configfile" + " " + "name" + "=\"" + DataUtils.toValidXML(this.getName()) + "\"" + " " + "dosboxversion" + "=\"" + DataUtils.toValidXML(this.getDbVersion()) + "\"" + ">";
        if (this.groupList != null) {
            int a = 0;
            int z = this.groupList.size();
            while (a < z) {
                s = String.valueOf(s) + this.groupList.get(a).toXML(String.valueOf(indent) + "  ");
                ++a;
            }
        }
        s = String.valueOf(s) + "\n" + indent + "</" + "configfile" + ">";
        return s;
    }

    @Override
    public AbstractData getClone() {
        DosboxSettingsData clone = new DosboxSettingsData(this.getName(), this.getDbVersion());
        if (this.getGroupList() != null) {
            int a = 0;
            int z = this.getGroupList().size();
            while (a < z) {
                clone.add((GroupData)this.getGroupList().get(a).getClone());
                ++a;
            }
        }
        return clone;
    }

    @Override
    public String toDosBox() {
        String str = "";
        if (this.getGroupList() != null) {
            int a = 0;
            int z = this.getGroupList().size();
            while (a < z) {
                str = String.valueOf(str) + this.getGroupList().get(a).toDosBox();
                ++a;
            }
        }
        return str;
    }

    @Override
    public int getElementCount() {
        if (this.groupList != null) {
            return this.groupList.size();
        }
        return 0;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public List<GroupData> getGroupList() {
        return this.groupList;
    }
}

