/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.utils;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import thoto.jamyda.controller.BrowseAction;
import thoto.jamyda.controller.CtrlAppSettings;
import thoto.jamyda.controller.CtrlDosboxConfigurations;
import thoto.jamyda.controller.CtrlDosboxSettings;
import thoto.jamyda.controller.CtrlJamydaSettings;
import thoto.jamyda.controller.ExceptionHandler;
import thoto.jamyda.data.DosboxSettingsData;
import thoto.jamyda.data.GroupData;
import thoto.jamyda.data.ItemData;
import thoto.jamyda.data.SectionData;
import thoto.jamyda.gui.JamydaComponent;
import thoto.jamyda.gui.MainFrame;
import thoto.jamyda.interfaces.IItemType;
import thoto.jamyda.utils.DataUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIFactory {
    private static MainFrame mainFrame;
    private static CtrlAppSettings ctrlAppSettings;
    private static CtrlDosboxSettings ctrlDosboxSettings;
    private static CtrlJamydaSettings ctrlJamydaSettings;
    private static CtrlDosboxConfigurations ctrlDosboxConfigurations;

    public static MainFrame getMainFrame() {
        if (mainFrame == null) {
            mainFrame = new MainFrame();
        }
        return mainFrame;
    }

    public static void gotoLine(JTextComponent component, int line) {
        Element root = component.getDocument().getDefaultRootElement();
        line = Math.max(line, 1);
        line = Math.min(line, root.getElementCount());
        component.setCaretPosition(root.getElement(line - 1).getStartOffset());
    }

    public static void showWaitCursor(Component c) {
        if (c == null) {
            return;
        }
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void resetCursor(Component c) {
        if (c == null) {
            return;
        }
        c.setCursor(null);
    }

    public static ImageIcon getDefaultAppIcon() {
        try {
            return new ImageIcon(GUIFactory.getMainFrame().getClass().getResource("/res/icons/32x32/Rectangle_Green.png"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ResourceBundle getBundle() {
        return ResourceBundle.getBundle("thoto.jamyda.i18n.jamyda");
    }

    public static JComponent create(DosboxSettingsData data, List<JamydaComponent> jamydaCompList) {
        block6: {
            if (jamydaCompList == null) {
                jamydaCompList = new ArrayList<JamydaComponent>(0);
            }
            if (data != null) break block6;
            return null;
        }
        try {
            JTabbedPane tabbedPane = new JTabbedPane();
            int a = 0;
            int z = data.getGroupList().size();
            while (a < z) {
                JamydaComponent comp = GUIFactory.createGroupComp(data.getGroupList().get(a), jamydaCompList);
                if (comp != null) {
                    tabbedPane.addTab(comp.getData().getName(), comp.getComponent());
                }
                ++a;
            }
            return tabbedPane;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return null;
        }
    }

    private static JamydaComponent createGroupComp(GroupData data, List<JamydaComponent> jamydaCompList) {
        if (data == null) {
            return null;
        }
        FormLayout layout = new FormLayout();
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(layout);
        layout.appendRow(new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0));
        layout.appendRow(FormFactory.LINE_GAP_ROWSPEC);
        layout.appendRow(new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0));
        int column = -1;
        int row = 1;
        int a = 0;
        int z = data.getSectionList().size();
        while (a < z) {
            JamydaComponent comp = GUIFactory.createSectionComp(data.getSectionList().get(a), jamydaCompList);
            if (comp != null) {
                layout.appendColumn(new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0));
                if (a + 1 < z) {
                    layout.appendColumn(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
                }
                row = 1;
                panel.add((Component)comp.getComponent(), cc.xy(column += 2, row));
            }
            ++a;
        }
        return new JamydaComponent(data, panel);
    }

    private static JamydaComponent createSectionComp(SectionData data, List<JamydaComponent> jamydaCompList) {
        if (data == null) {
            return null;
        }
        FormLayout layout = new FormLayout();
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(layout);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), data.getName()));
        layout.appendColumn(new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0));
        int a = 0;
        int z = data.getItemList().size();
        while (a < z) {
            ItemData itemData = data.getItemList().get(a);
            JamydaComponent comp = GUIFactory.createItemComp(itemData, jamydaCompList);
            if (comp != null) {
                if (itemData.getType() == IItemType.MULTILINE_TEXT) {
                    layout.appendRow(new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0));
                } else {
                    layout.appendRow(FormFactory.DEFAULT_ROWSPEC);
                }
                if (a + 1 < z) {
                    layout.appendRow(FormFactory.LINE_GAP_ROWSPEC);
                }
                panel.add((Component)comp.getComponent(), cc.xy(1, 1 + a * 2));
            }
            ++a;
        }
        return new JamydaComponent(data, panel);
    }

    private static JamydaComponent createItemComp(ItemData data, List<JamydaComponent> jamydaCompList) {
        if (data == null) {
            return null;
        }
        FormLayout layout = new FormLayout("", "");
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(layout);
        boolean isEditable = data.isEditable();
        JamydaComponent jComp = new JamydaComponent(data, panel);
        if (data.getType() == IItemType.MULTILINE_TEXT) {
            layout.appendRow(new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0));
        } else {
            layout.appendRow(FormFactory.DEFAULT_ROWSPEC);
        }
        if (data.getType() == IItemType.BOOL) {
            JCheckBox chb = new JCheckBox(data.getName());
            chb.setEnabled(isEditable);
            chb.setSelected(DataUtils.getBoolean(data.getValue()));
            chb.setName(data.getName());
            jComp.setDataComponent(chb);
            layout.appendColumn(FormFactory.DEFAULT_COLSPEC);
            panel.add((Component)chb, cc.xy(1, 1));
        } else {
            JLabel lb = new JLabel(data.getName());
            lb.setEnabled(isEditable);
            layout.appendColumn(FormFactory.DEFAULT_COLSPEC);
            layout.appendColumn(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
            panel.add((Component)lb, cc.xy(1, 1));
            if (data.getType() == IItemType.TEXT || data.getType() == IItemType.NUMBER) {
                JComponent comp = null;
                if (data.getType() == IItemType.NUMBER && data.getMinValue() < data.getMaxValue()) {
                    int value = -1;
                    try {
                        value = Integer.parseInt(data.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    SpinnerNumberModel model = new SpinnerNumberModel(value, data.getMinValue(), data.getMaxValue(), 1);
                    JSpinner spinner = new JSpinner(model);
                    spinner.setEnabled(isEditable);
                    spinner.setName(data.getName());
                    comp = spinner;
                } else {
                    JTextField tf = new JTextField(data.getValue());
                    tf.setEditable(isEditable);
                    tf.setName(data.getName());
                    comp = tf;
                }
                jComp.setDataComponent(comp);
                layout.appendColumn(new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0));
                panel.add((Component)comp, cc.xy(3, 1));
            } else if (data.getType() == IItemType.MULTILINE_TEXT) {
                JTextArea ta = new JTextArea(data.getValue());
                ta.setEditable(isEditable);
                ta.setName(data.getName());
                jComp.setDataComponent(ta);
                layout.appendColumn(new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0));
                panel.add((Component)new JScrollPane(ta), cc.xy(3, 1));
            } else if (data.getType() == IItemType.CHOICE) {
                JComponent[] arrComp = new JComponent[data.getChoices()];
                String[] values = DataUtils.getValues(data.getValue());
                int a = 0;
                int z = data.getChoices();
                while (a < z) {
                    JComboBox<String> cmb = new JComboBox<String>();
                    cmb.setEditable(false);
                    cmb.setEnabled(isEditable);
                    cmb.setName(data.getName());
                    int b = 0;
                    int y = data.getValues().size();
                    while (b < y) {
                        cmb.addItem(data.getValues().get(b));
                        ++b;
                    }
                    if (values != null && values.length > 0) {
                        int valInd = Math.min(a, values.length - 1);
                        cmb.setSelectedItem(values[valInd]);
                    }
                    arrComp[a] = cmb;
                    layout.appendColumn(new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0));
                    if (a + 1 < z) {
                        layout.appendColumn(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
                    }
                    panel.add(cmb, cc.xy(3 + a * 2, 1));
                    ++a;
                }
                jComp.setDataComponents(arrComp);
            } else if (data.getType() == IItemType.FILE || data.getType() == IItemType.DIRECTORY) {
                JTextField tf = new JTextField(data.getValue());
                tf.setEditable(isEditable);
                tf.setName(data.getName());
                jComp.setDataComponent(tf);
                JButton btt = new JButton(new BrowseAction(data, tf));
                btt.setEnabled(isEditable);
                btt.setName(data.getName());
                layout.appendColumn(new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0));
                layout.appendColumn(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
                panel.add((Component)tf, cc.xy(3, 1));
                layout.appendColumn(new ColumnSpec(ColumnSpec.LEFT, Sizes.DEFAULT, 0.0));
                panel.add((Component)btt, cc.xy(5, 1));
            }
        }
        jamydaCompList.add(jComp);
        return jComp;
    }

    public static void showError(String i18nText) {
        String msg = GUIFactory.getBundle().getString(i18nText);
        JOptionPane.showMessageDialog(GUIFactory.getMainFrame(), msg, GUIFactory.getBundle().getString("title.error"), 0);
    }

    public static CtrlAppSettings getCtrlAppSettings() {
        if (ctrlAppSettings == null) {
            ctrlAppSettings = new CtrlAppSettings();
        }
        return ctrlAppSettings;
    }

    public static CtrlDosboxSettings getCtrlDosboxSettings() {
        if (ctrlDosboxSettings == null) {
            ctrlDosboxSettings = new CtrlDosboxSettings();
        }
        return ctrlDosboxSettings;
    }

    public static CtrlJamydaSettings getCtrlJamydaSettings() {
        if (ctrlJamydaSettings == null) {
            ctrlJamydaSettings = new CtrlJamydaSettings();
        }
        return ctrlJamydaSettings;
    }

    public static CtrlDosboxConfigurations getCtrlDosboxConfigurations() {
        if (ctrlDosboxConfigurations == null) {
            ctrlDosboxConfigurations = new CtrlDosboxConfigurations();
        }
        return ctrlDosboxConfigurations;
    }
}

