/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.controller;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import thoto.jamyda.data.ItemData;
import thoto.jamyda.interfaces.IItemType;
import thoto.jamyda.utils.GUIFactory;

public class BrowseAction
extends AbstractAction {
    private static final long serialVersionUID = 8595194428285429167L;
    private ItemData data;
    private JTextField textField;
    private boolean isDirectoryChooser;
    private JFileChooser fileChooser;
    private FileFilter fileFilter;

    public BrowseAction(ItemData data, JTextField textField) {
        this(data, textField, null);
    }

    public BrowseAction(ItemData data, JTextField textField, FileFilter fileFilter) {
        super(null);
        this.data = data;
        this.textField = textField;
        this.fileFilter = fileFilter;
        if (data != null) {
            this.isDirectoryChooser = this.data.getType() == IItemType.DIRECTORY;
        }
        this.init();
    }

    public BrowseAction(boolean isDirectoryChooser, JTextField textField) {
        this(isDirectoryChooser, textField, null);
    }

    public BrowseAction(boolean isDirectoryChooser, JTextField textField, FileFilter fileFilter) {
        super(null);
        this.textField = textField;
        this.fileFilter = fileFilter;
        this.isDirectoryChooser = isDirectoryChooser;
        this.init();
    }

    private void init() {
        try {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/res/icons/16x16/Computer_File_064.gif")));
        }
        catch (Exception e) {
            this.putValue("Name", "...");
        }
        this.fileChooser = new JFileChooser();
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setDialogTitle(GUIFactory.getBundle().getString("FileChooser.openButtonText"));
        if (this.fileFilter != null) {
            this.fileChooser.setFileFilter(this.fileFilter);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int mode = this.isDirectoryChooser ? 1 : 2;
        this.fileChooser.setFileSelectionMode(mode);
        if (this.fileChooser.showOpenDialog(GUIFactory.getMainFrame()) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (this.textField != null && file != null) {
                this.textField.setText(file.getAbsolutePath());
            }
        }
    }
}

