/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.controller;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import thoto.jamyda.controller.ContextMenuFactory;
import thoto.jamyda.controller.ExceptionHandler;
import thoto.jamyda.data.AppConstants;
import thoto.jamyda.data.AppData;
import thoto.jamyda.data.CategoryData;
import thoto.jamyda.data.DosboxSettingsData;
import thoto.jamyda.data.JProperties;
import thoto.jamyda.data.JamydaData;
import thoto.jamyda.gui.AppList;
import thoto.jamyda.gui.AppListCellRenderer;
import thoto.jamyda.gui.CategoryTree;
import thoto.jamyda.gui.DlgAppSettings;
import thoto.jamyda.gui.DlgDosboxConfigurations;
import thoto.jamyda.gui.DlgEditString;
import thoto.jamyda.gui.DlgHTMLViewer;
import thoto.jamyda.gui.DlgJamydaSettings;
import thoto.jamyda.utils.DataUtils;
import thoto.jamyda.utils.GUIFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainController {
    private DosboxSettingsData defaultDosboxSettingsData;
    private List<AppData> applicationList;
    private List<CategoryData> categoryList;
    private JamydaData jamydaData;
    private static MainController mainController;

    private MainController() {
        if (this.loadConfiguration("config/jamyda.ini")) {
            this.defaultDosboxSettingsData = DataUtils.loadDBSettings(this.jamydaData.getDefaultAppSettingsFilename());
            this.categoryList = DataUtils.loadAdvancedJamydaSettings(this.jamydaData.getAdvancedJamydaSettingsFilename());
            if (this.defaultDosboxSettingsData != null) {
                this.init();
                this.loadAppSettings();
                GUIFactory.getMainFrame().setVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Cannot find: config/jamyda.ini", "Error", 0);
        }
    }

    public static MainController getInstance() {
        if (mainController == null) {
            mainController = new MainController();
        }
        return mainController;
    }

    private void init() {
        this.initUISettings();
        GUIFactory.getMainFrame().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainController.this.saveConfiguration("config/jamyda.ini");
                DataUtils.storeAdvancedJamydaSettings(MainController.this.jamydaData.getAdvancedJamydaSettingsFilename());
            }
        });
        GUIFactory.getMainFrame().getBttAddCategory().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryData parent = MainController.this.getSelectedCategory();
                if (parent == AppConstants.CATEGORY_ALL || parent == AppConstants.CATEGORY_FAVORITES) {
                    parent = null;
                }
                MainController.this.onEditCategory(parent, null);
            }
        });
        GUIFactory.getMainFrame().getBttDeleteCategory().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.this.onRemoveCategory(MainController.this.getSelectedCategory());
            }
        });
        GUIFactory.getMainFrame().getBttEditCategory().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.this.onEditCategory(null, MainController.this.getSelectedCategory());
            }
        });
        GUIFactory.getMainFrame().getBttAddApplication().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.this.onEditApplication(null);
            }
        });
        GUIFactory.getMainFrame().getBttEditApplication().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppData data = (AppData)GUIFactory.getMainFrame().getLstApplications().getSelectedValue();
                MainController.this.onEditApplication(data);
            }
        });
        GUIFactory.getMainFrame().getBttRemoveApplication().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.this.onRemoveApplications();
            }
        });
        GUIFactory.getMainFrame().getBttSettings().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.this.onEditJamydaSettings();
            }
        });
        GUIFactory.getMainFrame().getBttDosboxConfigurations().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.this.onEditDosboxConfigurations();
            }
        });
        GUIFactory.getMainFrame().getBttAbout().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainController.this.onHelp();
            }
        });
        GUIFactory.getMainFrame().getLstApplications().setCellRenderer(new AppListCellRenderer());
        GUIFactory.getMainFrame().getLstApplications().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                MainController.this.onUpdateGUI();
            }
        });
        GUIFactory.getMainFrame().getLstApplications().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AppList list;
                AppData data;
                JPopupMenu menu;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && GUIFactory.getMainFrame().getLstApplications().getSelectedIndices().length == 1) {
                    AppData data2 = (AppData)GUIFactory.getMainFrame().getLstApplications().getSelectedValue();
                    MainController.this.onLaunchApplication(data2);
                } else if (SwingUtilities.isRightMouseButton(e) && (menu = ContextMenuFactory.createPopupMenu(data = (AppData)(list = GUIFactory.getMainFrame().getLstApplications()).getSelectedValue())) != null) {
                    menu.show(list, e.getX(), e.getY());
                }
            }
        });
        GUIFactory.getMainFrame().getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                MainController.this.updateApplicationList();
                MainController.this.onUpdateGUI();
            }
        });
        GUIFactory.getMainFrame().getTree().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    CategoryTree tree = GUIFactory.getMainFrame().getTree();
                    CategoryData data = MainController.this.getSelectedCategory();
                    JPopupMenu menu = ContextMenuFactory.createPopupMenu(data);
                    if (menu != null) {
                        menu.show(tree, e.getX(), e.getY());
                    }
                }
            }
        });
        this.onUpdateGUI();
    }

    private void initUISettings() {
        try {
            UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        UIManager.put("FileChooser.acceptAllFileFilterText", GUIFactory.getBundle().getString("FileChooser.acceptAllFileFilterText"));
        UIManager.put("FileChooser.cancelButtonText", GUIFactory.getBundle().getString("FileChooser.cancelButtonText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", GUIFactory.getBundle().getString("FileChooser.cancelButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", GUIFactory.getBundle().getString("FileChooser.detailsViewButtonAccessibleName"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", GUIFactory.getBundle().getString("FileChooser.detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.directoryDescriptionText", GUIFactory.getBundle().getString("FileChooser.directoryDescriptionText"));
        UIManager.put("FileChooser.fileDescriptionText", GUIFactory.getBundle().getString("FileChooser.fileDescriptionText"));
        UIManager.put("FileChooser.fileNameLabelText", GUIFactory.getBundle().getString("FileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", GUIFactory.getBundle().getString("FileChooser.filesOfTypeLabelText"));
        UIManager.put("FileChooser.helpButtonText", GUIFactory.getBundle().getString("FileChooser.helpButtonText"));
        UIManager.put("FileChooser.helpButtonToolTipText", GUIFactory.getBundle().getString("FileChooser.helpButtonToolTipText"));
        UIManager.put("FileChooser.homeFolderAccessibleName", GUIFactory.getBundle().getString("FileChooser.homeFolderAccessibleName"));
        UIManager.put("FileChooser.homeFolderToolTipText", GUIFactory.getBundle().getString("FileChooser.homeFolderToolTipText"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", GUIFactory.getBundle().getString("FileChooser.listViewButtonAccessibleName"));
        UIManager.put("FileChooser.listViewButtonToolTipText", GUIFactory.getBundle().getString("FileChooser.listViewButtonToolTipText"));
        UIManager.put("FileChooser.lookInLabelText", GUIFactory.getBundle().getString("FileChooser.lookInLabelText"));
        UIManager.put("FileChooser.newFolderAccessibleName", GUIFactory.getBundle().getString("FileChooser.newFolderAccessibleName"));
        UIManager.put("FileChooser.newFolderErrorSeparator", GUIFactory.getBundle().getString("FileChooser.newFolderErrorSeparator"));
        UIManager.put("FileChooser.newFolderErrorText", GUIFactory.getBundle().getString("FileChooser.newFolderErrorText"));
        UIManager.put("FileChooser.newFolderToolTipText", GUIFactory.getBundle().getString("FileChooser.newFolderToolTipText"));
        UIManager.put("FileChooser.openButtonText", GUIFactory.getBundle().getString("FileChooser.openButtonText"));
        UIManager.put("FileChooser.openButtonToolTipText", GUIFactory.getBundle().getString("FileChooser.openButtonToolTipText"));
        UIManager.put("FileChooser.saveButtonText", GUIFactory.getBundle().getString("FileChooser.saveButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText", GUIFactory.getBundle().getString("FileChooser.saveButtonToolTipText"));
        UIManager.put("FileChooser.updateButtonText", GUIFactory.getBundle().getString("FileChooser.updateButtonText"));
        UIManager.put("FileChooser.updateButtonToolTipText", GUIFactory.getBundle().getString("FileChooser.updateButtonToolTipText"));
        UIManager.put("FileChooser.upFolderAccessibleNam", GUIFactory.getBundle().getString("FileChooser.upFolderAccessibleName"));
        UIManager.put("FileChooser.upFolderToolTipText", GUIFactory.getBundle().getString("FileChooser.upFolderToolTipText"));
        CategoryTree tree = GUIFactory.getMainFrame().getTree();
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        URL iconPathOpen = MainController.class.getResource("/res/icons/16x16/Computer_File_064.gif");
        URL iconPathClose = MainController.class.getResource("/res/icons/16x16/Computer_File_063.gif");
        if (iconPathClose != null && iconPathOpen != null) {
            cellRenderer.setOpenIcon(new ImageIcon(iconPathOpen));
            cellRenderer.setClosedIcon(new ImageIcon(iconPathClose));
            cellRenderer.setLeafIcon(new ImageIcon(iconPathClose));
        }
        tree.setCellRenderer(cellRenderer);
        GUIFactory.getMainFrame().setBounds(this.jamydaData.getLastMainFrameBounds());
        GUIFactory.getMainFrame().getSplitPane().setDividerLocation(this.jamydaData.getLastDividerLocation());
    }

    private void onUpdateGUI() {
        int[] selIndicesApp = GUIFactory.getMainFrame().getLstApplications().getSelectedIndices();
        boolean isMultiSelApp = selIndicesApp.length > 1;
        boolean isSelApp = selIndicesApp.length > 0;
        CategoryData selCategory = this.getSelectedCategory();
        boolean isEditableCategory = selCategory != AppConstants.CATEGORY_ALL && selCategory != AppConstants.CATEGORY_FAVORITES;
        GUIFactory.getMainFrame().getBttEditCategory().setEnabled(selCategory != null && isEditableCategory);
        GUIFactory.getMainFrame().getBttDeleteCategory().setEnabled(selCategory != null && isEditableCategory);
        GUIFactory.getMainFrame().getBttEditApplication().setEnabled(isSelApp && !isMultiSelApp);
        GUIFactory.getMainFrame().getBttRemoveApplication().setEnabled(isSelApp);
    }

    void onEditCategory(CategoryData parentCategory, CategoryData editCategory) {
        String name;
        String result;
        String initialName = editCategory != null ? editCategory.getName() : null;
        DlgEditString dlg = new DlgEditString(GUIFactory.getMainFrame());
        dlg.setTitle(GUIFactory.getBundle().getString("title.add.category"));
        dlg.setDescription(GUIFactory.getBundle().getString("label.category.name"));
        dlg.setText(initialName);
        dlg.setVisible(true);
        String string = result = dlg.isApplied() ? dlg.getText() : null;
        if (result != null && this.getCategoryList() != null && (name = result.toString().trim()).length() > 0) {
            if (editCategory == null) {
                CategoryData cat = new CategoryData(name, parentCategory);
                if (parentCategory != null) {
                    parentCategory.getChildrenList().add(cat);
                } else {
                    this.getCategoryList().add(cat);
                }
            } else {
                editCategory.setName(name);
            }
            this.updateTree();
        }
    }

    void onEditApplication(AppData data) {
        String oldFileName = data != null ? data.getFilename() : null;
        DlgAppSettings dlg = GUIFactory.getCtrlAppSettings().getDialog();
        GUIFactory.getCtrlAppSettings().setData(data);
        dlg.setVisible(true);
        if (GUIFactory.getCtrlAppSettings().isApplied()) {
            AppData newData = (AppData)GUIFactory.getCtrlAppSettings().getData();
            newData.save();
            if (oldFileName != null && !oldFileName.equals(newData.getFilename())) {
                File f = new File(oldFileName);
                f.delete();
            }
            this.loadAppSettings();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onLaunchApplication(AppData data) {
        try {
            GUIFactory.showWaitCursor(GUIFactory.getMainFrame());
            if (data == null) {
                GUIFactory.showError("message.error.launch.app.invalid");
                return;
            }
            if (!DataUtils.isFilenameValid(data.getAppPath(), true, false, null)) {
                GUIFactory.showError("message.error.launch.app.path.invalid");
                return;
            }
            File appExec = new File(data.getAppPath());
            JamydaData jData = MainController.getInstance().getJamydaData();
            if (jData == null) {
                GUIFactory.showError("message.error.launch.common.data.invalid");
                return;
            }
            String dbExecPath = jData.getDosboxPath();
            if (!DataUtils.isFilenameValid(dbExecPath, true, false, null)) {
                GUIFactory.showError("message.error.launch.common.data.db.path.invalid");
                return;
            }
            File dbExec = new File(dbExecPath);
            if (!dbExec.exists() && dbExec.isDirectory()) {
                GUIFactory.showError("message.error.launch.common.data.db.path.invalid");
                return;
            }
            String dbConfName = data.getDosboxConfigPath();
            String dbConfPath = "config/dosbox/" + dbConfName + ".xml";
            if (!DataUtils.isFilenameValid(dbConfPath, true, false, null)) {
                GUIFactory.showError("message.error.launch.app.db.config.invalid");
                return;
            }
            DosboxSettingsData dbData = DataUtils.loadDBSettings(dbConfPath);
            if (dbData == null) {
                GUIFactory.showError("message.error.launch.app.db.config.load.invalid");
                return;
            }
            dbConfPath = "config/dosbox/" + (dbConfName = dbConfName.replaceAll(" ", "_")) + ".conf";
            if (!DataUtils.storeDataToFile(dbData, new File(dbConfPath), 1)) {
                GUIFactory.showError("message.error.launch.app.db.config.write.invalid");
                return;
            }
            String dbCommands = data.getAdditionalDBCommands();
            dbCommands = dbCommands != null && dbCommands.length() > 0 ? " -c \"" + dbCommands + "\"" : "";
            String command = String.valueOf(dbExec.getAbsolutePath()) + " \"" + appExec.getAbsolutePath() + "\"" + dbCommands + " -conf \"" + dbConfPath + "\"";
            Runtime r = Runtime.getRuntime();
            try {
                r.exec(command);
                return;
            }
            catch (IOException e) {
                ExceptionHandler.handleException(e);
            }
            return;
        }
        finally {
            GUIFactory.resetCursor(GUIFactory.getMainFrame());
        }
    }

    void onRemoveCategory(CategoryData category) {
        if (this.getCategoryList() != null && category != null && JOptionPane.showConfirmDialog(GUIFactory.getMainFrame(), GUIFactory.getBundle().getString("message.delete.selected.category"), GUIFactory.getBundle().getString("title.delete.elements"), 0) == 0) {
            boolean removed = DataUtils.removeCategory(category, this.getCategoryList());
            if (removed) {
                List<AppData> appList = DataUtils.getApplicationList(this.applicationList, category);
                int a = 0;
                int z = appList.size();
                while (a < z) {
                    appList.get(a).setCategoryPath(null);
                    ++a;
                }
            }
            this.updateTree();
        }
    }

    void onRemoveApplications() {
        Object[] selItems = GUIFactory.getMainFrame().getLstApplications().getSelectedValues();
        if (selItems.length > 0 && JOptionPane.showConfirmDialog(GUIFactory.getMainFrame(), GUIFactory.getBundle().getString("message.delete.selected.elements"), GUIFactory.getBundle().getString("title.delete.elements"), 0) == 0) {
            int a = 0;
            int z = selItems.length;
            while (a < z) {
                AppData data = (AppData)selItems[a];
                File file = new File(data.getFilename());
                file.delete();
                this.loadAppSettings();
                ++a;
            }
        }
    }

    private void onEditJamydaSettings() {
        DlgJamydaSettings dlg = GUIFactory.getCtrlJamydaSettings().getDialog();
        GUIFactory.getCtrlJamydaSettings().setData(this.jamydaData);
        dlg.setVisible(true);
        if (GUIFactory.getCtrlJamydaSettings().isApplied()) {
            this.jamydaData = (JamydaData)GUIFactory.getCtrlJamydaSettings().getData();
        }
    }

    private void onEditDosboxConfigurations() {
        GUIFactory.getCtrlDosboxConfigurations().setData(null);
        DlgDosboxConfigurations dlg = GUIFactory.getCtrlDosboxConfigurations().getDialog();
        dlg.setVisible(true);
    }

    private void onHelp() {
        URL helpURL;
        String path;
        DlgHTMLViewer dlg = new DlgHTMLViewer(GUIFactory.getMainFrame());
        try {
            path = "help/index_" + this.jamydaData.getLanguage() + ".html";
            helpURL = new URL("file", "localhost", path);
            if (helpURL != null) {
                dlg.getTpContent().setPage(helpURL);
            } else {
                GUIFactory.showError("message.error.could.not.find.file\n" + path);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        try {
            path = "jamyda-history.txt";
            helpURL = new URL("file", "localhost", path);
            if (helpURL != null) {
                dlg.getTpVersionHistory().setPage(helpURL);
            } else {
                GUIFactory.showError("message.error.could.not.find.file\n" + path);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        dlg.setVisible(true);
    }

    private boolean loadConfiguration(String filename) {
        try {
            this.jamydaData = new JamydaData();
            JProperties p = new JProperties();
            if (p.exists()) {
                String lang;
                p.load();
                this.jamydaData.setDefaultAppSettingsFilename(p.getString("defaultsettings"));
                this.jamydaData.setDosboxPath(p.getString("dosboxpath"));
                this.jamydaData.setDosboxConfigFilename(p.getString("dosboxconfigfile"));
                this.jamydaData.setAdvancedJamydaSettingsFilename(p.getString("advancedjamydasettingsfile"));
                this.jamydaData.setLanguage(p.getString("language"));
                Locale.setDefault(new Locale(this.jamydaData.getLanguage()));
                ArrayList<String> l = new ArrayList<String>();
                int num = 1;
                while ((lang = p.getString("lang_" + num)) != null) {
                    if (!l.contains(lang)) {
                        l.add(lang);
                    }
                    ++num;
                }
                this.jamydaData.setLanguageList(l);
                int x = Math.max(p.getInt("appX"), 0);
                int y = Math.max(p.getInt("appY"), 0);
                int w = Math.max(p.getInt("appWidth"), 450);
                int h = Math.max(p.getInt("appHeight"), 300);
                int divLoc = Math.max(p.getInt("appDivLoc"), 150);
                this.jamydaData.setLastMainFrameBounds(new Rectangle(x, y, w, h));
                this.jamydaData.setLastDividerLocation(divLoc);
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        return false;
    }

    private boolean saveConfiguration(String filename) {
        try {
            JProperties p = new JProperties();
            if (p.exists()) {
                p.setString("defaultsettings", this.jamydaData.getDefaultAppSettingsFilename());
                p.setString("dosboxpath", this.jamydaData.getDosboxPath());
                p.setString("dosboxconfigfile", this.jamydaData.getDosboxConfigFilename());
                p.setString("language", this.jamydaData.getLanguage());
                Rectangle r = GUIFactory.getMainFrame().getBounds();
                int divLoc = GUIFactory.getMainFrame().getSplitPane().getDividerLocation();
                p.setInt("appX", r.x);
                p.setInt("appY", r.y);
                p.setInt("appWidth", r.width);
                p.setInt("appHeight", r.height);
                p.setInt("appDivLoc", divLoc);
                p.save();
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        return false;
    }

    private void loadAppSettings() {
        this.applicationList = DataUtils.loadAppSettings();
        this.updateTree();
    }

    public void updateApplicationList() {
        List<Object> list = new ArrayList();
        CategoryData category = this.getSelectedCategory();
        list = DataUtils.getApplicationList(this.applicationList, category);
        GUIFactory.getMainFrame().getLstApplications().setListData(list.toArray());
    }

    private void updateTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(GUIFactory.getBundle().getString("label.categories"));
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        if (this.getCategoryList() != null) {
            Collections.sort(this.getCategoryList());
            this.addCategoryNode(AppConstants.CATEGORY_ALL, rootNode);
            this.addCategoryNode(AppConstants.CATEGORY_FAVORITES, rootNode);
            int a = 0;
            int z = this.getCategoryList().size();
            while (a < z) {
                CategoryData cd = this.getCategoryList().get(a);
                this.addCategoryNode(cd, rootNode);
                ++a;
            }
        }
        CategoryTree tree = GUIFactory.getMainFrame().getTree();
        TreePath treePath = tree.getSelectionPath();
        tree.setModel(treeModel);
        tree.getSelectionModel().setSelectionMode(1);
        treePath = DataUtils.getTreePath(treeModel, treePath);
        tree.expandPath(treePath);
        tree.setSelectionPath(treePath);
        this.updateApplicationList();
    }

    private void addCategoryNode(CategoryData category, DefaultMutableTreeNode parent) {
        if (category != null && parent != null) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(category);
            parent.add(node);
            if (category.getChildrenList().size() > 0) {
                Collections.sort(category.getChildrenList());
                int a = 0;
                int z = category.getChildrenList().size();
                while (a < z) {
                    CategoryData cd = category.getChildrenList().get(a);
                    this.addCategoryNode(cd, node);
                    ++a;
                }
            }
        }
    }

    public CategoryData getSelectedCategory() {
        TreePath treePath = GUIFactory.getMainFrame().getTree().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return (CategoryData)selNode.getUserObject();
        }
        return null;
    }

    public DosboxSettingsData getDefaultDosboxSettingsData() {
        return this.defaultDosboxSettingsData;
    }

    public JamydaData getJamydaData() {
        return this.jamydaData;
    }

    public List<CategoryData> getCategoryList() {
        return this.categoryList;
    }
}

