/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import thoto.jamyda.data.AbstractData;
import thoto.jamyda.utils.DataUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryData
extends AbstractData
implements Comparable<CategoryData> {
    public static String PATH_SEPARATOR = ".";
    private List<CategoryData> childrenList;
    private CategoryData parent;

    public CategoryData(String name, CategoryData parent) {
        this(name, parent, null);
    }

    public CategoryData(String name, CategoryData parent, List<CategoryData> childrenList) {
        super(name);
        this.childrenList = childrenList;
        this.parent = parent;
    }

    public static String getPath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        String path = "";
        int a = 1;
        int z = treePath.getPathCount();
        while (a < z) {
            path = String.valueOf(path) + treePath.getPathComponent(a).toString();
            if (a + 1 < z) {
                path = String.valueOf(path) + PATH_SEPARATOR;
            }
            ++a;
        }
        return path;
    }

    public String getPath() {
        String path = this.getName();
        if (this.getParent() != null) {
            path = String.valueOf(this.getParent().getPath()) + PATH_SEPARATOR + path;
        }
        return path;
    }

    @Override
    public AbstractData getClone() {
        return new CategoryData(this.getName(), this.getParent(), this.getChildrenList());
    }

    @Override
    public int getElementCount() {
        return this.getChildrenList().size();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String toDosBox() {
        return null;
    }

    @Override
    public String toXML(String indent) {
        if (indent == null) {
            indent = "";
        }
        String s = "\n" + indent + "<" + "category" + " " + "name" + "=\"" + DataUtils.toValidXML(this.getName()) + "\"";
        if (this.getChildrenList().size() == 0) {
            s = String.valueOf(s) + "/>";
        } else {
            s = String.valueOf(s) + ">";
            int a = 0;
            int z = this.getChildrenList().size();
            while (a < z) {
                s = String.valueOf(s) + this.getChildrenList().get(a).toXML(String.valueOf(indent) + "  ");
                ++a;
            }
            s = String.valueOf(s) + "\n" + indent + "</" + "category" + ">";
        }
        return s;
    }

    @Override
    public int compareTo(CategoryData o) {
        return this.getPath().compareTo(o.getPath());
    }

    public List<CategoryData> getChildrenList() {
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<CategoryData>();
        }
        return this.childrenList;
    }

    public CategoryData getParent() {
        return this.parent;
    }
}

