/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import thoto.jamyda.controller.ExceptionHandler;
import thoto.jamyda.utils.GUIFactory;

public class DosboxConfigData {
    private List<DBSectionData> sectionList;

    public DosboxConfigData(File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.valueOf(GUIFactory.getBundle().getString("message.dosbox.config.file.invalid")) + "null");
        }
        if (!this.load(file)) {
            throw new IllegalArgumentException(String.valueOf(GUIFactory.getBundle().getString("message.dosbox.config.file.invalid")) + file.getAbsolutePath());
        }
    }

    public int getLineNumber(String variableName) {
        block6: {
            if (this.sectionList != null) break block6;
            return -1;
        }
        try {
            int a = 0;
            int z = this.sectionList.size();
            while (a < z) {
                DBSectionData data = this.sectionList.get(a);
                List<String> vList = data.getVariableList();
                int b = 0;
                int y = vList.size();
                while (b < y) {
                    if (vList.get(b).startsWith(variableName)) {
                        return data.getLineNumber() + data.getCommentList().size() + data.variableList.size() + 1;
                    }
                    ++b;
                }
                ++a;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        return -1;
    }

    public String getText() {
        if (this.sectionList == null) {
            return null;
        }
        String text = "";
        int a = 0;
        int z = this.sectionList.size();
        while (a < z) {
            DBSectionData data = this.sectionList.get(a);
            text = String.valueOf(text) + data.toString() + "\n";
            ++a;
        }
        return text;
    }

    private boolean load(File file) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            int lineNumber = 1;
            DBSectionData section = null;
            this.sectionList = new ArrayList<DBSectionData>();
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
                    if (section != null) {
                        this.sectionList.add(section);
                        ++lineNumber;
                    }
                    line = line.substring(1, line.length() - 1);
                    section = new DBSectionData(line, lineNumber);
                    ++lineNumber;
                    continue;
                }
                if (section == null) continue;
                if (line.startsWith("#")) {
                    section.getCommentList().add(String.valueOf(line) + "\n");
                    ++lineNumber;
                    continue;
                }
                if (line.length() <= 0) continue;
                section.getVariableList().add(String.valueOf(line) + "\n");
                ++lineNumber;
            }
            if (section != null && !this.sectionList.contains(section)) {
                this.sectionList.add(section);
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DBSectionData {
        private String sectionName;
        private List<String> commentList;
        private List<String> variableList;
        private int lineNumber;

        public DBSectionData(String sectionName, int lineNumber) {
            this.sectionName = sectionName;
            this.lineNumber = lineNumber;
        }

        public String toString() {
            String commStr = "";
            int a = 0;
            int z = this.getCommentList().size();
            while (a < z) {
                commStr = String.valueOf(commStr) + this.getCommentList().get(a);
                ++a;
            }
            String varStr = "";
            int a2 = 0;
            int z2 = this.getVariableList().size();
            while (a2 < z2) {
                varStr = String.valueOf(varStr) + this.getVariableList().get(a2);
                ++a2;
            }
            return "[" + this.getSectionName() + "]\n" + commStr + varStr;
        }

        public String getSectionName() {
            return this.sectionName;
        }

        public List<String> getCommentList() {
            if (this.commentList == null) {
                this.commentList = new ArrayList<String>();
            }
            return this.commentList;
        }

        public List<String> getVariableList() {
            if (this.variableList == null) {
                this.variableList = new ArrayList<String>();
            }
            return this.variableList;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

