/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.util.List;
import thoto.jamyda.data.AbstractData;
import thoto.jamyda.interfaces.IItemType;
import thoto.jamyda.utils.DataUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemData
extends AbstractData {
    private String value;
    private IItemType type;
    private List<String> values;
    private boolean editable;
    private int choices;
    private int minValue;
    private int maxValue;

    public ItemData(String name, IItemType type, String value, List<String> values, int choices, int minValue, int maxValue, boolean editable) {
        super(name);
        this.type = type;
        this.value = value;
        this.values = values;
        this.choices = choices;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.editable = editable;
    }

    @Override
    public String toXML(String indent) {
        if (indent == null) {
            indent = "";
        }
        String s = "\n" + indent + "<" + "item" + " " + "name" + "=\"" + DataUtils.toValidXML(this.getName()) + "\"" + " " + "value" + "=\"" + DataUtils.toValidXML(this.getValue()) + "\"" + " " + "type" + "=\"" + DataUtils.toValidXML(this.getType().getName()) + "\"";
        if (this.getMinValue() < this.getMaxValue() && this.getType().equals(IItemType.NUMBER)) {
            s = String.valueOf(s) + " min=\"" + this.getMinValue() + "\"";
            s = String.valueOf(s) + " max=\"" + this.getMaxValue() + "\"";
        }
        if (this.getValues() != null && this.getValues().size() > 0) {
            s = String.valueOf(s) + " values=\"";
            int a = 0;
            int z = this.getValues().size();
            while (a < z) {
                s = String.valueOf(s) + DataUtils.toValidXML(this.getValues().get(a));
                if (a + 1 < z) {
                    s = String.valueOf(s) + ",";
                }
                ++a;
            }
            s = String.valueOf(s) + "\"";
        }
        if (!this.isEditable()) {
            s = String.valueOf(s) + " edit=\"" + this.isEditable() + "\"";
        }
        if (this.getChoices() != 1) {
            s = String.valueOf(s) + " choices=\"" + this.getChoices() + "\"";
        }
        s = String.valueOf(s) + "/>";
        return s;
    }

    @Override
    public AbstractData getClone() {
        ItemData clone = new ItemData(this.getName(), this.getType(), this.getValue(), this.getValues(), this.getChoices(), this.getMinValue(), this.getMaxValue(), this.isEditable());
        return clone;
    }

    @Override
    public String toDosBox() {
        if (this.getName() != null && this.getName().trim().length() > 0) {
            return String.valueOf(this.getName()) + "=" + this.getValue() + "\n";
        }
        return "";
    }

    @Override
    public int getElementCount() {
        return 0;
    }

    public String getValue() {
        return this.value;
    }

    public IItemType getType() {
        return this.type;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public int getChoices() {
        return this.choices;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }
}

