/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class JProperties {
    private Properties prop;
    private boolean bExists = false;
    private String m_filename = "config/jamyda.ini";

    public JProperties() {
        this.prop = new Properties();
        this.bExists = this.load(this.m_filename);
    }

    public JProperties(String filename) {
        this.m_filename = filename;
        this.prop = new Properties();
        this.bExists = this.load(this.m_filename);
    }

    public boolean exists() {
        return this.bExists;
    }

    public boolean load() {
        return this.load(this.m_filename);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(String filename) {
        File systemFile = new File(filename);
        if (!systemFile.canRead()) {
            return false;
        }
        try {
            FileInputStream in = new FileInputStream(systemFile);
            try {
                this.prop.load(in);
                in.close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (FileNotFoundException e2) {
            return false;
        }
    }

    public boolean save() {
        return this.save(this.m_filename);
    }

    public boolean save(String filename) {
        File systemFile = new File(filename);
        try {
            FileOutputStream out = new FileOutputStream(systemFile);
            try {
                this.prop.store(out, "Properties Jamyda");
                out.close();
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return true;
    }

    public void remove(String key) {
        this.prop.remove(key);
    }

    public int getInt(String key) {
        try {
            Integer result = new Integer(this.getString(key));
            return result;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean getBoolean(String key) {
        Boolean result = new Boolean(this.getString(key));
        return result;
    }

    public float getFloat(String key) {
        try {
            Float result = new Float(this.getString(key));
            return result.floatValue();
        }
        catch (NumberFormatException e) {
            return -1.0f;
        }
    }

    public String getString(String key) {
        return this.prop.getProperty(key);
    }

    public Object setString(String key, String value) {
        return this.prop.setProperty(key, value);
    }

    public Object setInt(String key, int value) {
        Integer iVal = new Integer(value);
        return this.prop.setProperty(key, iVal.toString());
    }

    public Object setBoolean(String key, boolean value) {
        Boolean bVal = new Boolean(value);
        return this.prop.setProperty(key, bVal.toString());
    }
}

