/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.util.ArrayList;
import java.util.List;
import thoto.jamyda.data.AbstractData;
import thoto.jamyda.data.ItemData;
import thoto.jamyda.utils.DataUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionData
extends AbstractData {
    private List<ItemData> itemList;

    public SectionData(String name) {
        super(name);
    }

    public void add(ItemData item) {
        if (item == null) {
            return;
        }
        if (this.itemList == null) {
            this.itemList = new ArrayList<ItemData>();
        }
        if (!this.itemList.contains(item)) {
            this.itemList.add(item);
        }
    }

    @Override
    public String toXML(String indent) {
        if (indent == null) {
            indent = "";
        }
        String s = "\n" + indent + "<" + "section" + " " + "name" + "=\"" + DataUtils.toValidXML(this.getName()) + "\"" + ">";
        if (this.itemList != null) {
            int a = 0;
            int z = this.itemList.size();
            while (a < z) {
                s = String.valueOf(s) + this.itemList.get(a).toXML(String.valueOf(indent) + "  ");
                ++a;
            }
        }
        s = String.valueOf(s) + "\n" + indent + "</" + "section" + ">";
        return s;
    }

    @Override
    public AbstractData getClone() {
        SectionData clone = new SectionData(this.getName());
        if (this.getItemList() != null) {
            int a = 0;
            int z = this.getItemList().size();
            while (a < z) {
                clone.add((ItemData)this.getItemList().get(a).getClone());
                ++a;
            }
        }
        return clone;
    }

    @Override
    public String toDosBox() {
        String str = "[" + this.getName() + "]\n";
        if (this.getItemList() != null) {
            int a = 0;
            int z = this.getItemList().size();
            while (a < z) {
                str = String.valueOf(str) + this.getItemList().get(a).toDosBox();
                ++a;
            }
        }
        return String.valueOf(str) + "\n";
    }

    @Override
    public int getElementCount() {
        if (this.itemList != null) {
            return this.itemList.size();
        }
        return 0;
    }

    public List<ItemData> getItemList() {
        return this.itemList;
    }
}

