/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.utils;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import thoto.jamyda.controller.ExceptionHandler;
import thoto.jamyda.controller.MainController;
import thoto.jamyda.data.AbstractData;
import thoto.jamyda.data.AdvancedJamydaSettingsXMLHandler;
import thoto.jamyda.data.AppConstants;
import thoto.jamyda.data.AppData;
import thoto.jamyda.data.CategoryData;
import thoto.jamyda.data.DataFile;
import thoto.jamyda.data.DosboxSettingsData;
import thoto.jamyda.data.DosboxSettingsXMLHandler;
import thoto.jamyda.utils.DBConfigurationFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtils {
    public static final int MODE_SAVE_AS_XML = 0;
    public static final int MODE_SAVE_AS_DOSBOX = 1;

    public static boolean storeDataToFile(AbstractData data, File file, int saveMode) {
        if (data == null || file == null) {
            return false;
        }
        if (saveMode != 0 && saveMode != 1) {
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            if (saveMode == 0) {
                out.write(data.toXML(null));
            } else if (saveMode == 1) {
                out.write(data.toDosBox());
            }
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return false;
        }
    }

    public static DosboxSettingsData loadDBSettings(String path) {
        File file;
        block5: {
            block4: {
                try {
                    if (path != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                    return null;
                }
            }
            file = new File(path);
            if (file.exists()) break block5;
            return null;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        DosboxSettingsXMLHandler handler = new DosboxSettingsXMLHandler();
        parser.parse(file, (DefaultHandler)handler);
        DosboxSettingsData data = handler.getDosboxSettingsData();
        return data;
    }

    public static List<CategoryData> loadAdvancedJamydaSettings(String path) {
        File file;
        block5: {
            block4: {
                try {
                    if (path != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                    return null;
                }
            }
            file = new File(path);
            if (file.exists()) break block5;
            return null;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        AdvancedJamydaSettingsXMLHandler handler = new AdvancedJamydaSettingsXMLHandler();
        parser.parse(file, (DefaultHandler)handler);
        return handler.getCategoryList();
    }

    public static boolean storeAdvancedJamydaSettings(String path) {
        block5: {
            if (path != null) break block5;
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            List<CategoryData> catList = MainController.getInstance().getCategoryList();
            StringBuffer buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>");
            buf.append("\n\n<jamyda>\n");
            buf.append("  <categories>");
            if (catList != null) {
                int a = 0;
                int z = catList.size();
                while (a < z) {
                    CategoryData cd = catList.get(a);
                    buf.append(cd.toXML("    "));
                    ++a;
                }
            }
            buf.append("\n  </categories>");
            buf.append("\n</jamyda>");
            out.write(buf.toString());
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return false;
        }
    }

    public static List<AppData> loadAppSettings() {
        File dir = new File("config/apps/");
        if (dir.exists()) {
            File[] files = dir.listFiles();
            ArrayList<AppData> fileList = new ArrayList<AppData>(files.length);
            int a = 0;
            int z = files.length;
            while (a < z) {
                AppData data = new AppData();
                if (data.load(files[a].getAbsolutePath())) {
                    fileList.add(data);
                }
                ++a;
            }
            Collections.sort(fileList);
            return fileList;
        }
        return null;
    }

    public static List<AppData> getApplicationList(List<AppData> appList, CategoryData category) {
        ArrayList<AppData> list = new ArrayList<AppData>();
        if (appList == null) {
            return list;
        }
        String catPath = category != null ? category.getPath() : null;
        boolean isAllCategory = category == AppConstants.CATEGORY_ALL;
        boolean isFavCategory = category == AppConstants.CATEGORY_FAVORITES;
        int a = 0;
        int z = appList.size();
        while (a < z) {
            AppData appData = appList.get(a);
            String appCatPath = appData.getCategoryPath();
            if (isAllCategory) {
                list.add(appData);
            } else if (isFavCategory && appData.isAddedToFavorites()) {
                list.add(appData);
            } else if (appCatPath != null && catPath != null && appCatPath.equals(catPath)) {
                list.add(appData);
            }
            ++a;
        }
        Collections.sort(list);
        return list;
    }

    public static List<String> getAvailableCategoryPathList() {
        List<CategoryData> catList = MainController.getInstance().getCategoryList();
        if (catList == null) {
            return null;
        }
        List<String> l = new ArrayList<String>();
        int a = 0;
        int z = catList.size();
        while (a < z) {
            CategoryData category = catList.get(a);
            l.add(category.getPath());
            l = DataUtils.getCategoryChildrenPaths(category, l);
            ++a;
        }
        Collections.sort(l);
        return l;
    }

    private static List<String> getCategoryChildrenPaths(CategoryData category, List<String> pathList) {
        if (category == null) {
            return pathList;
        }
        if (pathList == null) {
            pathList = new ArrayList<String>();
        }
        int a = 0;
        int z = category.getChildrenList().size();
        while (a < z) {
            CategoryData childCat = category.getChildrenList().get(a);
            pathList.add(childCat.getPath());
            pathList = DataUtils.getCategoryChildrenPaths(childCat, pathList);
            ++a;
        }
        return pathList;
    }

    public static boolean removeCategory(CategoryData category, List<CategoryData> categoryList) {
        if (category == null || categoryList == null) {
            return false;
        }
        int a = 0;
        int z = categoryList.size();
        while (a < z) {
            boolean removed;
            CategoryData cat = categoryList.get(a);
            if (cat == category) {
                return categoryList.remove(category);
            }
            if (cat.getChildrenList().size() > 0 && (removed = DataUtils.removeCategory(category, cat.getChildrenList()))) {
                return true;
            }
            ++a;
        }
        return false;
    }

    public static List<DataFile> getAvailableDBConfigurations() {
        File dir = new File("config/dosbox/");
        if (dir.exists()) {
            File[] files = dir.listFiles(new DBConfigurationFileFilter());
            ArrayList<DataFile> fileList = new ArrayList<DataFile>(files.length);
            int a = 0;
            int z = files.length;
            while (a < z) {
                fileList.add(new DataFile(files[a]));
                ++a;
            }
            Collections.sort(fileList);
            return fileList;
        }
        return null;
    }

    public static String getPath(File file) {
        block4: {
            try {
                if (file != null) break block4;
                return null;
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
                return null;
            }
        }
        if (file.isDirectory()) {
            return file.getAbsolutePath();
        }
        String path = file.getAbsolutePath();
        String name = file.getName();
        return path.substring(0, path.length() - name.length());
    }

    public static boolean getBoolean(String value) {
        if (value == null) {
            return false;
        }
        try {
            boolean b = new Boolean(value.toString());
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getInt(String value) {
        if (value == null) {
            return -1;
        }
        try {
            int i = new Integer(value.toString());
            return i;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String[] getValues(String value) {
        if (value == null) {
            return null;
        }
        try {
            String[] splitted = value.split(",");
            return splitted;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return null;
        }
    }

    public static String toValidXML(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("&", "&amp;");
        str = str.replace("\"", "&quot;");
        str = str.replace("'", "&apos;");
        return str;
    }

    public static boolean isFilenameValid(String filename, boolean mustExist, boolean isDirectory, JComponent component) {
        File file;
        block12: {
            block11: {
                boolean isValidType;
                block10: {
                    try {
                        file = new File(filename);
                        boolean bl = isDirectory ? file.isDirectory() : (isValidType = !file.isDirectory());
                        if (!file.exists() || !isValidType) break block10;
                        if (component != null) {
                            component.setBackground(Color.WHITE);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        if (component != null) {
                            component.setBackground(Color.RED);
                        }
                        return false;
                    }
                }
                if (!mustExist || file.exists() && isValidType) break block11;
                if (component != null) {
                    component.setBackground(Color.RED);
                }
                return false;
            }
            if (filename.length() != 0) break block12;
            if (component != null) {
                component.setBackground(Color.WHITE);
            }
            return true;
        }
        file.createNewFile();
        file.delete();
        if (component != null) {
            component.setBackground(Color.WHITE);
        }
        return true;
    }

    public static TreePath getTreePath(DefaultTreeModel treeModel, TreePath path) {
        if (treeModel == null || path == null) {
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeModel.getRoot();
        Object[] newPathObjects = new Object[path.getPathCount()];
        newPathObjects[0] = parent;
        int a = 1;
        int z = path.getPathCount();
        while (a < z) {
            String pathName = ((DefaultMutableTreeNode)path.getPathComponent(a)).getUserObject().toString();
            boolean childMatched = false;
            int b = 0;
            int y = parent.getChildCount();
            while (b < y && !childMatched) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(b);
                String childName = child.getUserObject().toString();
                if (childName.equals(pathName)) {
                    parent = child;
                    newPathObjects[a] = parent;
                    childMatched = true;
                }
                ++b;
            }
            ++a;
        }
        return new TreePath(newPathObjects);
    }
}

