/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.controller;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import thoto.jamyda.controller.MainController;
import thoto.jamyda.data.DosboxConfigData;
import thoto.jamyda.data.DosboxSettingsData;
import thoto.jamyda.gui.DlgDosBoxSettings;
import thoto.jamyda.gui.DlgTextViewer;
import thoto.jamyda.gui.JamydaComponent;
import thoto.jamyda.utils.DataUtils;
import thoto.jamyda.utils.GUIFactory;

public class CtrlDosboxSettings {
    private DlgDosBoxSettings dialog = new DlgDosBoxSettings(GUIFactory.getMainFrame());
    private boolean isApplied;
    private DosboxSettingsData data;
    private List<JamydaComponent> jamydaCompList;

    public CtrlDosboxSettings() {
        this.dialog.getBttApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxSettings.this.isApplied = true;
                CtrlDosboxSettings.this.getDialog().dispose();
            }
        });
        this.dialog.getBttCancel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxSettings.this.isApplied = false;
                CtrlDosboxSettings.this.getDialog().dispose();
            }
        });
        this.dialog.getBttHelp().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CtrlDosboxSettings.this.onHelp();
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CtrlDosboxSettings.this.onUpdateGUI();
            }
        };
        this.dialog.getTfConfigName().addKeyListener(keyListener);
        this.onUpdateGUI();
    }

    private void onUpdateGUI() {
        String name = this.dialog.getTfConfigName().getText().trim();
        boolean isFullFilled = DataUtils.isFilenameValid(name, false, false, this.getDialog().getTfConfigName()) && name.length() > 0;
        String dbExe = MainController.getInstance().getJamydaData().getDosboxPath();
        this.dialog.getBttApply().setEnabled(isFullFilled);
        this.dialog.getBttHelp().setEnabled(dbExe != null && new File(dbExe).exists());
    }

    private void onHelp() {
        Component focusedComp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        String dbExe = MainController.getInstance().getJamydaData().getDosboxPath();
        String dbConfFile = MainController.getInstance().getJamydaData().getDosboxConfigFilename();
        if (dbExe != null && dbConfFile != null) {
            File file = new File(dbExe);
            String dbConfigFilename = String.valueOf(DataUtils.getPath(file)) + dbConfFile;
            DosboxConfigData data = new DosboxConfigData(new File(dbConfigFilename));
            int lineNumber = 0;
            if (focusedComp != null) {
                lineNumber = data.getLineNumber(focusedComp.getName());
            }
            if (lineNumber == -1) {
                lineNumber = 0;
            }
            DlgTextViewer dlg = new DlgTextViewer(GUIFactory.getMainFrame());
            dlg.getTaContent().setText(data.getText());
            GUIFactory.gotoLine(dlg.getTaContent(), lineNumber);
            dlg.setVisible(true);
        }
    }

    public void setData(DosboxSettingsData data) {
        this.data = data;
        this.dialog.getPnlComponents().removeAll();
        this.dialog.getTfConfigName().setText(data.getName());
        this.jamydaCompList = new ArrayList<JamydaComponent>();
        JComponent comp = GUIFactory.create(data, this.jamydaCompList);
        if (comp != null) {
            this.dialog.getPnlComponents().add((Component)comp, "Center");
        }
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.onUpdateGUI();
    }

    public DosboxSettingsData getData() {
        if (this.jamydaCompList != null) {
            this.data.setName(this.dialog.getTfConfigName().getText());
        }
        int a = 0;
        int z = this.jamydaCompList.size();
        while (a < z) {
            this.jamydaCompList.get(a).saveData();
            ++a;
        }
        return this.data;
    }

    public DlgDosBoxSettings getDialog() {
        return this.dialog;
    }

    public boolean isApplied() {
        return this.isApplied;
    }
}

