/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.data;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import thoto.jamyda.data.DosboxSettingsData;
import thoto.jamyda.data.GroupData;
import thoto.jamyda.data.ItemData;
import thoto.jamyda.data.SectionData;
import thoto.jamyda.interfaces.IItemType;
import thoto.jamyda.utils.ItemTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosboxSettingsXMLHandler
extends DefaultHandler {
    private DosboxSettingsData appSettingsData;
    private GroupData currentGroup;
    private SectionData currentSection;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name == null) {
            return;
        }
        if (name.equals("configfile")) {
            String _name = attributes.getValue("name");
            String version = attributes.getValue("dosboxversion");
            this.appSettingsData = new DosboxSettingsData(_name, version);
        } else if (this.appSettingsData != null) {
            if (name.equals("group")) {
                String _name = attributes.getValue("name");
                this.currentGroup = new GroupData(_name);
                this.appSettingsData.add(this.currentGroup);
            } else if (this.currentGroup != null) {
                if (name.equals("section")) {
                    String _name = attributes.getValue("name");
                    this.currentSection = new SectionData(_name);
                    this.currentGroup.add(this.currentSection);
                } else if (this.currentSection != null && name.equals("item")) {
                    String _name = attributes.getValue("name");
                    IItemType type = ItemTypeFactory.get(attributes.getValue("type"));
                    String value = attributes.getValue("value");
                    List<String> values = this.getStrings("values", attributes);
                    boolean editable = this.getBoolean("edit", true, attributes);
                    int choices = this.getInt("choices", 1, attributes);
                    int minValue = this.getInt("min", -1, attributes);
                    int maxValue = this.getInt("max", -1, attributes);
                    ItemData item = new ItemData(_name, type, value, values, choices, minValue, maxValue, editable);
                    this.currentSection.add(item);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("group")) {
            this.currentGroup = null;
        } else if (name.equals("section")) {
            this.currentSection = null;
        }
    }

    private List<String> getStrings(String attrName, Attributes attributes) {
        if (attrName == null || attributes == null) {
            return null;
        }
        String values = attributes.getValue(attrName);
        if (values == null) {
            return null;
        }
        String[] arrValues = values.split(",");
        ArrayList<String> l = new ArrayList<String>(arrValues.length);
        int a = 0;
        int z = arrValues.length;
        while (a < z) {
            l.add(arrValues[a].trim());
            ++a;
        }
        return l;
    }

    private boolean getBoolean(String attrName, boolean defaultValue, Attributes attributes) {
        if (attrName == null || attributes == null) {
            return defaultValue;
        }
        String value = attributes.getValue(attrName);
        if (value == null) {
            return defaultValue;
        }
        try {
            boolean boolValue = new Boolean(value);
            return boolValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private int getInt(String attrName, int defaultValue, Attributes attributes) {
        if (attrName == null || attributes == null) {
            return defaultValue;
        }
        String value = attributes.getValue(attrName);
        if (value == null) {
            return defaultValue;
        }
        try {
            int intValue = new Integer(value);
            return intValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public DosboxSettingsData getDosboxSettingsData() {
        return this.appSettingsData;
    }
}

