/*
 * Decompiled with CFR 0.152.
 */
package thoto.jamyda.gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import thoto.jamyda.data.CategoryData;

public class DlgEditString
extends JDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel lbDescription;
    private JTextField tfContent;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    boolean isApplied = false;

    public DlgEditString(Frame owner) {
        super(owner);
        this.initComponents();
        this.tfContent.setDocument(new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str != null && !str.equals(CategoryData.PATH_SEPARATOR)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        this.tfContent.setCaretPosition(0);
        this.tfContent.moveCaretPosition(this.tfContent.getText().length());
    }

    private void tfContentKeyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.okButton.doClick();
        } else if (e.getKeyChar() == '\u001b') {
            this.cancelButton.doClick();
        }
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.isApplied = true;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.isApplied = false;
        this.dispose();
    }

    public void setText(String text) {
        this.tfContent.setText(text);
    }

    public String getText() {
        return this.tfContent.getText();
    }

    public void setDescription(String desc) {
        this.lbDescription.setText(desc);
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("thoto.jamyda.i18n.jamyda");
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.lbDescription = new JLabel();
        this.tfContent = new JTextField();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 0.0)}));
        this.lbDescription.setText("text");
        this.contentPanel.add((Component)this.lbDescription, cc.xy(1, 1));
        this.tfContent.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                DlgEditString.this.tfContentKeyTyped(e);
            }
        });
        this.contentPanel.add((Component)this.tfContent, cc.xy(1, 3));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        int[] nArray = new int[3];
        nArray[1] = 85;
        nArray[2] = 80;
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = nArray;
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText(bundle.getString("label.ok"));
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/res/icons/16x16/objects_007.gif")));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgEditString.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(bundle.getString("FileChooser.cancelButtonText"));
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/res/icons/16x16/objects_079.gif")));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgEditString.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public boolean isApplied() {
        return this.isApplied;
    }
}

