// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	Direct2D+GDI ɂʕ` (HiColor ȏ)
// ---------------------------------------------------------------------------

#include "headers.h"
#include "drawd2d.h"

#pragma comment( lib,    "delayimp.lib" )
#pragma comment( lib,    "d2d1.lib" )

template <class T> void SafeRelease(T **ppT)
{
	if (*ppT) {
		(*ppT)->Release();
		*ppT = NULL;
	}
}

// ---------------------------------------------------------------------------
//	\z/
//
WinDrawD2D::WinDrawD2D() :
	m_hWnd(0),
	m_hCWnd(0),
	m_image(0),
	m_GDIRT(0),
	m_D2DFact(0),
	m_RenderTarget(0),
	m_UpdatePal(false),
	m_hBitmap(0),
	m_nMag(1),
	m_nBitmapW(640),
	m_nBitmapH(400)
{
}

WinDrawD2D::~WinDrawD2D()
{
	Cleanup();
}

// ---------------------------------------------------------------------------
//	
//
bool WinDrawD2D::Init( HWND _hWnd, uint _width, uint _height, GUID* g, int mag)
{
	m_hWnd = _hWnd;
	m_nMag = mag;

	if ( CreateD2D(_width, _height) == false ) {
		return false;
	}

	if ( Resize( _width, _height ) == false ) {
		return false;
	}
	return true;
}

void WinDrawD2D::SetGUIMode( bool _mode )
{
	// mode check

	if ( _mode == 1 ) {
		// Full
	} else {
		// Normal
	}
}


bool WinDrawD2D::CreateD2D(uint w, uint h)
{
	// OSo[W̃`FbN
	OSVERSIONINFOEX osinfo;
	memset( &osinfo, 0, sizeof( osinfo ) );
	osinfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFOEX );
	::GetVersionEx( (OSVERSIONINFO*)&osinfo );
	if ( osinfo.dwMajorVersion < 6 ) {
		// Vista(ver6.0)ȑO͎s
		return false;
	}

	Cleanup();

	if ( m_hCWnd == 0 ) {
		// Base window𐶐
		m_hCWnd = ::CreateWindowEx(
			WS_EX_TRANSPARENT,
			"M88p2 WinUI",
			"",
			WS_CHILD,
			0,
			0,
			w,
			h,
			m_hWnd,
			NULL, NULL, NULL);
	}

	if ( m_hCWnd == 0 ) {
		return false;
	} else {
		::ShowWindow( m_hCWnd, SW_SHOW );
	}

	// D2D factory쐬
	HRESULT hr;
	hr = ::D2D1CreateFactory( D2D1_FACTORY_TYPE_MULTI_THREADED,
							  &m_D2DFact );

	if ( SUCCEEDED(hr) ) {
		return true;
	} else {
		return false;
	}
}

//! ʗL͈͂ύX
//
bool WinDrawD2D::Resize( uint _width, uint _height )
{
	m_width  = _width;
	m_height = _height;

	status |= Draw::shouldrefresh;

	HRESULT hr = S_OK;

	::SetWindowPos( m_hCWnd, HWND_BOTTOM, 0, 0, m_width, m_height, SWP_SHOWWINDOW);

	if ( !m_RenderTarget ) {

		D2D1_SIZE_U size = D2D1::SizeU(
			_width,
			_height
			);

		D2D1_RENDER_TARGET_PROPERTIES RTProps = D2D1::RenderTargetProperties();
		m_D2DFact->GetDesktopDpi( &RTProps.dpiX, &RTProps.dpiY );
		RTProps.usage =  D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE;

		// Create a GDI compatible Hwnd render target.
		hr = m_D2DFact->CreateHwndRenderTarget(
			RTProps,
			D2D1::HwndRenderTargetProperties( m_hCWnd, size ),
			&m_RenderTarget
			);

		if (SUCCEEDED(hr)) {
			hr = m_RenderTarget->QueryInterface(
				__uuidof(ID2D1GdiInteropRenderTarget),
				(void**)&m_GDIRT
				);
		}

		if ( MakeBitmap() == false ) {
			return false;
		}
		memset( m_image, 0x40, m_nBitmapW * m_nBitmapH);
	} else {
		RECT rc;
		GetClientRect( m_hCWnd, &rc );
		D2D1_SIZE_U size = D2D1::SizeU(
			rc.right - rc.left,
			rc.bottom - rc.top
			);
		m_RenderTarget->Resize( size );
	}

	if ( !SUCCEEDED(hr) ) {
		return false;
	}


	return true;
}

//! Еt
//
bool WinDrawD2D::Cleanup()
{
	SafeRelease( &m_GDIRT );
	SafeRelease( &m_RenderTarget );
	SafeRelease( &m_D2DFact );
	if ( m_hBitmap ) {
		::DeleteObject( m_hBitmap );
		m_hBitmap = 0;
	}
	if ( m_hCWnd ) {
		::DestroyWindow( m_hCWnd );
		m_hCWnd = 0;
	}
	return true;
}

//! BITMAP 쐬
//
bool WinDrawD2D::MakeBitmap()
{
	m_bmpinfo.header.biSize          = sizeof(BITMAPINFOHEADER);
	m_bmpinfo.header.biWidth         = m_nBitmapW;
	m_bmpinfo.header.biHeight        = -(int)m_nBitmapH;
	m_bmpinfo.header.biPlanes        = 1;
	m_bmpinfo.header.biBitCount      = 8;
	m_bmpinfo.header.biCompression   = BI_RGB;
	m_bmpinfo.header.biSizeImage     = 0;
	m_bmpinfo.header.biXPelsPerMeter = 0;
	m_bmpinfo.header.biYPelsPerMeter = 0;
	m_bmpinfo.header.biClrUsed       = 256;
	m_bmpinfo.header.biClrImportant  = 0;

	m_RenderTarget->BeginDraw();

	// pbgꍇ
	HDC hdc;
	m_GDIRT->GetDC( D2D1_DC_INITIALIZE_MODE_COPY, &hdc );

	memset( m_bmpinfo.colors, 0, sizeof(RGBQUAD) * 256 );

	if ( m_hBitmap ) {
		::DeleteObject( m_hBitmap );
	}
	BYTE* bitmapimage = 0;
	m_hBitmap = ::CreateDIBSection( hdc,
									(BITMAPINFO*) &m_bmpinfo,
									DIB_RGB_COLORS,
									(void**)(&bitmapimage),
									NULL,
									0 );

	RECT rect = { 0,0,m_nBitmapW,m_nBitmapH };
	m_GDIRT->ReleaseDC( &rect );
	m_RenderTarget->EndDraw();

	if ( m_hBitmap == 0 ) {
		return false;
	}

	bpl = m_nBitmapW;
	m_image = bitmapimage;
	return true;
}

//! pbgݒ
//	index Ԗڂ̃pbg pe Zbg
//
void WinDrawD2D::SetPalette(PALETTEENTRY* _pe, int index, int nentries)
{
	for (; nentries>0; nentries--)
	{
		m_bmpinfo.colors[index].rgbRed   = _pe->peRed;
		m_bmpinfo.colors[index].rgbBlue  = _pe->peBlue;
		m_bmpinfo.colors[index].rgbGreen = _pe->peGreen;
		index++, _pe++;
	}
	m_UpdatePal = true;
}

//! `
//
void WinDrawD2D::DrawScreen(const RECT& _rect, bool refresh)
{
	if ( ::IsWindow(m_hWnd) == FALSE ) {
		return;
	}

	m_RenderTarget->BeginDraw();

//	m_RenderTarget->Clear( D2D1::ColorF(D2D1::ColorF::Black) );

	RECT rc = _rect;
	bool valid = rc.left < rc.right && rc.top < rc.bottom;

	if ( refresh || m_UpdatePal ) {
		::SetRect( &rc, 0, 0, m_nBitmapW, m_nBitmapH );
		valid = true;
	}

	if (valid) {
		HRESULT hr;
		HDC hDC = NULL;
		hr = m_GDIRT->GetDC( D2D1_DC_INITIALIZE_MODE_COPY, &hDC );

		HDC hmemdc = ::CreateCompatibleDC( hDC );
		HBITMAP oldbitmap = (HBITMAP)::SelectObject( hmemdc, m_hBitmap );
		if ( m_UpdatePal ) {
			m_UpdatePal = false;
			::SetDIBColorTable( hmemdc, 0, 0x100, m_bmpinfo.colors );
		}

		if (m_nMag > 1) {
			::StretchBlt(
				hDC,
				rc.left * m_nMag,
				rc.top * m_nMag,
				(rc.right - rc.left) * m_nMag,
				(rc.bottom - rc.top) * m_nMag,
				hmemdc,
				rc.left,
				rc.top,
				rc.right - rc.left,
				rc.bottom - rc.top,
				SRCCOPY);
		} else {
			::BitBlt( hDC, rc.left, rc.top,
					  rc.right - rc.left, rc.bottom - rc.top,
					  hmemdc, rc.left, rc.top,
					  SRCCOPY);
		}

		::SelectObject( hmemdc, oldbitmap );
		::DeleteDC( hmemdc );

		RECT rect = { 0,0,m_nBitmapW * m_nMag,m_nBitmapH * m_nMag };
		m_GDIRT->ReleaseDC( &rect );
	}

	if ( m_RenderTarget->EndDraw() == D2DERR_RECREATE_TARGET ) {
		// device lost
	}
}

//! ʃC[W̎gpv
// @param _pimage [out] image pointer
// @param _pbpl   [out] width
//
bool WinDrawD2D::Lock(uint8** _pimage, int* _pbpl)
{
	*_pimage = m_image;
	*_pbpl = bpl;
	return m_image != 0;
}

//! ʃC[W̎gpI
//
bool WinDrawD2D::Unlock()
{
	status &= ~Draw::shouldrefresh;
	return true;
}

