// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	GDI ɂʕ` (HiColor ȏ)
// ---------------------------------------------------------------------------
//	$Id: DrawGDI.cpp,v 1.13 2003/04/22 13:16:35 cisc Exp $

//	bug:pbg`(T-T

#include "headers.h"
#include "drawgdi.h"

// ---------------------------------------------------------------------------
//	\z/
//
WinDrawGDI::WinDrawGDI()
:	hwnd(0),
	hbitmap(0),
	updatepal(false),
	bitmapimage(0),
	image(0),
	m_nBitmapW(640),
	m_nBitmapH(400)
{
}

WinDrawGDI::~WinDrawGDI()
{
	Cleanup();
}

// ---------------------------------------------------------------------------
//	
//
bool WinDrawGDI::Init(HWND hwindow, uint w, uint h, GUID* g, int mag)
{
	hwnd = hwindow;
	m_nMag = mag;

	if (!Resize(w, h))
		return false;
	return true;
}

// ---------------------------------------------------------------------------
//	ʗL͈͂ύX
//
bool WinDrawGDI::Resize(uint w, uint h)
{
	width = w;
	height = h;

	if (!MakeBitmap())
		return false;

	memset(image, 0x40, m_nBitmapW * m_nBitmapH);
	status |= Draw::shouldrefresh;
	return true;
}

// ---------------------------------------------------------------------------
//	Еt
//
bool WinDrawGDI::Cleanup()
{
	if (hbitmap)
	{
		DeleteObject(hbitmap), hbitmap = 0;
	}
	return true;
}

// ---------------------------------------------------------------------------
//	BITMAP 쐬
//
bool WinDrawGDI::MakeBitmap()
{
	binfo.header.biSize          = sizeof(BITMAPINFOHEADER);
	binfo.header.biWidth         = m_nBitmapW;
	binfo.header.biHeight        = -(int)m_nBitmapH;
	binfo.header.biPlanes        = 1;
	binfo.header.biBitCount      = 8;
	binfo.header.biCompression   = BI_RGB;
	binfo.header.biSizeImage     = 0;
	binfo.header.biXPelsPerMeter = 0;
	binfo.header.biYPelsPerMeter = 0;
	binfo.header.biClrUsed       = 256;
	binfo.header.biClrImportant  = 0;

	// pbgȂꍇ
	
	HDC hdc = GetDC(hwnd);
	memset(binfo.colors, 0, sizeof(RGBQUAD) * 256);

	if (hbitmap)
		DeleteObject(hbitmap);
	hbitmap = CreateDIBSection( hdc,
								(BITMAPINFO*) &binfo,
								DIB_RGB_COLORS,
								(void**)(&bitmapimage),
								NULL, 
								0 );

	ReleaseDC(hwnd, hdc);

	if (!hbitmap)
		return false;
	
	bpl = m_nBitmapW;
	image = bitmapimage;
	return true;
}

// ---------------------------------------------------------------------------
//	pbgݒ
//	index Ԗڂ̃pbg pe Zbg
//
void WinDrawGDI::SetPalette(PALETTEENTRY* pe, int index, int nentries)
{
	for (; nentries>0; nentries--)
	{
		binfo.colors[index].rgbRed = pe->peRed;
		binfo.colors[index].rgbBlue = pe->peBlue;
		binfo.colors[index].rgbGreen = pe->peGreen;
		index++, pe++;
	}
	updatepal = true;
}

// ---------------------------------------------------------------------------
//	`
//
void WinDrawGDI::DrawScreen(const RECT& _rect, bool refresh)
{
	RECT rect = _rect;
	bool valid = rect.left < rect.right && rect.top < rect.bottom;

	if (refresh || updatepal)
		SetRect(&rect, 0, 0, m_nBitmapW, m_nBitmapH), valid = true;
	
	if (valid)
	{
		HDC hdc = GetDC(hwnd);
		HDC hmemdc = CreateCompatibleDC(hdc);
		HBITMAP oldbitmap = (HBITMAP) SelectObject(hmemdc, hbitmap);
		if (updatepal)
		{
			updatepal = false;
			SetDIBColorTable(hmemdc, 0, 0x100, binfo.colors);
		}

		if (m_nMag > 1) {
			StretchBlt(
				hdc,
				rect.left * m_nMag,
				rect.top * m_nMag,
				(rect.right - rect.left) * m_nMag,
				(rect.bottom - rect.top) * m_nMag,
				hmemdc,
				rect.left,
				rect.top,
				rect.right - rect.left,
				rect.bottom - rect.top,
				SRCCOPY);
		} else {
				BitBlt(hdc, rect.left, rect.top, 
					rect.right - rect.left, rect.bottom - rect.top, 
					hmemdc, rect.left, rect.top, 
					SRCCOPY);
		}
		
		SelectObject(hmemdc, oldbitmap);
		DeleteDC(hmemdc);
		ReleaseDC(hwnd, hdc);
	}
}

// ---------------------------------------------------------------------------
//	ʃC[W̎gpv
//
bool WinDrawGDI::Lock(uint8** pimage, int* pbpl)
{
	*pimage = image;
	*pbpl = bpl;
	return image != 0;
}

// ---------------------------------------------------------------------------
//	ʃC[W̎gpI
//
bool WinDrawGDI::Unlock()
{
	status &= ~Draw::shouldrefresh;
	return true;
}

