/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2019 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2019 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021-2025 GIMONS
 *
 *	[ XPW[ ]
 *
 *	RHG
 *	  2001.11.19		Xe[gt@C(Cxg16^Cv)̃[hɑΉ
 *	  2001.11.24		TuHALT^C~OύX
 *	  2002.03.06		VMzԃJE^(@ˑƂ͕)ǉ
 *	  2002.03.07		ݒ\u[N|Cg16ɕύX
 *	  2002.06.21		VRAMANZXtOOÑTuCPUx^(^^;)
 *						31ɕύX
 *	  2002.07.17		ZbgRTCCxĝ݃NAȂ悤ɕύX
 *	  2002.08.03		S͋쓮sDMAC𓮂Ȃ悤ɕύX
 *	  2002.11.12		sTCN̗_lƎۂ̒l𒲐鏈ǉ
 *						TuHALT̎sTCNݒ@ύX
 *						TuCPU߂s邱ƂC
 *	  2002.12.17		FDDEFCg[hAfBXN쒆͑S͋쓮Ȃ悤
 *						ɕύX
 *	  2003.05.02		TuCPŨftHgsTCNύX
 *	  2003.06.03		CCPUETuCPŨftHgsTCN
 *	  2003.06.19		MMR֘AWX^ύX̑x␳𓱓
 *	  2003.11.21		XM7 V1.1Ή
 *						u[N|CgCPU`FbN
 *	  2004.01.24		TEh̎Ԑx
 *	  2004.01.25		e[vj^tapelp.cړ
 *	  2008.01.20		ȂƂɂ
 *	  2012.04.20		sTCN/TCNX`[[h̃Xe[gf[^
 *						̕ۑ/A@\
 *						炭grsɂȂĂexec0p~
 *	  2017.03.07		CCPŨftHgsTCN
 *						ᑬ[h̑x@ɋ߂邽߂̃`[jO
 */

#include <string.h>
#include "xm7.h"
#include "subctrl.h"
#include "display.h"
#include "mmr.h"
#include "fdc.h"
#include "jsubsys.h"
#if XM7_VER >= 3
#include "dmac.h"
#endif
#include "device.h"
#include "event.h"
#include "tapelp.h"

/*
 *	O[o [N
 */
BOOL run_flag;							/* 쒆tO */
BOOL stopreq_flag;						/* ~vtO */
event_t event[EVENT_MAXNUM];			/* Cxg f[^ */
breakp_t breakp[BREAKP_MAXNUM];			/* u[N|Cg f[^ */
WORD main_runadr;						/* CCPȖOsAhX */
WORD sub_runadr;						/* TuCPȖOsAhX */
DWORD main_speed;						/* CCPUXs[h */
DWORD mmr_speed;						/* C(MMR)Xs[h */
#if XM7_VER >= 3
DWORD fmmr_speed;						/* C(MMR)Xs[h */
#endif
DWORD sub_speed;						/* TuCPUXs[h */
WORD main_overcycles;					/* CCPUI[o[TCN */
WORD sub_overcycles;					/* TuCPUI[o[TCN */
BOOL cycle_steal;						/* TCNX`[tO */
BOOL cycle_steal_default;				/* TCNX`[ftHgtO */
BOOL subclock_mode;						/* TuCPU uLO^C~O */
DWORD speed_ratio;						/* CPU쑬x(%) */
DWORD vmtime;							/* VMz */
#if XM7_VER == 1
DWORD main_speed_low;					/* CCPUXs[h(ᑬ) */
DWORD sub_speed_low;					/* TuCPUXs[h(ᑬ) */
BOOL motoron_lowspeed;					/* CMT[ONᑬ[h */
#ifdef JSUB
DWORD jsub_speed;						/* {TuCPUXs[h */
WORD jsub_overcycles;					/* {TuCPUI[o[TCN */
WORD jsub_runadr;						/* {TuCPȖOsAhX */
#endif
#ifdef Z80CARD
WORD mainz80_runadr;					/* CCPU(Z80)̑OsAhX */
#endif
#endif

/*
 *	X^eBbN [N
 */
static BOOL break_flag;					/* u[N|CgLtO */

/*
 *	XPW[
 *	
 */
BOOL FASTCALL schedule_init(void)
{
	run_flag = FALSE;
	stopreq_flag = FALSE;
	break_flag = FALSE;
	memset(breakp, 0, sizeof(breakp));
	memset(event, 0, sizeof(event));

	/* CPUxݒ */
	main_speed = MAINCYCLES * 10;
	mmr_speed = MAINCYCLES_MMR * 10;
#if XM7_VER >= 3
	fmmr_speed = MAINCYCLES_FMMR * 10;
#endif
	sub_speed = SUBCYCLES * 10;
	cycle_steal = TRUE;
	cycle_steal_default = TRUE;
#if XM7_VER == 1
	subclock_mode = TRUE;
#else
	subclock_mode = FALSE;
#endif
	main_overcycles = 0;
	sub_overcycles = 0;
#if XM7_VER == 1
	main_speed_low = MAINCYCLES_LOW * 10;
	sub_speed_low = SUBCYCLES_LOW * 10;
	motoron_lowspeed = TRUE;
#ifdef JSUB
	jsub_speed = JSUBCYCLES * 10;
	jsub_overcycles = 0;
#endif
#endif

	/* zԏ */
	vmtime = 0;

	return TRUE;
}

/*
 *	XPW[
 *	N[Abv
 */
void FASTCALL schedule_cleanup(void)
{
}

/*
 *	XPW[
 *	Zbg
 */
void FASTCALL schedule_reset(void)
{
	int i;

	/* RTCCxgȊÕXPW[NA */
	/* (XM7NRTCCxg schedule_init ŃNAĂ) */
	for (i=0; i<EVENT_MAXNUM; i++) {
		if (i != EVENT_RTC) {
			memset(&event[i], 0, sizeof(event_t));
		}
	}

	/* JE^NA */
	maincpu.total = 0;
	subcpu.total = 0;
	main_overcycles = 0;
	sub_overcycles = 0;
#if XM7_VER == 1 && defined(JSUB)
	jsubcpu.total = 0;
	jsub_overcycles = 0;
#endif

	/* O̎sAhX */
	main_runadr = 0xFFFF;
	sub_runadr = 0xFFFF;
#if XM7_VER == 1
#ifdef JSUB
	jsub_runadr = 0xFFFF;
#endif
#ifdef Z80CARD
	mainz80_runadr = 0xFFFF;
#endif
#endif

	/* zԏ */
	vmtime = 0;

	/* sx䗦 */
	speed_ratio = 10000;

	/* TCNX`[ݒ菉 */
	cycle_steal = cycle_steal_default;
}

/*
 *	XPW[
 *	sTCN擾
 */
DWORD FASTCALL schedule_get_cycle(void)
{
	DWORD tmp;

#if XM7_VER >= 3
	if (mmr_fastmode) {
		tmp = fmmr_speed;
	}
	else
#endif
#if XM7_VER == 1
	if (lowspeed_mode ||
		((fm_subtype == FMSUB_FM8) && tape_motor && motoron_lowspeed)) {
		tmp = main_speed_low;
	}
	else {
#else
	{
#endif
		if (mmr_flag || twr_flag) {
			tmp = mmr_speed;
		}
		else {
			tmp = main_speed;
		}
	}

#if XM7_VER >= 3
	/* tbV[h̃TCN𐶐 */
	if (!mmr_fastmode && mmr_fast_refresh) {
		if (mmr_flag || twr_flag) {
			/* MMR/TWRL 8.9%Abv */
			tmp = (DWORD)((tmp * 4461) >> 12);
		}
		else {
			/* MMR/TWR 8.6%Abv */
			tmp = (DWORD)((tmp * 4447) >> 12);
		}
	}
#endif

	/* CPUx䗦 */
	if (speed_ratio != 10000) {
		tmp = (tmp * speed_ratio) / 10000;
		if (tmp < 1) {
			tmp = 1;
		}
	}

	return tmp;
}

/*-[ Cxg ]-------------------------------------------------------------*/

/*
 *	XPW[
 *	Cxgݒ
 */
BOOL FASTCALL schedule_setevent(int id, DWORD microsec, BOOL (FASTCALL *func)(void))
{
	DWORD exec;

	ASSERT((id >= 0) && (id < EVENT_MAXNUM));
	ASSERT(func);

	if ((id < 0) || (id >= EVENT_MAXNUM)) {
		return FALSE;
	}
	if (microsec == 0) {
		event[id].flag = EVENT_NOTUSE;
		return FALSE;
	}

	/* o^ */
	event[id].current = microsec;
	event[id].reload = microsec;
	event[id].callback = func;
	event[id].flag = EVENT_ENABLED;

	/* sȂAԂ𑫂ĂKv(ň) */
	if (run_flag) {
		exec = (DWORD)maincpu.total;
		exec *= 10000;
		exec /= schedule_get_cycle();
		event[id].current += exec;
	}

	return TRUE;
}

/*
 *	XPW[
 *	Cxg폜
 */
BOOL FASTCALL schedule_delevent(int id)
{
	ASSERT((id >= 0) && (id < EVENT_MAXNUM));

	if ((id < 0) || (id >= EVENT_MAXNUM)) {
		return FALSE;
	}

	/* gp */
	event[id].flag = EVENT_NOTUSE;

	return TRUE;
}

/*
 *	XPW[
 *	Cxg擾
 */
event_t* FASTCALL schedule_getevent(int id)
{
	ASSERT((id >= 0) && (id < EVENT_MAXNUM));

	if ((id < 0) || (id >= EVENT_MAXNUM)) {
		return NULL;
	}

	/* |C^ԋp */
	return &event[id];
}

/*
 *	XPW[
 *	Cxgnhݒ
 */
void FASTCALL schedule_handle(int id, BOOL (FASTCALL *func)(void))
{
	ASSERT((id >= 0) && (id < EVENT_MAXNUM));
	ASSERT(func);

	/* R[obN֐o^̂݁BȊO͐GȂ */
	event[id].callback = func;
}

/*
 *	XPW[
 *	ŒZsԒ
 */
static DWORD FASTCALL schedule_chkevent(DWORD microsec)
{
	DWORD exectime;
	int i;

	/* ݒ */
	exectime = microsec;

	/* CxgĒ */
	for (i=0; i<EVENT_MAXNUM; i++) {
		if (event[i].flag == EVENT_NOTUSE) {
			continue;
		}

		ASSERT(event[i].current > 0);
		ASSERT(event[i].reload > 0);

		if (event[i].current < exectime) {
			exectime = event[i].current;
		}
	}

	return exectime;
}

/*
 *	XPW[
 *	is
 */
static void FASTCALL schedule_doevent(DWORD microsec)
{
	int i;

	for (i=0; i<EVENT_MAXNUM; i++) {
		if (event[i].flag == EVENT_NOTUSE) {
			continue;
		}

		ASSERT(event[i].current > 0);
		ASSERT(event[i].reload > 0);

		/* sԂ */
		if (event[i].current < microsec) {
			event[i].current = 0;
		}
		else {
			event[i].current -= microsec;
		}

		/* JE^0Ȃ */
		if (event[i].current == 0) {
			/* ԂENABLE,DISABLEɂ炸[h */
			event[i].current = event[i].reload;
			/* R[obNs */
			if (event[i].flag == EVENT_ENABLED) {
				if (!event[i].callback()) {
					event[i].flag = EVENT_DISABLED;
				}
			}
		}
	}
}

/*-[ u[N|Cg ]-----------------------------------------------------*/

/*
 *	XPW[
 *	u[N|CgZbg(łɃZbgĂΏ)
 */
BOOL FASTCALL schedule_setbreak(int cpu, WORD addr)
{
	int i;

	/* ܂ASẴu[N|CgA邩 */
	for (i=0; i<BREAKP_MAXNUM; i++) {
		if (breakp[i].flag != BREAKP_NOTUSE) {
			if ((breakp[i].cpu == cpu) && (breakp[i].addr == addr)) {
				break;
			}
		}
	}
	/* ΁A폜 */
	if (i != BREAKP_MAXNUM) {
		breakp[i].flag = BREAKP_NOTUSE;
		/* u[NLtO`FbN */
		break_flag = FALSE;
		for (i=0; i<BREAKP_MAXNUM; i++) {
			if (breakp[i].flag != BREAKP_NOTUSE) {
				break_flag = TRUE;
			}
		}
		return TRUE;
	}

	/* 󂫂𒲍 */
	for (i=0; i<BREAKP_MAXNUM; i++) {
		if (breakp[i].flag == BREAKP_NOTUSE) {
			break;
		}
	}
	/* ׂĖ܂Ă邩 */
	if (i == BREAKP_MAXNUM) {
		return FALSE;
	}

	/* Zbg */
	breakp[i].flag = BREAKP_ENABLED;
	breakp[i].cpu = cpu;
	breakp[i].addr = addr;

	/* u[NL */
	break_flag = TRUE;

	return TRUE;
}

/*
 *	XPW[
 *	u[N|CgZbg(ʒuw)
 */
BOOL FASTCALL schedule_setbreak2(int num, int cpu, WORD addr)
{
	/* Zbg */
	if (breakp[num].flag != BREAKP_DISABLED) {
		breakp[num].flag = BREAKP_ENABLED;
	}
	breakp[num].cpu = cpu;
	breakp[num].addr = addr;

	/* u[NL */
	break_flag = TRUE;

	return TRUE;
}

/*
 *	XPW[
 *	u[N`FbN
 */
static BOOL FASTCALL schedule_chkbreak(void)
{
	int i;
	WORD main_prevrunadr;
	WORD sub_prevrunadr;
#if XM7_VER == 1
#ifdef JSUB
	WORD jsub_prevrunadr;
#endif
#ifdef Z80CARD
	WORD mainz80_prevrunadr;
#endif
#endif

	ASSERT(break_flag);

	/* A₱c */
#if XM7_VER == 1 && defined(Z80CARD)
	if (!main_z80mode) {
		main_prevrunadr = main_runadr;
		main_runadr = maincpu.pc;
	}
	else {
		mainz80_prevrunadr = mainz80_runadr;
		mainz80_runadr = (WORD)mainz80.pc;
	}
#else
	main_prevrunadr = main_runadr;
	main_runadr = maincpu.pc;
#endif
	sub_prevrunadr = sub_runadr;
	sub_runadr = subcpu.pc;
#if XM7_VER == 1 && defined(JSUB)
	jsub_prevrunadr = jsub_runadr;
	jsub_runadr = jsubcpu.pc;
#endif

	for (i=0; i<BREAKP_MAXNUM; i++) {
		if (breakp[i].flag == BREAKP_ENABLED) {
#if XM7_VER == 1 && defined(Z80CARD)
			/* CCPUZ80̏ꍇA */
			if ((breakp[i].cpu == MAINCPU) && !main_z80mode) {
#else
			if (breakp[i].cpu == MAINCPU) {
#endif
				if (breakp[i].addr == maincpu.pc) {
					if (maincpu.pc != main_prevrunadr) {
						return TRUE;
					}
				}
			}
			else if (breakp[i].cpu == SUBCPU) {
				if (breakp[i].addr == subcpu.pc) {
					if (subcpu.pc != sub_prevrunadr) {
						return TRUE;
					}
				}
			}
#if XM7_VER == 1
#ifdef JSUB
			else if (breakp[i].cpu == JSUBCPU) {
				if (breakp[i].addr == jsubcpu.pc) {
					if (jsubcpu.pc != jsub_prevrunadr) {
						return TRUE;
					}
				}
			}
#endif
#ifdef Z80CARD
			/* CCPUZ80̏ꍇ̂ݗL */
			else if ((breakp[i].cpu == MAINZ80) && main_z80mode) {
				if (breakp[i].addr == (WORD)mainz80.pc) {
					if ((WORD)mainz80.pc != mainz80_prevrunadr) {
						return TRUE;
					}
				}
			}
#endif
#endif
		}
	}

	return FALSE;
}

/*-[ s ]---------------------------------------------------------------*/

/*
 *	g[X
 */
void FASTCALL schedule_trace(void)
{
	/* Pߎs */
#if XM7_VER >= 3
	if (!dma_burst_transfer || !dma_flag) {
		maincpu_execline();
	}
#else
	maincpu_execline();
#endif

#if XM7_VER >= 3
	/* DMA] */
	if (dma_flag) {
		dmac_exec();
	}
#endif

	if ((!subhalt_flag || (subcpu.intr & INTR_HALT)) &&
		(cycle_steal || (subclock_mode || !(vrama_flag && !blank_flag)))) {
		subcpu_execline();
		/* VRAMANZXtOON̏ꍇ,vNbN3{ɂ */
		if (!cycle_steal && subclock_mode && vrama_flag) {
			subcpu.total += (WORD)(subcpu.cycle * 1.86f);
		}
	}
#if XM7_VER == 1 && defined(JSUB)
	if (jsub_available && jsub_enable && !jsub_haltflag &&
		(fm_subtype != FMSUB_FM8)) {
		jsubcpu_execline();
	}
#endif

	/* HALTvɉ (V3.1) */
	subctrl_halt_ack();

	/* I[o[TCNNA */
	main_overcycles = 0;
	sub_overcycles = 0;
#if XM7_VER == 1 && defined(JSUB)
	jsub_overcycles = 0;
#endif
}

/*
 *	CS͋쓮
 */
void FASTCALL schedule_main_fullspeed(void)
{
	ASSERT(run_flag);
	ASSERT(!stopreq_flag);

#if XM7_VER >= 3
	if (dma_burst_transfer) {
		/* o[Xg]sBCCPU͓Ȃ */
		return;
	}
#endif

	if (break_flag) {
		/* u[N|Cg */
		if (schedule_chkbreak()) {
			stopreq_flag = TRUE;
		}
		if (stopreq_flag) {
			return;
		}
	}

	/* CCPUs */
#ifdef FDDSND
	if (!fdc_waitmode || !(fdc_status & FDC_ST_BUSY)) {
		maincpu_exec();
	}
#else
	maincpu_exec();
#endif

	/* HALTvɉ (V3.1) */
	subctrl_halt_ack();

	/* I[o[TCNNA */
	main_overcycles = 0;
}

/*
 *	S͋쓮
 */
void FASTCALL schedule_fullspeed(void)
{
	ASSERT(run_flag);
	ASSERT(!stopreq_flag);

	if (break_flag) {
		/* u[N|Cg */
		if (schedule_chkbreak()) {
			stopreq_flag = TRUE;
		}
		if (stopreq_flag) {
			return;
		}
	}

	/* CCPUs */
#if XM7_VER >= 3
	if (!dma_burst_transfer) {
#ifdef FDDSND
		if (!fdc_waitmode || !(fdc_status & FDC_ST_BUSY)) {
			maincpu_exec();
		}
#else
		maincpu_exec();
#endif
	}
#else
#ifdef FDDSND
	if (!fdc_waitmode || !(fdc_status & FDC_ST_BUSY)) {
		maincpu_exec();
	}
#else
	maincpu_exec();
#endif
#endif

	/* TuCPUs */
	if ((!subhalt_flag || (subcpu.intr & INTR_HALT)) &&
		(cycle_steal || (subclock_mode || !(vrama_flag && !blank_flag)))) {
		subcpu_execline();
		/* VRAMANZXtOON̏ꍇ,vNbN3{ɂ */
		if (!cycle_steal && subclock_mode && vrama_flag) {
			subcpu.total += (WORD)(subcpu.cycle * 1.86f);
		}
	}

#if XM7_VER == 1 && defined(JSUB)
	/* {TuCPUs */
	if (jsub_available && jsub_enable && !jsub_haltflag &&
		(fm_subtype != FMSUB_FM8)) {
		jsubcpu_execline();
	}
#endif

	/* HALTvɉ (V3.1) */
	subctrl_halt_ack();

	/* I[o[TCNNA */
	main_overcycles = 0;
	sub_overcycles = 0;
#if XM7_VER == 1 && defined(JSUB)
	jsub_overcycles = 0;
#endif
}

/*
 *	s
 */
DWORD FASTCALL schedule_exec(DWORD microsec)
{
	DWORD exec;
	DWORD exec2;
	DWORD count;
	DWORD cycle;
	DWORD ratio;
	WORD main;
	WORD sub;
	DWORD limit;
	DWORD tmp;
#if XM7_VER == 1 && defined(JSUB)
	DWORD ratio_js;
	WORD jsub;
#endif

	/* ASSERT(run_flag); */
	if (!run_flag) {
		return 0;
	}
	ASSERT(!stopreq_flag);

	/* ŒZ̎sԂ𓾂 */
	exec = schedule_chkevent(microsec);
	exec2 = 0;

	do {
		/* CCPUƃTuCPU̓쑬x䗦߂ */
		cycle = schedule_get_cycle();
#if XM7_VER == 1
		if (lowspeed_mode) {
			tmp = (sub_speed_low * speed_ratio) / 100000;
		}
		else {
			tmp = (sub_speed * speed_ratio) / 100000;
		}
#else
		tmp = (sub_speed * speed_ratio) / 100000;
#endif
		if (tmp < 1) {
			tmp = 1;
		}
		ratio = (tmp << 12);
		ratio /= (cycle / 10);
#if XM7_VER == 1 && defined(JSUB)
		tmp = (jsub_speed * speed_ratio) / 100000;
		if (tmp < 1) {
			tmp = 1;
		}
		ratio_js = (tmp << 12);
		ratio_js /= (cycle / 10);
#endif

		/* CPUԂɊZ */
		count = cycle;
		count *= (exec - exec2);
		count /= 10000;
		main = (WORD)count;
		sub = (WORD)((main * ratio) >> 12);
#if XM7_VER == 1 && defined(JSUB)
		jsub = (WORD)((main * ratio_js) >> 12);
#endif

		/* JE^EtO */
		maincpu.total = main_overcycles;
		subcpu.total = sub_overcycles;
#if XM7_VER == 1 && defined(JSUB)
		jsubcpu.total = jsub_overcycles;
#endif
		mmr_modify = FALSE;

		if (cycle_steal) {
			if (break_flag) {
				/* TCNX`[Au[N|Cg */

				/* s */
				while ((maincpu.total < main) && !mmr_modify) {
					if (schedule_chkbreak()) {
						stopreq_flag = TRUE;
					}
					if (stopreq_flag) {
						break;
					}

#if XM7_VER >= 3
					/* CCPUs */
					if (!dma_burst_transfer) {
						maincpu_exec();
					}

					/* DMA] */
					if (dma_flag) {
						dmac_exec();
					}
#else
					/* CCPUs */
					maincpu_exec();
#endif

					/* TuCLR߂gpBUSYtO𑀍삵ꍇ */
					/* ㏈(MAGUS) */
					if (busy_CLR_count > 0) {
						if (busy_CLR_count >= 2) {
							subbusy_flag = TRUE;
						}
						busy_CLR_count = 0;
					}

					/* TuCPUs */
					limit = maincpu.total * ratio;
					if (subhalt_flag && !(subcpu.intr & INTR_HALT)) {
						/* CCPUƋ */
						subcpu.total = (WORD)(limit >> 12);
					}
					else {
						while (((DWORD)subcpu.total << 12) < limit) {
							if (schedule_chkbreak()) {
								stopreq_flag = TRUE;
							}
							if (stopreq_flag) {
								break;
							}
							subcpu_exec();
						}
					}

#if XM7_VER == 1 && defined(JSUB)
					/* {TuCPUs */
					limit = maincpu.total * ratio_js;
					while ((((DWORD)jsubcpu.total << 12) < limit) &&
							jsub_available && jsub_enable && !jsub_haltflag &&
							(fm_subtype != FMSUB_FM8)) {
						if (schedule_chkbreak()) {
							stopreq_flag = TRUE;
						}
						if (stopreq_flag) {
							break;
						}
						jsubcpu_exec();
					}
#endif
					/* HALTvɉ (V3.1) */
					subctrl_halt_ack();
				}

				/* u[Nꍇ̏ */
				if (stopreq_flag) {
					/* execԂi߂(ĕ␳Ȃ) */
					run_flag = FALSE;
				}
			}
			else {
				/* TCNX`[Au[N|CgȂ */

				/* s */
				while ((maincpu.total < main) && !mmr_modify) {
#if XM7_VER >= 3
					/* CCPUs */
					if (!dma_burst_transfer) {
						maincpu_exec();
					}

					/* DMA] */
					if (dma_flag) {
						dmac_exec();
					}
#else
					/* CCPUs */
					maincpu_exec();
#endif

					/* TuCLR߂gpBUSYtO𑀍삵ꍇ */
					/* ㏈(MAGUS) */
					if (busy_CLR_count > 0) {
						if (busy_CLR_count >= 2) {
							subbusy_flag = TRUE;
						}
						busy_CLR_count = 0;
					}

					/* TuCPUs */
					limit = maincpu.total * ratio;
					if (subhalt_flag && !(subcpu.intr & INTR_HALT)) {
						/* CCPUƋ */
						subcpu.total = (WORD)(limit >> 12);
					}
					else {
						while (((DWORD)subcpu.total << 12) < limit) {
							subcpu_exec();
						}
					}

#if XM7_VER == 1 && defined(JSUB)
					/* {TuCPUs */
					limit = maincpu.total * ratio_js;
					while ((((DWORD)jsubcpu.total << 12) < limit) &&
						jsub_available && jsub_enable && !jsub_haltflag &&
						(fm_subtype != FMSUB_FM8)) {
						jsubcpu_exec();
					}
#endif

					/* HALTvɉ (V3.1) */
					subctrl_halt_ack();
				}
			}
		}
		else {
			if (break_flag) {
				/* TCNX`[ȂAu[N|Cg */

				/* s */
				while ((maincpu.total < main) && !mmr_modify) {
					if (schedule_chkbreak()) {
						stopreq_flag = TRUE;
					}
					if (stopreq_flag) {
						break;
					}

#if XM7_VER >= 3
					/* CCPUs */
					if (!dma_burst_transfer) {
						maincpu_exec();
					}

					/* DMA] */
					if (dma_flag) {
						dmac_exec();
					}
#else
					/* CCPUs */
					maincpu_exec();
#endif

					/* TuCLR߂gpBUSYtO𑀍삵ꍇ */
					/* ㏈(MAGUS) */
					if (busy_CLR_count > 0) {
						if (busy_CLR_count >= 2) {
							subbusy_flag = TRUE;
						}
						busy_CLR_count = 0;
					}

					/* TuCPUs */
					limit = maincpu.total * ratio;
					if ((subhalt_flag && !(subcpu.intr & INTR_HALT)) ||
						(!subclock_mode && (vrama_flag && blank_flag))) {
						/* CCPUƋ */
						subcpu.total = (WORD)(limit >> 12);
					}
					else {
						while (((DWORD)subcpu.total << 12) < limit) {
							if (schedule_chkbreak()) {
								stopreq_flag = TRUE;
							}
							if (stopreq_flag) {
								break;
							}

							subcpu_exec();
							/* VRAMANZXtOON̏ꍇ */
							/* vNbN3{ɂ */
							if (subclock_mode && vrama_flag) {
								subcpu.total += (WORD)(subcpu.cycle * 1.86f);
							}
						}
					}

#if XM7_VER == 1 && defined(JSUB)
					/* {TuCPUs */
					limit = maincpu.total * ratio_js;
					while ((((DWORD)jsubcpu.total << 12) < limit) &&
							jsub_available && jsub_enable && !jsub_haltflag &&
							(fm_subtype != FMSUB_FM8)) {
						if (schedule_chkbreak()) {
							stopreq_flag = TRUE;
						}
						if (stopreq_flag) {
							break;
						}
						jsubcpu_exec();
					}
#endif

					/* HALTvɉ (V3.1) */
					subctrl_halt_ack();
				}

				/* u[Nꍇ̏ */
				if (stopreq_flag) {
					/* execԂi߂(ĕ␳Ȃ) */
					run_flag = FALSE;
				}
			}
			else {
				/* TCNX`[ȂAu[N|CgȂ */

				/* s */
				while ((maincpu.total < main) && !mmr_modify) {
#if XM7_VER >= 3
					/* CCPUs */
					if (!dma_burst_transfer) {
						maincpu_exec();
					}

					/* DMA] */
					if (dma_flag) {
						dmac_exec();
					}
#else
					/* CCPUs */
					maincpu_exec();
#endif

					/* TuCLR߂gpBUSYtO𑀍삵ꍇ */
					/* ㏈(MAGUS) */
					if (busy_CLR_count > 0) {
						if (busy_CLR_count >= 2) {
							subbusy_flag = TRUE;
						}
						busy_CLR_count = 0;
					}

					/* TuCPUs */
					limit = maincpu.total * ratio;
					if ((subhalt_flag && !(subcpu.intr & INTR_HALT)) ||
						(!subclock_mode && (vrama_flag && blank_flag))) {
						/* CCPUƋ */
						subcpu.total = (WORD)(limit >> 12);
					}
					else {
						while (((DWORD)subcpu.total << 12) < limit) {
							subcpu_exec();
							/* VRAMANZXtOON̏ꍇ */
							/* vNbN3{ɂ */
							if (subclock_mode && vrama_flag) {
								subcpu.total += (WORD)(subcpu.cycle * 1.86f);
							}
						}
					}

#if XM7_VER == 1 && defined(JSUB)
					/* {TuCPUs */
					limit = maincpu.total * ratio_js;
					while ((((DWORD)jsubcpu.total << 12) < limit) &&
							jsub_available && jsub_enable && !jsub_haltflag &&
							(fm_subtype != FMSUB_FM8)) {
						jsubcpu_exec();
					}
#endif

					/* HALTvɉ (V3.1) */
					subctrl_halt_ack();
				}
			}
		}

		/* MMR֘AWX^ύXꂽꍇAsԂ␳ */
		if (mmr_modify) {
			exec2 += (maincpu.total * 10000) / cycle;
			main_overcycles = 0;
			sub_overcycles = 0;
#if XM7_VER == 1 && defined(JSUB)
			jsub_overcycles = 0;
#endif
		}
	} while (mmr_modify && run_flag && (exec > exec2));

	/* I[o[TCN */
	if (maincpu.total > main) {
		main_overcycles = (WORD)(maincpu.total - main);
	}
	else {
		main_overcycles = 0;
	}
	if (subcpu.total > sub) {
		sub_overcycles = (WORD)(subcpu.total - sub);
	}
	else {
		sub_overcycles = 0;
	}
#if XM7_VER == 1 && defined(JSUB)
	if (jsubcpu.total > jsub) {
		jsub_overcycles = (WORD)(jsubcpu.total - jsub);
	}
	else {
		jsub_overcycles = 0;
	}
#endif

	/* Cxg */
	maincpu.total = 0;
	subcpu.total = 0;
#if XM7_VER == 1 && defined(JSUB)
	jsubcpu.total = 0;
#endif
	schedule_doevent(exec);
	vmtime += exec;

	return exec;
}

/*-[ t@CI/O ]----------------------------------------------------------*/

/*
 *	XPW[
 *	Z[u
 */
BOOL FASTCALL schedule_save(int fileh)
{
	int i;

	if (!file_bool_write(fileh, run_flag)) {
		return FALSE;
	}

	if (!file_bool_write(fileh, stopreq_flag)) {
		return FALSE;
	}

	/* Ver901g */
	if (!file_byte_write(fileh, BREAKP_MAXNUM)) {
		return FALSE;
	}

	/* u[N|Cg */
	for (i=0; i<BREAKP_MAXNUM; i++) {
		if (!file_byte_write(fileh, (BYTE)breakp[i].flag)) {
			return FALSE;
		}
		if (!file_byte_write(fileh, (BYTE)breakp[i].cpu)) {
			return FALSE;
		}
		if (!file_word_write(fileh, breakp[i].addr)) {
			return FALSE;
		}
	}

	/* Cxg */

	/* Ver9g */
	if (!file_byte_write(fileh, EVENT_MAXNUM)) {
		return FALSE;
	}

	for (i=0; i<EVENT_MAXNUM; i++) {
		/* R[obNȊOۑ */
		if (!file_byte_write(fileh, (BYTE)event[i].flag)) {
			return FALSE;
		}
		if (!file_dword_write(fileh, event[i].current)) {
			return FALSE;
		}
		if (!file_dword_write(fileh, event[i].reload)) {
			return FALSE;
		}
	}

	/* Ver9.05/7.05g */
	if (!file_word_write(fileh, main_overcycles)) {
		return FALSE;
	}
	if (!file_word_write(fileh, sub_overcycles)) {
		return FALSE;
	}

#if XM7_VER == 1 && defined(JSUB)
	if (!file_word_write(fileh, jsub_overcycles)) {
		return FALSE;
	}
#endif

	/* Ver9.16/7.16/3.06g */
	if (!file_bool_write(fileh, cycle_steal)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, subclock_mode)) {
		return FALSE;
	}
	if (!file_dword_write(fileh, main_speed)) {
		return FALSE;
	}
	if (!file_dword_write(fileh, mmr_speed)) {
		return FALSE;
	}
#if XM7_VER >= 3
	if (!file_dword_write(fileh, fmmr_speed)) {
		return FALSE;
	}
#endif
	if (!file_dword_write(fileh, sub_speed)) {
		return FALSE;
	}
#if XM7_VER == 1
	if (!file_dword_write(fileh, main_speed_low)) {
		return FALSE;
	}
	if (!file_dword_write(fileh, sub_speed_low)) {
		return FALSE;
	}
#ifdef JSUB
	if (!file_dword_write(fileh, jsub_speed)) {
		return FALSE;
	}
#endif
#endif

	return TRUE;
}

/*
 *	XPW[
 *	[h
 */
#if XM7_VER == 1
BOOL FASTCALL schedule_load(int fileh, int ver)
#else
BOOL FASTCALL schedule_load(int fileh, int ver, BOOL old)
#endif
{
	int i;
	BYTE tmp;
	BYTE MAXNUM;

	/* o[W`FbN */
	if (ver < 200) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &run_flag)) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &stopreq_flag)) {
		return FALSE;
	}

	/* u[N|Cg */
	/* Ver9g */
#if XM7_VER >= 3
	if ((ver >= 901) || ((ver >= 701) && (ver <= 799))) {
#elif XM7_VER >= 2
	if (ver >= 701) {
#else
	if (ver >= 300) {
#endif
		if (!file_byte_read(fileh, &MAXNUM)) {
			return FALSE;
		}
	}
#if XM7_VER >= 2
	else {
		/* V1.1ł͎gȂ */
		MAXNUM = BREAKP_MAXNUM_OLD;
	}
#endif

	/* 񏉊 */
	memset(breakp, 0, sizeof(breakp));

	for (i=0; i<MAXNUM; i++) {
		if (!file_byte_read(fileh, &tmp)) {
			return FALSE;
		}
		breakp[i].flag = (int)tmp;
		if (!file_byte_read(fileh, &tmp)) {
			return FALSE;
		}
		breakp[i].cpu = (int)tmp;
		if (!file_word_read(fileh, &breakp[i].addr)) {
			return FALSE;
		}
	}
	break_flag = FALSE;
	for (i=0; i<MAXNUM; i++) {
		if (breakp[i].flag != BREAKP_NOTUSE) {
			break_flag = TRUE;
		}
	}

	/* Cxg */
	/* Ver9g */
#if XM7_VER >= 3
	if ((ver >= 900) || ((ver >= 700) && (ver <= 799))) {
#elif XM7_VER >= 2
	if (ver >= 700) {
#else
	if (ver >= 300) {
#endif
		if (!file_byte_read(fileh, &MAXNUM)) {
			return FALSE;
		}
	}
#if XM7_VER >= 2
	else {
		if (old) {
			MAXNUM = EVENT_MAXNUM_L30;
		}
		else {
			MAXNUM = EVENT_MAXNUM_L31;
		}
	}
#endif

	for (i=0; i<MAXNUM; i++) {
		/* R[obNȊOݒ */
		if (!file_byte_read(fileh, &tmp)) {
			return FALSE;
		}
		event[i].flag = (int)tmp;
		if (!file_dword_read(fileh, &event[i].current)) {
			return FALSE;
		}
		if (!file_dword_read(fileh, &event[i].reload)) {
			return FALSE;
		}
	}

	/* Ver9.05/Ver7.05g */
#if XM7_VER >= 3
	if ((ver >= 905) || ((ver >= 705) && (ver <= 799))) {
#elif XM7_VER >= 2
	if (ver >= 705) {
#else
	if (ver >= 300) {
#endif
		if (!file_word_read(fileh, &main_overcycles)) {
			return FALSE;
		}
		if (!file_word_read(fileh, &sub_overcycles)) {
			return FALSE;
		}
#if XM7_VER == 1 && defined(JSUB)
		if (!file_word_read(fileh, &jsub_overcycles)) {
			return FALSE;
		}
#endif
	}
	else {
		main_overcycles = 0;
		sub_overcycles = 0;
#if XM7_VER == 1 && defined(JSUB)
		jsub_overcycles = 0;
#endif
	}

	/* Ver9.16/7.16/3.06g */
#if XM7_VER >= 3
	if ((ver >= 916) || ((ver >= 716) && (ver <= 799))) {
#elif XM7_VER >= 2
	if (ver >= 716) {
#else
	if (ver >= 306) {
#endif
		if (!file_bool_read(fileh, &cycle_steal)) {
			return FALSE;
		}
#if XM7_VER >= 3
		if (((ver >= 723) && (ver <= 799)) ||
			((ver >= 923) && (ver <= 999))) {
#elif XM7_VER >= 2
		if ((ver >= 723) && (ver <= 799)) {
#else
		if ((ver >= 313) && (ver <= 399)) {
#endif
			if (!file_bool_read(fileh, &subclock_mode)) {
				return FALSE;
			}
			else {
				if (cycle_steal) {
					subclock_mode = FALSE;
				}
			}
		}
		if (!file_dword_read(fileh, &main_speed)) {
			return FALSE;
		}
		if (!file_dword_read(fileh, &mmr_speed)) {
			return FALSE;
		}
#if XM7_VER >= 3
		if (ver >= 916) {
			if (!file_dword_read(fileh, &fmmr_speed)) {
				return FALSE;
			}
		}
#endif
		if (!file_dword_read(fileh, &sub_speed)) {
			return FALSE;
		}
#if XM7_VER == 1
		if (!file_dword_read(fileh, &main_speed_low)) {
			return FALSE;
		}
		if (!file_dword_read(fileh, &sub_speed_low)) {
			return FALSE;
		}
#ifdef JSUB
		if (!file_dword_read(fileh, &jsub_speed)) {
			return FALSE;
		}
#endif
#endif
	}

	/* sx䗦 */
	speed_ratio = 10000;

	return TRUE;
}
