/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2021 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2021 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021-2024 GIMONS
 *
 *	[ ʒ` ]
 */

#ifndef _xm7_h_
#define _xm7_h_

#include <stdio.h>
#if XM7_VER == 1 && defined(Z80CARD)
#include "kmz80.h"
#endif

/*
 *	o[W
 */
#if XM7_VER >= 3
#define	VERSION		"V3.4"
#elif XM7_VER >= 2
#define	VERSION		"V2.9"
#else
#define	VERSION		"V1.1"
#endif
#define	LEVEL		"L77SX+z10 R3"
//#define	BETAVER
//#define	BETANO		"2"
#define	DATE		"2025/05/12"

/*
 *	萔A^`
 */

/* ėp萔 */
#ifndef FALSE
#define FALSE			0
#define TRUE			(!FALSE)
#endif
#ifndef NULL
#define NULL			((void)0)
#endif

/* ff */
#ifndef ASSERT
#ifdef _DEBUG
#include <assert.h>
#define ASSERT(exp)		assert(exp)
#else
#define ASSERT(exp)		((void)0)
#endif
#endif

/* gpϐ̏ */
#ifndef UNUSED
#define UNUSED(x)		((void)(x))
#endif

/* œK */
#if defined(_WIN32) && (defined(__BORLANDC__) || (defined(_MSC_VER) && (defined(_M_IX86))))
#define FASTCALL		__fastcall
#else
#define FASTCALL
#endif

/* {^` */
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef int BOOL;

/* CPUWX^` */
#ifdef _WIN32
#pragma pack(push, 1)
#endif
typedef struct {
	BYTE cc;
	BYTE dp;
	union {
		struct {
#ifdef ANDROID
			BYTE b;
			BYTE a;
#endif
#ifdef _WIN32
			BYTE b;
			BYTE a;
#endif
#ifdef __MSDOS__
			BYTE b;
			BYTE a;
#endif
#ifdef FMT
			BYTE b;
			BYTE a;
#endif
#ifdef HUMAN68K
			BYTE a;
			BYTE b;
#endif
#ifdef _XWIN
			BYTE b __attribute__((aligned(1)));
			BYTE a __attribute__((aligned(1)));
#endif
		} h;
		WORD d;
	} acc;
	WORD x;
	WORD y;
	WORD u;
	WORD s;
	WORD pc;
	WORD intr;
	WORD cycle;
	WORD total;
	BYTE (FASTCALL *readmem)(WORD);
	void (FASTCALL *writemem)(WORD, BYTE);
} cpu6809_t;
#ifdef _WIN32
#pragma pack(pop)
#endif

/* 荞ݒ` */
#define INTR_NMI		0x0001			/* NMI荞 */
#define INTR_FIRQ		0x0002			/* FIRQ荞 */
#define INTR_IRQ		0x0004			/* IRQ荞 */

#define INTR_SLOAD		0x0010			/* ZbgSݒ */
#define INTR_SYNC_IN	0x0020			/* SYNCs */
#define INTR_SYNC_OUT	0x0040			/* SYNCI\ */
#define INTR_CWAI_IN	0x0080			/* CWAIs */
#define INTR_CWAI_OUT	0x0100			/* CWAII\ */
#define INTR_NMI_PLS	0x1000			/* NMIpXM */
#define INTR_FIRQ_PLS	0x2000			/* FIRQpXM */
#define INTR_IRQ_PLS	0x4000			/* IRQpXM */
#define INTR_HALT		0x8000			/* HALTߎs */

/* u[N|Cg` */
#define BREAKP_NOTUSE	0				/* gp */
#define BREAKP_ENABLED	1				/* gp */
#define BREAKP_DISABLED	2				/* ֎~ */
#define BREAKP_STOPPED	3				/* ~ */
#define BREAKP_MAXNUM	16				/* u[N|Cǧ */
#define BREAKP_MAXNUM_OLD	8			/* u[N|Cǧ (`V3.1L10) */
typedef struct {
	int flag;							/* ̃tO */
	int cpu;							/* CPU */
	WORD addr;							/* u[N|CgAhX */
} breakp_t;

/* Cxg` */
#define EVENT_NOTUSE	0				/* gp */
#define EVENT_ENABLED	1				/* gp */
#define EVENT_DISABLED	2				/* ֎~ */
#define	EVENT_MAXNUM	32				/* Cxǧ */
#define EVENT_MAXNUM_L31	18			/* V3.0L31ł̃Cxǧ */
#define	EVENT_MAXNUM_L30	16			/* V3.0L30ł̃Cxǧ */
typedef struct {
	int flag;							/* ̃tO */
	DWORD current;						/* JgԃJE^ */
	DWORD reload;						/* [hԃJE^ */
	BOOL (FASTCALL *callback)(void);	/* R[obN֐ */
} event_t;

/* CPUsTCN */
#define MAINCYCLES		1794			/* CCPU MMR OFF */
#define MAINCYCLES_MMR	1565			/* CCPU MMR ON */
#define MAINCYCLES_FMMR	2016			/* CCPU MMR */
#define SUBCYCLES		2000			/* TuCPU */
#define MAINCYCLES_LOW	1095			/* CCPU MMR OFF(ᑬ) */
#define SUBCYCLES_LOW	999				/* TuCPU(ᑬ) */
#define JSUBCYCLES		1228			/* {TuCPU */

/* n[hEFATuo[W */
#define FMSUB_FM7		0x00			/* FM-7 */
#define FMSUB_FM77		0x01			/* FM-77 */
#define FMSUB_FM8		0x02			/* FUJITSU MICRO 8 */
#define	FMSUB_DEFAULT	0x00			/* ftHgݒ(for V2/V3) */

/* ̑萔 */
#define MAINCPU			0				/* CCPU(6809) */
#define SUBCPU			1				/* TuCPU */
#define JSUBCPU			2				/* {TuCPU */
#define MAINZ80			3				/* CCPU(Z80) */
#define CPU_VOID		255				/* (ǂCPUłȂ) */
#if XM7_VER >= 2
#define MAXCPU			2				/* őCPU:2(V2,V3) */
#else
#ifdef Z80CARD
#define MAXCPU			4				/* őCPU:4(V1,Z80L) */
#else
#define MAXCPU			3				/* őCPU:3(V1,Z80) */
#endif
#endif

#define BOOT_BASIC		0				/* BASIC[h */
#define BOOT_DOS		1				/* DOS[h */
#define BOOT_BUBBLE		2				/* ou[h */

#define STATELOAD_ERROR		0			/* Xe[g[hG[ */
#define STATELOAD_SUCCESS	1			/* Xe[g[h */
#define STATELOAD_OPENERR	-1			/* t@CI[vG[ */
#define STATELOAD_HEADERR	-2			/* wb_G[ */
#define STATELOAD_VERERR	-3			/* o[WG[ */

/*
 * ROMt@C`
 */
#define FBASIC_ROM		"FBASIC30.ROM"	/* F-BASIC V3.0 */
#define INITIATE_ROM	"INITIATE.ROM"	/* FM77AV INITIATER ROM */
#define BOOTBAS_ROM		"BOOT_BAS.ROM"	/* FM-7 BASIC BOOT */
#define BOOTDOS_ROM		"BOOT_DOS.ROM"	/* FM-7 5inch DOS BOOT */
#define BOOTBBL_ROM		"BOOT_BBL.ROM"	/* FM-7 Bubble BOOT */
#define BOOT1MB_ROM		"BOOT_1MB.ROM"	/* FM-77 1MB BOOT */
#define BOOTHIDDEN_ROM	"BOOT_MMR.ROM"	/* FM-77 BASIC ROM BOOT($7E00-$7FFF) */
#define FBASIC10_ROM	"FBASIC10.ROM"	/* F-BASIC V1.0 */
#define BOOTBAS8_ROM	"BOOTBAS8.ROM"	/* MICRO 8 BASIC BOOT */
#define BOOTDOS8_ROM	"BOOTDOS8.ROM"	/* MICRO 8 5inch DOS BOOT */
#define BOOTBBL8_ROM	"BOOTBBL8.ROM"	/* MICRO 8 Bubble BOOT */
#define BOOTSFD8_ROM	"BOOTSFD8.ROM"	/* MICRO 8 8inch DOS BOOT */
#define BOOTDBG8_ROM	"BOOTDBG8.ROM"	/* MICRO 8 F-BASIC DEBUG BOOT */
#define SUBSYSC_ROM		"SUBSYS_C.ROM"	/* FM-7 SUBSYSTEM */
#define SUBSYS8_ROM		"SUBSYS_8.ROM"	/* MICRO 8 SUBSYSTEM */
#define SUBSYSL4_ROM	"SUBSYSL4.ROM"	/* FM-77L4 400LINE SUBSYSTEM */
#define SUBSYSA_ROM		"SUBSYS_A.ROM"	/* FM77AV Type-A SUBSYSTEM 3 */
#define SUBSYSB_ROM		"SUBSYS_B.ROM"	/* FM77AV Type-B SUBSYSTEM 3 */
#define SUBSYSCG_ROM	"SUBSYSCG.ROM"	/* FM77AV CGROM/SUBSYSTEM 1/2 */
#define ANKCG16_ROM		"ANKCG16.ROM"	/* FM-77L4 400LINE ANK FONT */
#define KANJI_ROM		"KANJI.ROM"		/* JIS78 CLASS 1 KANJI ROM */
#define KANJI_ROM1		"KANJI1.ROM"	/* JIS83 CLASS 1 KANJI ROM */
#define KANJI_ROM2		"KANJI2.ROM"	/* JIS83 CLASS 2 KANJI ROM */
#define JSUBSYS_ROM		"JSUBMON.ROM"	/* FM77-101 DICTIONARY ACCESS ROM */
#define DICT_ROM		"DICROM.ROM"	/* FM77-101/FM77-211 DICTIONARY ROM */
#define	DICT_RAM		"USERDIC.DAT"	/* FM77-211 BATTERY BACKUP RAM */
#define EXTSUB_ROM		"EXTSUB.ROM"	/* FM77AV40EX/SX EXTEND SUBSYSTEM */

/*
 *	j^ʒ`
 */
typedef enum {
	MONITOR_COLOR = 0,		/* m[}J[[h	*/
	MONITOR_GREEN,			/* O[j^[h(V1) */
	MONITOR_AMBERYELLOW,	/* Ao[CG[j^[h(V1) */
	MONITOR_FORCETTLCOLOR	/* TTLJ[[h(V2/V3) */
} MONITORTYPE;

/*
 *	Borland C++ł̋Ŝ悤Warning΍
 */
#ifdef __BORLANDC__
#undef MAKELONG
#define MAKELONG(l, h)			(LONG)(((WORD)(l)) | ((DWORD)(h) << 16))
#undef MAKEWPARAM
#define MAKEWPARAM(l, h)		(WPARAM)(MAKELONG(l, h))
#undef MAKELPARAM
#define MAKELPARAM(l, h)		(LPARAM)(MAKELONG(l, h))
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */

/* VXe(system.c) */
BOOL FASTCALL system_init(void);
										/* VXe  */
void FASTCALL system_cleanup(void);
										/* VXe N[Abv */
void FASTCALL system_reset(void);
										/* VXe Zbg */
void FASTCALL system_hotreset(void);
										/* VXe zbgZbg */
void FASTCALL system_tabreset(void);
										/* VXe TAB+Zbg */
#if XM7_VER >= 3
void FASTCALL system_tabreset(void);
										/* VXe TAB+Zbg */
#endif
BOOL FASTCALL system_save(char *filename);
										/* VXe Z[u */
int FASTCALL system_load(char *filename);
										/* VXe [h */

/* XPW[(schedule.c) */
BOOL FASTCALL schedule_init(void);
										/* XPW[  */
void FASTCALL schedule_cleanup(void);
										/* XPW[ N[Abv */
void FASTCALL schedule_reset(void);
										/* XPW[ Zbg */
DWORD FASTCALL schedule_get_cycle(void);
										/* sTCN擾 */
DWORD FASTCALL schedule_exec(DWORD microsec);
										/* s */
void FASTCALL schedule_main_fullspeed(void);
										/* CS͋쓮(tapep) */
void FASTCALL schedule_fullspeed(void);
										/* S͋쓮 */
void FASTCALL schedule_trace(void);
										/* g[X */
BOOL FASTCALL schedule_setbreak(int cpu, WORD addr);
										/* u[N|Cgݒ */
BOOL FASTCALL schedule_setbreak2(int num, int cpu, WORD addr);
										/* u[N|Cgݒ(ʒuw) */
BOOL FASTCALL schedule_setevent(int id, DWORD microsec, BOOL (FASTCALL *func)(void));
										/* Cxgǉ */
BOOL FASTCALL schedule_delevent(int id);
										/* Cxg폜 */
event_t* FASTCALL schedule_getevent(int id);
										/* Cxg擾 */
void FASTCALL schedule_handle(int id, BOOL (FASTCALL *func)(void));
										/* Cxgnhݒ */
BOOL FASTCALL schedule_save(int fileh);
										/* XPW[ Z[u */
#if XM7_VER == 1
BOOL FASTCALL schedule_load(int fileh, int ver);
										/* XPW[ [h (V1) */
#else
BOOL FASTCALL schedule_load(int fileh, int ver, BOOL old);
										/* XPW[ [h */
#endif

/* tAZu(disasm.c) */
int FASTCALL disline(int cputype, WORD pc, char *buffer);
										/* PstAZu */

/* Z80tAZu(disasm80.c) */
int FASTCALL disline80(int cputype, WORD pc, char *buffer);
										/* PstAZu */

/* CCPU(mainmem.c) */
BOOL FASTCALL mainmem_init(void);
										/* CCPU  */
void FASTCALL mainmem_cleanup(void);
										/* CCPU N[Abv */
void FASTCALL mainmem_reset(void);
										/* CCPU Zbg */
void FASTCALL mainmem_transfer_boot(void);
										/* CCPU u[g] */
BYTE FASTCALL mainmem_readb(WORD addr);
										/* CCPU ǂݏo */
BYTE FASTCALL mainmem_readbnio(WORD addr);
										/* CCPU ǂݏo(I/OȂ) */
void FASTCALL mainmem_writeb(WORD addr, BYTE dat);
										/* CCPU  */
BYTE FASTCALL mainmem_readb_p(DWORD raddr);
										/* CCPU ǂݏo() */
BYTE FASTCALL mainmem_readbnio_p(DWORD raddr);
										/* CCPU ǂݏo(2) */
void FASTCALL mainmem_writeb_p(DWORD raddr, BYTE dat);
										/* CCPU () */
BOOL FASTCALL mainmem_save(int fileh);
										/* CCPU Z[u */
BOOL FASTCALL mainmem_load(int fileh, int ver);
										/* CCPU [h */

/* TuCPU(submem.c) */
BOOL FASTCALL submem_init(void);
										/* TuCPU  */
void FASTCALL submem_cleanup(void);
										/* TuCPU N[Abv */
void FASTCALL submem_reset(void);
										/* TuCPU Zbg */
BYTE FASTCALL submem_readb(WORD addr);
										/* TuCPU ǂݏo */
BYTE FASTCALL submem_readbnio(WORD addr);
										/* TuCPU ǂݏo(I/OȂ) */
void FASTCALL submem_writeb(WORD addr, BYTE dat);
										/* TuCPU  */
BOOL FASTCALL submem_save(int fileh);
										/* TuCPU Z[u */
BOOL FASTCALL submem_load(int fileh, int ver);
										/* TuCPU [h */

/* CCPU(maincpu.c) */
BOOL FASTCALL maincpu_init(void);
										/* CCPU  */
void FASTCALL maincpu_cleanup(void);
										/* CCPU N[Abv */
void FASTCALL maincpu_reset(void);
										/* CCPU Zbg */
void FASTCALL maincpu_execline(void);
										/* CCPU Pss */
void FASTCALL maincpu_exec(void);
										/* CCPU s */
void FASTCALL maincpu_nmi(void);
										/* CCPU NMI荞ݗv */
void FASTCALL maincpu_firq(void);
										/* CCPU FIRQ荞ݗv */
void FASTCALL maincpu_irq(void);
										/* CCPU IRQ荞ݗv */
BOOL FASTCALL maincpu_save(int fileh);
										/* CCPU Z[u */
BOOL FASTCALL maincpu_load(int fileh, int ver);
										/* CCPU [h */

/* TuCPU(subcpu.c) */
BOOL FASTCALL subcpu_init(void);
										/* TuCPU  */
void FASTCALL subcpu_cleanup(void);
										/* TuCPU N[Abv */
void FASTCALL subcpu_reset(void);
										/* TuCPU Zbg */
void FASTCALL subcpu_execline(void);
										/* TuCPU Pss */
void FASTCALL subcpu_exec(void);
										/* TuCPU s */
void FASTCALL subcpu_nmi(void);
										/* TuCPU NMI荞ݗv */
void FASTCALL subcpu_firq(void);
										/* TuCPU FIRQ荞ݗv */
void FASTCALL subcpu_irq(void);
										/* TuCPU IRQ荞ݗv */
BOOL FASTCALL subcpu_save(int fileh);
										/* TuCPU Z[u */
BOOL FASTCALL subcpu_load(int fileh, int ver);
										/* TuCPU [h */

/*
 *	CPUȂv[NGA
 */
extern cpu6809_t maincpu;
										/* CCPU */
extern cpu6809_t subcpu;
										/* TuCPU */
#if XM7_VER == 1
extern cpu6809_t jsubcpu;
										/* {TuCPU */
#ifdef Z80CARD
extern KMZ80_CONTEXT mainz80;
										/* CCPUReLXg(Z80) */
extern BOOL main_z80mode;
										/* CCPU Z80ZNgtO */
extern BOOL z80_enable;
										/* Z80Cl[utO */
extern BOOL z80_irq_thru;
										/* IRQMʉ߃tO */
extern BOOL z80_firq_thru;
										/* FIRQMʉ߃tO */
extern BOOL z80_nmi_thru;
										/* NMIMʉ߃tO */
#endif
#endif
extern DWORD main_cycles;
										/* CCPUsTCN */
extern int fm7_ver;
										/* o[W */
extern breakp_t breakp[BREAKP_MAXNUM];
										/* u[N|Cg */
extern event_t event[EVENT_MAXNUM];
										/* Cxg */
extern BOOL run_flag;
										/* tO */
extern BOOL stopreq_flag;
										/* ~vtO */
extern DWORD main_speed;
										/* CCPUXs[h */
extern DWORD mmr_speed;
										/* CCPU(MMR)Xs[h */
#if XM7_VER >= 3
extern DWORD fmmr_speed;
										/* CCPU(MMR)Xs[h */
#endif
extern DWORD sub_speed;
										/* TuCPUXs[h */
extern DWORD speed_ratio;
										/* TuCPUXs[h */
extern BOOL cycle_steal;
										/* TCNX`[tO */
extern BOOL cycle_steal_default;
										/* TCNX`[ftHgtO */
extern BOOL subclock_mode;
										/* TuCPU uLO^C~O */
extern DWORD vmtime;
										/* VMz */
extern BOOL reset_flag;
										/* VXeZbgtO */
extern BOOL hotreset_flag;
										/* CzbgZbgtO */
extern WORD main_overcycles;
										/* CCPUI[o[TCN */
extern WORD sub_overcycles;
										/* TuCPUI[o[TCN */
#ifdef DEBUG
extern DWORD main_cycle;
										/* CCPUsTCNJE^ */
extern DWORD sub_cycle;
										/* TuCPUsTCNJE^ */
#endif
extern BYTE fetch_op;
										/* OɃtFb`߃R[h */
#if XM7_VER == 1
extern BYTE fm_subtype;
										/* n[hEFATuo[W */
extern BOOL lowspeed_mode;
										/* CPUNbN[h */
extern BOOL motoron_lowspeed;
										/* CMT[ONᑬ[h */
extern DWORD main_speed_low;
										/* CCPUXs[h(ᑬ) */
extern DWORD sub_speed_low;
										/* TuCPUXs[h(ᑬ) */
#ifdef JSUB
extern DWORD jsub_speed;
										/* {TuCPUXs[h */
extern WORD jsub_overcycles;
										/* {TuCPUI[o[TCN */
#endif
#endif

/*
 *	
 */
extern BYTE *mainram_a;
										/* RAM (\RAM)      $8000 */
extern BYTE *mainram_b;
										/* RAM (RAM)      $7C80 */
extern BYTE *basic_rom;
										/* ROM (F-BASIC)    $7C00 */
extern BYTE *main_io;
										/* CCPU I/O    $0100 */
extern BYTE *vram_c;
										/* VRAM(^CvC)    $C000 ($30000) */
extern BYTE *subrom_c;
										/* ROM (^CvC)    $2800 */
extern BYTE *sub_ram;
										/* R\[RAM    $1680 */
extern BYTE *sub_io;
										/* TuCPU I/O      $0100 */
#if XM7_VER == 1
extern BYTE *basic_rom8;
										/* ROM (F-BASIC1.0) $7C00 */
extern BYTE *boot_bas;
										/* BOOT (BASIC)      $200 */
extern BYTE *boot_dos;
										/* BOOT (DOS[h)  $200 */
extern BYTE *boot_bas8;
										/* BOOT (BASIC,FM-8) $200 */
extern BYTE *boot_dos8;
										/* BOOT (DOS,FM-8)   $200 */
extern BYTE *subrom_c;
										/* ROM (FM-8)       $2800 */
extern BYTE *subrampcg;
										/* RAM (PCG)         $800 */
extern BOOL pcg_flag;
										/* PCGtO */
extern BOOL pcg_enable;
										/* PCGLtO */
extern BOOL available_fm7roms;
										/* FM-7 ROMgp\tO */
extern BOOL available_fm8roms;
										/* MICRO 8 ROMgp\tO */
#ifdef BUBBLE
extern BOOL bubble_available;
										/* ougp\tO */
#endif
#endif
extern BOOL boot_mode;
										/* N[h */
extern BOOL basicrom_en;
										/* F-BASIC V3.0 ROM Cl[u */
extern BYTE *boot_ram;
										/* BOOT (RAM)        $200 */
extern BOOL bootram_rw;
										/* u[gRAM ݉\ */
extern BOOL rom_ram_write;
										/* FM-7[hROM̈揑̋ */
#if XM7_VER >= 3
extern BOOL init_is_exsx;
										/* CjVG[^ROM EX/SXtO */
#endif

/*
 *	 (FM-77)
 */
#if XM7_VER == 1
extern BYTE *extram_a;
										/* RAM (FM-77)     $30000 */
#ifdef L4CARD
extern BYTE *tvram_c;
										/* eLXgVRAM(L4) $1000 */
extern BYTE *subrom_l4;
										/* Tuj^ (L4)  $4800 */
extern BYTE *subcg_l4;
										/* CGROM (L4)       $1000 */
extern BOOL ankcg_force_internal;
										/* tHggptO */
extern BOOL enable_400linecard;
										/* 400CLtO */
extern BOOL detect_400linecard;
										/* 400CJ[htO */
extern BOOL detect_400linecard_tmp;
										/* 400CJ[htO(tmp) */
#endif
extern BOOL subrom_xchg;
										/* TuVXeύXLtO */
#endif

/*
 *	 (FM77AV)
 */
#if XM7_VER >= 2
extern BYTE *extram_a;
										/* RAM (FM77AV)    $10000 */
extern BYTE *init_rom;
										/* CjVG[^ROM  $2000 */

extern BYTE *subrom_a;
										/* ROM (^CvA)    $2000 */
extern BYTE *subrom_b;
										/* ROM (^CvB)    $2000 */
extern BYTE *subromcg;
										/* ROM (CG)         $2000 */
extern BYTE *vram_b;
										/* VRAM (^CvA,B) $C000 */

extern BOOL initrom_en;
										/* CjVG[^ROM Cl[u */
extern BYTE subrom_bank;
										/* TuVXeROM/RAMoN */
extern BYTE cgrom_bank;
										/* CGROMoN */
#endif

/*
 *	 (FM77AV40E{J[h)
 */
#if XM7_VER >= 3
extern BYTE *extram_c;
										/* RAM (FM77AV40)  $40000 */
extern BYTE *subramde;
										/* RAM (TypeD/E)    $2000 */
extern BYTE *subramcg;
										/* RAM (tHg)   $4000 */
extern BYTE *subramcn;
										/* R\[RAM  $2000 */

extern BYTE cgram_bank;
										/* CGRAMoN */
extern BYTE consram_bank;
										/* R\[RAMoN */
#endif

#ifdef __cplusplus
}
#endif

#endif	/* _xm7_h_ */
