/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2019 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2019 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2025 GIMONS
 *
 *	[ Win32API Rg[o[ ]
 *
 *	RHG
 *	  2003.05.25		ResizeStatus֐ǉ
 *	  2004.05.03		WinXPΉDLLǂݍ݃`FbN̈S
 *	  2004.08.31		2D/2DD/VFD/^CgȂD77̕\ύX
 *	  2010.08.05		CWP[^XM6ɍ킹dlɕύX
 *	  2010.10.03		2{g\[hɑΉ
 *	  2012.06.03		Xe[^Xo[̕\Ԃ̏lSW_HIDEɕύX
 *	  2012.08.01		CAP//INSL[\bZ[W\[Xǂނ悤
 *						ύX
 *	  2012.10.10		LvṼobt@TCY256oCgɑ
 */

#ifdef _WIN32

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winbase.h>
#include <commctrl.h>
#include <stdlib.h>
#include <assert.h>
#include "xm7.h"
#include "keyboard.h"
#include "tapelp.h"
#include "display.h"
#include "ttlpalet.h"
#include "apalet.h"
#include "subctrl.h"
#include "fdc.h"
#include "bubble.h"
#include "w32.h"
#include "w32_bar.h"
#include "w32_sch.h"
#include "w32_draw.h"
#include "w32_res.h"

/*
 *	O[o [N
 */
HWND hStatusBar;						/* Xe[^Xo[ */
BOOL bStatusMessage;					/* Xe[^XbZ[W\ */
int uPaneX[3];							/* Drag&DroppyCʒu */

/*
 *	X^eBbN [N
 */
static char szIdleMessage[128];			/* AChbZ[W */
static char szStatusMessage[128];		/* Xe[^XbZ[W */
static char szRunMessage[128];			/* RUNbZ[W */
static char szStopMessage[128];			/* STOPbZ[W */
static char szCaption[256];				/* LvV */
static char szCAPMessage[16];			/* CAPL[bZ[W */
static char szKANAMessage[16];			/* ȃL[bZ[W */
static char szINSMessage[16];			/* INSL[bZ[W */
static int nCAP;						/* CAPL[ */
static int nKANA;						/* ȃL[ */
static int nINS;						/* INSL[ */
static int nDrive[2];					/* tbs[hCu */
static char szDrive[2][128];			/* tbs[hCu */
static int nTape;						/* e[v */
static UINT uResID;						/* \[XIDۑ */
static int nStatusBorder;				/* Xe[^Xo[̃{[_[` */
static BOOL (*IsAppThemed)(void);		/* e[}KpmF֐(uxtheme.dll) */
static HINSTANCE hInstTheme;			/* uxtheme.dll̃nh */
static BOOL bThemed;					/* e[}Kp */

/*-[ Xe[^Xo[ ]-------------------------------------------------------*/

/*
 *	ANZX}N
 */
#define Status_SetParts(hwnd, nParts, aWidths) \
	SendMessage((hwnd), SB_SETPARTS, (WPARAM) nParts, (LPARAM) (LPINT) aWidths)

#define Status_SetText(hwnd, iPart, uType, szText) \
	SendMessage((hwnd), SB_SETTEXT, (WPARAM) (iPart | uType), (LPARAM) (LPSTR) szText)

/*
 *	yC`
 */
enum {
		PANE_DEFAULT = 0,
		PANE_DRIVE1,
		PANE_DRIVE0,
		PANE_TAPE,
		PANE_CAP,
		PANE_KANA,
		PANE_INS,
		PANE_MAX
};

/*
 *	Xe[^Xo[쐬
 */
HWND FASTCALL CreateStatus(HWND hParent)
{
	HWND hWnd;

	ASSERT(hParent);

	/* e[}KptO */
	bThemed = FALSE;

	/* bZ[W[h */
	if (LoadString(hAppInstance, IDS_IDLEMESSAGE,
					szIdleMessage, sizeof(szIdleMessage)) == 0) {
		szIdleMessage[0] = '\0';
	}
	if (LoadString(hAppInstance, IDS_RUNCAPTION,
					szRunMessage, sizeof(szRunMessage)) == 0) {
		szRunMessage[0] = '\0';
	}
	if (LoadString(hAppInstance, IDS_STOPCAPTION,
					szStopMessage, sizeof(szStopMessage)) == 0) {
		szStopMessage[0] = '\0';
	}
	if (LoadString(hAppInstance, IDS_BAR_CAP,
					szCAPMessage, sizeof(szCAPMessage)) == 0) {
		strncpy(szCAPMessage, "CAP", sizeof(szCAPMessage));
	}
	if (LoadString(hAppInstance, IDS_BAR_KANA,
					szKANAMessage, sizeof(szKANAMessage)) == 0) {
#if XM7_VER == 1
		strncpy(szKANAMessage, "Ji", sizeof(szKANAMessage));
#else
		strncpy(szKANAMessage, "", sizeof(szKANAMessage));
#endif
	}
	if (LoadString(hAppInstance, IDS_BAR_INS,
					szINSMessage, sizeof(szINSMessage)) == 0) {
		strncpy(szINSMessage, "INS", sizeof(szINSMessage));
	}

	/* Xe[^XbZ[W */
	szStatusMessage[0] = '\0';
	bStatusMessage = FALSE;
	uResID = 0;

	/* Xe[^Xo[쐬 */
	hWnd = CreateStatusWindow(WS_CHILD | CCS_BOTTOM | CCS_NORESIZE,
								"", hParent, ID_STATUS_BAR);
	ChangeStatusBorder(hWnd);
	ResizeStatus(hParent, hWnd);
	ShowWindow(hWnd, SW_HIDE);

	return hWnd;
}

/*
 *	LvV`
 */
static void FASTCALL DrawMainCaption(void)
{
	char string[256];
	char tmp[256];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];

	/* 󋵂ɉāARs[ */
	if (run_flag) {
		strncpy(string, szRunMessage, sizeof(string));
	}
	else {
		strncpy(string, szStopMessage, sizeof(string));
	}
	strncat(string, " ", sizeof(string) - strlen(string) - 1);

#ifndef DISABLE_FULLSPEED
	/* CPUx䗦 */
	if (bAutoSpeedAdjust) {
		_snprintf(tmp, sizeof(tmp), "(%3d%%) ", speed_ratio / 100);
		strncat(string, tmp, sizeof(string) - strlen(string) - 1);
	}
#endif

	/* tbs[fBXNhCu 0 */
	if (fdc_ready[0] != FDC_TYPE_NOTREADY) {
		/* t@Cl[{gq̂ݎo */
		_splitpath(fdc_fname[0], drive, dir, fname, ext);
		_snprintf(tmp, sizeof(tmp), "- %s%s ", fname, ext);
		strncat(string, tmp, sizeof(string) - strlen(string) - 1);
	}

	/* tbs[fBXNhCu 1 */
	if (fdc_ready[1] != FDC_TYPE_NOTREADY) {
		if ((strcmp(fdc_fname[0], fdc_fname[1]) != 0) ||
			(fdc_ready[0] == FDC_TYPE_NOTREADY)) {
			/* t@Cl[{gq̂ݎo */
			_splitpath(fdc_fname[1], drive, dir, fname, ext);
			if (fdc_ready[0] == FDC_TYPE_NOTREADY) {
				_snprintf(tmp, sizeof(tmp), "- (%s%s) ", fname, ext);
			}
			else {
				_snprintf(tmp, sizeof(tmp), "(%s%s) ", fname, ext);
			}
			strncat(string, tmp, sizeof(string) - strlen(string) - 1);
		}
	}

	/* e[v */
	if (tape_fileh != -1) {
		/* t@Cl[{gq̂ݎo */
		_splitpath(tape_fname, drive, dir, fname, ext);
		_snprintf(tmp, sizeof(tmp), "- %s%s ", fname, ext);
		strncat(string, tmp, sizeof(string) - strlen(string) - 1);
	}

#if XM7_VER == 1 && defined(BUBBLE)
	/* ou */
	if (fm_subtype == FMSUB_FM8) {
		if (bmc_ready[0] != BMC_TYPE_NOTREADY) {
			/* t@Cl[{gq̂ݎo */
			_splitpath(bmc_fname[0], drive, dir, fname, ext);
			_snprintf(tmp, sizeof(tmp), "- %s%s ", fname, ext);
			strncat(string, tmp, sizeof(string) - strlen(string) - 1);
		}

		if (bmc_ready[1] != BMC_TYPE_NOTREADY) {
			/* t@Cl[{gq̂ݎo */
			_splitpath(bmc_fname[1], drive, dir, fname, ext);
			if (bmc_ready[0] == BMC_TYPE_NOTREADY) {
				_snprintf(tmp, sizeof(tmp), "- (%s%s) ", fname, ext);
			}
			else {
				_snprintf(tmp, sizeof(tmp), "(%s%s) ", fname, ext);
			}
			strncat(string, tmp, sizeof(string) - strlen(string) - 1);
		}
	}
#endif

	/* r` */
	string[255] = '\0';
	if (memcmp(szCaption, string, strlen(string) + 1) != 0) {
		strncpy(szCaption, string, sizeof(szCaption));
		SetWindowText(hMainWnd, szCaption);
	}
}

/*
 *	ACR`FbNAύX
 */
static void FASTCALL CheckIcon(void)
{
	HICON hIcon;

#if XM7_VER == 1
	/* v`FbN */
	if (fm_subtype == nAppIcon) {
		return;
	}

	/* VACR[hAZbg */
	switch (fm_subtype) {
		case FMSUB_FM8:
			hIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_FM8ICON));
			break;
		case FMSUB_FM7:
			hIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_FM7ICON));
			break;
		case FMSUB_FM77:
			hIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_FM77ICON));
			break;
		default:
			hIcon = NULL;
			ASSERT(FALSE);
			break;
	}
	SendMessage(hMainWnd, WM_SETICON, ICON_BIG, (LPARAM)hIcon);
	SendMessage(hMainWnd, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);

	/* ACR폜 */
	DestroyIcon(hAppIcon);

	/* L */
	hAppIcon = hIcon;
	nAppIcon = fm_subtype;
#else
	/* v`FbN */
	if (fm7_ver == nAppIcon) {
		return;
	}

	/* VACR[hAZbg */
	switch (fm7_ver) {
		case 1:
			hIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_FM7ICON));
			break;
		case 2:
			hIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_77AVICON));
			break;
#if XM7_VER >= 3
		case 3:
			if (bGravestone) {
				hIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_40SXICON));
			}
			else {
				hIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_40EXICON2));
			}
			break;
#endif
		default:
			hIcon = NULL;
			ASSERT(FALSE);
			break;
	}
	SendMessage(hMainWnd, WM_SETICON, ICON_BIG, (LPARAM)hIcon);
	SendMessage(hMainWnd, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);

	/* ACR폜 */
	DestroyIcon(hAppIcon);

	/* L */
	hAppIcon = hIcon;
	nAppIcon = fm7_ver;
#endif
}

/*
 *	CAPL[`
 */
static void FASTCALL DrawCAP(void)
{
	int num;

	/* ԍ */
	if (caps_flag) {
		num = 1;
	}
	else {
		num = 0;
	}

	/* Ȃ牽Ȃ */
	if (nCAP == num) {
		return;
	}

	/* `A[NXV */
	nCAP = num;
	Status_SetText(hStatusBar, PANE_CAP, SBT_OWNERDRAW, PANE_CAP);
}

/*
 *	ȃL[`
 */
static void FASTCALL DrawKANA(void)
{
	int num;

	/* ԍ */
	if (kana_flag) {
		num = 1;
	}
	else {
		num = 0;
	}

	/* Ȃ牽Ȃ */
	if (nKANA == num) {
		return;
	}

	/* `A[NXV */
	nKANA = num;
	Status_SetText(hStatusBar, PANE_KANA, SBT_OWNERDRAW, PANE_KANA);
}

/*
 *	INSL[`
 */
static void FASTCALL DrawINS(void)
{
	int num;

	/* ԍ */
	if (ins_flag) {
		num = 1;
	}
	else {
		num = 0;
	}

	/* Ȃ牽Ȃ */
	if (nINS == num) {
		return;
	}

	/* `A[NXV */
	nINS = num;
	Status_SetText(hStatusBar, PANE_INS, SBT_OWNERDRAW, PANE_INS);
}

/*
 *	hCu`
 */
static void FASTCALL DrawDrive(int drive, UINT nID)
{
	char string[_MAX_FNAME + _MAX_EXT];
	char buffer[_MAX_FNAME + _MAX_EXT + 4];
	char drive_[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	int num;
	char *name;

	ASSERT((drive >= 0) && (drive <= 1));

	/* ԍZbg */
	if ((fdc_ready[drive] == FDC_TYPE_NOTREADY) || (fdc_teject[drive])) {
		num = FDC_ACCESS_NOTREADY;
	}
	else {
		num = fdc_access[drive];
		if (num == FDC_ACCESS_SEEK) {
			num = FDC_ACCESS_READY;
		}
	}

	/* O擾 */
	name = "";
	if ((fdc_ready[drive] == FDC_TYPE_D77) &&
		(strlen(fdc_name[drive][ fdc_media[drive] ]) > 0)) {
		name = fdc_name[drive][ fdc_media[drive] ];
	}
	else if ((fdc_ready[drive] == FDC_TYPE_FDX) &&
		(strlen(fdc_name[drive][0]) > 0)) {
		name = fdc_name[drive][0];
	}
	else if (fdc_ready[drive] != FDC_TYPE_NOTREADY) {
		/* t@Cl[{gq̂ݎo */
		_splitpath(fdc_fname[drive], drive_, dir, fname, ext);
		strncpy(string, fname, sizeof(string));
		strncat(string, ext, sizeof(string) - strlen(string) - 1);
		if ((fdc_ready[drive] == FDC_TYPE_D77) && (fdc_medias[drive] > 1)) {
			_snprintf(buffer, sizeof(buffer), "%s #%02d", string,
					  fdc_media[drive] + 1);
			name = buffer;
		}
		else {
			name = string;
		}
	}

	/* ԍr */
	if (nDrive[drive] == num) {
		if (strcmp(szDrive[drive], name) == 0) {
			return;
		}
	}

	/* ` */
	nDrive[drive] = num;
	strncpy(szDrive[drive], name, sizeof(szDrive[drive]));
	Status_SetText(hStatusBar, nID, SBT_OWNERDRAW, nID);
}

/*
 *	e[v`
 */
static void FASTCALL DrawTape(void)
{
	int num;

	/* io[vZ */
	num = 30000;
	if (tape_fileh != -1) {
		num = (int)((tape_offset >> 8) % 10000);
		if (tape_motor) {
			if (tape_rec) {
				num += 20000;
			}
			else {
				num += 10000;
			}
		}
	}

	/* ԍr */
	if (nTape == num) {
		return;
	}

	/* ` */
	nTape = num;
	Status_SetText(hStatusBar, PANE_TAPE, SBT_OWNERDRAW, PANE_TAPE);
}

/*
 *	`
 */
void FASTCALL DrawStatus(void)
{
	/* EChE`FbN */
	if (!hMainWnd) {
		return;
	}

	DrawMainCaption();
	CheckIcon();

	/* SʁAXe[^Xo[`FbN */
	if (bFullScreen || !hStatusBar) {
		return;
	}

	DrawCAP();
	DrawKANA();
	DrawINS();
	DrawDrive(0, PANE_DRIVE0);
	DrawDrive(1, PANE_DRIVE1);
	DrawTape();
}

/*
 *	ĕ`
 */
void FASTCALL PaintStatus(void)
{
	/* L[NׂăNA */
	szCaption[0] = '\0';
	nCAP = -1;
	nKANA = -1;
	nINS = -1;
	nDrive[0] = -1;
	nDrive[1] = -1;
	szDrive[0][0] = '\0';
	szDrive[1][0] = '\0';
	nTape = -1;

	/* ` */
	DrawStatus();
}

/*
 *	LN^`
 */
static void FASTCALL DrawChar(HDC hDC, BYTE c, int x, int y, UINT color)
{
	int i;
	int j;
	BYTE *p;
	BYTE dat;

	/* TuROM(C)̃tHgAhX𓾂 */
	p = &subrom_c[c * 8];

	/* y[v */
	for (i=0; i<8; i++) {
		/* f[^擾 */
		dat = *p;
		p++;

		/* x[v */
		for (j=0; j<8; j++) {
			if (dat & 0x80) {
				SetPixelV(hDC, x, y, color);
			}
			else {
				SetPixelV(hDC, x, y, RGB(0, 0, 0));
			}
			dat <<= 1;
			x++;
		}

		/* y */
		x -= 8;
		y++;
	}
}

/*
 *	I[i[h[
 */
void FASTCALL OwnerDrawStatus(DRAWITEMSTRUCT *pDI)
{
	HBRUSH hBrush;
	COLORREF fColor;
	COLORREF bColor;
	RECT srect;
	char string[_MAX_FNAME + _MAX_EXT + 4];
	int drive;

	ASSERT(pDI);

	/* AF */
	switch (pDI->itemData) {
		/* tbs[fBXN */
		case PANE_DRIVE1:
		case PANE_DRIVE0:
			if (pDI->itemData == PANE_DRIVE0) {
				drive = 0;
			}
			else {
				drive = 1;
			}
			if ((nDrive[drive] == FDC_ACCESS_NOTREADY) &&
				(!fdc_teject[drive])) {
				strncpy(string, "", sizeof(string));
			}
			else {
				strncpy(string, szDrive[drive], sizeof(string));
			}
			fColor = RGB(255, 255, 255);
			bColor = RGB(63, 63, 63);
			if ((nDrive[drive] == FDC_ACCESS_NOTREADY) ||
				(fdc_teject[drive])) {
				bColor = RGB(0, 0, 0);
			}
			if (nDrive[drive] == FDC_ACCESS_READ) {
				bColor = RGB(191, 0, 0);
			}
			if (nDrive[drive] == FDC_ACCESS_WRITE) {
				bColor = RGB(0, 0, 191);
			}
			break;

		/* e[v */
		case PANE_TAPE:
			if (nTape >= 30000) {
				string[0] = '\0';
			}
			else {
				_snprintf(string, sizeof(string), "%04d", nTape % 10000);
			}
			fColor = RGB(255, 255, 255);
			bColor = RGB(63, 63, 63);
			if (nTape >= 10000) {
				if (nTape >= 30000) {
					bColor = RGB(0, 0, 0);
				}
				else if (nTape >= 20000) {
					bColor = RGB(0, 0, 191);
				}
				else {
					bColor = RGB(191, 0, 0);
				}
			}
			break;

		/* CAP */
		case PANE_CAP:
			fColor = RGB(255, 255, 255);
			strncpy(string, szCAPMessage, sizeof(string));
			if (nCAP) {
				bColor = RGB(255, 0, 0);
			}
			else {
				bColor = RGB(0, 0, 0);
			}
			break;

		/*  */
		case PANE_KANA:
			fColor = RGB(255, 255, 255);
			strncpy(string, szKANAMessage, sizeof(string));
			if (nKANA) {
				bColor = RGB(255, 0, 0);
			}
			else {
				bColor = RGB(0, 0, 0);
			}
			break;

		/* INS */
		case PANE_INS:
			fColor = RGB(255, 255, 255);
			strncpy(string, szINSMessage, sizeof(string));
			if (nINS) {
				bColor = RGB(255, 0, 0);
			}
			else {
				bColor = RGB(0, 0, 0);
			}
			break;

		/* ȊO */
		default:
			ASSERT(FALSE);
			return;
	}

	/* uVœh */
	hBrush = CreateSolidBrush(bColor);
	if (hBrush) {
		FillRect(pDI->hDC, &(pDI->rcItem), hBrush);
		DeleteObject(hBrush);
	}

	/* eLXg̉e` */
	srect.left = pDI->rcItem.left + 1;
	srect.right = pDI->rcItem.right + 1;
	srect.top = pDI->rcItem.top + 1;
	srect.bottom = pDI->rcItem.bottom + 1;
	SetTextColor(pDI->hDC, RGB(0, 0, 0));
	SetBkMode(pDI->hDC, TRANSPARENT);
	DrawText(pDI->hDC, string, strlen(string), &srect,
				DT_CENTER | DT_VCENTER | DT_SINGLELINE | DT_NOPREFIX);

	/* eLXg` */
	SetTextColor(pDI->hDC, fColor);
	SetBkMode(pDI->hDC, TRANSPARENT);	/* for WinXP Luna */
	DrawText(pDI->hDC, string, strlen(string), &(pDI->rcItem),
				DT_CENTER | DT_VCENTER | DT_SINGLELINE | DT_NOPREFIX);

	/* hCuԍ` */
	if ((pDI->itemData == PANE_DRIVE1) || (pDI->itemData == PANE_DRIVE0)) {
		DrawChar(pDI->hDC, (BYTE)(0x30 + drive),
				 pDI->rcItem.right - 8, pDI->rcItem.bottom - 8,
				 RGB(255, 255, 255));
	}
}

/*
 *	TCYύX
 */
void FASTCALL SizeStatus(LONG cx)
{
	HDC hDC;
	TEXTMETRIC tm;
	LONG cw;
	UINT uPane[PANE_MAX];

	ASSERT(cx > 0);
	ASSERT(hStatusBar);

	/* eLXggbN擾 */
	hDC = GetDC(hStatusBar);
	GetTextMetrics(hDC, &tm);
	ReleaseDC(hStatusBar, hDC);
	cw = tm.tmAveCharWidth;

	/* yCTCY(yCE[̈ʒuݒ) */
	uPane[PANE_INS] = cx;
	uPane[PANE_KANA] = uPane[PANE_INS] - cw * 4;
	uPane[PANE_CAP] = uPane[PANE_KANA] - cw * 4;
	uPane[PANE_TAPE] = uPane[PANE_CAP] - cw * 4;
	uPane[PANE_DRIVE0] = uPane[PANE_TAPE] - cw * 5;
	uPane[PANE_DRIVE1] = uPane[PANE_DRIVE0] - cw * 16;
	uPane[PANE_DEFAULT] = uPane[PANE_DRIVE1] - cw * 16;

	/* Drag&DroppyCWݒ */
	uPaneX[0] = uPane[PANE_DEFAULT];
	uPaneX[1] = uPane[PANE_DRIVE1];
	uPaneX[2] = uPane[PANE_DRIVE0];

	/* yCTCYݒ */
	Status_SetParts(hStatusBar, sizeof(uPane)/sizeof(UINT), uPane);

	/* ĕ` */
	PaintStatus();
}

/*
 *	Xe[^Xo[TCY
 */
void FASTCALL ResizeStatus(HWND hwnd, HWND hstatus)
{
	RECT rect;
	int height;

	/* wiFύX */
	SendMessage(hstatus, SB_SETBKCOLOR, 0, GetSysColor(COLOR_3DFACE));

	/* ␳ */
	GetWindowRect(hMainWnd, &rect);
	if (bDoubleSize) {
		height = 800;
	}
	else {
		height = 400;
	}
	MoveWindow(hstatus, 0, height, (rect.right - rect.left),
			   GetSystemMetrics(SM_CYMENU), TRUE);

	/* t[EChẼTCY␳ */
	GetClientRect(hwnd, &rect);
	PostMessage(hwnd, WM_SIZE, 0, MAKELPARAM(rect.right, rect.bottom));
}

/*
 *	Xe[^XbZ[W\
 */
void FASTCALL SetStatusMessage(UINT ID)
{
	ASSERT(hStatusBar);

	/* Xe[^Xo[\ĂȂ΁AȂ */
	if (!IsWindowVisible(hStatusBar)) {
		return;
	}

	/* wID̕񃊃\[X[h݂ */
	if (LoadString(hAppInstance, ID, szStatusMessage, sizeof(szStatusMessage)) != 0) {
		/* Xe[^XbZ[WZbg */
		Status_SetText(hStatusBar, 0, nStatusBorder, szStatusMessage);

		/* Xe[^XbZ[Wp^C}ݒ肷 */
		if (bStatusMessage) {
			KillTimer(hMainWnd, ID_STATUS_BAR);
		}
		SetTimer(hMainWnd, ID_STATUS_BAR, 1500, NULL);

		/* Xe[^XbZ[W\tO𗧂Ă */
		bStatusMessage = TRUE;
	}
	else {
		/* \[X[hɎsꍇA\tO~낷 */
		bStatusMessage = FALSE;
	}
}

/*
 *	Xe[^XbZ[WI
 */
void FASTCALL EndStatusMessage(void)
{
	char buffer[128];

	ASSERT(hStatusBar);

	/* ƂƃXe[^XbZ[W\ĂȂ΁AȂ */
	if (!bStatusMessage) {
		return;
	}

	/* Xe[^XbZ[W\tO~낷 */
	bStatusMessage = FALSE;

	/* Xe[^Xo[\ĂȂ΁AȂ */
	if (!IsWindowVisible(hStatusBar)) {
		return;
	}

	if (uResID != 0) {
		/* 񃊃\[X[h݂ */
		if (LoadString(hAppInstance, uResID, buffer, sizeof(buffer)) == 0) {
			buffer[0] = '\0';
		}
	}
	else {
		/* AChbZ[WRs[ */
		strncpy(buffer, szIdleMessage, sizeof(buffer));
	}

	/* Zbg */
	Status_SetText(hStatusBar, 0, nStatusBorder, buffer);
}

/*
 *	j[ZNg
 */
void FASTCALL OnMenuSelect(WPARAM wParam)
{
	char buffer[128];
	UINT uID;

	ASSERT(hStatusBar);

	/* Xe[^Xo[\ĂȂ΁AȂ */
	if (!IsWindowVisible(hStatusBar)) {
		return;
	}

	/* [h郊\[XID */
	uID = (UINT)LOWORD(wParam);
	if (((uID >= IDM_D0MEDIA00) && (uID <= IDM_D0MEDIA15)) ||
		((uID >= IDM_D1MEDIA00) && (uID <= IDM_D1MEDIA15))) {
		/* fBA */
		uID = IDS_MEDIA_CHANGE;
	}

	/* 񃊃\[X[h݂ */
	if (LoadString(hAppInstance, uID, buffer, sizeof(buffer)) == 0) {
		buffer[0] = '\0';
	}

	/* Zbg */
	Status_SetText(hStatusBar, 0, nStatusBorder, buffer);

	/* \[XID([htO)ۑ */
	uResID = uID;
}

/*
 *	j[I
 */
void FASTCALL OnExitMenuLoop(void)
{
	ASSERT(hStatusBar);

	/* Xe[^Xo[\ĂȂ΁AȂ */
	if (!IsWindowVisible(hStatusBar)) {
		return;
	}

	/* AChbZ[W\ */
	if (bStatusMessage) {
		Status_SetText(hStatusBar, 0, nStatusBorder, szStatusMessage);
	}
	else {
		Status_SetText(hStatusBar, 0, nStatusBorder, szIdleMessage);
	}

	/* \[XID([htO)ۑ */
	uResID = 0;
}

/*-[ WindowsXPΉ ]----------------------------------------------------*/

/*
 *	WindowsXP rWAX^CΉp 08/14
 *	UXTHEME.DLL
 */
void FASTCALL InitThemeDLL(void)
{
	char path[_MAX_PATH];

	/* uxtheme.dll[h */
	GetSystemDirectory(path, sizeof(path));
	strncat(path, "\\uxtheme.dll", sizeof(path) - strlen(path) - 1);
	hInstTheme = LoadLibrary(path);

	/* ֐̐擪AhXݒ */
	if (hInstTheme) {
		IsAppThemed = (BOOL(*)(void))GetProcAddress(hInstTheme, "IsAppThemed");

		if (!IsAppThemed) {
			/* s */
			CleanThemeDLL();
		}
	}
}

/*
 *	WindowsXP rWAX^CΉp
 *	UXTHEME.DLLN[Abv
 */
void FASTCALL CleanThemeDLL(void)
{
	/* DLLǂݍ܂ĂJ */
	if (hInstTheme) {
		FreeLibrary(hInstTheme);
		IsAppThemed = NULL;
		hInstTheme = NULL;
	}
}

/*
 *	WindowsXP rWAX^CΉp
 *	Xe[^XbZ[W{[_[`ԕύX
 */
void FASTCALL ChangeStatusBorder(HWND hwnd)
{
	/* e[}KpԂł͘g`悷 */
	if (hInstTheme && IsAppThemed) {
		if (!IsAppThemed()) {
			nStatusBorder = SBT_NOBORDERS;
			bThemed = FALSE;
		}
		else {
			nStatusBorder = 0;
			bThemed = TRUE;
		}
	}
	else {
		nStatusBorder = SBT_NOBORDERS;
		bThemed = FALSE;
	}

	/* AChbZ[W\ */
	if (bStatusMessage) {
		Status_SetText(hwnd, 0, nStatusBorder, szStatusMessage);
	}
	else {
		Status_SetText(hwnd, 0, nStatusBorder, szIdleMessage);
	}
}

#endif	/* _WIN32 */
