/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2021 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2021 Ryu Takegami (Twitter:@RyuTakegami)
 *
 *	[ Win32API CvO ]
 *
 *	RHG
 *	  2001.12.25		DrawEBhEIME֎~悤ύX(ohD)
 *						TuEBhEtHg̃p[^ύX(ohD)
 *	  2002.01.24		ȈuR|[lg̃N[Abv
 *						ݒt@C̕ۑvɕύX
 *	  2002.04.05		NɃTCY␳ÕEBhEȂ悤ɏC
 *	  2002.04.25		WinNTnœdÑR}hCp[^ɋN
 *						ĂCX^XɓnȂC
 *	  2002.05.01		]o[WƂ̌݊mۂ̂Win9xnł̃R}h
 *						CnWM_USER+1g@ɖ߂
 *	  2002.08.15		ꕔL[ɂWM_KEYDOWNł̃L[󋵎擾ɑΉ
 *	  2002.08.29		ANeBuɃEBhE̍ĕ`s悤ɕύX
 *						(^vWFNgpJX^łtA ^^;)
 *	  2002.09.11		Xe[^XbZ[WɃVXe^C}[𗘗p
 *						悤ɕύX
 *	  2002.09.17		NTnŃTuEBhE𕜌ꍇɈꕔ̃L[
 *						ȂC
 *						CEBhE폜ɃTuEBhE폜悤
 *						ύX
 *	  2002.11.13		XbhD揇ʂABOVE NORMALɕύX
 *	  2002.12.11		DLLJYĂC(ccc)
 *	  2003.01.19		F10ׂF10ɃL[R[h蓖ĂĂ鎞̂ݍs
 *						悤ɕύX
 *	  2003.01.23		ROMEOtORPC
 *	  2003.02.10		V2߂ŋNɃ`lR[ݒ肪ݒ_CA
 *						OɔfȂC
 *	  2003.04.22		NT΍BreakɃVXe^C}𗘗p悤ɕύX
 *	  2003.05.11		DLLǂݍݏ̖̏ŃrWAX^CKp`
 *						FbNɎsC(XP only)
 *	  2003.05.25		Win2000/XPŃVXeJ[ύXɃXe[^Xo[̐F
 *						ςȂƂC
 *						ʃfUCύX̃Xe[^Xo[̃TCYύXɑΉ
 *	  2003.07.25		EBhEʒu̕ۑEɑΉ
 *	  2003.09.23		NTnSHIFT+CAP͂łȂC
 *	  2004.03.29		PC-9801L[{[hŃJiL[gpłȂC
 *	  2004.05.03		IMET|[g֐DLLǂݍ݃`FbN̈S
 *	  2004.08.30		ÑG[bZ[W\ɓdNłĂ
 *						ɑ΍
 *						z}VEDirectX̏sɃEBhE\
 *						Ȃ悤ɕύX
 *	  2004.09.13		ÑEChETCYAdjustWindowRect𗘗p
 *						悤ɕύX
 *	  2004.10.20		NTnSHIFT+J^Ji/Ђ炪ȂȂC
 *	  2005.10.15		NɃ}EXLv`LɂȂȂC
 *	  2010.01.14		Vistaȍ~ł̉EVtgL[ւ̑΍s
 *	  2010.01.20		WindowsVista/Windows7ŋtAZuEChEJ
 *						nỎ̂߃TuEChE`Ɨ
 *	  2010.02.18		XM7s͌ŒL[@\𖳌悤ɕύX
 *	  2010.06.19		ŏɃL[͂󂯕tC
 *	  2010.08.02		L[{[h|[Ow32_sch.cړ
 *	  2010.10.03		2{g\[hɑΉ
 *	  2011.01.26		Xe[^Xo[\ɃEBhEs蒷ɂ̂т
 *						C
 *	  2012.03.06		C[vύX
 *	  2012.05.01		tXN[ԕۑւ̑Ή
 *	  2012.06.03		Xe[^Xo[̕\Ԃ̕ۑɑΉ
 *	  2012.07.14		ΉpODLLɑΉ
 *	  2012.10.10		Windows 8łDrawMenuBar API̋ύXɑ΍
 *						NOSo[W`FbN
 *	  2014.06.28		ΉpODLLւ̑Ήp~
 *	  2017.06.17		˔qȂΉpODLLւ̑ΉĊJ
 *	  2017.11.24		ΉpODLLւ̑ΉSɔp~
 */

#ifdef _WIN32

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commctrl.h>
#include <imm.h>
#include <shellapi.h>
#include <stdlib.h>
#include <assert.h>
#include <mmsystem.h>
#define DIRECTINPUT_VERSION		0x0300		/* DirectX3w */
#include <dinput.h>
#include "xm7.h"
#include "mouse.h"
#include "tapelp.h"
#include "keyboard.h"
#include "w32.h"
#include "w32_bar.h"
#include "w32_draw.h"
#include "w32_dd.h"
#include "w32_gdi.h"
#include "w32_kbd.h"
#include "w32_sch.h"
#include "w32_snd.h"
#include "w32_res.h"
#include "w32_sub.h"
#include "w32_cfg.h"
#include "w32_comm.h"

#ifdef SOUNDENGINE
#include "juliet.h"
#endif
#ifdef MIDI
#include "w32_midi.h"
#endif

#ifdef _MSC_VER
#pragma comment(lib, "comctl32.lib")
#pragma comment(lib, "imm32.lib")
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "dinput8.lib")
#pragma comment(lib, "dsound.lib")
#pragma comment(lib, "strmiids.lib")
#endif

/*
 *	O[o [N
 */
HINSTANCE hAppInstance;					/* AvP[V CX^X */
HWND hMainWnd;							/* CEChE */
HWND hDrawWnd;							/* h[EChE */
int nErrorCode;							/* G[R[h */
BOOL bMenuLoop;							/* j[[v */
BOOL bMenuExit;							/* j[otO */
BOOL bCloseReq;							/* IvtO */
LONG lCharWidth;						/* LN^ */
LONG lCharHeight;						/* LN^c */
BOOL bSync;								/* sɓ */
BOOL bSyncDisasm[4];					/* tAZuPCɓ */
BOOL bMinimize;							/* ŏtO */
BOOL bActivate;							/* ANeBx[gtO */
BOOL bHideStatus;						/* Xe[^Xo[B */
HICON hAppIcon;							/* ACRnh */
int nAppIcon;							/* ACRԍ(1,2,3) */
BOOL bNTflag;							/* OS^Cv1(NT) */
BOOL bXPflag;							/* OS^Cv2(XP) */
BOOL bVistaflag;						/* OS^Cv3(Vista/7) */
BOOL bWin7flag;							/* OS^Cv4(Windows 7) */
BOOL bWin8flag;							/* OS^Cv5(Windows 8) */
BOOL bWin10flag;						/* OS^Cv6(Windows 10) */
BOOL bMMXflag;							/* MMXT|[gtO */
BOOL bCMOVflag;							/* CMOVT|[gtO(󖢎gp) */
BOOL bHighPriority;						/* nCvCIeBtO */
POINT WinPos;							/* EBhEʒu */
#ifdef SOUNDENGINE
BOOL bRomeo;							/* ROMEOFtO */
BOOL bSCCI_available;					/* SCCIFtO */
#endif
#if XM7_VER == 2 && defined(FMTV151)
BOOL bFMTV151;							/* V2`lR[tO */
#endif
HFONT hFont;							/* TuEBhEptHgnh */
HMENU hMediaMenu;						/* fBAj[nh */
HMENU hHistoryMenu;						/* qXgj[nh */

/*
 *	X^eBbN [N
 */
static CRITICAL_SECTION CSection;		/* NeBJZNV */
static BOOL (WINAPI *WINNLSEnableIME)(HWND, BOOL);
										/* IMEL/ݒpAPI֐ */
static HINSTANCE hInstDLL;				/* user32.dll̃nh */
static BOOL bContextualMenuLoop;		/* ReLXgj[[v */
static WORD wMenuID;					/* j[I */

/*
 *	AZu֐̂߂̃vg^Cv錾
 */
extern BOOL CheckMMX(void);				/* MMXΉ`FbN */
extern BOOL CheckCMOV(void);			/* CMOVΉ`FbN(ݖgp) */

/*-[ IMET|[g ]----------------------------------------------------------*/

/*
 *	IMEL/ݒAPI
 *	DLL
 */
void FASTCALL InitIMEDLL(void)
{
	char path[_MAX_PATH];

	/* user32.dll[h */
	GetSystemDirectory(path, sizeof(path));
	strncat(path, "\\user32.dll", sizeof(path) - strlen(path) - 1);
	hInstDLL = LoadLibrary(path);

	/* ֐̐擪AhXݒ */
	if (hInstDLL) {
		WINNLSEnableIME = (BOOL (WINAPI *)(HWND, BOOL))GetProcAddress(
			hInstDLL, "WINNLSEnableIME");

		if (!WINNLSEnableIME) {
			/* s */
			CleanIMEDLL();
		}
	}
}

/*
 *	IMEL/ݒAPI
 *	DLLN[Abv
 */
void FASTCALL CleanIMEDLL(void)
{
	/* DLLǂݍ܂ĂJ */
	if (hInstDLL) {
		FreeLibrary(hInstDLL);
	}

	WINNLSEnableIME = NULL;
	hInstDLL = NULL;
}

/*
 *	IMEL/؂芷 09/09
 */
BOOL FASTCALL EnableIME(HWND hWnd, BOOL flag)
{
	/* WINNLSEnableIME֐ǂݍ߂Ăꍇ͎s */
	if (hInstDLL && WINNLSEnableIME) {
		return WINNLSEnableIME(hWnd, flag);
	}

	/* ̂܂ܕԂlƂ */
	return flag;
}

/*-[ TuEBhET|[g ]-----------------------------------------------*/

/*
 *	eLXgtHg쐬
 *	ĂяoDeleteObject邱
 */
HFONT FASTCALL CreateTextFont(void)
{
	HFONT hFont;

	/* ꔻ肵āAVtgJISEANSIǂ炩̃tHg */
	if (PRIMARYLANGID(GetUserDefaultLangID()) == LANG_JAPANESE) {
		/* { */
		hFont = CreateFont(-12, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE,
			SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, FIXED_PITCH, "MS Gothic");
	}
	else {
		/* p */
		hFont = CreateFont(-11, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE,
			ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, FIXED_PITCH, NULL);
	}

	ASSERT(hFont);
	return hFont;
}

/*
 *	TuEBhEZbgAbv
 */
static void FASTCALL SetupSubWnd(HWND hWnd)
{
	HFONT hBackup;
	HDC hDC;
	TEXTMETRIC tm;

	ASSERT(hWnd);

	/* EChE[N */
	memset(hSubWnd, 0, sizeof(hSubWnd));
	memset(bShowSubWindow, 0, sizeof(bShowSubWindow));
	InitSubWndWork();

	/* DC擾AtHgZNg */
	hDC = GetDC(hWnd);
	ASSERT(hDC);
	hBackup = SelectObject(hDC, hFont);
	ASSERT(hBackup);

	/* eLXggbN擾 */
	GetTextMetrics(hDC, &tm);

	/* DCN[Abv */
	SelectObject(hDC, hBackup);
	ReleaseDC(hWnd, hDC);

	/* ʂXgA */
	lCharWidth = tm.tmAveCharWidth;
	lCharHeight = tm.tmHeight + tm.tmExternalLeading;
}

/*-[  ]-----------------------------------------------------------------*/

/*
 *	VMbN
 */
void FASTCALL LockVM(void)
{
	EnterCriticalSection(&CSection);
}

/*
 *	VMAbN
 */
void FASTCALL UnlockVM(void)
{
	LeaveCriticalSection(&CSection);
}

/*-[ h[EChE ]-----------------------------------------------------*/

/*
 * 	EChEvV[W
 */
static LRESULT CALLBACK DrawWndProc(HWND hWnd, UINT message,
								 WPARAM wParam,LPARAM lParam)
{
	/* bZ[W */
	switch (message) {
		/* EChE쐬 */
		case WM_CREATE:
			/* IME֎~ */
			ImmAssociateContext(hWnd, (HIMC)NULL);
			break;

		/* EChEwi` */
		case WM_ERASEBKGND:
			/* G[ȂȂAwi`悹 */
			if (nErrorCode == 0) {
				return 0;
			}
			break;

		/* EChEĕ` */
		case WM_PAINT:
			/* bNKv */
			LockVM();
			OnPaint(hWnd);
			UnlockVM();
			return 0;

		/* j[`FbN (CEBhEɑ΂ăbZ[WĔs) */
		case WM_NCMOUSEMOVE:
		case WM_MOUSEMOVE:
			if (bWin8flag) {
				/* Windows 8Ƃǂ]̏ł܂sȂ̂ */
				PostMessage(hMainWnd, message, wParam, lParam);
			}
			else {
				PostMessage(hMainWnd, message, wParam, 
					MAKELPARAM(LOWORD(lParam), (HIWORD(lParam) +
					GetSystemMetrics(SM_CYMENU))));
			}
			return 0;
	}

	/* ftHg EChEvV[W */
	return DefWindowProc(hWnd, message, wParam, lParam);
}

/*
 *	h[EChE쐬
 */
static HWND FASTCALL CreateDraw(HWND hParent)
{
	WNDCLASSEX wcex;
	char szWndName[] = "XM7_Draw";
	RECT rect;
	HWND hWnd;

	ASSERT(hParent);

	/* eEChE̋`擾 */
	GetClientRect(hParent, &rect);

	/* EChENX̓o^ */
	memset(&wcex, 0, sizeof(wcex));
	wcex.cbSize = sizeof(wcex);
	wcex.style = CS_VREDRAW | CS_HREDRAW;
	wcex.lpfnWndProc = DrawWndProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra = 0;
	wcex.hInstance = hAppInstance;
	wcex.hIcon = NULL;
	wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wcex.lpszMenuName = NULL;
	wcex.lpszClassName = szWndName;
	wcex.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	RegisterClassEx(&wcex);

	/* EChE쐬 */
	hWnd = CreateWindow(szWndName,
						szWndName,
						WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN,
						0,
						0,
						640,
						400,
						hParent,
						NULL,
						hAppInstance,
						NULL);

	/* ʂA */
	return hWnd;
}

/*-[ CEChE ]-----------------------------------------------------*/

/*
 *	EChE쐬
 */
static void FASTCALL OnCreate(HWND hWnd)
{
	BOOL flag;

	ASSERT(hWnd);

	/* NeBJZNV쐬 */
	InitializeCriticalSection(&CSection);

	/* IME֎~ */
	ImmAssociateContext(hWnd, (HIMC)NULL);

	/* t@Chbv */
	DragAcceptFiles(hWnd, TRUE);

	/* [NGA */
	nErrorCode = 0;
	bMenuLoop = FALSE;
	bCloseReq = FALSE;
	bSync = TRUE;
	bSyncDisasm[0] = TRUE;
	bSyncDisasm[1] = TRUE;
#if XM7_VER == 1
#ifdef JSUB
	bSyncDisasm[2] = TRUE;
#endif
#ifdef Z80CARD
	bSyncDisasm[3] = TRUE;
#endif
#endif
	bMinimize = FALSE;
	bActivate = FALSE;
	bHideStatus = FALSE;
	WinPos.x = -99999;
	WinPos.y = -99999;
	wMenuID = 0;
	bContextualMenuLoop = FALSE;

	/* TuEBhE */
	SetupSubWnd(hWnd);

#ifdef SOUNDENGINE
	/* ROMEOJn by  */
	juliet_load();
	if (juliet_prepare() == 0) {
		bRomeo = TRUE;
		juliet_YMF288Reset();
	}
	else {
		bRomeo = FALSE;
	}

	/* SCCItO͈UŗƂĂ */
	bSCCI_available = FALSE;
#endif

	/* h[EChEAXe[^Xo[쐬 */
	hDrawWnd = CreateDraw(hWnd);
	hStatusBar = CreateStatus(hWnd);

	/* R|[lg */
	LoadCfg();
	InitDraw();
	InitSnd();
#ifdef SOUNDENGINE
	InitSCCI();
#endif
	InitKbd();
	InitSch();
#ifdef FDDSND
	InitFDDSnd();
#endif

	/* z}V */
	if (!system_init()) {
		nErrorCode = 1;
		PostMessage(hWnd, WM_USER, 0, 0);
		return;
	}

	/* AZbg */
	ApplyCfg();
	system_reset();

	/* R|[lgZNg */
	flag = TRUE;
#ifdef SOUNDENGINE
	LoadSCCI();
#endif
	if (!SelectDraw(hDrawWnd)) {
		flag = FALSE;
	}
	if (!SelectSnd(hWnd)) {
		flag = FALSE;
	}
	if (!SelectKbd(hWnd)) {
		flag = FALSE;
	}
	if (!SelectSch()) {
		flag = FALSE;
	}

	/* G[R[hZbgAX^[g */
	if (!flag) {
		nErrorCode = 2;
	}
	PostMessage(hWnd, WM_USER, 0, 0);
}

/*
 *	EChEN[Y
 */
static void FASTCALL OnClose(HWND hWnd)
{
	int i;

	ASSERT(hWnd);

	/* TEh~ */
	StopSnd();
#ifdef SOUNDENGINE
	if (bSCCI_available) {
		SCCI_Mute(TRUE);
	}
#endif

	/* CEChEx(^XNo[΍) */
	ShowWindow(hWnd, SW_HIDE);

	/* tOAbv */
	LockVM();
	bCloseReq = TRUE;
	UnlockVM();

	/* TuEChEɔj */
	for (i=0; i<SWND_MAXNUM; i++) {
		if (hSubWnd[i]) {
			DestroyWindow(hSubWnd[i]);
		}
	}
}

/*
 *	EChE폜
 */
static void FASTCALL OnDestroy(void)
{
	/* TEh~ */
//	StopSnd();

	/* INIt@C */
	if (nErrorCode == 0) {
		SaveCfg();
	}

	/* R|[lg N[Abv */
#ifdef MIDI
	CleanMIDI();
#endif
#ifdef FDDSND
	CleanFDDSnd();
#endif
#ifdef RSC
	CleanCommPort();
#endif
	CleanSch();
	CleanKbd();
#ifdef SOUNDENGINE
	CleanSCCI();
#endif
	CleanSnd();
	CleanDraw();
	
	/* ROMEOI by  */
#ifdef SOUNDENGINE
	if (bRomeo) {
		juliet_YMF288Reset();
		Sleep(1);
	}
	juliet_unload();
	Sleep(1);
#endif

	/* NeBJZNV폜 */
	DeleteCriticalSection(&CSection);

	/* z}V N[Abv */
	system_cleanup();
}

/*
 *	WM_QUIT
 */
void FASTCALL OnQuit(void)
{
	/* EChEnhNA */
	hMainWnd = NULL;
	hDrawWnd = NULL;
	hStatusBar = NULL;

	/* fBAj[폜 */
	DestroyMenu(hMediaMenu);
	hMediaMenu = NULL;

	/* qXgj[폜 */
	DestroyMenu(hHistoryMenu);
	hHistoryMenu = NULL;
}

/*
 *	TCYύX
 */
void FASTCALL OnSize(HWND hWnd, WORD cx, WORD cy)
{
	RECT crect;
	RECT wrect;
	RECT trect;
	RECT srect;
	int width;
	int height;
	int wheight;

	ASSERT(hWnd);
	ASSERT(hDrawWnd);

	/* ŏ̏ꍇ́AȂ */
	if ((cx == 0) && (cy == 0)) {
		return;
	}

	/* tXN[l */
	if (bFullScreen) {
		return;
	}

	/* c[o[AXe[^Xo[̗LlɓAvZ */
	if (bDoubleSize) {
		width = 1280;
		height = 800;
	}
	else {
		width = 640;
		height = 400;
	}
	memset(&trect, 0, sizeof(trect));
	if (IsWindowVisible(hStatusBar)) {
		GetWindowRect(hStatusBar, &srect);
		wheight = height + (srect.bottom - srect.top);
	}
	else {
		memset(&srect, 0, sizeof(srect));
		wheight = height;
	}

	/* NCAg̈̃TCY擾 */
	GetClientRect(hWnd, &crect);

	/* vTCYƔrA␳ */
	if ((crect.right != width) || (crect.bottom != wheight)) {
		GetWindowRect(hWnd, &wrect);
		wrect.right -= wrect.left;
		wrect.bottom -= wrect.top;
		wrect.right -= crect.right;
		wrect.bottom -= crect.bottom;
		wrect.right += width;
		wrect.bottom += wheight;
		MoveWindow(hWnd, wrect.left, wrect.top, wrect.right, wrect.bottom, TRUE);
	}

	/* CEChEzu */
	MoveWindow(hDrawWnd, 0, trect.bottom, width, height, TRUE);

	/* Xe[^Xo[zu */
	if (IsWindowVisible(hStatusBar)) {
		MoveWindow(hStatusBar, 0, trect.bottom + height, width,
					(srect.bottom - srect.top), TRUE);
		SizeStatus(width);
	}
}

/*
 *	LbN(j[ɂ͖`)
 */
static void FASTCALL OnKick(HWND hWnd)
{
	char buffer[128];

	buffer[0] = '\0';

	/* G[R[h */
	switch (nErrorCode) {
		/* G[Ȃ */
		case 0:
			/* sJn */
			stopreq_flag = FALSE;
			run_flag = TRUE;

			/* R}hC */
			OnCmdLine(GetCommandLine());

#ifdef MOUSE
			/* }EXLv`Jn */
			SetMouseCapture(TRUE);
#endif
			break;

		/* VMG[ */
		case 1:
			LoadString(hAppInstance, IDS_VMERROR, buffer, sizeof(buffer));
			MessageBox(hWnd, buffer, "XM7", MB_ICONSTOP | MB_OK);
			PostMessage(hWnd, WM_CLOSE, 0, 0);
			break;

		/* R|[lgG[ */
		case 2:
			LoadString(hAppInstance, IDS_DXERROR, buffer, sizeof(buffer));
			MessageBox(hWnd, buffer, "XM7", MB_ICONSTOP | MB_OK);
			PostMessage(hWnd, WM_CLOSE, 0, 0);
			break;
	}
}


/*
 * 	EChEvV[W
 */
static LRESULT CALLBACK WndProc(HWND hWnd, UINT message,
								 WPARAM wParam,LPARAM lParam)
{
	PAINTSTRUCT ps;
	BYTE key_code;
	RECT rect;

	/* bZ[W */
	switch (message) {
		/* EChE쐬 */
		case WM_CREATE:
			OnCreate(hWnd);
			break;

		/* EBhEN[Y */
		case WM_CLOSE:
			OnClose(hWnd);
			break;

		/* EChE폜 */
		case WM_DESTROY:
			OnDestroy();
			PostQuitMessage(0);
			return 0;

		/* EBhEړ */
		case WM_MOVE:
			if (!bFullScreen && (!(GetWindowLong(hWnd, GWL_STYLE) &
				(WS_MAXIMIZE | WS_MINIMIZE)))) {
				GetWindowRect(hWnd, &rect);
				WinPos.x = rect.left;
				WinPos.y = rect.top;
			}
			break;

		/* EChETCYύX */
		case WM_SIZE:
			/* ŏ̃L[͑΍ */
			if (wParam == SIZE_MINIMIZED) {
				bMinimize = TRUE;
			}
			else {
				bMinimize = FALSE;
			}
			OnSize(hWnd, LOWORD(lParam), HIWORD(lParam));
			break;

		/* EChEĕ` */
		case WM_PAINT:
			/* bNKv */
			LockVM();
			BeginPaint(hWnd, &ps);
			PaintStatus();
			EndPaint(hWnd, &ps);
			UnlockVM();
			return 0;

		/* [U+0:X^[g */
		case WM_USER + 0:
			OnKick(hWnd);
			return 0;

		/* [U+1:R}hC(Win9x) */
		case WM_USER + 1:
			if (!bNTflag) {
				OnCmdLine((LPSTR)wParam);
			}
			break;

#ifdef MOUSE
		/* [U+2:}EXLv`OFF */
		case WM_USER + 2:
			SetMouseCapture(FALSE);
			break;

		/* [U+3:}EXLv`ON */
		case WM_USER + 3:
			SetMouseCapture(TRUE);
			break;
#endif

		/* R}hC(WinNT) */
		case WM_COPYDATA:
			if (bNTflag) {
				if (((PCOPYDATASTRUCT)lParam)->dwData == 0x01374d58) {
					OnCmdLine((LPSTR)((PCOPYDATASTRUCT)lParam)->lpData);
				}
			}
			break;

#ifndef DINPUT8
		case WM_KEYDOWN:
			if ((LOBYTE(HIWORD(lParam)) == 0x36) && bVistaflag) {
				/* Vistaȍ~̉EVtg΍ */
				bNTkeyPushFlag[KNT_RSHIFT] = TRUE;
				return 0;
			}
			break;
#endif

		case WM_SYSKEYUP:
		case WM_KEYUP:
			if ((LOBYTE(wParam) == VK_F10) && kbd_table[DIK_F10]) {
				/* F10ׂ(^^; */
				return 0;
			}
			if ((LOBYTE(wParam) == VK_MENU) && !(lParam & 0x01000000) &&
				 kbd_table[DIK_LMENU]) {
				/* Altׂ(^^; */
				return 0;
			}
			if ((LOBYTE(wParam) == VK_MENU) && (lParam & 0x01000000) &&
				 kbd_table[DIK_RMENU]) {
				/* EAltׂ(^^; */
				return 0;
			}
#ifndef DINPUT8
			if ((LOBYTE(HIWORD(lParam)) == 0x36) && bVistaflag) {
				/* Vistaȍ~̉EVtg΍ */
				bNTkeyPushFlag[KNT_RSHIFT] = FALSE;
				return 0;
			}
#endif
			if (((LOBYTE(wParam) == VK_MENU) || (LOBYTE(wParam) == VK_F10)) && 
				 bWin8flag) {
				/* Windows 8 ΍􏈗 */
				if (bFullScreen) {
					if (!bMenuLoop) {
						EnterMenu(hWnd, TRUE);
						bMenuLoop = TRUE;
					}
					else {
						ExitMenu(TRUE);
						OnExitMenuLoop();
						bMenuLoop = FALSE;
					}
				}
			}
			break;

		/* j[[vJn */
		case WM_ENTERMENULOOP:
			if (!bMenuLoop && !bWin8flag) {
				EnterMenu(hWnd, TRUE);
			}
			bMenuLoop = TRUE;
			break;

		/* j[[vI */
		case WM_EXITMENULOOP:
			if (bContextualMenuLoop) {
				break;
			}
			keyboard_inputmask(TRUE);
			if (bMenuLoop && !bWin8flag) {
				ExitMenu(TRUE);
				OnExitMenuLoop();
			}
			keyboard_inputmask(FALSE);
			SetMenuExitTimer();
			bMenuLoop = FALSE;
			break;

		/* j[I */
		case WM_MENUSELECT:
			OnMenuSelect(wParam);
			if (!bContextualMenuLoop) {
				wMenuID = LOWORD(wParam);
			}
			break;

		/* j[`FbN */
		case WM_NCMOUSEMOVE:
		case WM_MOUSEMOVE:
			if (bFullScreen) {
				if (HIWORD(lParam) < GetSystemMetrics(SM_CYMENUSIZE)) {
					if (!bMenuLoop) {
						EnterMenu(hMainWnd, TRUE);
						bMenuLoop = TRUE;
					}
				}
				else {
					if (bMenuLoop) {
						ExitMenu(TRUE);
						OnExitMenuLoop();
						bMenuLoop = FALSE;
					}
				}
			}
			break;

		/* j[|bvAbv */
		case WM_INITMENUPOPUP:
			if (!HIWORD(lParam)) {
				OnMenuPopup(hWnd, (HMENU)wParam, (UINT)LOWORD(lParam));
				return 0;
			}
			break;

		/* j[R}h */
		case WM_COMMAND:
			EnterMenu(hWnd, FALSE);
			OnCommand(hWnd, LOWORD(wParam));
			ExitMenu(FALSE);
			return 0;

		/* ReLXgj[ */
		case WM_RBUTTONUP:
			if (bContextualMenuLoop) {
				break;
			}
			if (bMenuLoop) {
				bContextualMenuLoop = TRUE;
				OnContextualMenu(hWnd, wMenuID, LOWORD(lParam), HIWORD(lParam));
				bContextualMenuLoop = FALSE;
				return 0;
			}
			break;

		/* t@Chbv */
		case WM_DROPFILES:
			OnDropFiles((HANDLE)wParam);
			return 0;

		/* ANeBx[g */
		case WM_ACTIVATE:
			if (LOWORD(wParam) == WA_INACTIVE) {
				bActivate = FALSE;
			}
			else {
				if (!bActivate) {
					InvalidateRect(hDrawWnd, NULL, FALSE);
				}
				bActivate = TRUE;
			}

#ifdef MOUSE
			SetMouseCapture(bActivate);
#endif
			break;

		/* I[i[h[ */
		case WM_DRAWITEM:
			if (wParam == ID_STATUS_BAR) {
				OwnerDrawStatus((LPDRAWITEMSTRUCT)lParam);
				return TRUE;
			}
			break;

		/* ʃfUCύX */
		case WM_SYSCOLORCHANGE:
			ResizeStatus(hWnd, hStatusBar);
			break;

		/* e[}ύX */
		case WM_THEMECHANGED:
			if (bXPflag) {
				ChangeStatusBorder(hStatusBar);
			}
			break;

		/* ^C}[ */
		case WM_TIMER:
			if ((wParam >= 0x80) && (wParam < 0x100)) {
				/* L[J */
				key_code = (BYTE)(wParam & 0x7f);
				if (bNTkeyMakeFlag[key_code]) {
					keyboard_break(key_code);
					bNTkeyMakeFlag[key_code] = FALSE;
				}
				KillTimer(hMainWnd, wParam);
			}
			else switch (wParam) {
				case ID_STATUS_BAR :
					/* Xe[^XbZ[W */
					if (bStatusMessage) {
						EndStatusMessage();
					}
					KillTimer(hMainWnd, ID_STATUS_BAR);
					break;
			}
			break;

		/* dǗ */
		case WM_POWERBROADCAST:
			timeEndPeriod(uTimerResolution);
			timeBeginPeriod(uTimerResolution);
			break;

		/* VXeR}h */
		case WM_SYSCOMMAND:
			/* XN[Z[oEj^ߓd[h} */
			if ((wParam == SC_SCREENSAVE) || (wParam == SC_MONITORPOWER)) {
				return 1;
			}
			break;
	}

	/* ftHg EChEvV[W */
	return DefWindowProc(hWnd, message, wParam, lParam);
}

/*-[ AvP[V ]-----------------------------------------------------*/

/*
 *	XM7EChEAR}hCn
 */
static BOOL FASTCALL FindXM7Wnd(void)
{
	COPYDATASTRUCT	cds;
	HWND hWnd;
	char string[128];

	/* EChENXŌ */
	hWnd = FindWindow("XM7", NULL);
	if (!hWnd) {
		return FALSE;
	}

	/* eLXg擾 */
	GetWindowText(hWnd, string, sizeof(string));
	string[4] = '\0';
	if (strcmp("XM7 ", string) != 0) {
		return FALSE;
	}

	/* bZ[W𑗐M */
	if (bNTflag) {
		/* NTłWM_COPYDATAg */
		cds.dwData = 0x01374d58;
		cds.lpData = (void *)GetCommandLine();
		cds.cbData = lstrlen(GetCommandLine()) + 1;
		SendMessage(hWnd, WM_COPYDATA, (WPARAM)NULL, (LPARAM)&cds);
	}
	else {
		/* Win9x/Meł͏]Ɠ@ŃbZ[WM */
		SendMessage(hWnd, WM_USER + 1, (WPARAM)GetCommandLine(), (LPARAM)NULL);
	}

	return TRUE;
}

/*
 *	CX^X
 */
static HWND FASTCALL InitInstance(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	HMENU hMenu;
	WNDCLASSEX wcex;
	char szAppName[] = "XM7";
	char szWindowName[128];
	int xx, yy;
	RECT rect;

	ASSERT(hInst);

	/* EChEnhNA */
	hMainWnd = NULL;
	hDrawWnd = NULL;
	hStatusBar = NULL;

	/* EBhETCYvZ */
	rect.left = 0;
	rect.top = 0;
	if (LoadCfg_DoubleSize()) {
		rect.right = 1280;
		rect.bottom = 800;
	}
	else {
		rect.right = 640;
		rect.bottom = 400;
	}
	AdjustWindowRect(&rect, WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION |
							WS_BORDER | WS_CLIPCHILDREN | WS_MINIMIZEBOX,
							TRUE);
	xx = rect.right - rect.left;
	yy = rect.bottom - rect.top;

	/* ACR[h */
#if XM7_VER >= 3
	hAppIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_APPICON));
#elif XM7_VER >= 2
	hAppIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_AVICON));
#else
	hAppIcon = LoadIcon(hAppInstance, MAKEINTRESOURCE(IDI_APPICON));
#endif
	nAppIcon = 255;

	/* EChENX̓o^ */
	memset(&wcex, 0, sizeof(wcex));
	wcex.cbSize = sizeof(wcex);
	wcex.style = CS_VREDRAW | CS_HREDRAW;
	wcex.lpfnWndProc = WndProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra = 0;
	wcex.hInstance = hInst;
	wcex.hIcon = hAppIcon;
	wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wcex.lpszMenuName = MAKEINTRESOURCE(IDR_MAINMENU);
	wcex.lpszClassName = szAppName;
	wcex.hIconSm = hAppIcon;
	RegisterClassEx(&wcex);

	/* EBhE^Cg쐬 */
	strncpy(szWindowName, szAppName, sizeof(szWindowName));
	strncat(szWindowName, " ", sizeof(szWindowName) - strlen(szWindowName) - 1);

	/* j[쐬 */
	hMenu = LoadMenu(hAppInstance, MAKEINTRESOURCE(IDR_MAINMENU));

	/* fBAj[[h */
	hMediaMenu = LoadMenu(hAppInstance, MAKEINTRESOURCE(IDR_MEDIAMENU));

	/* qXgj[[h */
	hHistoryMenu = LoadMenu(hAppInstance, MAKEINTRESOURCE(IDR_HISTORYMENU));

	/* EChE쐬 */
	hWnd = CreateWindow(szAppName,
						szWindowName,
						WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION | WS_BORDER |
						WS_CLIPCHILDREN | WS_MINIMIZEBOX,
						CW_USEDEFAULT,
						CW_USEDEFAULT,
						xx,
						yy,
						NULL,
						hMenu,
						hInst,
						NULL);
	if (!hWnd) {
		return NULL;
	}
	
	/* EBhEʒuݒ */
	if ((WinPos.x == -99999) && (WinPos.y == -99999)) {
		GetWindowRect(hWnd, &rect);
		WinPos.x = (GetSystemMetrics(SM_CXSCREEN) - rect.right) / 2;
		WinPos.y = (GetSystemMetrics(SM_CYSCREEN) - rect.bottom) / 2;
	}
	SetWindowPos(hWnd, HWND_NOTOPMOST, WinPos.x, WinPos.y, 0, 0, SWP_NOSIZE);
	OnSize(hWnd, 640, 400);

	/* EChE\ */
	if (nErrorCode == 0) {
		ShowWindow(hWnd, nCmdShow);
		UpdateWindow(hWnd);
	}

	return hWnd;
}

/*
 *	WinMain
 */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
						LPSTR lpszCmdParam, int nCmdShow)
{
	MSG msg;
	HACCEL hAccel;
	OSVERSIONINFO osvi;
	STICKYKEYS sk;
	STICKYKEYS skb;
	char buffer[128];
	int osver;

	UNUSED(hPrevInstance);
	UNUSED(lpszCmdParam);

	/* COM */
	if (FAILED(CoInitialize(NULL))) {
		LoadString(hInstance, IDS_COINITERROR, buffer, sizeof(buffer));
		MessageBox(NULL, buffer, "XM7", MB_ICONSTOP | MB_OK);

		return -1;
	}

	/* RRg[ */
	InitCommonControls();

	/* 삵ĂOSWinNTn */
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osvi);
	osver = osvi.dwMajorVersion * 100 + osvi.dwMinorVersion;

	/* NT`FbN */
	if (osvi.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		bNTflag = TRUE;
	}
	else {
		bNTflag = FALSE;
	}

	/* XP`FbN */
	if (osver >= 501) {
		bXPflag = TRUE;
	}
	else {
		bXPflag = FALSE;
	}

	/* Windows Vista`FbN */
	if (osver >= 600) {
		bVistaflag = TRUE;
	}
	else {
		bVistaflag = FALSE;
	}

	/* Windows 7`FbN */
	if (osver >= 601) {
		bWin7flag = TRUE;
	}
	else {
		bWin7flag = FALSE;
	}

	/* Windows 8`FbN */
	if (osver >= 602) {
		bWin8flag = TRUE;
	}
	else {
		bWin8flag = FALSE;
	}

	/* Windows 10`FbN */
	if (osver >= 604) {
		bWin10flag = TRUE;
	}
	else {
		bWin10flag = FALSE;
	}

	/* XM7`FbNAR}hCn */
	if (FindXM7Wnd()) {
		/* COMI */
		CoUninitialize();

		return 0;
	}

	/* etO擾Eݒ */
	bMMXflag = CheckMMX();
	bCMOVflag = CheckCMOV();
#ifdef SOUNDENGINE
	bRomeo = FALSE;
	bSCCI_available = FALSE;
#endif
#if XM7_VER == 2 && defined(FMTV151)
	bFMTV151 = TRUE;
#endif

	/* DLL */
	InitThemeDLL();
	InitIMEDLL();

	/* tHgnh擾 */
	hFont = CreateTextFont();

	/* CX^XۑA */
	hAppInstance = hInstance;
	hMainWnd = InitInstance(hInstance, nCmdShow);
	if (!hMainWnd) {
		CleanIMEDLL();
		CleanThemeDLL();
		DeleteObject(hFont);

		/* COMI */
		CoUninitialize();

		return -1;
	}

	/* ŒL[@\̖ */
	sk.cbSize = sizeof(STICKYKEYS);
	SystemParametersInfo(SPI_GETSTICKYKEYS, sizeof(STICKYKEYS), &sk, 0);
	skb = sk;
	sk.dwFlags &= ~(SKF_HOTKEYACTIVE | SKF_AVAILABLE | SKF_STICKYKEYSON);
	SystemParametersInfo(SPI_SETSTICKYKEYS, sizeof(STICKYKEYS), &sk, 0);

	/* ANZ[^[h */
	hAccel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDR_ACCELERATOR));
	ASSERT(hAccel);

	/* bZ[W [v */
	while (hMainWnd) {
		/* bZ[W`FbNA */
		if (PeekMessage(&msg, 0, 0, 0, PM_NOREMOVE)) {
			if (!GetMessage(&msg, NULL, 0, 0)) {
				OnQuit();
				break;
			}

#ifdef MOUSE
			/* {^ɂ}EX[h؂ւ */
			if ((msg.message == WM_MBUTTONDOWN) &&
				(msg.wParam == MK_MBUTTON) &&
				(uMidBtnMode == MOSCAP_WMESSAGE)) {
				/* {^ꂽ}EX[h؂芷 */
				EnterMenu(hMainWnd, FALSE);
				OnCommand(hMainWnd, IDM_MOUSEMODE);
				ExitMenu(FALSE);
			}

			/* zC[ɂ}EX[h؂ւ(Unz) */
#ifdef WM_MOUSEWHEEL
			if ((msg.message == WM_MOUSEWHEEL) &&
				(uMidBtnMode == MOSCAP_WHEELWM)) {
				if ((short)HIWORD(msg.wParam) > 0) {
					EnterMenu(hMainWnd, FALSE);
					OnCommand(hMainWnd, IDM_MOUSEON);
					ExitMenu(FALSE);
				}
				if ((short)HIWORD(msg.wParam) < 0) {
					EnterMenu(hMainWnd, FALSE);
					OnCommand(hMainWnd, IDM_MOUSEOFF);
					ExitMenu(FALSE);
				}
			}
#endif
#endif

			/* NTL[΍􏈗 */
			if (msg.message == WM_KEYDOWN) {
				switch (LOBYTE(msg.wParam)) {
					case VKNT_CAPITAL	:	/* CapsLock */
					case VK_CAPITAL		:	bNTkeyPushFlag[KNT_CAPS] = TRUE;
											break;
					case VKNT_KANA		:
					case VKNT_KATAKANA	:	/* J^Ji/Ђ炪,Ji(PC-98) */
					case VK_KANA		:	bNTkeyPushFlag[KNT_KANA] = TRUE;
											break;
					case VKNT_KANJI1	:	/* p/Sp */
					case VKNT_KANJI2	:	bNTkeyPushFlag[KNT_KANJI] = TRUE;
											break;
				}
			}

#ifdef KBDPASTE
			if (hKeyStrokeDialog) {
				if (IsDialogMessage(hKeyStrokeDialog, &msg)) {
					continue;
				}
			}
#endif

			if (!TranslateAccelerator(hMainWnd, hAccel, &msg)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}

			continue;
		}

		/* tXN[v */
		if (bFullRequested) {
			PostMessage(hMainWnd, WM_COMMAND, IDM_FULLSCREEN, 0);
			bFullRequested = FALSE;
		}

		/* Xe[^X`恕X[v */
		if (nErrorCode == 0) {
			/* Windows Vista/7̏ꍇAŃTuEBhEXV */
			if (bVistaflag) {
				DrawSubWindow();
			}

			DrawStatus();
			if (bSync) {
				ReSizeOPNReg();
				ReSizeOPNDisp();
			}

			/* ƈx */
			Sleep(16);
		}
	}

	/* tHgnh */
	DeleteObject(hFont);

	/* DLLJ */
	CleanIMEDLL();
	CleanThemeDLL();

	/* IɃ}EXNbv */
	ClipCursor(0);

	/* ŒL[@\̕ */
	SystemParametersInfo(SPI_SETSTICKYKEYS, sizeof(STICKYKEYS), &skb,  0);

	/* COMI */
	CoUninitialize();

	/* I */
	return msg.wParam;
}

#endif	/* _WIN32 */
