/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2021 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2021 Ryu Takegami (Twitter:@RyuTakegami)
 *
 *	[ Win32API XPW[ ]
 *
 *	RHG
 *	  2001.12.25		XbhIw/mF̈S(ohD)
 *						WinNTnł̃XPW[x(ohD)
 *	  2002.05.07		_Z/ԃEBhE̍XVǉ
 *	  2002.06.06		Xbh̗D揇ʐݒSetPriorityClassgĂ
 *						C
 *	  2002.07.30		WCXeBbN,}EX̃|[OԊu`擯ɕύX
 *	  2002.08.09		tAZuEBhEPC񓯊[hłVM~͋
 *						IPCɂȂ悤ɕύX
 *	  2002.08.11		XybN}VCPUxŗƂ[hǉ
 *	  2002.11.13		XPW[Xbh̗D揇ʂABOVE NORMALɕύX
 *	  2002.12.25		}EXG~[VgpɃu[N|CgŒ~
 *						ꍇ̏P(?)
 *	  2003.01.02		S͋쓮̗D揇ʐݒP(NT only)
 *	  2003.01.13		TXyh΍􏈗ǉ
 *	  2003.02.26		e[v[h̗D揇ʐݒP(NT only)
 *	  2004.01.24		TEh̎Ԑx
 *	  2012.03.06		Windows Vista/Windows 7ɂăNeBJZNV
 *						dlςĂ̂SleepUnlockVM̏C
 */

#ifdef _WIN32

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>
#include <assert.h>
#include <process.h>
#include "xm7.h"
#include "tapelp.h"
#include "display.h"
#include "subctrl.h"
#include "device.h"
#include "mouse.h"
#include "w32.h"
#include "w32_sch.h"
#include "w32_draw.h"
#include "w32_snd.h"
#include "w32_kbd.h"
#include "w32_bar.h"
#include "w32_sub.h"
#include "w32_res.h"

#ifdef SOUNDENGINE
#include "juliet.h"
#endif

/*
 *	O[o [N
 */
DWORD dwExecTotal;						/* sg[^(us) */
DWORD dwDrawTotal;						/* `g[^ */
DWORD uTimerResolution;					/* ^C}[x */
BOOL bTapeFullSpeed;					/* e[v[htO */
BOOL bCPUFullSpeed;						/* CPUS͋쓮tO */
BOOL bVMFullSpeed;						/* VMS͋쓮tO */
BOOL bAutoSpeedAdjust;					/* xtO */
DWORD dwNowTime;						/* timeGetTime̒l */
BOOL bTapeModeType;						/* e[v[h^Cv */

/*
 *	X^eBbN [N
 */
static HANDLE hThread;					/* Xbhnh */
static UINT uThResult;					/* Xbh߂l */
static int nPriority;					/* XbhsD揇 */
static BOOL bDrawVsync;					/* VSYNCtO(`p) */
static BOOL bPollVsync;					/* VSYNCtO(|[Op) */
static DWORD dwTempTime;				/* dwTempTime(ms) */
static DWORD dwExecTime;				/* s(ms) */
static int nFrameSkip;					/* t[XLbv(ms) */
static BOOL bRunningBak;				/* stO backup */
static BOOL bFastMode;					/* stO backup */

static DWORD nSpeedCheck;				/* xpJE^(ms) */
static DWORD dwChkTime;					/* x(ms) */
static DWORD dwSleepCount;				/* X[v */


/*
 *	vg^Cv錾
 */
static UINT WINAPI ThreadSch(LPVOID);			/* Xbh֐ */

/*
 *	
 */
void FASTCALL InitSch(void)
{
	/* [NGA */
	hThread = NULL;
	uThResult = 0;
	nPriority = THREAD_PRIORITY_NORMAL;
	bDrawVsync = TRUE;
	bPollVsync = TRUE;
	bRunningBak = FALSE;
	bFastMode = FALSE;

	/* O[o[N */
	dwExecTotal = 0;
	dwDrawTotal = 0;
	dwNowTime = 0;
	bTapeFullSpeed = FALSE;
	bCPUFullSpeed = FALSE;
	bVMFullSpeed = FALSE;
	bAutoSpeedAdjust = FALSE;
	uTimerResolution = 1;
	bTapeModeType = FALSE;

	return;
}

/*
 *	N[Abv
 */
void FASTCALL CleanSch(void)
{
	DWORD dwExitCode;

	/* XbhIĂȂ΁AI点 */
	while (hThread && !uThResult) {
		bCloseReq = TRUE;
		while (TRUE) {
			GetExitCodeThread(hThread, &dwExitCode);
			if (dwExitCode == STILL_ACTIVE) {
				WaitForSingleObject(hThread, 10);
			}
			else {
				CloseHandle(hThread);
				break;
			}
		}
	}

	/* ^C}[Ԋu߂ */
	timeEndPeriod(uTimerResolution);
}

/*
 *	ZNg
 */
BOOL FASTCALL SelectSch(void)
{
	TIMECAPS	caps;

	/* ^C}[Ԋu1ms */
	timeGetDevCaps(&caps, sizeof(TIMECAPS));
	if (uTimerResolution < caps.wPeriodMin) {
		uTimerResolution = caps.wPeriodMin;
	}
	if (uTimerResolution > caps.wPeriodMax) {
		uTimerResolution = caps.wPeriodMax;
	}
	timeBeginPeriod(uTimerResolution);

	/* XbhN */
	hThread = (HANDLE)_beginthreadex(NULL, 0, ThreadSch, 0, 0, &uThResult);
	if (hThread == NULL) {
		return FALSE;
	}

	/* XbhD揇ʂݒ */
	if (bNTflag && bHighPriority) {
		nPriority = THREAD_PRIORITY_ABOVE_NORMAL;
	}
	else {
		nPriority = THREAD_PRIORITY_NORMAL;
	}
	SetThreadPriority(hThread, nPriority);

	return TRUE;
}

/*
 *	VSYNCʒm
 */
void FASTCALL vsync_notify(void)
{
	bDrawVsync = TRUE;
	bPollVsync = TRUE;
}

/*
 *	1mss
 */
void FASTCALL ExecSch(void)
{
	DWORD dwCount;
	DWORD dwExec;

	/* |[O */
	PollKbd();
	if (bPollVsync) {
		PollJoy();
#ifdef MOUSE
		PollMos();
#endif
		bPollVsync = FALSE;
	}

	/* TEh */
	ProcessSnd(FALSE);

	dwCount = 1000;
	while (dwCount > 0) {
		/* ~vオĂ΁AɃ^[ */
		if (stopreq_flag) {
			run_flag = FALSE;
			break;
		}

		/* Ŏs */
		dwExec = schedule_exec(dwCount);
		dwCount -= dwExec;
		dwSoundTotal += dwExec;
	}

	/* g[^^C */
	dwExecTotal += (1000 - dwCount);
}

/*
 *	`
 */
static void FASTCALL DrawSch(void)
{
	HDC hDC;

	/* h[EChE */
	hDC = GetDC(hDrawWnd);
	OnDraw(hDrawWnd, hDC);
	ReleaseDC(hDrawWnd, hDC);

	/* TuEChE̍XV */
	if (!bVistaflag) {
		DrawSubWindow();
	}

	/* JE^Abv */
	dwDrawTotal++;
}

/*
 *	TuEChE`
 */
void FASTCALL DrawSubWindow(void)
{
	/* TuEChE(Synĉ) */
	if (bSync) {
		RefreshBreakPoint();
		RefreshScheduler();
		RefreshCPURegister();
		if (bSyncDisasm[0] && run_flag) {
			AddrDisAsm(MAINCPU, maincpu.pc);
		}
		if (bSyncDisasm[1] && run_flag) {
			AddrDisAsm(SUBCPU, subcpu.pc);
		}
#if XM7_VER == 1
#ifdef JSUB
		if (bSyncDisasm[2] && run_flag) {
			AddrDisAsm(JSUBCPU, jsubcpu.pc);
		}
#endif
#ifdef Z80CARD
		if (bSyncDisasm[3] && run_flag) {
			AddrDisAsm(MAINZ80, (WORD)mainz80.pc);
		}
#endif
#endif
		RefreshDisAsm();
		RefreshMemory();

		RefreshFDC();
		RefreshOPNReg();
		RefreshOPNDisp();
		RefreshPaletteReg();
		RefreshSubCtrl();
		RefreshKeyboard();
		RefreshMMR();
#if XM7_VER == 1 && defined(BUBBLE)
		RefreshBMC();
#endif
#if XM7_VER >= 2
		RefreshALULine();
#endif
#if XM7_VER >= 3
		RefreshDMAC();
#endif
	}
}

/*
 *	sZbg
 *	VM̃bN͍sĂȂ̂Œ
 */
void FASTCALL ResetSch(void)
{
	nFrameSkip = 0;
	dwExecTime = timeGetTime();
}

/*
 *	xZbg
 */
void FASTCALL ResetSpeedAdjuster(void)
{
	nSpeedCheck = 0;
	dwSleepCount = 0;
	dwChkTime = timeGetTime();
}

/*
 *	Xbh֐
 */
static UINT WINAPI ThreadSch(LPVOID param)
{
	int tmp;

	UNUSED(param);

	/*  */
	ResetSch();
	ResetSpeedAdjuster();

	/* [v(N[YwΏI) */
	while (!bCloseReq) {
		/* Ȃ胍bN */
		LockVM();

		/* swω`FbN */
		if (bRunningBak != run_flag) {
			bRunningBak = run_flag;

#ifdef SOUNDENGINE
			/* YMF288~[g */
			ROMEO_Mute(!run_flag);
#endif

#ifdef MOUSE
			/* u[N|Cg~̃}EXJ[\΍(--; */
			if (hMainWnd && !run_flag && mos_capture && !bFullScreen) {
				PostMessage(hMainWnd, WM_USER + 2, 0, 0);
			}
#endif
		}

		/* swȂ΁AX[v */
		if (!run_flag) {
			/* ăX[v */
			ProcessSnd(TRUE);
			UnlockVM();
			Sleep(10);
			ResetSch();
			ResetSpeedAdjuster();
			continue;
		}

		/* Zbg̓JE^ނ */
		if (reset_flag) {
			ResetSpeedAdjuster();
#ifdef SOUNDENGINE
			if (bRomeo) {
				/* łɂ݂Zbg */
				juliet_YMF288Reset();
			}
#endif
			reset_flag = FALSE;
		}

		/* Ԃ擾(49ł̃[vl) */
		dwNowTime = timeGetTime();
		dwTempTime = dwNowTime;
		if (dwTempTime < dwExecTime) {
			dwExecTime = 0;
		}

		/* Ԃr */
		if (dwTempTime <= dwExecTime) {
			/* Ԃ]Ă邪A`ł邩 */
			if (bDrawVsync) {
				DrawSch();
				nFrameSkip = 0;
				bDrawVsync = FALSE;
			}

			/* ēxAԂ擾(49ł̃[vl) */
			dwNowTime = timeGetTime();
			dwTempTime = dwNowTime;
			if (dwTempTime < dwExecTime) {
				dwExecTime = 0;
			}
			if (dwTempTime > dwExecTime) {
				UnlockVM();
				continue;
			}

			/* Ԃɗ]T̂ŁAe[v[h */
			if ((!tape_motor || !bTapeFullSpeed) || !bTapeModeType) {
				dwSleepCount ++;
				if (!bVMFullSpeed) {
					if (bCPUFullSpeed ||
						(tape_motor && bTapeFullSpeed && !bTapeModeType)) {
						UnlockVM();

						/* Ƃ肠̃vZXɐڂ */
						if (bNTflag) {
							Sleep(0);
						}

						while (!stopreq_flag) {
							if (dwTempTime != timeGetTime()) {
								break;
							}

#if XM7_VER == 1
							if (lowspeed_mode) {
								schedule_fullspeed();
							}
							else
#endif
							/* e[v[h̓ĈݑS͋쓮 */
							if (tape_motor && bTapeFullSpeed &&
								!bCPUFullSpeed) {
								schedule_main_fullspeed();
							}
							else {
								schedule_fullspeed();
							}
						}
						continue;
					}
					else {
						UnlockVM();
						Sleep(1);
						continue;
					}
				}
			}

			/* S͋쓮[h/e[v[h */
			dwExecTime = dwTempTime - 1;
			if (dwExecTime > dwTempTime) {
				dwExecTime++;
			}
		}

		/* s */
		ExecSch();
		nFrameSkip++;
		nSpeedCheck++;
		dwExecTime++;

		/* x */
		if (nSpeedCheck >= 200) {
			if (bAutoSpeedAdjust) {
				/* Ԃ擾(49ł̃[vl) */
				dwTempTime = timeGetTime();
				if (dwTempTime < dwChkTime) {
					dwChkTime = 0;
				}

				/* xԊu+X[vԂƎۂ̎sԂ̔䗦߂ */
				speed_ratio = (nSpeedCheck + dwSleepCount) * speed_ratio;
				speed_ratio /= (dwTempTime - dwChkTime);

				/* CPUx䗦100%5%̊Ԃɐ */
				if (speed_ratio > 10000) {
					speed_ratio = 10000;
				}
				else if (speed_ratio < 500) {
					speed_ratio = 500;
				}
			}
			else {
				/* x100%Œ */
				speed_ratio = 10000;
			}

			/* JE^ނ */
			ResetSpeedAdjuster();
		}

		/* I΍ŁAŔ */
		if (bCloseReq) {
			UnlockVM();
			break;
		}

		/* Break΍ */
		if (!run_flag) {
			DrawSch();
			bDrawVsync = FALSE;
			nFrameSkip = 0;
			UnlockVM();
			continue;
		}

		/* XLbvJE^KlȉȂAĎs */
		if (bAutoSpeedAdjust) {
			tmp = (10000 - speed_ratio) / 10;

			/* 2fps`15fps/30fps̊Ԃɐ */
#if XM7_VER >= 2
#if XM7_VER >= 3
			if (screen_mode & SCR_ANALOG) {
#else
			if (mode320) {
#endif
				/* 4096F/26F[hł͍ō15fps */
				if (tmp < 66) {
					tmp = 66;
				}
			}
			else {
				/* 8F[hł͍ō30fps */
				if (tmp < 33) {
					tmp = 33;
				}
			}
#else
			if (tmp < 33) {
				tmp = 33;
			}
#endif
			if (tmp > 500) {
				tmp = 500;
			}
		}
		else {
			tmp = 500;
		}

		if (nFrameSkip >= tmp) {
			/* `悪Ă̂ŁAň` */
			DrawSch();
			ResetSch();
			bDrawVsync = FALSE;
		}
		UnlockVM();
	}

	/* I𖾎邽߁AvtO~낷 */
	bCloseReq = FALSE;

	/* XbhI */
	_endthreadex(TRUE);

	return TRUE;
}

#endif	/* _WIN32 */
