var searchjson = 
[
{
	"uri": "/apireference/changelog.html",
	"title": "Changelog",
	"tags": [],
	"description": "",
	"content": " Changes between 0.9.3 and 0.9.4 New features  New functions:\n getLogWindowLog getRomInfo getScriptDataFolder isKeyPressed clearSavestateData getSavestateData\n loadSavestateAsync saveSavestateAsync   New event callbacks: inputPolled, stateLoaded, stateSaved\n New memory types: cpuDebug, ppuDebug\n  Breaking changes  Removed the debugRead, debugReadWord, debugWrite and debugWriteWord functions. They have been replaced by the memType.cpuDebug and memType.ppuDebug enum values. The behavior of the setInput function has changed. The return values for the APU portion of the getState function has slightly changed.  "
},
{
	"uri": "/gettingstarted.html",
	"title": "Getting Started",
	"tags": [],
	"description": "",
	"content": " System Requirements Windows  Windows Vista, 7, 8, 8.1 and 10 are supported DirectX 11 .NET Framework 4.5+  Linux  glibc 2.24+ Mono 4.2.1+ SDL 2  Installation  Configuration Wizard  There is no actual installer for Mesen \u0026ndash; run the Mesen.exe application and a first-run configuration wizard will be shown.\nData Storage Location: This section of the wizard allows you to select where you prefer to keep Mesen\u0026rsquo;s files.\nInput Mappings: Select which input types you want to use to play games. There are built-in presets for:\n Xbox controllers PS4 controllers WASD keyboard layout Arrow keyboard layout  You can select multiple presets at once, but only a single keyboard layout.\nCreate a shortcut on my desktop: Check this option if you want to add a Mesen shortcut to your desktop.\nUsing Mesen  Game Menu  Mesen\u0026rsquo;s default configuration should work out of the box and allow you to get right into playing games.\nTo load a game, use the File\u0026rarr;Open command and select any supported file (.nes, .fds, .nsf, .nsfe, .unf) you want to load.\nOnce a game is loaded, you can pause, reset or stop the game via the Game menu.\nThe game menu also contains additional options for Famicom Disk System (FDS) games and VS System games.\nFamicom Disk System (FDS) games  FDS Game Menu  FDS games require a BIOS file. When you load a FDS game for the first time, Mesen will ask you for the BIOS file \u0026ndash; without one, running FDS games is not possible.\n FDS games were originally stored on floppy disks - sometimes split across multiple disks and disk sides. The Game menu contains a number of additional shortcuts for FDS games to handle these:\n Switch Disk Side: Switches between sides A and B of the current disk. Select Disk: Allows you to select any disk and side combination availble for the current game. Eject Disk: Ejects the current disk. Ejecting the disk is usually unnecessary and only available for the sake of completeness.   VS System games  VS System Game Menu  VS System games were originally in the form of arcade cabinets \u0026ndash; unlike FDS games, playing them does not require any special BIOS.\nBeing arcade cabinets, VS System games typically require the player to insert coins before the game can be played. Additionally, the arcade cabinets could often be configured via a number of physical DIP switches \u0026ndash; for example, to select how much money needs to be inserted to play, or to alter a game\u0026rsquo;s difficulty. The Game menu offers additional options when playing VS System games to handle these:\n Game Configuration: Displays a configuration dialog containing the DIP switch options available for this game. Insert Coin 1: Inserts a coin into the first coin slot. Insert Coin 2: Inserts a coin into the second coin slot.   NSF Player  Mesen's NSF Player  NSF and NSFe files are used to store music from NES and Famicom games.\nWhen loading NSF files into Mesen, the UI will change into a media player style UI. From this UI, you can control the volume, select the track, pause the music or fast forward by holding down the mouse button.\nAdditionally, the two icons at the top right allow you to toggle the repeat and shuffle playback modes.\n Game Selection Screen  Game Selection Screen  The game selection screen is shown when no games are currently loaded \u0026ndash; it will display the last 5 games you\u0026rsquo;ve played, along with a screenshot of the game at the point where you left off playing.\nYou can use this screen via the key bindings for player 1 - e.g press Left or Right on Player 1\u0026rsquo;s d-pad to change game, and the A button to start the game. You can also navigate the screen with your mouse \u0026ndash; use the arrows on each side of the screen to change game, and click on the game\u0026rsquo;s screenshot to start playing.\n Shortcut Keys Mesen has a number of shortcut keys that you may find useful:\n Ctrl-O: Open a file Ctrl-R: Reset the game Escape: Pause/resume the game F1 to F8: Load save state in the corresponding slot. Shift-F1 to Shift-F7: Save a save state in the corresponding slot. Ctrl-S: Manually save a save state to a file. Ctrl-L: Manually load a save state from a file. Alt-1 to Alt-6: Change the video scale.  Additionally, there are a large number of customizable shortcut keys in the preferences.\n Command-line Options  Command-line Options  Mesen supports a large number of command-line options.\nTo see a full list and some examples, click on the Help\u0026rarr;Command-line Options menu option.\n"
},
{
	"uri": "/",
	"title": "Home",
	"tags": [],
	"description": "",
	"content": " Mesen - NES/Famicom Emulator Table of contents  Getting Started Configuration  Audio Options Input Options Video Options Emulation Options Preferences  Tools  Netplay Movies Cheats Sound Recorder Video Recorder Log Window  Debugging Tools  Debugger PPU Viewer Memory Tools Trace Logger Assembler Script Window Integration with CC65/ASM6  HD Packs Lua API reference  "
},
{
	"uri": "/configuration/audio.html",
	"title": "Audio Options",
	"tags": [],
	"description": "",
	"content": " General Options  General Options  Audio Device: Selects which device is used for audio output (e.g computer speakers, or a headset)\nSample Rate: Selects the sample rate for the audio output \u0026ndash; typically, computers output at 44,100Hz or 48,000Hz, so they usually offer the best sound quality.\nLatency: This represents the length of the buffer used in audio processing. A smaller value results in less delay between the audio and video, however, depending on the hardware used, a value that is too small may cause sound problems.\nIn addition, the volume and panning of each sound channel can be adjusted. For more control over the actual sound, the equalizer can be used to alter the relative strength of specific frequencies \u0026ndash; with work, this can be used to make the audio sound more like an actual NES would.\nA number of audio effects are available in the Effects tab \u0026ndash; the Stereo Delay effect, in particular, produces a relatively nice fake stereo effect.\n Advanced Options  Advanced Options  Unlike all the other options before it, the options in this section affect the way the sound is emulated.\n Mute ultrasonic frequencies on the triangle channel: This option mutes the triangle channel under certain conditions, which prevents it from causing popping sounds.\n Reduce popping sounds on the DMC channel: Similar to the previous option, but for the DMC channel \u0026ndash; this option prevents games from changing the output of the DMC channel too abruptly, which often causes popping sounds.\n Swap square channel duty cycles: This option is to mimic some older NES clones that had incorrect sound output for both of the square channels. It greatly alters the sound in some games, and shouldn\u0026rsquo;t be enabled unless you want this behavior.\n Disable noise channel mode flag: Very early Famicom models did not implement this feature, so this option is available to mimic early Famicom consoles. It changes the sound output of the noise channel in some games, and shouldn\u0026rsquo;t be enabled unless you want this behavior.\n  "
},
{
	"uri": "/configuration.html",
	"title": "Configuration",
	"tags": [],
	"description": "",
	"content": " Options Menu  Options Menu  The options menu contains a number of shortcuts to change some popular settings:\nSpeed: Selects the emulation\u0026rsquo;s current speed. Also see the Rewind and Fast Forward shortcut keys.\nVideo Size: Selects the picture\u0026rsquo;s size \u0026ndash; when fullscreen is selected, the picture will automatically fill the screen. Additionally, you can also manually resize the window to select any size you prefer.\nVideo Filter: Selects a filter to apply to the picture. The NTSC filters attempt to reproduce the feeling of old CRT screens, while the other filters are a variety of different techniques used to scale up pixel art. Additional NTSC filter specific settings are available in the video options.\nRegion: When set to Auto, the emulator will try to detect the game\u0026rsquo;s region (NTSC or PAL) - however, this is not always possible. When there is nothing to suggest a game is for the PAL region (Australia \u0026amp; Europe), the NTSC region (North America \u0026amp; Japan) will be used by default. Dendy is used to mimic a number of different NES clones, in particular, the Dendy, which was a popular clone in Russia.\nConfiguration Dialogs Additional settings can be found in each of the available menu options:\n Audio Options Input Options Video Options Emulation Options Preferences  "
},
{
	"uri": "/tools.html",
	"title": "Tools",
	"tags": [],
	"description": "",
	"content": "  Tools Menu  Netplay Hosting a game  Server Configuration  Server name: This name will be shown to clients when they connect.\nPort: The port used for the communication. Mesen will attempt to automatically port-forward this port on your router when you start the server \u0026ndash; if this fails, you will have to manually forward the port on your router to allow people outside of your LAN to connect to your server.\nThe other options on this screen have not been implemented yet and are disabled for now.\n Connecting to a server  Connect to...  Host: The host name of the server you want to connect to. This is usually an IP address but can also be a domain name.\nPort: The port to connect to \u0026ndash; this must match the Port value used by the server\u0026rsquo;s host.\nJoin as a spectator: When enabled, you will join the server without taking control of a specific controller. An unlimited number of spectators can join a game, but only 4 people can take control of a controller.\nOnce you are connected to a server, you can select your controller via the Tools\u0026rarr;Netplay\u0026rarr;Select Controller menu.\nMovies  Movie Recording Options  Movies are files that can be created by Mesen and played back within Mesen itself. They are essentially a recording of the events that occurred during recording. To record an actual video file, see Video Recorder.\nWhen you start recording, a configuration dialog is shown that allows you to select a number of options.\n Save to: The location where the movie will be saved. Press the Browse button to change it. Record from: Selects where the recording should start:  Power on: This will reset the game and start recording from the start. Your save data (.sav files) will be excluded from the movie file - after the reset, you will start the game as if it had never been run yet. Power on, with save data: This will reset the game and start recording from the start. Your save data (.sav files, etc.) will be included in the movie file. Current state: This will start recording from the current state \u0026ndash; in this case, the movie file will contain a save state.  Author: The movie\u0026rsquo;s author (optional) - this will be saved in the movie file. Description: A description of the movie\u0026rsquo;s content (optional) - this will be saved in the movie file.  To play a movie file, select it via the Tools\u0026rarr;Movies\u0026rarr;Play command.\nCheats  Cheats Window  Mesen supports cheats in a number of different formats, including Game Genie and Pro Action Rocky codes.\nIt is also possible to import cheats from the built-in Cheat Database or from XML or CHT files.\nSelect a game on the left to see all the cheats currently available for that game.\nTo add a new cheat code, click the Add Cheat button.\nTo edit a cheat code, double-click on it in the list.\nTo delete a cheat code, select it from the list and click the Delete button.\nTo import cheats, click the Import button.\nTo export cheats to an XML file, click the Export button.\nTo disable a specific cheat, uncheck it from the list.\nTo disable all cheats, check the Disable all cheats option.\n Adding/Editing Cheats  Edit Cheat  When adding a cheat, you must first select the game to which it should be applied. By default, the game that is currently loaded will be selected.\nYou must give each cheat a name, which will be used to display it in the cheats list.\nThe Code section lets you enter the actual cheat \u0026ndash; select Game Genie for Game Genie codes.\nIf you want to create a custom code, select the Custom action.\nWhen creating custom codes, the Memory / Game Code options select whether the code should be applied to a specific CPU address (Memory) or a specific offset in the PRG ROM (Game Code).\n Importing Cheats From the Cheat Database  Import cheats from the built-in cheat database  To import from the cheats database, click Import and select From Cheat Database.\nIn the next dialog, select the game for which you want to import cheats. You can type in the Search bar at the top to filter the game list. Once you\u0026rsquo;ve selected a game, press OK \u0026ndash; this will import all cheats for that game into the cheats list. You can then manually enable any cheat you want to use.\nBy default, the game that is currently loaded will be selected for you. Having no game selected when the dialog opens indicates that there are no built-in cheats available for the game that is currently running.\nFrom XML/CHT files To import cheats from external files (FCEUX\u0026rsquo;s .cht files or Nestopia\u0026rsquo;s .xml files), click Import, and select From File (XML, CHT).\nIn the next dialog, select the file you want to import.\nFor FCEUX\u0026rsquo;s .cht files, you will also need to select the game for which you are importing cheats for.\nOnce you\u0026rsquo;re done, click OK \u0026ndash; the cheats will be imported and added to the cheats list.\nSound Recorder The sound recorder allows you to record uncompressed .wav files. The .wav file will use the exact same output settings as Mesen\u0026rsquo;s audio options \u0026ndash; this means the sample rate will match Mesen\u0026rsquo;s current sample rate, and that any sound modification (volume, panning, equalizer or effects) will also be applied to the .wav files.\nTo start recording, use the Tools\u0026rarr;Sound Recorder\u0026rarr;Record command.\nTo stop an on-going recording, use the Tools\u0026rarr;Sound Recorder\u0026rarr;Stop Recording command.\nVideo Recorder  Video Recorder  Much like the sound recorder, the video recorder allows you to record .avi files.\nBefore you start a recording, you can select where to save the .avi file and which video codec to use. All video codecs are lossless codecs \u0026ndash; the only reason to reduce the compression level to a lower level is to improve performance in the event your computer is having a hard time recording the video and running the emulation at its normal speed at the same time.\nTo start recording, use the Tools\u0026rarr;Video Recorder\u0026rarr;Record command.\nTo stop an on-going recording, use the Tools\u0026rarr;Video Recorder\u0026rarr;Stop Recording command.\nLog Window  Log Window  The Log Window displays a number of useful information \u0026ndash; mostly about the roms you load.\nIt is also sometimes used as a way to log errors or warnings.\nDebugger See Debugging Tools\nHD Pack Builder See HD Packs\n"
},
{
	"uri": "/apireference/callbacks.html",
	"title": "Callbacks",
	"tags": [],
	"description": "",
	"content": " addEventCallback Syntax\nemu.addEventCallback(function, type)  Parameters\nfunction - A Lua function.\ntype - Enum See eventType.\nReturn value\nReturns an integer value that can be used to remove the callback by calling removeEventCallback.\nDescription\nRegisters a callback function to be called whenever the specified event occurs.\nThe callback function receives no parameters.\nremoveEventCallback Syntax\nemu.removeEventCallback(reference, type)  Parameters\nreference - The value returned by the call to addEventCallback.\ntype - Enum See eventType.\nReturn value\nNone\nDescription\nRemoves a previously registered callback function.\naddMemoryCallback Syntax\nemu.addMemoryCallback(function, type, startAddress, endAddress)  Parameters\nfunction - A Lua function.\ntype - Enum See memCallbackType\nstartAddress - Integer Start of the CPU memory address range to register the callback on.\nendAddress - Integer End of the CPU memory address range to register the callback on.\nReturn value\nReturns an integer value that can be used to remove the callback by calling removeMemoryCallback.\nDescription\nRegisters a callback function to be called whenever the specified event occurs.\nThe callback function receives 2 parameters address and value that correspond to the address being written to or read from, and the value that is being read/written.\nFor reads, the callback is called after the read is performed.\nFor writes, the callback is called before the write is performed.\nIf the callback returns an integer value, it will replace the value \u0026ndash; you can alter the results of read/write operation using this. e.g:\nfunction writeCallback(address, value) --This sets bit 0 to 0 for all CHR RAM writes return value \u0026amp; 0xFE end emu.addMemoryCallback(writeCallback, emu.memCallbackType.ppuWrite, 0, 0x1FFF)  removeMemoryCallback Syntax\nemu.removeMemoryCallback(reference, type, startAddress, endAddress)  Parameters\nreference - The value returned by the call to addMemoryCallback.\ntype - Enum See memCallbackType.\nstartAddress - Integer Start of the CPU memory address range to unregister the callback from.\nendAddress - Integer End of the CPU memory address range to unregister the callback from.\nReturn value\nNone\nDescription\nRemoves a previously registered callback function.\n"
},
{
	"uri": "/debugging.html",
	"title": "Debugging Tools",
	"tags": [],
	"description": "",
	"content": "The debugging capabilities of Mesen are split across a number of different tools, including the debugger itself:\nAssembler: Allows you to edit a game\u0026rsquo;s code or run custom code on-the-fly.\nDebugger: View the code, add breakpoints, labels, watch values, and much more.\nMemory Tools: Contains a hex editor and performance profiler.\nPPU Viewer: Displays information on the nametables, sprites, CHR banks and palette. Contains a CHR graphic editor and a palette editor.\nScript Window: Allows the execution of Lua scripts, which can communicate with the emulation via an API.\nTrace Logger: View or log to a file the execution trace of the CPU and PPU.\nAdditionally, some other smaller features are available from the main debugger window. e.g:\n Import labels from CA65/CC65 or ASM6\n Save any modification done to PRG/CHR ROM via the CHR Viewer, Assembler or the Memory Viewer as a new .nes file, or as an .ips patch file Edit a rom\u0026rsquo;s iNES header  "
},
{
	"uri": "/hdpacks.html",
	"title": "HD Packs",
	"tags": [],
	"description": "",
	"content": " HD Packs make it possible to replace a game\u0026rsquo;s graphics and audio with high definition alternatives. This can be used in many ways, for example, one could keep the game\u0026rsquo;s original resolution and simply improve its graphics by adding more colors and shading.\nUsing HD packs To use HD packs, first make sure to turn on the Enable HDNes HD Packs option.\nTo install a HD Pack, you should extract it in a subfolder inside the HdPacks folder in Mesen\u0026rsquo;s data folder. You can open this folder by clicking on the Open Mesen Folder button in the Preferences window. The subfolder should have the same name as the rom file itself.\nFor HD packs created with Mesen\u0026rsquo;s HD Pack Builder, you can also put them in .zip format in the HdPacks folder, without unzipping them nor worrying about renaming the file.\nUsing the HD Pack Builder  HD Pack Builder  The HD Pack Builder can be used to record a game\u0026rsquo;s graphics into PNG image files and build a matching hires.txt file. These are the 2 basic elements needed for HD Packs: a tile map (the PNG files) and a definition file that specifies where each tile is on the tile map (the hires.txt file).\nThe basic concept of this tool is to use it to record gameplay of a game from start to finish, attempting to trigger every possible animation or graphics during gameplay. This will create a complete set of tiles (saved in PNG files) and a single hires.txt file that contains all that is needed to replace the tiles with HD tiles. Once this is done, the only thing left to do, in most cases, is to replace the graphics in the PNG files with better alternatives (e.g higher resolution, more colors, etc.).\nA number of options exist to control the way the PNG files are generated:\nScale/Filter: Selects the scale and video filter to use when generating the PNG files for the HD Pack. Use the \u0026ldquo;Prescale\u0026rdquo; filters to generate the tiles at a larger scale without applying any transformation to the pixels.\nCHR Bank Size: This option is only available for CHR RAM games. CHR RAM games have no fixed \u0026ldquo;banks\u0026rdquo; - they are dynamically created by the game\u0026rsquo;s code. This option alters the HD Pack Builder\u0026rsquo;s behavior when grouping the tiles into the PNG files - a smaller bank size will usually result in less PNG files (but depending on the game\u0026rsquo;s code, larger values may produce better results).\nGroup blank tiles: This option groups all the blank tiles sequentially into the same PNG files - this helps reduce the number of PNG files produced by removing almost-empty PNG files containing only blank tiles.\nSort pages by usage frequency: When this option is enabled, the tiles in PNG files are sorted by the frequency at which they are shown on the screen while recording (more common palettes will be grouped together in the first PNG for a specific bank number. If this option is unchecked, the PNGs will be sorted by palette - each PNG will only contain up to 4 different colors in this case.\nUse 8x16 sprite display mode: When enabled, this option will alter the display order of CHR banks that contain only sprites to make the sprites easier to edit in the PNG file.\nIgnore tiles at the edges of the screen (overscan): When enabled, this will make the builder ignore any pixels in the overscan area. This is useful in games that contain glitches on the outer edge of the screen. Incorrect palette combinations due to these glitches will be ignored and won\u0026rsquo;t be shown in the PNG files.\nBefore you start recording, select the options you want to use and the location to which you want to save the HD Pack, then press the Start Recording button.\nFile Format (hires.txt) The following are the specifications for the hires.txt file, as of version \u0026ldquo;100\u0026rdquo;.\n\u0026lt;ver\u0026gt; tag Syntax: \u0026lt;ver\u0026gt;[integer]\nExample: \u0026lt;ver\u0026gt;100\nThe format\u0026rsquo;s version number \u0026ndash; this is currently 100 for Mesen.\n\u0026lt;scale\u0026gt; tag Syntax: \u0026lt;scale\u0026gt;[integer]\nExample: \u0026lt;scale\u0026gt;4\nThe scale used for the replacement graphics \u0026ndash; this can be any integer number (minimum: 1). Anything above 8-10x will probably have a very hard time running on any computer. It is suggested to use scales between 1x and 4x.\n\u0026lt;overscan\u0026gt; tag Syntax: \u0026lt;overscan\u0026gt;[top],[right],[bottom],[left]\nExample: \u0026lt;overscan\u0026gt;8,8,8,8\nThe overscan values to use when the HD Pack is loaded - this is useful for games that produce glitches on the edges of the screen.\n\u0026lt;patch\u0026gt; tag Syntax: \u0026lt;patch\u0026gt;[filename],[sha1 hash]\nExample: \u0026lt;patch\u0026gt;MyPatch.ips,26aec27ef0fc1a6fd282937b918ebdd1fb480891\nSpecifies a patch file to apply if the loaded ROM matches the specified SHA1 hash.\nThe patches can be in either .ips or .bps format. Multiple \u0026lt;patch\u0026gt; tags with different SHA1 hashes can be present in the same hires.txt file.\n\u0026lt;img\u0026gt; tag Syntax: \u0026lt;img\u0026gt;[filename]\nExample: \u0026lt;img\u0026gt;Tileset01.png\nSpecifies a PNG file that contains tile graphics \u0026ndash; each \u0026lt;img\u0026gt; tag is indexed (starting from 0) according to the order it appears in the hires.txt file, the tag\u0026rsquo;s index must be used when using \u0026lt;tile\u0026gt; tags.\n\u0026lt;condition\u0026gt; tag Syntax: \u0026lt;condition\u0026gt;[name - text], [conditionType - text], [x value - integer], [y value - integer], [tile data], [palette data - hex]\nExample (CHR ROM): \u0026lt;condition\u0026gt;myCondition,tileNearby,8,0,10,0F100017\nExample (CHR RAM): \u0026lt;condition\u0026gt;myCondition,tileNearby,8,0,D2C2C2C7CF2FFEFC2C3C3C3830D00000,0F100017\nFor CHR ROM games, tile data is an integer representing the position of the original tile in CHR ROM.\nFor CHR RAM games, tile data is a 32-character hexadecimal string representing all 16 bytes of the tile.\npalette data is always an 8-character hexadecimal string representing all 4 bytes of the palette used for the tile. For sprites, the first byte is always \u0026ldquo;FF\u0026rdquo;.\nconditionType can be any of: tileAtPosition, tileNearby, spriteAtPosition and spriteNearby.\ntileAtPosition and spriteAtPosition use the X/Y parameters as screen coordinates. e.g:\n\u0026lt;condition\u0026gt;myCondition,tileAtPosition,10,10,[tile data],[palette data]\nIn this case, myCondition will be true if the tile at position 10,10 on the NES\u0026rsquo; screen (256x240 resolution) matches the tile+palette data given.\ntileNearby and spriteNearby use positive or negative X/Y offsets to the current position. e.g:\n\u0026lt;condition\u0026gt;myCondition2,tileNearby,-8,0,[tile data],[palette data]\nIn this case, myCondition2 will be true if the tile 8 pixels to the left of the current tile matches the tile+palette data specified.\n\u0026lt;tile\u0026gt; tag Syntax: \u0026lt;tile\u0026gt;[img index - integer], [tile data], [palette data], [x - integer], [y - integer], [brightness - 0.0 to 1.0], [default tile - Y or N]\nExample (CHR ROM): \u0026lt;tile\u0026gt;0,20,FF16360F,0,0,1,N\nExample (CHR RAM): \u0026lt;tile\u0026gt;0,0E0E079C1E3EA7076101586121010000,0F100017,176,1168,1,N\nFor CHR ROM games, tile data is an integer representing the position of the original tile in CHR ROM.\nFor CHR RAM games, tile data is a 32-character hexadecimal string representing all 16 bytes of the tile.\npalette data is always an 8-character hexadecimal string representing all 4 bytes of the palette used for the tile. For sprites, the first byte is always \u0026ldquo;FF\u0026rdquo;.\n\u0026lt;tile\u0026gt; define mappings between the original game\u0026rsquo;s tile data and their replacements in the PNG file. The tile data and palette data are used to identify the original tile, while the img index, x and y fields are used to specify in which PNG file the replacement can be found, and at what x,y coordinates in that PNG file.\nbrightness can be used to reuse the same HD tile for multiple original tiles \u0026ndash; this can be useful when a game has fade in and out effects.\nWhen default tile is enabled (with Y), the tile is marked as the default tile for all palettes. Whenever a tile appears on the screen that matches the tile data, but has no rules matching its palette data, the default tile will be used instead.\n\u0026lt;background\u0026gt; tag Syntax: \u0026lt;background\u0026gt;[name - text], [brightness level - 0.0 to 1.0]\nExample: \u0026lt;background\u0026gt;myBackground.png,1.0\n\u0026lt;background\u0026gt; tags meant to be used alongside conditions to add a background image under certain conditions (e.g on a specific screen, for example).\n\u0026lt;options\u0026gt; tag Syntax: \u0026lt;options\u0026gt;[option1 - text], [...]\nExample: \u0026lt;options\u0026gt;disableSpriteLimit\nCurrently, the only flag available is disableSpriteLimit which forces the emulator to disable the sprite limit when the HD pack is loaded.\n\u0026lt;bgm\u0026gt; tag Syntax: \u0026lt;bgm\u0026gt;[album - integer],[track - integer],[filename - ogg]\nExample: \u0026lt;bgm\u0026gt;0,0,myBgm.ogg\nUsed to assign a background music track (.ogg audio file) to a specific album and track number. Album and track numbers are used to form a unique ID for each bgm, allowing up to 64k different bgm tracks.\n\u0026lt;sfx\u0026gt; tag Syntax: \u0026lt;sfc\u0026gt;[album - integer],[track - integer],[filename - ogg]\nExample: \u0026lt;sfc\u0026gt;0,0,myBgm.ogg\nUsed to assign a sound effect (.ogg audio file) to a specific album and track number. Album and track numbers are used to form a unique ID for each sound effect, allowing up to 64k different sound effects.\nUsing conditions To use conditions, add the condition\u0026rsquo;s name at the start of the line. e.g:\n[myConditionName]\u0026lt;tile\u0026gt;...\nConditions can only be applied to \u0026lt;tile\u0026gt; or \u0026lt;background\u0026gt; tags. When a condition is applied to a \u0026lt;tile\u0026gt; or \u0026lt;background\u0026gt; tag, that rule will only be used if the condition is met.\nThe first matching rule (in the order they are written in the hires.txt file) will be used. So conditional tiles MUST be placed before tiles with no conditions (for the same tile data+palette data) to have any effect.\nYou can also make it so multiple conditions must be met for a rule to be used by joining each condition name with a \u0026amp;:\n[cond1\u0026amp;cond2]\u0026lt;tile\u0026gt;...\nReplacing audio in games Audio replacement in HD packs in Mesen works in a similar fashion to the MSU-1 for the SNES. It adds a number of read/write registers in memory and they can be used to play OGG files specified via \u0026lt;bgm\u0026gt; and \u0026lt;sfx\u0026gt; tags.\nTO BE COMPLETED.\n$4100/$3002: Playback Options $4101/$3012: Playback Control $4102/$3022: BGM Volume $4103/$3032: SFX Volume $4104/$3042: Album Number $4105/$3052: Play BGM Track $4106/$3062: Play SFX Track "
},
{
	"uri": "/configuration/input.html",
	"title": "Input Options",
	"tags": [],
	"description": "",
	"content": " General Options  Controller Options  Console Type: Selects which console to emulate for all input ports. The NES and Famicom have different accessories and some of the identical accessories (e.g the Zapper) have different behavior on a hardware level. If you want to connect Famicom-only accessories that plug into the Famicom\u0026rsquo;s expansion port, select Famicom.\nAutomatically configure controllers when loading a game: When enabled, when loading any game recognized by Mesen\u0026rsquo;s internal game database, the appropriate controllers will automatically be setup. For example, loading up a game like Duck Hunt will connect a Zapper to the second port.\nSetting up controllers NES For each player, select the device you want to use. To connect more than 2 controllers, check the Use Four Score accessory option.\nTo setup the key mappings for a controller (or other device-specific options), click the Setup button on the right of the player you want to configure.\nFamicom On older Famicoms, the player 1 \u0026amp; 2 controllers are hard-wired and cannot be disconnected \u0026ndash; Mesen does the same. To connect additional controllers, select the Four Player Adapter expansion device.\nTo setup the key mappings for a controller (or other device-specific options), click the Setup button on the right of the player you want to configure.\nConfiguring Key Bindings  Controller Setup  Each player can have up to four tabs of key bindings \u0026ndash; this allows you to control the same player with different input devices. For example, you can setup player 1 to be controlled by your keyboard and your Xbox controller at the same time.\nTo select a binding for a button, click on the corresponding button in the UI and then press the key or gamepad button you want to use for this button.\nTo clear a binding, click on it and then close the popup window by clicking on the X button.\nTo clear all bindings for this tab, click on the Clear Key Bindings.\nTo simplify configuration, a number of presets are available \u0026ndash; click on the Select Preset button to choose one.\nYou can also configure that controller\u0026rsquo;s turbo buttons\u0026rsquo; speed with the Turbo Speed slider. Note: setting the turbo speed to the fastest setting may cause some games to not detect the button presses at all.\nAdvanced Options  Advanced Options  Display Controller Input Use these options to display the controller input on the screen.\nThis will be recorded by the Video Recorder - so make sure you turn it off if you do not want it to appear on the video.\n "
},
{
	"uri": "/configuration/video.html",
	"title": "Video Options",
	"tags": [],
	"description": "",
	"content": " General Options  General Options  Scale: The scale determines the emulator window\u0026rsquo;s size - use integer factors (e.g: 2x, 3x, 4x) for best results.\nAspect Ratio: The NES\u0026rsquo; internal aspect ratio is almost square (Default (No Stretching)), but it used to be displayed on CRT TVs that had a rectangular picture. To simulate a CRT TV, you can use the Auto option - it will switch between NTSC and PAL aspect ratios depending on the game you are playing. Using anything other than the Default (No Stretching) option may cause pixels to have irregular sizes. You can reduce this effect by using a combination of video filters and the bilinear filtering option.\nEnable integer FPS mode: Under normal conditions, the NTSC NES runs at 60.1 fps. When playing a 60hz LCD, this causes a lot of dropped frames. This option slows down the emulation by a tiny amount to produce 60 frames per second instead, which reduces the number of dropped frames.\nEnable vertical sync: Turns on vertical sync \u0026ndash; can help prevent screen tearing on some hardware configurations.\nUse exclusive fullscreen mode: Turns on exclusive fullscreen mode. This may be useful if you are experiencing screen tearing issues in regular fullscreen despite vertical sync being turned on.\nRequested Refresh Rate: This option is shown only when exclusive fullsceen mode is enabled. It allows you to select your preferred refresh rate when running in exclusive fullscreen mode.\nUse integer scale values when entering fullscreen mode: By default, fullscreen mode fills the entire screen. However, this can cause non-integer scaling values to be used \u0026ndash; for example, in 1080p resolution, the scale becomes 4.5x. Since this can cause irregularly shaped pixels, you can use this option to use the nearest integer scale value instead (e.g 4x in this example).\nUse HDNes HD packs: Enables the use of HD packs.\nShow FPS: Displays an FPS counter on the screen. The first number is the number of frames emulated, the second number is the number of frames displayed on the screen. These values are usually identical, except when vertical sync is enabled.\nOverscan: The overscan settings allow you to cut out pixels on any edge of the screen. On a CRT TV, a few pixels on each side of the screen was usually invisible to the player. Because of this, games often have glitches or incorrect palette colors on the edges of the screen \u0026ndash; this is normal and caused by the game itself. Setting a value of 8 or so on each side of the overscan configuration will usually hide most glitches.\nPicture  Picture Options  Filter: Allows you to select a video filter. Selecting NTSC filters will cause additional configuration options to appear below.\nCommon Options The Brightness, Contrast, Hue, Saturation, Scanline settings are common to all filters and can even be used without a filter.\nUse bilinear interpolation when scaling: When enabled, bilinear interpolation is used when stretching (due to scale or aspect ratio). When disabled, nearest neighbor scaling is used. An easy way to get a slightly-softened screen, for example, is to use the Prescale filters (which use nearest neighbor scaling), use a bigger scale and enable bilinear filtering. For example, try this configuration:\nFilter: Prescale 3x Scale: 4x Use bilinear interpolation when scaling: Enabled  Scanlines: Simulates the scanlines on a CRT TV - the higher the value, the deeper the scanlines appear on the screen.\nNTSC Filter Options There are 2 separate NTSC filters implemented in Mesen. The NTSC filter is blargg\u0026rsquo;s implementation - this filter is very fast, and available in various other emulators. The NTSC (bisqwit) filter is an implementation of bisqwit\u0026rsquo;s NTSC filter \u0026ndash; it is slower and produces a different output.\nThe 2 filters have a different set of options:\nNTSC (blargg): Artifacts, Bleed, Fringing, Gamma, Resolution, Sharpness\nNTSC (bisqwit): Y Filter (Horizontal Blur), I Filter (Horizontal Blur), Q Filter (Horizontal Bleed)\nFeel free to experiment with the settings and choose what you feel looks best.\nPalette  Palette Options  This tab allows you to customize the palette used by all games.\nClick on any color in the palette to manually change its color.\n Load Preset Palette: Mesen comes with a number of built-in palette options - you can select them from here.\nLoad Palette File: Use this to load a .pal file into the emulator.\nExport Palette: Use this to export your current palette into a .pal file.\nUse this palette for VS System games: By default, VS System games have their own predefined RGB palettes and don\u0026rsquo;t use the palette defined here. When enabled, this option forces VS System games to ignore their default palette and use this one instead.\nAdvanced Options  Advanced Options  These options should not be used if you are looking for accurate emulation.\n Screen Rotation: Rotates the display by the specified angle. This is useful to play games (generally homebrew games) designed for a vertical display.\nDisable background: Disables rendering of the background layer.\nDisable sprite: Disables rendering of all sprites.\nForce background display in first column: The NES has a flag that prevents the background from rendering in the first 8 pixels on the left of the screen. When enabled, this option forces the background to be rendered in the first 8 pixels, no matter what the flag\u0026rsquo;s value is.\nForce sprite display in first column: The NES has a flag that prevents sprites from rendering in the first 8 pixels on the left of the screen. When enabled, this option forces the sprites to be rendered in the first 8 pixels, no matter what the flag\u0026rsquo;s value is.\n"
},
{
	"uri": "/configuration/emulation.html",
	"title": "Emulation Options",
	"tags": [],
	"description": "",
	"content": " General Options  General Options  Emulation Speed: This configures the regular speed to use when emulating. This should normally be set to 100%.\nFast Forward Speed: This is the alternate speed that is used when the Fast Forward button is held down.\nRewind Speed: This configures the speed at which to rewind the gameplay when the Rewind button is held down.\nSet any speed value to 0 to make Mesen run as fast as it can.\n Advanced Options Several options in this section should NOT be enabled to avoid issues in some games \u0026ndash; they are available here stricly for the sake of completeness (and testing homebrew software, etc.). These options are marked with the (not recommended) tag in the UI.\n  Advanced Options  Remove sprite limit: The NES can normally only draw up to 8 sprites per line \u0026ndash; this limitation is indirectly responsible for some of the flickering seen in games at times. When this option is enabled, the limit is disabled, allowing up to 64 sprites to be drawn on the same line.\nAutomatically re-enable sprite limit as needed to prevent graphical glitches when possible: Some games rely on the sprite limit to hide objects from view. These games will have graphical glitches when the Remove sprite limit option is enabled. By enabling this option, Mesen will try to detect when games are attempting to hit the sprite limit on purpose and temporarely re-enable the limit in these specific cases. This option is not perfect and may not work in certain games, but it helps reduce the potential negative impacts of the Remove sprite limit option.\nUse NES/HVC-101 (Top-loader / AV Famicom) behavior: The NES and Famicom both had 2 different releases - their original model and the \u0026ldquo;top loader\u0026rdquo; model. Both of these have slightly different behavior when it comes to their input ports. When enabled, this option causes Mesen to simulate the top loader models. No games are known to rely on this behavior.\nUse alternative MMC3 IRQ behavior: The MMC3 has a number of different variants (A, B and C). By default, Mesen uses the IRQ behavior for versions B and C. By turning this option on, Mesen will default to using the MMC3A\u0026rsquo;s IRQ behavior instead. There is usually no reason to enable this.\nEnable OAM RAM decay: On all models, OAM RAM decays whenever rendering is disabled. This causes the values in OAM RAM to randomly change, which may cause sprite-related glitches on the screen. No known game relies on this \u0026ndash; the option is offered here mostly for the sake of homebrew software testing.\nDo not reset PPU when resetting console: On the Famicom and top loader NES, the PPU does not reset when pressing the reset button (only the CPU is reset). When enabled, only the CPU resets when the reset button is pressed.\nDisable PPU $2004 reads: On some early models, the OAM RAM cannot be read via the $2004 register (in this case, $2004 becomes a write-only register). When enabled, this option emulates this behavior.\nDisable PPU OAMADDR bug emulation: On some models, a bug occurs that corrupts OAM RAM under certain circumstances. When this option is enabled, the bug is no longer emulated. This bug is required for at least 1 game to work properly.\nDisable PPU palette reads: On some early models, it is not possible to read the palette RAM via $2007 \u0026ndash; when enabled, this option emulates this behavior, making reads to palette RAM return corresponding values in the PPU\u0026rsquo;s memory instead.\nAllow invalid input: On a NES controller, it is impossible to press both left and right or up and down at the same time on the controller\u0026rsquo;s D-pad. Some games rely on this and pressing both buttons at once can cause glitches. When enabled, this option makes it possible to press opposite directional buttons at the same time.\nDefault power on state for RAM: On a console, the RAM\u0026rsquo;s state at power on is undetermined and relatively random. This option lets you select Mesen\u0026rsquo;s behavior when initializing RAM - set all bits to 0, set all bits to 1, or randomize the value of each bit.\nOverclocking Overclocking can cause issues in some games. The safest way to overclock is to increase the Additional scanlines before NMI option and leave the other options to their default values.\n  Overclocking Options  Clock Rate Multiplier: Use this to overclock or underclock the CPU \u0026ndash; this has the same effect as physically changing the clock speed on an actual NES. Unless you enable the Do not overclock APU option below, the audio output will be affected by this. This is not the recommended way to overclock the CPU.\nAdditional scanlines before NMI: Increases the number of scanlines in the PPU, before the NMI signal is triggered at the end of the visible frame. This effectively gives more time for games to perform calculations, which can reduce slowdowns in games. This is the preferred option for overclocking.\nAdditional scanlines after NMI: Increases the number of scanlines in the PPU, after the NMI signal is triggered at the end of the visible frame. This effectively gives more time for games to perform calculations, which can reduce slowdowns in games. This option is less compatible and should only be used if the before NMI variation does not work as expected.\nDo not overclock APU: When the Clock Rate Multiplier is not set to 100, the audio will be affected. When this option is enabled, the audio processor is not overclocked, which allows normal sound to be played despite the CPU being overclocked.\nShow Lag Counter: When enabled, the lag counter is displayed on the screen. The lag counter keeps track of frames where the game does not attempt to read the input ports \u0026ndash; this is usually an indication of the game running out of time to perform calculations, which usually causes slowdowns.\n"
},
{
	"uri": "/debugging/debugger.html",
	"title": "Debugger",
	"tags": [],
	"description": "",
	"content": "  The debugger window  The debugger is the main part of the debugging tools available in Mesen. This window displays the disassembled code, allows you to configure breakpoints, labels and watch values. It also contains a large number of options and smaller features \u0026ndash; all of which are described below.\nGeneral Usage Tips Generally speaking, the debugger tries to mimic the look and feel of Visual Studio in a lot of ways, including a lot of keyboard shortcuts (especially if you use the C# shortcut settings in Visual Studio). If you are familiar with any version of VS, the debugger should be easy to use.\nMost elements in the debugger\u0026rsquo;s interface have right-click menu options - make sure you explore the right-click options available in each list and window.\nWatch expressions, breakpoints and labels are automatically saved on a per-rom basis in a Workspace.\nYou can completely reset the workspace for a specific rom by using the File\u0026rarr;Workspace\u0026rarr;Reset Workspace command.\nShortcuts Use keyboard and mouse shortcuts to speed things up:\nGeneral  F9 to add/remove a breakpoint to the current line of code. Left-clicking on the left-most portion of the margin in the code window will set a breakpoint for that line.  Search and navigation  Ctrl+F: To perform an incremental search in the code window. Ctrl-Shift-F: Find all occurrences of an address or label in the code window. Ctrl-G: Go to a specific address. Double-click on an address to navigate to it. Back/Forward mouse buttons (on a 5-button mouse) allow you to go back and forth in the navigation history.   Code Window  Code Window  The code window displays the disassembled code and contains a number of features and options.\nGeneral information  Several options control what is shown in the code window, and how it is shown - see Display Options below. Labels and comments defined in the label list are shown in the code. Single-line comments appear on the left, multi-line comments appear on top. The instruction that\u0026rsquo;s currently executing is highlighted in yellow. Mouse-hovering any label or address will display a tooltip giving additional information (label, comment, current value in memory, etc.) You can alter the flow of execution by using the Set Next Statement command to change the next instruction to be executed.  Display Options Disassemble\u0026hellip;:\n Verified code only: The strictest disassembly mode - this will cause the dissassembler to only disassemble bytes that it knows to be actual code. Everything else will be treated as data. Everything: In this mode, the disassembler will attempt to disassemble absolutely everything, including bytes that are marked as data. Everything except verified data: In this mode, the disassembler will disassemble everything except bytes that have been used/marked as data.  Display OP codes in lower case: When enabled, OP codes are displayed in lowercase letters\nHighlight Unexecuted Code: When enabled, code that has been identified by the disassembler as code but hasn\u0026rsquo;t been executed yet will be highlighted in green.\nShow Effective Addresses: When enabled, the resulting address of indirect addressing modes (e.g LDA $3321, Y) will be displayed next to the instruction in blue. e.g: @ $3323\nShow Only Disassembled Code: When enabled, everything that has not been disassembled (e.g because it has not been confirmed to be actual code, or because it is data) will be hidden from the code window.\nByte Code Display: When enabled, the byte code matching the instructions will be displayed next to them (either on the left, or on the line below based on your selection)\nPRG Address Display: When enabled, the address matching the actual position of an instructions in PRG ROM will be displayed next to the CPU address (or replace it entirely, based on your selection)\nEmulation Status  Emulation Status  This section of the debugger window displays the CPU and PPU\u0026rsquo;s current state.\nWhile execution is paused, most fields are editable. Altering the value of any field will change its corresponding value in the emulation core. To undo any edits you have done by mistake, click the \u0026ldquo;Undo Changes\u0026rdquo; button.\nInput Button Setup  Input Button Setup - P1's top and right buttons are pushed  This section lets you force certain buttons to be held down on the NES\u0026rsquo; controller. This is often useful when trying to debug input-related code.\nClicking on a button on the mini NES controllers will toggle its state - green buttons are currently being held down.\nWatch Window  Watch Window  The watch window allows you to evaluate expression and see their value. Mesen supports complex expressions in C/C++ style syntax.\nTo add a new watch expression, click on the last empty line in the list and start typing.\nTo edit a watch expression, double-click on it and start typing.\nTo switch between hex and decimal, right-click in the watch and toggle the Hexadecimal Display option.\nSyntax The used syntax is identical to C/C++ syntax (e.g \u0026amp;\u0026amp; for and, || for or, etc.) and should have the same operator precedence as C/C++.\nNote: Use the $ prefix to denote hexadecimal values.\nSpecial values\nA/X/Y/PS/SP: Value of corresponding registers PC: Program Counter OpPC: Address of the current instruction's first byte Irq/Nmi: True if the Irq/Nmi flags are set Cycle/Scanline: Current cycle (0-340)/scanline(-1 to 260) of the PPU Frame: PPU frame number (since power on/reset) Value: Current value being read/written from/to memory IsRead: True if the CPU is reading from a memory address IsWrite: True if the CPU is writing to a memory address Address: Current CPU memory address being read/written RomAddress: Current ROM address being read/written [\u0026lt;address\u0026gt;]: (Byte) Memory value at \u0026lt;address\u0026gt; (CPU) {\u0026lt;address\u0026gt;}: (Word) Memory value at \u0026lt;address\u0026gt; (CPU)  Examples\n [$10] //Displays the value of memory at address $10 (CPU) a == 10 || x == $23 scanline == 10 \u0026amp;\u0026amp; (cycle \u0026gt;= 55 \u0026amp;\u0026amp; cycle \u0026lt;= 100) x == [$150] || y == [10] [[$15] + y] //Reads the value at address $15, adds Y to it and reads the value at the resulting address. {$FFFA} //Returns the NMI handler's address.  Using labels\nAny label defined in the debugger can be used in watch expressions (their value will match the label\u0026rsquo;s address in CPU memory).\nFor example, if you have a label called \u0026ldquo;velocity\u0026rdquo; that points to 1-byte value at address $30 in the CPU\u0026rsquo;s memory, you can display its value in the watch using the following syntax: [velocity]\nBreakpoints  Breakpoint List  Breakpoints define conditions under which the execution of the game\u0026rsquo;s code will be suspended. Any number of breakpoints can be defined. To quickly add or remove a breakpoint for the current line of code, press F9 in the code window.\nTo add a breakpoint, right-click the breakpoint list and select Add.\nTo edit a breakpoint, double-click on it in the list.\nTo disable a breakpoint, uncheck it.\nTo delete a breakpoint, right-click on it and select Delete\nTo view the breakpoint in the code, right-click on it and select Go to location\nBreakpoint configuration  Edit Breakpoint Window  Breakpoints can be set to trigger based on CPU/PPU memory accesses at specific memory addresses.\nBreak On\nSelect whether this breakpoint should occur based on CPU or PPU accesses, and which types of accesses should trigger the breakpoint.\nAddress\nSelect which address or address range this breakpoint should apply to.\nIt is also possible to specify no address at all by selecting Any - in this case, breakpoints will be evaluated on every CPU cycle.\nUse PRG ROM addresses: This option makes it so the addresses apply to the PRG ROM itself, instead of their mappings in CPU memory.\nCondition (optional)\nConditions allow you to use the same expression syntax as the one used in the Watch Window to cause a breakpoint to trigger under very specific conditions.\nExamples\nTo break when the sum of the X and Y registers is 5:\nx + y == 5  To break when the value at memory address $10 is smaller or equal to $40:\n[$10] \u0026lt;= $40  To break when the CPU writes the value $60 to any address:\nIsWrite \u0026amp;\u0026amp; Value == $60  Call Stack  Call Stack example with labels  The call stack displays the currently executing function, and all functions that are below it on the stack. The top of the list is the current function, while the row below it is the location that the code will return to once the current function executes the RTS instruction. The call stack also displays NMI and IRQ routine handlers and processes calls to RTI in the same manner as calls to JSR and RTS.\nNote: Rows shown in gray and italic represent portions of the call stack that are currently not inside the CPU\u0026rsquo;s memory (e.g because the PRG banks were changed since that point in the execution).\nLabels: When labels are defined for the PRG ROM offset matching the function\u0026rsquo;s entry point, that label is shown as the function\u0026rsquo;s name in the call stack.\nTo view the code at any location in the call stack, double-click on the row.\nLabels  Label List  Labels can be used to simplify debugging. They allow you to give names to variables and functions which will be used instead of numeric addresses when viewing the code in the debugger. Labels can also be used to display single and multi-line comments to the code.\nThe label list displays every label defined in alphabetical order.\nTo add a label, right-click in the label list and select Add.\nTo edit a label, right-click in the label list and select Edit.\nTo delete a label, right-click in the label list and select Delete.\nTo find where a label is used, right-click in the label list and select Find Occurrences.\nTo view the code at the label\u0026rsquo;s location, double-click on the label in the list.\nEditing Labels  Edit Label Window  Various types of labels can be defined:\n Internal RAM: Used for labels residing in the $0000-$1FFF memory range (the NES\u0026rsquo; built-in RAM) PRG ROM: Used for constants, data, code labels and functions in PRG ROM - the address value represents the offset from the start of PRG ROM (which can exceed $FFFF) Work RAM: Used for variables in work ram (also called PRG RAM without battery backup) - the address value represents the offset from the start of the ram chip. Save RAM: Used for variables in work ram (also called battery-backed PRG RAM) - the address value represents the offset from the start of the ram chip. Register: These are used to give name to built-in or mapper-specific registers. For example, the $2000 PPU register could be renamed to \u0026ldquo;PpuControl\u0026rdquo;.   There are some restrictions on what a label can contain \u0026ndash; in general, they must begin with a letter or an underscore and cannot contain spaces or most non-alphanumeric characters. Every type of label can also contain a comment. Comments are shown in the code window as well as in the tooltips that are displayed when putting your cursor over a label in the code window.\nFunction List  Function List  The function list is similar to the label list and allows you to easily add or edit the name of functions (which are also labels).\nUnlike the label list, which only displays labels, the function list displays all known functions, including those with no labels. This is useful to quickly check an unnamed function\u0026rsquo;s code (by double-clicking on it) and give it a name. This can help when attempting to reverse-engineer code.\nCPU/PPU Memory Mappings  CPU/PPU Memory Mappings  The CPU and PPU memory mappings are visual aids that display information about the currently selected PRG/CHR banks and the nametable configuration.\nThe banking configuration represents Mesen\u0026rsquo;s internal representation of the mapper in use, which may not exactly match the mapper\u0026rsquo;s specs.\nFor example, a mapper with 2x 8kb + 1x 16kb PRG banking is emulated as 4x 8kb internally, so it will appear as 4 8kb banks.\nHow To: Edit Code  Using \"Edit Selected Code\" from the code window allows you to edit the code in the assembler  From the code window, you can select code (via click and drag, or shift+arrow keys) and use the \u0026ldquo;Edit Selected Code\u0026rdquo; command to open the Assembler and edit that section of code. The assembler recognizes labels and allows you to define temporary labels as well. If the new code is smaller (in terms of bytes) than the original code, the extra bytes will be replaced by NOPs. If the new code is larger, it will override whatever comes next in the code \u0026ndash; a warning will be shown beforehand in this case. When you\u0026rsquo;re ready to apply your modifications, press the Apply button.\nIf you want to save your code modifications to a .nes file, or as an IPS patch, you can use the File\u0026rarr;Save or File\u0026rarr;Save edits as IPS commands.\n "
},
{
	"uri": "/apireference/drawing.html",
	"title": "Drawing",
	"tags": [],
	"description": "",
	"content": " Drawing basics All drawing-related functions share a few properties:\n- (x, y) coordinates must be between (0, 0) and (255, 239)\n- The \u0026ldquo;duration\u0026rdquo; is specified as a number of frames during which the drawing must remain on the screen. This defaults to 1 frame when unspecified, and draw calls will be permanent (until a call to clearScreen) if duration is set to 0.\n- Colors are integers in ARGB format:\nWhite: 0xFFFFFF Black: 0x000000 Red: 0xFF0000 Green: 0x00FF00 Blue: 0x0000FF The alpha component (transparency) can be used and defaults to being fully opaque when set to 0 or omitted. (0xFF is fully transparent) e.g: semi-transparent black: 0x7F000000 opaque gray: 0xFF888888 (fully transparent gray color)  drawPixel Syntax\nemu.drawPixel(x, y, color, duration)  Parameters\nx - Integer X position\ny - Integer Y position\ncolor - Integer Color\nduration - Integer Number of frames to display (Default: 1 frame)\nReturn value\nNone\nDescription\nDraws a pixel at the specified (x, y) coordinates using the specified color for a specific number of frames.\ndrawLine Syntax\nemu.drawLine(x, y, x2, y2, color, duration)  Parameters\nx - Integer X position (start of line)\ny - Integer Y position (start of line)\nx2 - Integer X position (end of line)\ny2 - Integer Y position (end of line)\ncolor - Integer Color\nduration - Integer Number of frames to display (Default: 1 frame)\nReturn value\nNone\nDescription\nDraws a line between (x, y) to (x2, y2) using the specified color for a specific number of frames.\ndrawRectangle Syntax\nemu.drawRectangle(x, y, width, height, color, fill, duration)  Parameters\nx - Integer X position\ny - Integer Y position width - Integer The rectangle\u0026rsquo;s width\nheight - Integer The rectangle\u0026rsquo;s height color - Integer Color\nfill - Boolean Whether or not to draw an outline, or a filled rectangle.\nduration - Integer Number of frames to display (Default: 1 frame)\nReturn value\nNone\nDescription\nDraws a rectangle between (x, y) to (x+width, y+height) using the specified color for a specific number of frames.\nIf fill is false, only the rectangle\u0026rsquo;s outline will be drawn.\ndrawString Syntax\nemu.drawString(x, y, text, textColor, backgroundColor, duration)  Parameters\nx - Integer X position\ny - Integer Y position text- String The text to display textColor - Integer Color to use for the text\nbackgroundColor - Integer Color to use for the text\u0026rsquo;s background color\nduration - Integer Number of frames to display (Default: 1 frame)\nReturn value\nNone\nDescription\nDraws text at (x, y) using the specified text and colors for a specific number of frames.\nclearScreen Syntax\nemu.clearScreen()  Return value\nNone\nDescription\nRemoves all drawings from the screen.\ngetPixel Syntax\nemu.getPixel(x, y)  Parameters\nx - Integer X position\ny - Integer Y position\nReturn value\nInteger ARGB color\nDescription\nReturns the color (in ARGB format) of the PPU\u0026rsquo;s output for the specified location.\n"
},
{
	"uri": "/debugging/ppuviewer.html",
	"title": "PPU Viewer",
	"tags": [],
	"description": "",
	"content": " The PPU Viewer is a collection of tools allowing you to view/edit the current state of various parts of the PPU\u0026rsquo;s memory: nametable RAM, CHR ROM/RAM, palette RAM and OAM (sprite) RAM.\nAll tabs share some common settings:\n Auto-refresh: Enabled by default, this makes the PPU viewer refresh at a rate of 15 FPS. When emulation is running, show PPU data at scanline [y] and cycle [x]: When using the auto-refresh option, this allows you to control at which point in a frame (cycle \u0026amp; scanline) the data is refreshed while the emulation is running. This is useful for games that perform CHR bank switching in the middle of a frame, for example.  Nametable Viewer  Nametable Viewer  The nametable viewer displays the contents of all 4 nametables (PPU addresses $2000 to $2FFF).\nMouve-over a tile to display that tile\u0026rsquo;s information on the right. There are also a number of display options:\n Show PPU Scroll Overlay: Shows a blue rectangular overlay showing the current scroll position of the screen. Show Tile Grid: Displays a 8x8 pixels red grid. Show Attribute Grid: Displays a 16x16 pixels blue grid. Highlight tile selected in CHR viewer: When enabled, click on a tile in the CHR viewer to select it, all occurrences of that tile will then be marked by a red rectangle in the nametable viewer.  Double-click on a tile in the nametable viewer to view/edit it in the CHR Viewer.\nAdditionally, you can right-click on a tile to copy the tile\u0026rsquo;s information to the clipboard (for use with HD Packs).\nCHR Viewer/Editor  CHR Viewer and Editor  The CHR Viewer tab displays up to 2 4kb banks of CHR data at once. It can display any portion of CHR RAM/ROM, even banks that are not currently selected.\nIt also doubles up as a very simple graphic editor.\nYou can right-click on a tile to copy the tile\u0026rsquo;s information (based on the currently selected palette) to the clipboard (for use with HD Packs).\nDisplay Options  Chr Selection: Select which portion of CHR memory to display in the viewer - by default, the portions of CHR memory mapped to the $0000-$1FFF range in PPU memory are shown. Palette Selection: Selects which palette to use to render the tiles - the first 4 palettes are for tiles, the last 4 palettes are for sprites. Highlight: This option allows tiles to be highlighted/dimmed based on the CDL file\u0026rsquo;s current data. This makes it possible to highlight/dim tiles that have never been drawn by the PPU, or vice versa. This option is only available for CHR ROM games. Display as 16x8 sprites: When enabled, changes the display order of the tiles to make it easier to visualize 16x8 sprites.  Editing Tiles To edit a tile, first click on the tile you want to edit in the left-side of the window. This will select the tile and highlight it with a transparent square.\nYou can select the color you want to use by clicking on the Color Picker. You can also press keys 1 to 4 on your keyboard to quickly switch between the four colors.\nWith a tile selected, move your mouse to the tile preview above the Color Picker and click+drag to start drawing. Right-click can be used to draw as well \u0026ndash; it always draws color #0.\nAny change will remain in effect until a power cycle. If you want to save your modifications to a .nes file, or as an IPS patch, you can use the File\u0026rarr;Save or File\u0026rarr;Save edits as IPS commands in the debugger window. Keep in mind that edits done to CHR RAM cannot be saved.\n Sprite Viewer  Sprite Viewer  The Sprite Viewer displays the contents of OAM RAM. Mouve-over a sprite to display that sprite\u0026rsquo;s information on the right.\nThe Screen Preview displays all sprites as they will be shown on the screen, based on the current OAM data.\nLike the nametable viewer, double-click on a tile to view/edit it in the CHR Viewer \u0026ndash; this works in the Screen Preview as well.\nAdditionally, you can right-click on a tile to copy the tile\u0026rsquo;s information to the clipboard (for use with HD Packs).\nPalette Viewer/Editor  Palette Viewer and Editor  The Palette Viewer displays basic information about the current state of palette RAM.\nIt shows which colors are configured in each of the 8 available palettes.\nYou can click on any color to select another color for that slot.\n"
},
{
	"uri": "/configuration/preferences.html",
	"title": "Preferences",
	"tags": [],
	"description": "",
	"content": " General Options  General Options  Display Language: Selects in which language the UI is shown \u0026ndash; defaults the user\u0026rsquo;s default language.\nAutomatically check for updates: When enabled, Mesen will check for a new version of the emulator every time the emulator is started.\nOnly allow one instance of Mesen at a time: When enabled, only a single copy of Mesen can be opened at the same time. This is useful when using file associations to load games by double-clicking on the rom files.\nPause/Background settings Hide the pause screen: When enabled, the PAUSE screen is no longer shown when the emulator is paused.\nPause when a movie finishes playing: When enabled, the emulator will automatically pause when a movie ends its playback.\nPause emulation when in background: When enabled, the emulator will automatically pause when in the background.\nAllow input when in background: When enabled, gamepad input can still be used even if the window is in the background. This does not work for keyboard key bindings.\nMisc. Settings Automatically apply IPS/BPS patches: When enabled, any IPS or BPS patch file found in the same folder as the ROM file will automatically be applied. (i.e: when loading MyRom.nes, if a file called MyRom.ips exists in the same folder, it will be loaded automatically.)\nAutomatically hide the menu bar: When enabled, the menu bar will automatically be hidden when not in use, even in windowed mode. The menu bar is always hidden automatically when playing in fullscreen mode, whether this option is enabled or not.\nDisplay confirmation dialog before reset/power cycle/exit: When enabled, a confirmation dialog will be shown before a reset or a power cycle or before the emulator is closed.\nDisplay play/record icon when playing or recording a movie: When enabled, an icon will be shown on the screen whenever a movie is playing or recording.\nEnable developer mode: When enabled, all debugging tools are moved to a Debug menu accessible directly from the main window. This makes debugging tools more accessible as they no longer require opening the debugger before being able to open any other tool.\nShortcut Keys  Shortcut Keys  Shortcut keys are user-defined shortcuts for various features in Mesen. Some of these features can only be accessed via shortcut keys (e.g: Fast Forward and Rewind).\nMost of these options are also available through the main window\u0026rsquo;s menu \u0026ndash; the shortcuts configured in this section will appear next to the matching action in the main window\u0026rsquo;s menu.\nTo change a shortcut, click on the button for the shortcut you want to change and press the key(s) you want to set for this shortcut. Once you release a key, all the keys you had pressed will be assigned to the shortcut.\nTo clear a key binding, right-click on the button.\nAvailable shortcuts:\n Fast Forward (Hold button): Hold down this key to fast forward the game. Toggle Fast Forward: Start/stop fast forwarding. Rewind (Hold button): Hold down this key to rewind the game in real-time. Toggle Rewind: Start/stop rewinding. Rewind 10 seconds: Instantly rewinds 10 seconds of gameplay. Rewind 1 minute: Instantly rewinds 1 minute of gameplay. Pause: Pauses or unpauses the game. Reset: Resets the game. Power Cycle: Power cycles the game. Power Off: Powers off the game, returning to the game selection screen. Exit: Exits the emulator. FDS - Insert Next Disk: Inserts face A of the next disk. FDS - Switch Side: Switches to the current disk\u0026rsquo;s other side (A or B) FDS - Eject Disk: Ejects the currently inserted disk VS - Insert Coin 1: Inserts a coin in slot 1. VS - Insert Coin 2: Inserts a coin in slot 2. VS - Service Button: Press to go to the service menu (only in some VS games) Input Barcode: Inputs a barcode into the connected barcode reader device. Take Screenshot: Takes a screenshot. Load Random Game: Loads a random game from your game folder. Run Single Frame: Press to run a single frame and pause. Set Scale 1x to 6x: Sets the scale to the matching value. Toggle Fullscreen Mode: Enters/exits fullscreen mode. Toggle FPS Counter: Turns on/off the FPS counter. Toggle Game Timer: Turns on/off the game timer. Toggle Frame Counter: Turns on/off the frame counter. Toggle Lag Counter: Turns on/off the lag counter. Toggle OSD (On-Screen Display): Turns on/off the OSD. Toggle Display on Top: Turns on/off the display on top option. Toggle Background Layer: Turns on/off the background layer. Toggle Sprite Layer: Turns on/off the sprite layer. Enable/Disable Cheat Codes: Press to toggle cheats on or off. Enable/Disable Audio: Press to toggle audio output on or off. Toggle Keyboard Mode: Turns on/off keyboard mode. Toggle Maximum Speed: Toggles emulation speed between 100% and maximum speed. Increase Speed: Increases the emulation speed. Decrease Speed: Decreases the emulation speed. Open File: Displays the open file dialog. Open Debugger: Opens the debugger. Open Assembler: Opens the assembler. Open Ppu Viewer: Opens the PPU viewer. Open Memory Tools: Opens the memory tools. Open Script Window: Opens the script window. Open Trace Logger: Opens the trace logger. Select Next Save Slot: Move to the next save state slot. Select Previous Save Slot: Move to the previous save state slot. Save State: Save the game\u0026rsquo;s state in the currently selected slot. Load State: Load the game\u0026rsquo;s state from the currently selected slot. Save State - Slot X: Save the game\u0026rsquo;s state to the matching slot. Load State - Slot X: Load the game\u0026rsquo;s state from the matching slot. Save State to File: Save the game\u0026rsquo;s state to a user-specified file. Load State from File: Load the game\u0026rsquo;s state from a user-specified file.  Folders and File Associations  Folders and File Associations  File Associations: Use these options to associate Mesen with these file types. This will allow you to double-click on these files in a file explorer to open them in Mesen.\nData Storage Location: Mesen can either store its data in your user profile or in the same folder as the executable file itself. This is configured when you launch Mesen for the first time, but can also be changed here. When changing from one option to the other, Mesen will automatically copy all files from one folder to the other, allowing you to keep your save data and all other important files automatically.\nFolder Overrides: On top of configuring the main folder where Mesen keeps its data, you may also specify custom locations for certain folders used by Mesen to store user-created files such as recordings or save data.\nAdvanced Options  Advanced Options  Disable built-in game database: Mesen contains a built-in database containing information on thousands of rom files \u0026ndash; it uses this database to use the most appropriate settings when loading a game (e.g NTSC vs PAL) and to fix incorrect file headers. Disabling this option is not recommended.\nKeep rewind data for the last [x] minutes: The rewind feature in Mesen periodically takes save states and keeps them in memory to allow the emulator to rewind the game. These save states take a minimal amount of memory (roughly 1MB per minute). To limit the amount of memory that Mesen can use for rewind data, this configures the number of minutes that it is possible to rewind for.\nFDS Settings The FDS (Famicom Disk System) is a Famicom-specific add-on that allows games to be stored on special floppy disks. These options help simplify playing FDS games by allowing the emulation to fast-forward through load screens and automatically switch disk when needed.\nAutomatically insert disk 1 side A when starting FDS games: By default, the FDS boots with no disk inserted in the drive. This option makes it so the player does not need to manually insert disk 1, side A manually.\nAutomatically fast forward FDS games when disk or BIOS is loading: FDS games contain a large number of load screens due to their data being stored on floppy drives. Mesen needs to emulate this floppy drive\u0026rsquo;s speed to ensure accurate emulation. This option makes it so Mesen runs the emulation as fast as it can when a game is loading data from the disk, which greatly reduces the time spent on loading screens.\nAutomatically switch disks for FDS games: FDS games are often split into multiple floppy disks, and each disk has 2 separate sides. Due to this, FDS games often ask the player to change disk, or flip to the other side. When this option is enabled, Mesen will attempt to detect when a game is asking for another disk and automatically insert it.\nUI Settings Always display on top of other windows: When enabled, Mesen\u0026rsquo;s window will always be displayed above all other windows.\nDisable on-screen display (OSD): When enabled, all on-screen messages are disabled.\nDisplay additional information in title bar: When enabled, additional information is shown in the title bar (such as filter, scale, etc.), next to the game\u0026rsquo;s name.\nShow frame counter: When enabled, the number of frames emulated since the last reset will be shown on the screen.\nShow game timer: When enabled, the amount of time elapsed since the last reset will be shown on the screen.\nShow game configuration dialog when loading VS System games: VS System arcade cabinets usually have a number of options that can be physically configured via DIP switches in the arcade cabinet itself. When enabled, this option makes it so the DIP switches\u0026rsquo; configuration dialog is shown every time a VS System game is loaded. This dialog can also be manually accessed from the Game menu.\nGame Selection Screen Settings Start game from power-on instead of resuming the previous state: Normally, when using the game selection screen to start a game, the game resumes where you left off. When this option is enabled, the game starts over from power on.\nDisable game selection screen: When enabled, the game selection screen is hidden and cannot be used.\n"
},
{
	"uri": "/debugging/memorytools.html",
	"title": "Memory Tools",
	"tags": [],
	"description": "",
	"content": " Memory Viewer  Memory Viewer  The memory viewer offers read and write access to all types of ROM and RAM:\n CPU Memory PPU Memory Palette RAM OAM RAM Secondary OAM RAM PRG ROM CHR ROM CHR RAM Work RAM Save RAM  PRG ROM and CHR ROM are writable from the memory viewer. Any change will remain in effect until a power cycle. If you want to save your PRG/CHR ROM modifications to a .nes file, or as an IPS patch, you can use the File\u0026rarr;Save or File\u0026rarr;Save edits as IPS commands in the debugger window.\n Editing Memory Values There are 2 ways to edit memory values:\n Using the hex view: Click on the byte you want to change in the hex view (on the left), and type hexadecimal values to replace it.\n Using the text view: Click on the section you want to change in the text view (on the right), and type ASCII text to replace. This method is rather limited and usually not very useful unless the ROM uses ASCII values for its text.\n  Importing / Exporting For most types of memory, it is possible to export its contents to a binary file as well as import it back from a file. Use the Import and Export commands to do this.\nHighlighting There are a number of highlighting/coloring options in the memory viewer.\nView\u0026rarr;Highlight has coloring options for addresses that were recently read, written or executed (colored in blue, red and green, respectively). A fade-out period can also be configured, after which the byte will revert to its normal black color.\nView\u0026rarr;De-emphasize offers options to display bytes matching certain conditions (unused, read, written or executed) in gray.\nFreezing values Using the right-click menu, you can Freeze values in CPU Memory. Frozen addresses are shown in magenta.\nFrozen addresses will no longer be affected by write operations - effectively making those addresses read-only for the CPU. It is still possible to manually edit the value of frozen addresses using the memory viewer.\nUsing TBL Files  Memory Viewer with a TBL file loaded to display Japanese text  TBL files are text files that define mappings between sequences of bytes and text characters. For example, it might define the byte $95 as the character \u0026lsquo;A\u0026rsquo;.\nNormally, when no TBL file is loaded, the memory viewer will display each byte\u0026rsquo;s standard ASCII representation on the right-hand side. Once a TBL file is loaded, the text representation of the data will be updated to reflect the TBL mappings. This is useful, for example, when translating text.\nMemory Access Counters  Memory Access Counters  When active, the debugger keeps track of all CPU and PPU memory reads, writes and executions. It is possible to view these counters here.\nUse the Sort By option to sort the list based on different criteria.\nThe Reset button allows you to reset all counters back to 0 \u0026ndash; this is useful when you are trying to gather data for a specific portion of the execution.\nUse the Highlight uninitialized memory reads option to track down any reads done to RAM memory before the RAM memory has been initialized after a power cycle \u0026ndash; reading from uninitialized memory can produce random behavior, which is usually unwanted.\nProfiler  Code Profiler  The profiler automatically collects data about all function calls done by the code, as well as the number of clock cycles spent in each respective function.\nUsing the profiler makes it is easy to find the bottlenecks in a game\u0026rsquo;s code, which can help code optimization efforts.\nIf you are familiar with Visual Studio\u0026rsquo;s profiler, these columns should be familiar:\n Call Count: The number of times this function was called during profiling Inclusive Time (Cyc): The amount of CPU cycles spent within this function (including the cycles spent by all functions called by this function) Inclusive Time (%): The relative portion of CPU time spent within this function (including the time spent by all functions called by this function) Exclusive Time (Cyc): The amount of CPU cycles spent within this function (functions called by this function are excluded) Exclusive Time (%): The relative portion of CPU time spent within this function (functions called by this function are excluded) Call Count: The number of times this function was called during profiling  Use the Reset button to reset the profiler\u0026rsquo;s data \u0026ndash; use this when you want to profile a specific portion of the execution.\n"
},
{
	"uri": "/apireference/emulation.html",
	"title": "Emulation",
	"tags": [],
	"description": "",
	"content": " getState Syntax\nemu.getState()  Return value\nTable Current emulation state with the following structure:\nregion: int, clockRate: int, cpu: { status: int, a: int, irqFlag: int, cycleCount: int, pc: int, y: int, x: int, sp: int, nmiFlag: bool }, ppu: { cycle: int, scanline: int, frameCount: int, control: { backgroundEnabled: bool, intensifyBlue: bool, intensifyRed: bool, backgroundPatternAddr: int, grayscale: bool, verticalWrite: bool, intensifyGreen: bool, nmiOnVBlank: bool, spritesEnabled: bool, spritePatternAddr: int, spriteMask: bool, largeSprites: bool, backgroundMask: bool }, status: {, spriteOverflow: bool, verticalBlank: bool, sprite0Hit: bool }, state: { status: int, lowBitShift: int, xScroll: int, highBitShift: int, videoRamAddr: int, control: int, mask: int, tmpVideoRamAddr: int, writeToggle: bool, spriteRamAddr: int } }, apu: { square1: { outputVolume: int, frequency: float, duty: int, period: int, enabled: bool, dutyPosition: int, sweepShift: int, sweepPeriod: int, sweepEnabled: bool, sweepNegate: bool envelope: { counter: int, loop: bool, divider: int, volume: int, startFlag: bool, constantVolume: bool }, lengthCounter: { halt: bool, counter: int, reloadValue: int } }, square2: { outputVolume: int, frequency: float, duty: int, period: int, enabled: bool, dutyPosition: int, sweepShift: int, sweepPeriod: int, sweepEnabled: bool, sweepNegate: bool, envelope: { counter: int, loop: bool, divider: int volume: int, startFlag: bool, constantVolume: bool }, lengthCounter: { halt: bool, counter: int, reloadValue: int } }, triangle: { outputVolume: int, frequency: float, sequencePosition: int, period: int, enabled: bool, lengthCounter: { halt: bool, counter: int, reloadValue: int } }, noise: { modeFlag: bool, enabled: bool, outputVolume: int, frequency: float, period: int, shiftRegister: int, envelope: { counter: int, loop: bool, divider: int, volume: int, startFlag: bool, constantVolume: bool }, lengthCounter: { halt: bool, counter: int, reloadValue: int } }, dmc: { sampleLength: int, irqEnabled: bool, loop: bool, outputVolume: int, bytesRemaining: int, sampleAddr: int, period: int, sampleRate: float }, frameCounter: { fiveStepMode: int, irqEnabled: int, sequencePosition: int } }, cart: { selectedPrgPages: array, chrRomSize: int, chrRamSize: int, prgPageCount: int, chrPageSize: int, selectedChrPages: array, chrPageCount: int, prgRomSize: int, prgPageSize: int, }  Description\nReturn a table containing information about the state of the CPU, PPU, APU and cartridge.\nsetState Syntax\nemu.setState(state)  Parameters\nstate - Table A table containing the state of the emulation to apply.\nReturn value\nNone\nDescription\nUpdates the CPU and PPU\u0026rsquo;s state. The state parameter must be a table in the same format as the one returned by getState()\nNote: the state of the APU or cartridge cannot be modified by using setState().\nbreakExecution Syntax\nemu.breakExecution()  Return value\nNone\nDescription\nBreaks the execution of the game and displays the debugger window.\nexecute Syntax\nemu.execute(count, type)  Parameters\ncount - Integer The number of cycles or instructions to run before breaking\ntype - Enum See executeCountType\nReturn value\nNone\nDescription\nRuns the emulator for the specified number of cycles/instructions and then breaks the execution.\nreset Syntax\nemu.reset()  Return value\nNone\nDescription\nResets the current game.\nresume Syntax\nemu.resume()  Return value\nNone\nDescription\nResumes execution after breaking.\nrewind Syntax\nemu.rewind(seconds)  Parameters\nseconds - Integer The number of seconds to rewind\nReturn value\nNone\nDescription\nInstantly rewinds the emulation by the number of seconds specified.\nNote: this can only be called from within a \u0026ldquo;StartFrame\u0026rdquo; event callback.\n"
},
{
	"uri": "/debugging/tracelogger.html",
	"title": "Trace Logger",
	"tags": [],
	"description": "",
	"content": "  Trace Logger  Basic Information The trace logger displays the execution log of the CPU. It can display the last 30,000 CPU instructions executed. Additionally, it is also possible to log these instructions to the disk by using the Start Logging button. Log files can rapidly grow in size (to several GBs worth of data in a few seconds), so it is recommended to log for the shortest amount of time needed.\nDisplay Options A number of options that toggle the display of several elements exist: Registers, CPU Cycles, PPU Cycles, PPU Scanline, Show Effective Addresses, Byte Code, Frame Count, Additional Information (IRQ, NMI, etc.). Adjust these based on your needs.\nAdditionally, you can alter the way some elements are displayed:\n Status Flag Format: Offers a number of different ways to display the CPU\u0026rsquo;s status flags. Indent code based on stack pointer: When enabled, the log\u0026rsquo;s lines will be indented by 1 character for every byte pushed to the stack. This is useful to quickly be able to identify function calls, for example. Use Labels: When enabled, addresses that match known labels will be replaced by their label instead.  Conditional Logging The Condition field accepts conditional statements in the same format as breakpoints.\nWhen a condition is entered, only instructions that match the given condition will be logged. This can be used, for example, to log cartridge register writes (e.g: IsWrite \u0026amp;\u0026amp; Address \u0026gt;= $8000), PPU register reads (e.g: IsRead \u0026amp;\u0026amp; Address \u0026gt;= $2000 \u0026amp;\u0026amp; Address \u0026lt;= $3FFF) or when a specific portion of CPU memory is being executed (e.g: pc \u0026gt;= $8100 \u0026amp;\u0026amp; pc \u0026lt;= $8150).\nConditions are very flexible and can be used to check just about any condition \u0026ndash; use them to your advantage.\n"
},
{
	"uri": "/debugging/assembler.html",
	"title": "Assembler",
	"tags": [],
	"description": "",
	"content": "  Assembler  The assembler allows writing new code, editing existing code and running arbitrary code.\nUsage Code is assembled on-the-fly, with the resulting byte code being shown on the right.\nAny compilation error will be shown in the list at the bottom \u0026ndash; double-click an error in the list to navigate to the line that caused it.\nOnce you are done editing the code, you can either Execute it, or Apply it. Executing the code will make it run in the $3000-$3FFF memory range (temporarely overriding the PPU\u0026rsquo;s normal behavior) and break the execution once the code is done executing. On the other hand, clicking Apply will write the code to the specified memory address - this can be used to create new code in RAM, for example, or alter existing code in PRG ROM.\nAny changes done to PRG ROM will remain in effect until a power cycle. If you want to save your modifications to a .nes file, or as an IPS patch, you can use the File\u0026rarr;Save or File\u0026rarr;Save edits as IPS commands in the debugger window.\n Note: When editing an existing block of code, the assembler keeps track of how many bytes of code the original code contained, as well as whether or not an RTS instruction was present. If the new code is lacking an RTS instruction, or is too large to fit into the original block of code, a warning will be shown before applying the changes.\nSupported features  All official opcodes and addressing modes are fully supported. All unofficial opcodes with well-defined behavior are supported (see limitations below) Hexadecimal ($ prefix) and decimal values are supported. Labels can be used and defined in the code. When using labels, the assembler will favor zero-page addressing when possible - only using other types of addressing when necessary. The .byte directive can be used to add arbitrary data to the output.  Limitations  Unofficial opcodes: The assembler supports all unofficial opcodes that Mesen can emulate. However, opcodes that have undefined behavior (and thus are not emulated by Mesen) are not supported. Additionally, name conflicts make it so it is impossible to use any NOP opcode other than the standard NOP opcode.\n Defining labels: As mentioned above, it is possible to define labels to use in the assembler. However, these labels are (currently) not permanent - they are discarded once the assembler is closed.\n  Display Options Syntax highlighting can be configured (or disabled) via the View menu.\nIt is also possible to change the font size.\n"
},
{
	"uri": "/debugging/scriptwindow.html",
	"title": "Script Window",
	"tags": [],
	"description": "",
	"content": " Script Window  The Script Window allows Lua scripting via a Mesen-specific API. Using this API, you can interact with the emulation core to perform a variety of things (e.g: logging, drawing, implementing an AI).\nThe code editor contains an autocomplete feature for all of Mesen\u0026rsquo;s API \u0026ndash; typing emu. will display an autocomplete popup displaying all available functions. Select a function in the list to see its parameters, return value and description.\nMultiple script windows can be opened at once to combine the effects of several scripts together.\nScripts can be loaded from the disk and edited in any other text editor. When using an external editor to modify the script, it is suggested to turn on the Script\u0026rarr;Auto-reload when file changes option to automatically reload the script each time it is saved to the disk.\nTo start a script, press F5.\nTo stop a script, press Escape or close the script window.\nThe Log Window at the bottom will display any Lua errors that occur while running the script. Additionally, any calls to emu.log() will also display their content in the log window.\n"
},
{
	"uri": "/debugging/debuggerintegration.html",
	"title": "Integration with CC65/ASM6",
	"tags": [],
	"description": "",
	"content": " When building homebrew software in assembly or C, it is possible to export the labels used in your code and import them into Mesen to simplify the debugging process. This allows the debugger to know which portions of the ROM correspond to which functions in your code, as well as display your code\u0026rsquo;s comments inside the debugger itself.\nCC65 / CA65 CC65/CA65 are able to produce .DBG files which can be imported into Mesen\u0026rsquo;s debugger.\nTo make CC65/CA65 create a .DBG file during the compilation, use the --dbgfile command line option.\nTo import the .DBG file, use the File\u0026rarr;Workspace\u0026rarr;Import Labels command in the debugger window.\nYou can also enable the Auto-load DBG/MLB files to make Mesen load any .DBG file it finds next to the ROM whenever the debugger is opened or the power cycle button is used.\nNote: For this option to work, the ROM file must have the same name as the DBG file (e.g MyRom.nes and MyRom.dbg) and be inside the same folder.\nASM6f Integration with ASM6 is possible by using freem\u0026rsquo;s branch of ASM6 named ASM6f.\nThis fork contains 2 additional command line options that are useful when using Mesen: -m and -c\n-m produces a .mlb (Mesen labels) file that can be imported manually using the File\u0026rarr;Workspace\u0026rarr;Import Labels command.\n-c produces a .cdl (Code Data Logger) file which can be imported manually using the Tools\u0026rarr;Code/Data Logger\u0026rarr;Load CDL file command.\nAdditionally, you can use the Auto-load DBG/MLB files and Auto-load CDL files options in the File\u0026rarr;Workspace menu to automatically load MLB and CDL files present in the same folder as the current ROM, with the same filename (e.g MyRom.nes, MyRom.mlb, MyRom.cdl).\n"
},
{
	"uri": "/apireference/input.html",
	"title": "Input",
	"tags": [],
	"description": "",
	"content": " getInput Syntax\nemu.getInput(port)  Parameters\nport - Integer The port number to read (0 to 3)\nReturn value\nTable A table containing the status of all 8 buttons.\nDescription\nReturns a table containing the status of all 8 buttons: { a, b, select, start, up, down, left, right }\nsetInput Syntax\nemu.setInput(port, input)  Parameters\nport - Integer The port number to apply the input to (0 to 3)\ninput - Table A table containing the state of some (or all) of the 8 buttons (same format as returned by getInput)\nReturn value\nNone\nDescription\nButtons enabled or disabled via setInput will keep their state until the next inputPolled event.\nIf a button\u0026rsquo;s value is not specified to either true or false in the input argument, then the player retains control of that button. For example, setInput(0, { select = false, start = false}) will prevent the player 1 from using both the start and select buttons, but all other buttons will still work as normal. To properly control the emulation, it is recommended to use this function within a callback for the inputPolled event. Otherwise, the inputs may not be applied before the ROM has the chance to read them.\ngetMouseState Syntax\nemu.getMouseState()  Return value\nTable The mouse\u0026rsquo;s state\nDescription\nReturns a table containing the position and the state of all 3 buttons: { x, y, left, middle, right }\nisKeyPressed Syntax\nemu.isKeyPressed(keyName)  Parameters\nkeyName - String The name of the key to check\nReturn value\nBoolean The key\u0026rsquo;s state (true = pressed)\nDescription\nReturns whether or not a specific key is pressed. The \u0026ldquo;keyName\u0026rdquo; must be the same as the string shown in the UI when the key is bound to a button.\n"
},
{
	"uri": "/apireference/logging.html",
	"title": "Logging",
	"tags": [],
	"description": "",
	"content": " displayMessage Syntax\nemu.displayMessage(category, text)  Parameters\ncategory - String The category is the portion shown between brackets []\ntext - String Text to show on the screen\nReturn value\nNone\nDescription\nDisplays a message on the main window in the format \u0026ldquo;[category] text\u0026rdquo;\nlog Syntax\nemu.log(text)  Parameters\ntext - String Text to log\nReturn value\nNone\nDescription\nLogs the given string in the script\u0026rsquo;s log window - useful for debugging scripts.\n"
},
{
	"uri": "/apireference/memoryaccess.html",
	"title": "Memory Access",
	"tags": [],
	"description": "",
	"content": " read / readWord Syntax\nemu.read(address, type, signed = false) emu.readWord(address, type, signed = false)  Parameters\naddress - Integer The address/offset to read from.\ntype - Enum The type of memory to read from. See memType.\nsigned - (optional) Boolean If true, the value returned will be interpreted as a signed value.\nReturn value\nAn 8-bit (read) or 16-bit (readWord) value.\nDescription\nReads a value from the specified memory type.\nWhen calling read / readWord with the memType.cpu or memType.ppu memory types, emulation side-effects may occur.\nTo avoid triggering side-effects, use the memType.cpuDebug or memType.ppuDebug types, which will not cause side-effects.\nwrite / writeWord Syntax\nemu.write(address, value, type) emu.writeWord(address, value, type)  Parameters\naddress - Integer The address/offset to write to.\nvalue - Integer The value to write.\ntype - Enum The type of memory to write to. See memType.\nReturn value\nNone\nDescription\nWrites an 8-bit or 16-bit value to the specified memory type.\nNormally read-only types such as PRG-ROM or CHR-ROM can be written to when using memType.prgRom or memType.chrRom.\nChanges will remain in effect until a power cycle occurs.\nTo revert changes done to ROM, see revertPrgChrChanges.\nWhen calling write / writeWord with the memType.cpu or memType.ppu memory types, emulation side-effects may occur.\nTo avoid triggering side-effects, use the memType.cpuDebug or memType.ppuDebug types, which will not cause side-effects.\nrevertPrgChrChanges Syntax\nemu.revertPrgChrChanges()  Return value\nNone\nDescription\nReverts all modifications done to PRG-ROM and CHR-ROM via write/writeWord calls.\n"
},
{
	"uri": "/apireference/misc.html",
	"title": "Miscellaneous",
	"tags": [],
	"description": "",
	"content": " Save States There are 2 separate save state APIs.\nThe first one is synchronous and uses the saveSavestate and loadSavestate functions. Its main restriction is that it can only be used inside \u0026ldquo;startFrame\u0026rdquo; or \u0026ldquo;cpuExec\u0026rdquo; callback functions.\nThe second API is asynchronous and uses an internally-managed \u0026ldquo;save slot\u0026rdquo; system to hold states in memory. It uses the following functions: saveSavestateAsync, loadSavestateAsync, getSavestateData and clearSavestateData.\nsaveSavestate Syntax\nemu.saveSavestate()  Return value\nString A string containing a binary blob representing the emulation\u0026rsquo;s current state.\nDescription\nCreates a savestate and returns it as a binary string. (The savestate is not saved on disk)\nNote: this can only be called from within a \u0026ldquo;startFrame\u0026rdquo; event callback or \u0026ldquo;cpuExec\u0026rdquo; memory callback.\nsaveSavestateAsync Syntax\nemu.saveSavestateAsync(slotNumber)  Parameters\nslotNumber - Integer A slot number to which the savestate data will be stored (slotNumber must be \u0026gt;= 0)\nReturn value\nNone\nDescription\nQueues a save savestate request. As soon at the emulator is able to process the request, it will be saved into the specified slot.\nThis API is asynchronous because save states can only be taken in-between 2 CPU instructions, not in the middle of an instruction. When called while the CPU is in-between 2 instructions (e.g: inside the callback of an cpuExec or startFrame event), the save state will be taken immediately and its data will be available via getSavestateData right after the call to saveSavestateAsync.\nThe savestate can be loaded by calling the loadSavestateAsync function.\nloadSavestate Syntax\nemu.loadSavestate(savestate)  Parameters\nsavestate - String A binary blob representing a savestate, as returned by saveSavestate()\nReturn value\nNone\nDescription\nLoads the specified savestate.\nNote: this can only be called from within a \u0026ldquo;startFrame\u0026rdquo; event callback or \u0026ldquo;cpuExec\u0026rdquo; memory callback.\nloadSavestateAsync Syntax\nemu.loadSavestateAsync(slotNumber)  Parameters\nslotNumber - Integer The slot number to load the savestate data from (must be a slot number that was used in a preceding saveSavestateAsync call)\nReturn value\nBoolean Returns true if the slot number was valid.\nDescription\nQueues a load savestate request. As soon at the emulator is able to process the request, the savestate will be loaded from the specified slot.\nThis API is asynchronous because save states can only be loaded in-between 2 CPU instructions, not in the middle of an instruction. When called while the CPU is in-between 2 instructions (e.g: inside the callback of an cpuExec or startFrame event), the savestate will be loaded immediately.\ngetSavestateData Syntax\nemu.getSavestateData(slotNumber)  Parameters\nslotNumber - Integer The slot number to get the savestate data from (must be a slot number that was used in a preceding saveSavestateAsync call)\nReturn value\nString A binary string containing the savestate\nDescription\nReturns the savestate stored in the specified savestate slot.\nclearSavestateData Syntax\nemu.clearSavestateData(slotNumber)  Parameters\nslotNumber - Integer The slot number to get the savestate data from (must be a slot number that was used in a preceding saveSavestateAsync call)\nReturn value\nNone\nDescription\nClears the specified savestate slot (any savestate data in that slot will be removed from memory).\nCheats addCheat Syntax\nemu.addCheat(cheatCode)  Parameters\ncheatCode - String A game genie format cheat code.\nReturn value\nNone\nDescription\nActivates a game genie cheat code (6 or 8 characters).\nNote: cheat codes added via this function are not permanent and not visible in the UI.\nclearCheats Syntax\nemu.clearCheats()  Return value\nNone\nDescription\nRemoves all active cheat codes (has no impact on cheat codes saved within the UI)\nMisc getLogWindowLog Syntax\nemu.getLogWindowLog()  Return value\nString A string containing the log shown in the log window\nDescription\nReturns the same text as what is shown in the emulator\u0026rsquo;s Log Window.\ngetRomInfo Syntax\nemu.getRomInfo()  Return value\nTable Information about the current ROM with the following structure:\nname: string, Filename of the current ROM path: string, Full path to the current ROM (including parent compressed archive when needed) fileCrc32Hash: int, The CRC32 value for the whole ROM file fileSha1Hash: string, The SHA1 hash for the whole ROM file prgChrCrc32Hash: int, The CRC32 value for the file, excluding its 16-byte header prgChrMd5Hash: string, The MD5 hash for the file, excluding its 16-byte header format: int, Value that represents the ROM format: 1 = iNES, 2 = UNIF, 3 = FDS, 4 = NSF isChrRam: bool true when the game uses CHR RAM, false otherwise  Description\nReturns information about the ROM file that is currently running.\ngetScriptDataFolder Syntax\nemu.getScriptDataFolder()  Return value\nString The script\u0026rsquo;s data folder\nDescription\nThis function returns the path to a unique folder (based on the script\u0026rsquo;s filename) where the script should store its data (if any data needs to be saved).\nThe data will be saved in subfolders inside the LuaScriptData folder in Mesen\u0026rsquo;s home folder.\ntakeScreenshot Syntax\nemu.takeScreenshot()  Return value\nString A binary string containing a PNG image.\nDescription\nTakes a screenshot and returns a PNG file as a string.\nThe screenshot is not saved to the disk.\n"
},
{
	"uri": "/apireference/enums.html",
	"title": "Enums",
	"tags": [],
	"description": "",
	"content": " eventType Syntax\nemu.eventType.[value]  Values\nreset = 0, Triggered when a soft reset occurs nmi = 1, Triggered when an nmi occurs irq = 2, Triggered when an irq occurs startFrame = 3, Triggered at the start of a frame (cycle 0, scanline -1) endFrame = 4, Triggered at the end of a frame (cycle 0, scanline 241) codeBreak = 5, Triggered when code execution breaks (e.g due to a breakpoint, etc.) stateLoaded = 6, Triggered when a user manually loads a savestate stateSaved = 7, Triggered when a user manually saves a savestate inputPolled = 8 Triggered when the emulation core polls the state of the input devices for the next frame  Description\nUsed by addEventCallback / removeEventCallback calls.\nexecuteCountType Syntax\nemu.executeCountType.[value]  Values\ncpuCycles = 0, Count the number of CPU cycles ppuCycles = 1, Count the number of PPU cycles cpuInstructions = 2 Count the number of CPU instructions  Description\nUsed by execute calls.\nmemCallbackType Syntax\nemu.memCallbackType.[value]  Values\ncpuRead = 0, Triggered when a read instruction is executed cpuWrite = 1, Triggered when a write instruction is executed cpuExec = 2, Triggered when any memory read occurs due to the CPU's code execution ppuRead = 3, Triggered when the PPU reads from its memory bus ppuWrite = 4 Triggered when the PPU writes to its memory bus  Description\nUsed by addMemoryCallback / removeMemoryCallback calls.\nmemType Syntax\nemu.memType.[value]  Values\ncpu = 0, CPU memory - $0000 to $FFFF Warning: Reading or writing to this memory type may cause side-effects! ppu = 1, PPU memory - $0000 to $3FFF Warning: Reading or writing to this memory type may cause side-effects! palette = 2, Palette memory - $00 to $3F oam = 3, OAM memory - $00 to $FF secondaryOam = 4, Secondary OAM memory - $00 to $1F prgRom = 5, PRG ROM - Range varies by game chrRom = 6, CHR ROM - Range varies by game chrRam = 7, CHR RAM - Range varies by game workRam = 8, Work RAM - Range varies by game saveRam = 9, Save RAM - Range varies by game cpuDebug = 256, CPU memory - $0000 to $FFFF Same as memType.cpu but does NOT cause any side-effects. ppuDebug = 257 PPU memory - $0000 to $3FFF Same as memType.ppu but does NOT cause any side-effects.  Description\nUsed by read / write calls.\n"
},
{
	"uri": "/apireference.html",
	"title": "Lua API reference",
	"tags": [],
	"description": "",
	"content": " This section documents the Mesen-specific Lua API that is available in scripts via the script window.\nChangelog The Lua is still a recent feature and not completely stable yet. To get a list of the major changes between different versions of Mesen, take a look at the Changelog.\nAPI References  Callbacks Drawing Emulation Input Logging Memory Access Miscellaneous Enums  "
},
{
	"uri": "/categories.html",
	"title": "Categories",
	"tags": [],
	"description": "",
	"content": ""
},
{
	"uri": "/tags.html",
	"title": "Tags",
	"tags": [],
	"description": "",
	"content": ""
}]