	// NOP_
SNSPC_OP(0x000,2);
SNSPC_ENDOP(2)

	// EI_
SNSPC_OP(0x0a0,3)
	SNSPC_SETFLAG_I();
SNSPC_ENDOP(3)

	// DI_
SNSPC_OP(0x0c0,3)
	SNSPC_CLRFLAG_I();
SNSPC_ENDOP(3)

	// CLV_
SNSPC_OP(0x0e0,2)
	SNSPC_SETFLAGI_V(0);
	SNSPC_SETFLAG_H(0);
SNSPC_ENDOP(2)

	// CLRC_
SNSPC_OP(0x060,2)
	SNSPC_SETFLAGI_C(0);
SNSPC_ENDOP(2)

	// SETC_
SNSPC_OP(0x080,2)
	SNSPC_SETFLAGI_C(1);
SNSPC_ENDOP(2)

	// NOTC_
SNSPC_OP(0x0ed,3)
	SNSPC_GETFLAG_C(t0);
	SNSPC_XORI(t0,1);
	SNSPC_SETFLAG_C(t0);
SNSPC_ENDOP(3)

	// CLRP_
SNSPC_OP(0x020,2)
	SNSPC_CLRFLAG_P();
SNSPC_ENDOP(2)

	// SETP_
SNSPC_OP(0x040,2)
	SNSPC_SETFLAG_P();
	SNSPC_CLRFLAG_I();
SNSPC_ENDOP(2)

	// PUSHA_
SNSPC_OP(0x02d,4)
	SNSPC_GET_A8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// PUSHX_
SNSPC_OP(0x04d,4)
	SNSPC_GET_X8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// PUSHY_
SNSPC_OP(0x06d,4)
	SNSPC_GET_Y8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// PUSHPSW_
SNSPC_OP(0x00d,4)
	SNSPC_GET_PSW8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// POPA_
SNSPC_OP(0x0ae,4)
	SNSPC_POP8(t0);
	SNSPC_SET_A8(t0);
SNSPC_ENDOP(4)

	// POPX_
SNSPC_OP(0x0ce,4)
	SNSPC_POP8(t0);
	SNSPC_SET_X8(t0);
SNSPC_ENDOP(4)

	// POPY_
SNSPC_OP(0x0ee,4)
	SNSPC_POP8(t0);
	SNSPC_SET_Y8(t0);
SNSPC_ENDOP(4)

	// POPPSW_
SNSPC_OP(0x08e,4)
	SNSPC_POP8(t0);
	SNSPC_SET_PSW8(t0);
SNSPC_ENDOP(4)

	// ASLA_
SNSPC_OP(0x01c,2)
	SNSPC_GET_A8(t1);
	SNSPC_SHLI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_ASL_
SNSPC_OP(0x00b,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SHLI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_ASL_
SNSPC_OP(0x01b,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SHLI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_ASL_
SNSPC_OP(0x00c,5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SHLI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// LSRA_
SNSPC_OP(0x05c,2)
	SNSPC_GET_A8(t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_LSR_
SNSPC_OP(0x04b,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_LSR_
SNSPC_OP(0x05b,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_LSR_
SNSPC_OP(0x04c,5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// ROLA_
SNSPC_OP(0x03c,2)
	SNSPC_GET_A8(t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_ROL_
SNSPC_OP(0x02b,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_ROL_
SNSPC_OP(0x03b,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_ROL_
SNSPC_OP(0x02c,5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// RORA_
SNSPC_OP(0x07c,2)
	SNSPC_GET_A8(t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_ROR_
SNSPC_OP(0x06b,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_ROR_
SNSPC_OP(0x07b,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_ROR_
SNSPC_OP(0x06c,5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// XCN_
SNSPC_OP(0x09f,5)
	SNSPC_GET_A8(t0);
	SNSPC_GET_A8(t1);
	SNSPC_SHLI(t0,4);
	SNSPC_SHRI(t1,4);
	SNSPC_OR(t1,t0);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_imm8_LDA_
SNSPC_OP(0x0e8,2)
	SNSPC_FETCH8(t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_LDA_
SNSPC_OP(0x0e6,3)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_x_indirect_inc_read_LDA_
SNSPC_OP(0x0bf,4)
	SNSPC_GET_X8(t0);
	SNSPC_ADDI(r_X,1);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_read_LDA_
SNSPC_OP(0x0e4,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_LDA_
SNSPC_OP(0x0f4,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_read_LDA_
SNSPC_OP(0x0e5,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_LDA_
SNSPC_OP(0x0f5,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_LDA_
SNSPC_OP(0x0f6,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_LDA_
SNSPC_OP(0x0e7,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_LDA_
SNSPC_OP(0x0f7,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(6)

	// addr_imm8_LDX_
SNSPC_OP(0x0cd,2)
	SNSPC_FETCH8(t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_LDX_
SNSPC_OP(0x0f8,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_dp_iy_read_LDX_
SNSPC_OP(0x0f9,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_read_LDX_
SNSPC_OP(0x0e9,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_imm8_LDY_
SNSPC_OP(0x08d,2)
	SNSPC_FETCH8(t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_LDY_
SNSPC_OP(0x0eb,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_LDY_
SNSPC_OP(0x0fb,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_read_LDY_
SNSPC_OP(0x0ec,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_x_indirect_STA_
SNSPC_OP(0x0c6,4)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_x_indirect_inc_STA_
SNSPC_OP(0x0af,4)
	SNSPC_GET_X8(t0);
	SNSPC_ADDI(r_X,1);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_STA_
SNSPC_OP(0x0c4,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_STA_
SNSPC_OP(0x0d4,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_STA_
SNSPC_OP(0x0c5,5)
	SNSPC_FETCH16(t0);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_ix_STA_
SNSPC_OP(0x0d5,6)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// addr_abs_iy_STA_
SNSPC_OP(0x0d6,6)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// addr_dp_ix_indirect_STA_
SNSPC_OP(0x0c7,7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(7)

	// addr_dp_indirect_iy_STA_
SNSPC_OP(0x0d7,7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(7)

	// addr_dp_STX_
SNSPC_OP(0x0d8,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_X8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_iy_STX_
SNSPC_OP(0x0d9,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_X8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_STX_
SNSPC_OP(0x0c9,5)
	SNSPC_FETCH16(t0);
	SNSPC_GET_X8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_dp_STY_
SNSPC_OP(0x0cb,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_Y8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_STY_
SNSPC_OP(0x0db,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_Y8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_STY_
SNSPC_OP(0x0cc,5)
	SNSPC_FETCH16(t0);
	SNSPC_GET_Y8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// MOV_A_X_
SNSPC_OP(0x07d,2)
	SNSPC_GET_X8(t0);
	SNSPC_SET_A8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_A_Y_
SNSPC_OP(0x0dd,2)
	SNSPC_GET_Y8(t0);
	SNSPC_SET_A8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_X_A_
SNSPC_OP(0x05d,2)
	SNSPC_GET_A8(t0);
	SNSPC_SET_X8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_Y_A_
SNSPC_OP(0x0fd,2)
	SNSPC_GET_A8(t0);
	SNSPC_SET_Y8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_X_SP_
SNSPC_OP(0x09d,2)
	SNSPC_GET_SP8(t0);
	SNSPC_SET_X8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_SP_X_
SNSPC_OP(0x0bd,2)
	SNSPC_GET_X8(t0);
	SNSPC_SET_SP8(t0);
SNSPC_ENDOP(2)

	// addr_dp_addr_dp_
SNSPC_OP(0x0fa,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_imm8_addr_dp_
SNSPC_OP(0x08f,5)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_imm8_ADC_
SNSPC_OP(0x088,2)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_ADC_
SNSPC_OP(0x086,3)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_ADC_
SNSPC_OP(0x084,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_ADC_
SNSPC_OP(0x094,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_ADC_
SNSPC_OP(0x085,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_ADC_
SNSPC_OP(0x095,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_ADC_
SNSPC_OP(0x096,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_ADC_
SNSPC_OP(0x087,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_ADC_
SNSPC_OP(0x097,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_ADCM_
SNSPC_OP(0x099,5)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_ADCM_
SNSPC_OP(0x089,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_ADCM_
SNSPC_OP(0x098,5)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_imm8_SBC_
SNSPC_OP(0x0a8,2)
	SNSPC_FETCH8(t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_SBC_
SNSPC_OP(0x0a6,3)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_SBC_
SNSPC_OP(0x0a4,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_SBC_
SNSPC_OP(0x0b4,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_SBC_
SNSPC_OP(0x0a5,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_SBC_
SNSPC_OP(0x0b5,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_SBC_
SNSPC_OP(0x0b6,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_SBC_
SNSPC_OP(0x0a7,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_SBC_
SNSPC_OP(0x0b7,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SBC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_SBCM_
SNSPC_OP(0x0b9,5)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_NOT8(t1);
	SNSPC_SBC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_SBCM_
SNSPC_OP(0x0a9,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_NOT8(t1);
	SNSPC_SBC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_SBCM_
SNSPC_OP(0x0b8,5)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_NOT8(t1);
	SNSPC_SBC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_imm8_CMPA_
SNSPC_OP(0x068,2)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_CMPA_
SNSPC_OP(0x066,3)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_CMPA_
SNSPC_OP(0x064,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_CMPA_
SNSPC_OP(0x074,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_CMPA_
SNSPC_OP(0x065,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_CMPA_
SNSPC_OP(0x075,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_CMPA_
SNSPC_OP(0x076,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_CMPA_
SNSPC_OP(0x067,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_CMPA_
SNSPC_OP(0x077,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_CMPX_
SNSPC_OP(0x0c8,2)
	SNSPC_FETCH8(t1);
	SNSPC_GET_X8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_dp_read_CMPX_
SNSPC_OP(0x03e,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_abs_read_CMPX_
SNSPC_OP(0x01e,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_imm8_CMPY_
SNSPC_OP(0x0ad,2)
	SNSPC_FETCH8(t1);
	SNSPC_GET_Y8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_dp_read_CMPY_
SNSPC_OP(0x07e,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_Y8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_abs_read_CMPY_
SNSPC_OP(0x05e,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_Y8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_y_indirect_addr_x_indirect_CMP_
SNSPC_OP(0x079,5)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_CMP_
SNSPC_OP(0x069,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_CMP_
SNSPC_OP(0x078,5)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_imm8_AND_
SNSPC_OP(0x028,2)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_AND_
SNSPC_OP(0x026,3)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_AND_
SNSPC_OP(0x024,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_AND_
SNSPC_OP(0x034,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_AND_
SNSPC_OP(0x025,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_AND_
SNSPC_OP(0x035,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_AND_
SNSPC_OP(0x036,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_AND_
SNSPC_OP(0x027,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_AND_
SNSPC_OP(0x037,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_ANDM_
SNSPC_OP(0x039,5)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_AND(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_ANDM_
SNSPC_OP(0x029,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_AND(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_ANDM_
SNSPC_OP(0x038,5)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_AND(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_imm8_ORA_
SNSPC_OP(0x008,2)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_ORA_
SNSPC_OP(0x006,3)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_ORA_
SNSPC_OP(0x004,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_ORA_
SNSPC_OP(0x014,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_ORA_
SNSPC_OP(0x005,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_ORA_
SNSPC_OP(0x015,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_ORA_
SNSPC_OP(0x016,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_ORA_
SNSPC_OP(0x007,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_ORA_
SNSPC_OP(0x017,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_ORM_
SNSPC_OP(0x019,5)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_OR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_ORM_
SNSPC_OP(0x009,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_OR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_ORM_
SNSPC_OP(0x018,5)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_OR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_imm8_EOR_
SNSPC_OP(0x048,2)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_EOR_
SNSPC_OP(0x046,3)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_EOR_
SNSPC_OP(0x044,3)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_EOR_
SNSPC_OP(0x054,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_EOR_
SNSPC_OP(0x045,4)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_EOR_
SNSPC_OP(0x055,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_EOR_
SNSPC_OP(0x056,5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_EOR_
SNSPC_OP(0x047,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_EOR_
SNSPC_OP(0x057,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,r_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_EORM_
SNSPC_OP(0x059,5)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_XOR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_EORM_
SNSPC_OP(0x049,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_XOR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_EORM_
SNSPC_OP(0x058,5)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_XOR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// DECA_
SNSPC_OP(0x09c,2)
	SNSPC_GET_A8(t1);
	SNSPC_SUBI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// DECX_
SNSPC_OP(0x01d,2)
	SNSPC_GET_X8(t1);
	SNSPC_SUBI(t1,1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// DECY_
SNSPC_OP(0x0dc,2)
	SNSPC_GET_Y8(t1);
	SNSPC_SUBI(t1,1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// INCA_
SNSPC_OP(0x0bc,2)
	SNSPC_GET_A8(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// INCX_
SNSPC_OP(0x03d,2)
	SNSPC_GET_X8(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// INCY_
SNSPC_OP(0x0fc,2)
	SNSPC_GET_Y8(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_INC_
SNSPC_OP(0x0ab,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_INC_
SNSPC_OP(0x0bb,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_INC_
SNSPC_OP(0x0ac,5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_dp_read_DEC_
SNSPC_OP(0x08b,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_DEC_
SNSPC_OP(0x09b,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_DEC_
SNSPC_OP(0x08c,5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_dp_read16_LDYA_
SNSPC_OP(0x0ba,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_SET_YA16(t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(5)

	// addr_dp_STYA_
SNSPC_OP(0x0da,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_GET_YA16(t1);
	SNSPC_WRITE16(t0,t1);
SNSPC_ENDOP(5)

	// addr_dp_read16_INC_
SNSPC_OP(0x03a,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE16(t0,t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(6)

	// addr_dp_read16_DEC_
SNSPC_OP(0x01a,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE16(t0,t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(6)

	// addr_dp_read16_ADC16_
SNSPC_OP(0x07a,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_GET_YA16(t2);
	SNSPC_ADC16(t2,t1);
	SNSPC_SET_YA16(t2);
	SNSPC_SETFLAG_Z16(t2);
	SNSPC_SETFLAG_N16(t2);
	SNSPC_SHRI(t2,16);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_read16_SBC16_
SNSPC_OP(0x09a,5)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_NOT16(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_GET_YA16(t2);
	SNSPC_ADC16(t2,t1);
	SNSPC_SET_YA16(t2);
	SNSPC_SETFLAG_Z16(t2);
	SNSPC_SETFLAG_N16(t2);
	SNSPC_SHRI(t2,16);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_read16_CMP16_
SNSPC_OP(0x05a,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_GET_YA16(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z16(t2);
	SNSPC_SETFLAG_N16(t2);
	SNSPC_SHRI(t2,16);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// MUL_
SNSPC_OP(0x0cf,9)
	SNSPC_GET_Y8(t0);
	SNSPC_GET_A8(t1);
	SNSPC_MUL(t1,t0);
	SNSPC_SET_YA16(t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(9)

	// addr_abs_CALL_
SNSPC_OP(0x03f,8)
	SNSPC_FETCH16(t0);
	SNSPC_GET_PC(t2);
	SNSPC_PUSH16(t2);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(8)

	// RTS_
SNSPC_OP(0x06f,5)
	SNSPC_POP16(t0);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(5)

	// addr_abs_JMP_
SNSPC_OP(0x05f,3)
	SNSPC_FETCH16(t0);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(3)

	// addr_abs_ix_indirect_JMP_
SNSPC_OP(0x01f,6)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,r_X);
	SNSPC_READ16(t0,t0);
	SNSPC_ANDI(t0,0xFFFF);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(6)

	// addr_dp_SET1_
SNSPC_OP(0x002,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x01);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x022,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x02);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x042,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x04);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x062,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x08);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x082,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x10);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x0a2,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x20);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x0c2,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x40);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x0e2,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x80);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x012,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x01);
	SNSPC_XORI(t1,0x01);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x032,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x02);
	SNSPC_XORI(t1,0x02);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x052,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x04);
	SNSPC_XORI(t1,0x04);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x072,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x08);
	SNSPC_XORI(t1,0x08);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x092,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x10);
	SNSPC_XORI(t1,0x10);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x0b2,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x20);
	SNSPC_XORI(t1,0x20);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x0d2,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x40);
	SNSPC_XORI(t1,0x40);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x0f2,4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,r_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x80);
	SNSPC_XORI(t1,0x80);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// TSET1_addr_abs_
SNSPC_OP(0x00e,6)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// TCLR1_addr_abs_
SNSPC_OP(0x04e,6)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t1,t2);
	SNSPC_XOR(t1,t2);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// PCALL_
SNSPC_OP(0x04f,6)
	SNSPC_FETCH8(t0);
	SNSPC_ADDI(t0,0xFF00);
	SNSPC_GET_PC(t1);
	SNSPC_PUSH16(t1);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(6)

	// MOV1_addr_abs_
SNSPC_OP(0x0aa,4)
	SNSPC_FETCH16(t0);
	SNSPC_MOVE(t2,t0);
	SNSPC_ANDI(t0,0x1FFF);
	SNSPC_SHRI(t2,13);
	SNSPC_READ8(t0,t1);
	SNSPC_SHR(t1,t2);
	SNSPC_ANDI(t1,1);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(4)

	// EOR1_addr_abs_
SNSPC_OP(0x08a,5)
	SNSPC_FETCH16(t0);
	SNSPC_MOVE(t2,t0);
	SNSPC_ANDI(t0,0x1FFF);
	SNSPC_SHRI(t2,13);
	SNSPC_READ8(t0,t1);
	SNSPC_SHR(t1,t2);
	SNSPC_ANDI(t1,1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// NOT1_addr_abs_
SNSPC_OP(0x0ea,5)
	SNSPC_FETCH16(t0);
	SNSPC_MOVE(t1,t0);
	SNSPC_GETI(t2,1);
	SNSPC_ANDI(t0,0x1FFF);
	SNSPC_SHRI(t1,13);
	SNSPC_SHL(t2,t1);
	SNSPC_READ8(t0,t1);
	SNSPC_XOR(t1,t2);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

// 199 ops completed
