	// NOP_
SNSPC_OP(0x000);
SNSPC_ENDOP(2)

	// EI_
SNSPC_OP(0x0a0)
	SNSPC_SETFLAG_I();
SNSPC_ENDOP(3)

	// DI_
SNSPC_OP(0x0c0)
	SNSPC_CLRFLAG_I();
SNSPC_ENDOP(3)

	// CLV_
SNSPC_OP(0x0e0)
	SNSPC_SETFLAGI_V(0);
	SNSPC_SETFLAG_H(0);
SNSPC_ENDOP(2)

	// CLRC_
SNSPC_OP(0x060)
	SNSPC_SETFLAGI_C(0);
SNSPC_ENDOP(2)

	// SETC_
SNSPC_OP(0x080)
	SNSPC_SETFLAGI_C(1);
SNSPC_ENDOP(2)

	// NOTC_
SNSPC_OP(0x0ed)
	SNSPC_GETFLAG_C(t0);
	SNSPC_XORI(t0,1);
	SNSPC_SETFLAG_C(t0);
SNSPC_ENDOP(3)

	// CLRP_
SNSPC_OP(0x020)
	SNSPC_CLRFLAG_P();
SNSPC_ENDOP(2)

	// SETP_
SNSPC_OP(0x040)
	SNSPC_SETFLAG_P();
	SNSPC_CLRFLAG_I();
SNSPC_ENDOP(2)

	// PUSHA_
SNSPC_OP(0x02d)
	SNSPC_GET_A8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// PUSHX_
SNSPC_OP(0x04d)
	SNSPC_GET_X8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// PUSHY_
SNSPC_OP(0x06d)
	SNSPC_GET_Y8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// PUSHPSW_
SNSPC_OP(0x00d)
	SNSPC_GET_PSW8(t0);
	SNSPC_PUSH8(t0);
SNSPC_ENDOP(4)

	// POPA_
SNSPC_OP(0x0ae)
	SNSPC_POP8(t0);
	SNSPC_SET_A8(t0);
SNSPC_ENDOP(4)

	// POPX_
SNSPC_OP(0x0ce)
	SNSPC_POP8(t0);
	SNSPC_SET_X8(t0);
SNSPC_ENDOP(4)

	// POPY_
SNSPC_OP(0x0ee)
	SNSPC_POP8(t0);
	SNSPC_SET_Y8(t0);
SNSPC_ENDOP(4)

	// POPPSW_
SNSPC_OP(0x08e)
	SNSPC_POP8(t0);
	SNSPC_SET_PSW8(t0);
SNSPC_ENDOP(4)

	// ASLA_
SNSPC_OP(0x01c)
	SNSPC_GET_A8(t1);
	SNSPC_SHLI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_ASL_
SNSPC_OP(0x00b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SHLI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_ASL_
SNSPC_OP(0x01b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SHLI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_ASL_
SNSPC_OP(0x00c)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SHLI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// LSRA_
SNSPC_OP(0x05c)
	SNSPC_GET_A8(t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_LSR_
SNSPC_OP(0x04b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_LSR_
SNSPC_OP(0x05b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_LSR_
SNSPC_OP(0x04c)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SETFLAG_C(t1);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// ROLA_
SNSPC_OP(0x03c)
	SNSPC_GET_A8(t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_ROL_
SNSPC_OP(0x02b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_ROL_
SNSPC_OP(0x03b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_ROL_
SNSPC_OP(0x02c)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t1,1);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
	SNSPC_SHRI(t1,8);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(5)

	// RORA_
SNSPC_OP(0x07c)
	SNSPC_GET_A8(t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_ROR_
SNSPC_OP(0x06b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_ROR_
SNSPC_OP(0x07b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_ROR_
SNSPC_OP(0x06c)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_SHLI(t2,8);
	SNSPC_SETFLAG_C(t1);
	SNSPC_OR(t1,t2);
	SNSPC_SHRI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// XCN_
SNSPC_OP(0x09f)
	SNSPC_GET_A8(t0);
	SNSPC_GET_A8(t1);
	SNSPC_SHLI(t0,4);
	SNSPC_SHRI(t1,4);
	SNSPC_OR(t1,t0);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_imm8_LDA_
SNSPC_OP(0x0e8)
	SNSPC_FETCH8(t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_LDA_
SNSPC_OP(0x0e6)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_x_indirect_inc_read_LDA_
SNSPC_OP(0x0bf)
	SNSPC_GET_X8(t0);
	SNSPC_ADDI(R_X,1);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_read_LDA_
SNSPC_OP(0x0e4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_LDA_
SNSPC_OP(0x0f4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_read_LDA_
SNSPC_OP(0x0e5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_LDA_
SNSPC_OP(0x0f5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_LDA_
SNSPC_OP(0x0f6)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_LDA_
SNSPC_OP(0x0e7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_LDA_
SNSPC_OP(0x0f7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(6)

	// addr_imm8_LDX_
SNSPC_OP(0x0cd)
	SNSPC_FETCH8(t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_LDX_
SNSPC_OP(0x0f8)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_dp_iy_read_LDX_
SNSPC_OP(0x0f9)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_read_LDX_
SNSPC_OP(0x0e9)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_imm8_LDY_
SNSPC_OP(0x08d)
	SNSPC_FETCH8(t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_LDY_
SNSPC_OP(0x0eb)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_LDY_
SNSPC_OP(0x0fb)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_abs_read_LDY_
SNSPC_OP(0x0ec)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_x_indirect_STA_
SNSPC_OP(0x0c6)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_x_indirect_inc_STA_
SNSPC_OP(0x0af)
	SNSPC_GET_X8(t0);
	SNSPC_ADDI(R_X,1);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_STA_
SNSPC_OP(0x0c4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_STA_
SNSPC_OP(0x0d4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_STA_
SNSPC_OP(0x0c5)
	SNSPC_FETCH16(t0);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_ix_STA_
SNSPC_OP(0x0d5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// addr_abs_iy_STA_
SNSPC_OP(0x0d6)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// addr_dp_ix_indirect_STA_
SNSPC_OP(0x0c7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(7)

	// addr_dp_indirect_iy_STA_
SNSPC_OP(0x0d7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_GET_A8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(7)

	// addr_dp_STX_
SNSPC_OP(0x0d8)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_X8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_iy_STX_
SNSPC_OP(0x0d9)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_X8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_STX_
SNSPC_OP(0x0c9)
	SNSPC_FETCH16(t0);
	SNSPC_GET_X8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_dp_STY_
SNSPC_OP(0x0cb)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_Y8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_STY_
SNSPC_OP(0x0db)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_Y8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_abs_STY_
SNSPC_OP(0x0cc)
	SNSPC_FETCH16(t0);
	SNSPC_GET_Y8(t1);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// MOV_A_X_
SNSPC_OP(0x07d)
	SNSPC_GET_X8(t0);
	SNSPC_SET_A8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_A_Y_
SNSPC_OP(0x0dd)
	SNSPC_GET_Y8(t0);
	SNSPC_SET_A8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_X_A_
SNSPC_OP(0x05d)
	SNSPC_GET_A8(t0);
	SNSPC_SET_X8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_Y_A_
SNSPC_OP(0x0fd)
	SNSPC_GET_A8(t0);
	SNSPC_SET_Y8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_X_SP_
SNSPC_OP(0x09d)
	SNSPC_GET_SP8(t0);
	SNSPC_SET_X8(t0);
	SNSPC_SETFLAG_N8(t0);
	SNSPC_SETFLAG_Z8(t0);
SNSPC_ENDOP(2)

	// MOV_SP_X_
SNSPC_OP(0x0bd)
	SNSPC_GET_X8(t0);
	SNSPC_SET_SP8(t0);
SNSPC_ENDOP(2)

	// addr_dp_addr_dp_
SNSPC_OP(0x0fa)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_imm8_addr_dp_
SNSPC_OP(0x08f)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

	// addr_imm8_ADC_
SNSPC_OP(0x088)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_ADC_
SNSPC_OP(0x086)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_ADC_
SNSPC_OP(0x084)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_ADC_
SNSPC_OP(0x094)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_ADC_
SNSPC_OP(0x085)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_ADC_
SNSPC_OP(0x095)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_ADC_
SNSPC_OP(0x096)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_ADC_
SNSPC_OP(0x087)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_ADC_
SNSPC_OP(0x097)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_ADCM_
SNSPC_OP(0x099)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_ADCM_
SNSPC_OP(0x089)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_ADCM_
SNSPC_OP(0x098)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_ADC8(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_imm8_SBC_
SNSPC_OP(0x0a8)
	SNSPC_FETCH8(t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_SBC_
SNSPC_OP(0x0a6)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_SBC_
SNSPC_OP(0x0a4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_SBC_
SNSPC_OP(0x0b4)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_SBC_
SNSPC_OP(0x0a5)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_SBC_
SNSPC_OP(0x0b5)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_SBC_
SNSPC_OP(0x0b6)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_SBC_
SNSPC_OP(0x0a7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_SBC_
SNSPC_OP(0x0b7)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_NOT8(t1);
	SNSPC_GET_A8(t2);
	SBC(t2);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_SBCM_
SNSPC_OP(0x0b9)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_NOT8(t1);
	SBC(t2);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_SBCM_
SNSPC_OP(0x0a9)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_NOT8(t1);
	SBC(t2);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_SBCM_
SNSPC_OP(0x0b8)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_NOT8(t1);
	SBC(t2);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_imm8_CMPA_
SNSPC_OP(0x068)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_CMPA_
SNSPC_OP(0x066)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_CMPA_
SNSPC_OP(0x064)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_CMPA_
SNSPC_OP(0x074)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_CMPA_
SNSPC_OP(0x065)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_CMPA_
SNSPC_OP(0x075)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_CMPA_
SNSPC_OP(0x076)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_CMPA_
SNSPC_OP(0x067)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_CMPA_
SNSPC_OP(0x077)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_CMPX_
SNSPC_OP(0x0c8)
	SNSPC_FETCH8(t1);
	SNSPC_GET_X8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_dp_read_CMPX_
SNSPC_OP(0x03e)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_abs_read_CMPX_
SNSPC_OP(0x01e)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_imm8_CMPY_
SNSPC_OP(0x0ad)
	SNSPC_FETCH8(t1);
	SNSPC_GET_Y8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(2)

	// addr_dp_read_CMPY_
SNSPC_OP(0x07e)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_Y8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(3)

	// addr_abs_read_CMPY_
SNSPC_OP(0x05e)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_Y8(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// addr_y_indirect_addr_x_indirect_CMP_
SNSPC_OP(0x079)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_CMP_
SNSPC_OP(0x069)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_CMP_
SNSPC_OP(0x078)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_SHRI(t2,8);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_imm8_AND_
SNSPC_OP(0x028)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_AND_
SNSPC_OP(0x026)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_AND_
SNSPC_OP(0x024)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_AND_
SNSPC_OP(0x034)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_AND_
SNSPC_OP(0x025)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_AND_
SNSPC_OP(0x035)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_AND_
SNSPC_OP(0x036)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_AND_
SNSPC_OP(0x027)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_AND_
SNSPC_OP(0x037)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_ANDM_
SNSPC_OP(0x039)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_AND(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_ANDM_
SNSPC_OP(0x029)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_AND(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_ANDM_
SNSPC_OP(0x038)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_AND(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_imm8_ORA_
SNSPC_OP(0x008)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_ORA_
SNSPC_OP(0x006)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_ORA_
SNSPC_OP(0x004)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_ORA_
SNSPC_OP(0x014)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_ORA_
SNSPC_OP(0x005)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_ORA_
SNSPC_OP(0x015)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_ORA_
SNSPC_OP(0x016)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_ORA_
SNSPC_OP(0x007)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_ORA_
SNSPC_OP(0x017)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_ORM_
SNSPC_OP(0x019)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_OR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_ORM_
SNSPC_OP(0x009)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_OR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_ORM_
SNSPC_OP(0x018)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_OR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_imm8_EOR_
SNSPC_OP(0x048)
	SNSPC_FETCH8(t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(2)

	// addr_x_indirect_read_EOR_
SNSPC_OP(0x046)
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_read_EOR_
SNSPC_OP(0x044)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(3)

	// addr_dp_ix_read_EOR_
SNSPC_OP(0x054)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_read_EOR_
SNSPC_OP(0x045)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(4)

	// addr_abs_ix_read_EOR_
SNSPC_OP(0x055)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_abs_iy_read_EOR_
SNSPC_OP(0x056)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_ix_indirect_read_EOR_
SNSPC_OP(0x047)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_dp_indirect_iy_read_EOR_
SNSPC_OP(0x057)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t0);
	SNSPC_ADD(t0,R_Y);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SET_A8(t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_y_indirect_addr_x_indirect_EORM_
SNSPC_OP(0x059)
	SNSPC_GET_Y8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_X8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_XOR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// addr_dp_addr_dp_EORM_
SNSPC_OP(0x049)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_XOR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(6)

	// addr_imm8_addr_dp_EORM_
SNSPC_OP(0x058)
	SNSPC_FETCH8(t1);
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t2);
	SNSPC_XOR(t2,t1);
	SNSPC_WRITE8(t0,t2);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
SNSPC_ENDOP(5)

	// DECA_
SNSPC_OP(0x09c)
	SNSPC_GET_A8(t1);
	SNSPC_SUBI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// DECX_
SNSPC_OP(0x01d)
	SNSPC_GET_X8(t1);
	SNSPC_SUBI(t1,1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// DECY_
SNSPC_OP(0x0dc)
	SNSPC_GET_Y8(t1);
	SNSPC_SUBI(t1,1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// INCA_
SNSPC_OP(0x0bc)
	SNSPC_GET_A8(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_SET_A8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// INCX_
SNSPC_OP(0x03d)
	SNSPC_GET_X8(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_SET_X8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// INCY_
SNSPC_OP(0x0fc)
	SNSPC_GET_Y8(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_SET_Y8(t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(2)

	// addr_dp_read_INC_
SNSPC_OP(0x0ab)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_INC_
SNSPC_OP(0x0bb)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_INC_
SNSPC_OP(0x0ac)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_dp_read_DEC_
SNSPC_OP(0x08b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(4)

	// addr_dp_ix_read_DEC_
SNSPC_OP(0x09b)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_ANDI(t0,0xFF);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_abs_read_DEC_
SNSPC_OP(0x08c)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE8(t0,t1);
	SNSPC_SETFLAG_Z8(t1);
	SNSPC_SETFLAG_N8(t1);
SNSPC_ENDOP(5)

	// addr_dp_read16_LDYA_
SNSPC_OP(0x0ba)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_SET_YA16(t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(5)

	// addr_dp_STYA_
SNSPC_OP(0x0da)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_GET_YA16(t1);
	SNSPC_WRITE16(t0,t1);
SNSPC_ENDOP(5)

	// addr_dp_read16_INC_
SNSPC_OP(0x03a)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_ADDI(t1,1);
	SNSPC_WRITE16(t0,t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(6)

	// addr_dp_read16_DEC_
SNSPC_OP(0x01a)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_SUBI(t1,1);
	SNSPC_WRITE16(t0,t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(6)

	// addr_dp_read16_ADC16_
SNSPC_OP(0x07a)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_GET_YA16(t2);
	SNSPC_ADC16(t2,t1);
	SNSPC_SET_YA16(t2);
	SNSPC_SETFLAG_Z16(t2);
	SNSPC_SETFLAG_N16(t2);
	SNSPC_SHRI(t2,16);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_read16_SBC16_
SNSPC_OP(0x09a)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_NOT16(t1);
	SNSPC_ADDI(t1,1);
	SNSPC_GET_YA16(t2);
	SNSPC_ADC16(t2,t1);
	SNSPC_SET_YA16(t2);
	SNSPC_SETFLAG_Z16(t2);
	SNSPC_SETFLAG_N16(t2);
	SNSPC_SHRI(t2,16);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// addr_dp_read16_CMP16_
SNSPC_OP(0x05a)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ16(t0,t1);
	SNSPC_GET_YA16(t2);
	SNSPC_SUB(t2,t1);
	SNSPC_SETFLAG_Z16(t2);
	SNSPC_SETFLAG_N16(t2);
	SNSPC_SHRI(t2,16);
	SNSPC_XORI(t2,1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(4)

	// MUL_
SNSPC_OP(0x0cf)
	SNSPC_GET_Y8(t0);
	SNSPC_GET_A8(t1);
	SNSPC_MUL(t1,t0);
	SNSPC_SET_YA16(t1);
	SNSPC_SETFLAG_Z16(t1);
	SNSPC_SETFLAG_N16(t1);
SNSPC_ENDOP(9)

	// addr_abs_CALL_
SNSPC_OP(0x03f)
	SNSPC_FETCH16(t0);
	SNSPC_GET_PC(t2);
	SNSPC_PUSH16(t2);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(8)

	// RTS_
SNSPC_OP(0x06f)
	SNSPC_POP16(t0);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(5)

	// addr_abs_JMP_
SNSPC_OP(0x05f)
	SNSPC_FETCH16(t0);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(3)

	// addr_abs_ix_indirect_JMP_
SNSPC_OP(0x01f)
	SNSPC_FETCH16(t0);
	SNSPC_ADD(t0,R_X);
	SNSPC_READ16(t0,t0);
	SNSPC_ANDI(t0,0xFFFF);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(6)

	// addr_dp_SET1_
SNSPC_OP(0x002)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x01);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x022)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x02);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x042)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x04);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x062)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x08);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x082)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x10);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x0a2)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x20);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x0c2)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x40);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_SET1_
SNSPC_OP(0x0e2)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x80);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x012)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x01);
	SNSPC_XORI(t1,0x01);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x032)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x02);
	SNSPC_XORI(t1,0x02);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x052)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x04);
	SNSPC_XORI(t1,0x04);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x072)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x08);
	SNSPC_XORI(t1,0x08);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x092)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x10);
	SNSPC_XORI(t1,0x10);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x0b2)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x20);
	SNSPC_XORI(t1,0x20);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x0d2)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x40);
	SNSPC_XORI(t1,0x40);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// addr_dp_CLR1_
SNSPC_OP(0x0f2)
	SNSPC_FETCH8(t0);
	SNSPC_ADD(t0,R_DP);
	SNSPC_READ8(t0,t1);
	SNSPC_ORI(t1,0x80);
	SNSPC_XORI(t1,0x80);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(4)

	// TSET1_addr_abs_
SNSPC_OP(0x00e)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t1,t2);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// TCLR1_addr_abs_
SNSPC_OP(0x04e)
	SNSPC_FETCH16(t0);
	SNSPC_READ8(t0,t1);
	SNSPC_GET_A8(t2);
	SNSPC_AND(t2,t1);
	SNSPC_SETFLAG_Z8(t2);
	SNSPC_SETFLAG_N8(t2);
	SNSPC_GET_A8(t2);
	SNSPC_OR(t1,t2);
	SNSPC_XOR(t1,t2);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(6)

	// PCALL_
SNSPC_OP(0x04f)
	SNSPC_FETCH8(t0);
	SNSPC_ADDI(t0,0xFF00);
	SNSPC_GET_PC(t1);
	SNSPC_PUSH16(t1);
	SNSPC_SET_PC16(t0);
SNSPC_ENDOP(6)

	// MOV1_addr_abs_
SNSPC_OP(0x0aa)
	SNSPC_FETCH16(t0);
	SNSPC_MOVE(t2,t0);
	SNSPC_ANDI(t0,0x1FFF);
	SNSPC_SHRI(t2,13);
	SNSPC_READ8(t0,t1);
	SNSPC_SHR(t1,t2);
	SNSPC_ANDI(t1,1);
	SNSPC_SETFLAG_C(t1);
SNSPC_ENDOP(4)

	// EOR1_addr_abs_
SNSPC_OP(0x08a)
	SNSPC_FETCH16(t0);
	SNSPC_MOVE(t2,t0);
	SNSPC_ANDI(t0,0x1FFF);
	SNSPC_SHRI(t2,13);
	SNSPC_READ8(t0,t1);
	SNSPC_SHR(t1,t2);
	SNSPC_ANDI(t1,1);
	SNSPC_GETFLAG_C(t2);
	SNSPC_XOR(t2,t1);
	SNSPC_SETFLAG_C(t2);
SNSPC_ENDOP(5)

	// NOT1_addr_abs_
SNSPC_OP(0x0ea)
	SNSPC_FETCH16(t0);
	SNSPC_MOVE(t1,t0);
	SNSPC_GETI(t2,1);
	SNSPC_ANDI(t0,0x1FFF);
	SNSPC_SHRI(t1,13);
	SNSPC_SHL(t2,t1);
	SNSPC_READ8(t0,t1);
	SNSPC_XOR(t1,t2);
	SNSPC_WRITE8(t0,t1);
SNSPC_ENDOP(5)

// 199 ops completed
