#!/bin/bash
# gets called with a wine path to the mame binary ($1), a command like -listxml ($2)
# and an output file wine path ($3)
w2l() {
  wine_path="$1"
  if [[ "$wine_path" =~ ^([A-Z]):\\ ]]; then
    drive="${BASH_REMATCH[1]}"
    linux_drive=$(readlink "$HOME/.wine/dosdevices/${drive}:")
    linux_path="${wine_path/${drive}:\\/$linux_drive/}"
    linux_path="${linux_path//\\//}"
  else
    echo "no valid wine path"
    return 1
  fi
  echo "$linux_path"
}
linuxExeFile="$(w2l "$1")"
linuxOutFile="$(w2l "$3")"
folder="$(dirname "$linuxExeFile")"
base="./$(basename "$linuxExeFile")"
cd "$folder"
$base "$2" > "$linuxOutFile"
