#pragma once
#ifndef _AVP_COMMON_H
#define _AVP_COMMON_H

#define AVP_SUPPORTED_HASH					0x1BCB3230DB41AA47ULL

//tried to correlate naming to available source, where possible, but a lot of this is just reverse engineered from disassembly.
#define AVP_CUR_LEVEL						0x0002F5AA //uint16
#define AVP_NEW_LEVEL						0x0002F5AC //uint16
#define AVP_NEW_X							0x0002F5AE //int32 (16:16 with maze coordinate packed in top 16, but whatever, just assume these sizes are correct and not much else)
#define AVP_NEW_Y							0x0002F5B2 //int32

#define AVP_MAZE_DATA						0x0004FC00
#define AVP_MAZE_BLOCK_SIZE					8
#define AVP_MAZE_PAD_DIMENSION				0
#define AVP_MAZE_MAX_WIDTH					(128 + AVP_MAZE_PAD_DIMENSION)
#define AVP_MAZE_MAX_HEIGHT					(128 + AVP_MAZE_PAD_DIMENSION)
#define AVP_MAZE_MAX_BLOCK_COUNT			(AVP_MAZE_MAX_WIDTH * AVP_MAZE_MAX_HEIGHT)
#define AVP_MAZE_MAX_SIZE					(AVP_MAZE_MAX_BLOCK_COUNT * AVP_MAZE_BLOCK_SIZE)

#define AVP_AMPS_PTR						0x0002F1B4 //uint32
#define AVP_GMPS_PTR						0x0002F1B8 //uint32
#define AVP_CLIST_PTR						0x0002F1BC //uint32
#define AVP_MAZE_WIDTH						0x0002F1C0 //int32
#define AVP_MAZE_HEIGHT						0x0002F1C4 //int32
#define AVP_SPRITE_RESCALE					0x0002F1C8 //uint16
#define AVP_TRUE_WIDTH						0x0002F1CA //uint16
#define AVP_CENTER_OFFSET					0x0002F1CC //uint16
#define AVP_X_POS							0x0002F1CE //int32 (copied to $3EAD8)
#define AVP_Y_POS							0x0002F1D2 //int32 (copied to $3EADC)
#define AVP_CENTER_ANGLE					0x0002F1D6 //int32
#define AVP_PLAYER_TYPE						0x0002F1DA //uint16
#define AVP_END_COUNT						0x0002F1DE //uint16
#define AVP_AMMO_SG							0x0002F214 //uint16
#define AVP_NEW_WEAPS						0x0002F30A //uint8
#define AVP_OLD_WEAPS						0x0002F30B //uint8
#define AVP_NEW_WEAPNO						0x0002F30C //uint16
#define AVP_FIRE_DAMAGE						0x0002F316 //uint16
#define AVP_IN_PAUSE						0x0002F378 //uint8
#define AVP_OBJ_OVER						0x0002F58C //uint32
#define AVP_INIT_MOVE						0x00030A34 //uint32
#define AVP_RESET_MOVE						0x00030A38 //uint32
#define AVP_DO_MOVE							0x00030A3C //uint32
#define AVP_NEW_POS							0x00030A40 //uint32
#define AVP_OLD_POS							0x00030A44 //uint32
#define AVP_ANG_VEL							0x00030A48 //uint16
#define AVP_ANG_ACC							0x00030A4A //uint16
#define AVP_MAX_AVEL						0x00030A4E //uint16
#define AVP_ACC_SHIFT						0x00030A50 //uint16
#define AVP_DECC_SHIFT						0x00030A52 //uint16
#define AVP_X_VEL							0x00030A54 //uint32
#define AVP_Y_VEL							0x00030A58 //uint32
#define AVP_PLAYER_VEL						0x00030A5C //uint16
#define AVP_PLAYER_DEAD						0x00030A60 //uint16
#define AVP_GAME_OVER						0x00030A62 //uint16
#define AVP_KEY_LOCK						0x00030A64 //uint16
#define AVP_DESTRUCT_FLAG					0x00030A66 //uint16
#define AVP_LAUNCH_FLAG						0x00030A68 //uint16
#define AVP_PLAYER_ENERGY					0x00030A6A //uint16
#define AVP_MAX_ENERGY						0x00030A6C //uint16
#define AVP_MAX_SPEED						0x00030A6E //uint32
#define AVP_PAIN_COLLS						0x00030A72 //uint32
#define AVP_SCORE							0x00030A76 //uint32
#define AVP_CHEAT							0x00030A7A //uint16
#define AVP_PAIN							0x00030A7C //uint16
#define AVP_OLD_ENERGY						0x00030A7E //uint16
#define AVP_LAST_MOAN						0x00030A80 //uint16
#define AVP_ACCESS_LEVEL					0x00030AD0 //uint8
#define AVP_CUR_ACCESS						0x00030AD2 //uint32
#define AVP_DISCFLAG						0x0003EAC2 //uint16
#define AVP_NEW_MESSAGE						0x00039834 //uint32
#define AVP_CHASE_X							0x0003EAD8 //int32
#define AVP_CHASE_Y							0x0003EADC //int32
#define AVP_AMP_PROXFLAG					0x00042AE0 //uint16
#define AVP_INV_TABLE						0x00042AE8 //uint8[16]
#define AVP_VBCOUNT							0x0002EEA0 //uint16
#define AVP_RENDER_VIEW_POS					0x00007FB0 //int32[2]

#define AVP_AMPOFS_XPOS						0 //int32
#define AVP_AMPOFS_YPOS						4 //int32
#define AVP_AMPOFS_MODE						8 //int32 (non-0 effectively means display/in-use)
#define AVP_AMPOFS_CREATURE					12 //int16
#define AVP_AMPOFS_ANIMSEQ					14 //int16
#define AVP_AMPOFS_ANIMFRAME				16 //int16
#define AVP_AMPOFS_ANGLE					18 //int16
#define AVP_AMPOFS_TIMER					20 //int32
#define AVP_AMPOFS_XVEL						24 //int16
#define AVP_AMPOFS_LAUNCHAMP				24 //int16
#define AVP_AMPOFS_YVEL						26 //int16
#define AVP_AMPOFS_LDIR						28 //int16
#define AVP_AMPOFS_XVEC						30 //int32
#define AVP_AMPOFS_YVEC						34 //int32
#define AVP_AMPOFS_ENERGY					38 //int16
#define AVP_AMPOFS_OLDENERGY				40 //int16
#define AVP_AMPOFS_FLAGWORD					42 //int16
#define AVP_AMPOFS_YOFFSET					44 //int16
#define AVP_AMPOFS_ASTYPE					46 //int16
#define AVP_AMPSIZE							48 //always align to 4 byte boundary
#define AVP_MAX_AMP_COUNT					300
#define AVP_AMP_TOTAL_SIZE					(AVP_AMPSIZE * AVP_MAX_AMP_COUNT)
#define AMP_FLAG_KILLABLE					(1 << 0)
#define AMP_FLAG_DEADGEN					(1 << 1)
#define AMP_FLAG_PLAYER						(1 << 2)
#define AMP_FLAG_DEAD						(1 << 3)
#define AMP_FLAG_COLLECT					(1 << 4)
#define AMP_FLAG_MOTION						(1 << 5)
#define AMP_FLAG_STUN						(1 << 6)
#define AMP_FLAG_PHIT						(1 << 7)
#define AMP_FLAG_CHATFLAG					(1 << 8)
#define AMP_FLAG_EGGOPEN					(1 << 9)
#define AMP_FLAG_CLOSEHIT					(1 << 10)
#define AMP_FLAG_INVHIT						(1 << 11)
#define AMP_FLAG_SSHIELD					(1 << 12)
#define AMP_FLAG_ALTFRAME					(1 << 15)
#define AMP_FLAG_AVATAR						(1 << 13) //claim an unused a bit
#define AMP_DEFAULT_AVATAR_FLAGS			(AMP_FLAG_KILLABLE | AMP_FLAG_MOTION | AMP_FLAG_AVATAR)

#define AVP_AVATAR_AMP_MODE					-1 //"static"
#define AVP_CURLEVEL_INVALID				0xFFFFFFFF

//not all of these are currently used, but figured i might as well leave some extras documented
#define AVP_PCADDR_COLLECTIT				0x0000F940
#define AVP_PCADDR_COLLECTIT_KILLEITHER		0x0000F91C
#define AVP_PCADDR_COLLECTIT_KILLCF			0x0000F922
#define AVP_PCADDR_COLLECTIT_KILLAMP		0x0000F938
#define AVP_PCADDR_COLLECTIT_KILLGRID		0x0000F93C
#define AVP_PCADDR_PLAYER_ATTACK_CHECK		0x0000FD1A
#define AVP_PCADDR_PLAYER_SHOOTLOOP			0x0000FD24
#define AVP_PCADDR_PLAYER_DAMAGE			0x0000FD9A //a1 = amp taking damage, d4/d5 = vec to amp, a4 = player x, a5 = player y, a6 = offset of hit
#define AVP_PCADDR_PLAYER_DAMAGE_RET		0x0000FE0E
#define AVP_PCADDR_CHECK_NEWLEVEL			0x0000C2FA //.not_comp
#define AVP_PCADDR_PROCESS_ENDGAME			0x0000C5AC
#define AVP_PCADDR_ENDGAME_DEATHYELL		0x0000C66A
#define AVP_PCADDR_ENDGAME_RET				0x0000C6E4
#define AVP_PCADDR_LIFT_DOOR				0x0001156A
#define AVP_PCADDR_LIFT_DOOR_ABORT			0x00011712
#define AVP_PCADDR_NORMAL_DOOR				0x00011670
#define AVP_PCADDR_MOVEDOORS				0x00011832
#define AVP_PCADDR_AIRLOCK_PRE_FIND_EXIT	0x00011B54
#define AVP_PCADDR_AIRLOCK_POST_FIND_EXIT	0x00011B58
#define AVP_PCADDR_CHECK_ACCESS				0x00011B7E
#define AVP_PCADDR_NO_ACCSND				0x00011C2A
#define AVP_PCADDR_SAFEPOS					0x000121A0
#define AVP_PCADDR_MAKE_AMP					0x00015078
#define AVP_PCADDR_REBUILD_LEVEL			0x000150C0
#define AVP_PCADDR_RAM_SAVE					0x00015176
#define AVP_PCADDR_AMP_REQ					0x000151E2
#define AVP_PCADDR_AMP_RELEASE				0x00015226
#define AVP_PCADDR_SAVE_LEVEL				0x00015242
#define AVP_PCADDR_RESTORE_LEVEL			0x00015272
#define AVP_PCADDR_RAND_SET					0x000153FA
#define AVP_PCADDR_UPDATE_AMPS				0x00015478
#define AVP_PCADDR_AMP_CHASE_PLAYER			0x0001555E
#define AVP_PCADDR_AMP_SLEEP				0x000156F4
#define AVP_PCADDR_AMP_SLEEP_TEST			0x00015700
#define AVP_PCADDR_AMP_DAMAGE_CHK			0x000157EE
#define AVP_PCADDR_AMP_CLOSE_FIGHT			0x00015836
#define AVP_PCADDR_AMP_CHKFAR				0x0001596A
#define AVP_PCADDR_AMP_HUMANMOVES			0x00015A94
#define AVP_PCADDR_AMP_OK_TO_MOVE			0x00015B8A
#define AVP_PCADDR_AMP_NOFACE				0x00015C86
#define AVP_PCADDR_AMP_RANGE_PLAYER			0x000163D0
#define AVP_PCADDR_AMP_THROWDISC			0x00016AEA
#define AVP_PCADDR_AMP_THROWDISC_RET		0x00016B7A
#define AVP_PCADDR_AMP_PRE_DISCMODE			0x00016B7C
#define AVP_PCADDR_AMP_LAUNCFIRE			0x00016C92
#define AVP_PCADDR_AMP_LAUNCHIT				0x00016CB8
#define AVP_PCADDR_AMP_LAUNCHIT_P0			0x00016D84
#define AVP_PCADDR_AMP_LAUNCHIT_P1			0x00016DE8
#define AVP_PCADDR_AMP_LAUNCHIT_P2			0x00016E4C
#define AVP_PCADDR_AMP_LAUNCHIT_P3			0x00016EB8
#define AVP_PCADDR_AMP_PRE_FLAMEON			0x00016EBA
#define AVP_PCADDR_AMP_FLAMEON				0x00016ED0
#define AVP_PCADDR_AMP_LASER				0x00017018
#define AVP_PCADDR_AMP_LASER_RET			0x00017120
#define AVP_PCADDR_AMP_WEAPON_HIT			0x0001718C
#define AVP_PCADDR_AMP_WEAPON_HIT_RET		0x0001719C
#define AVP_PCADDR_AMP_CHK_SQUARE			0x00017226
#define AVP_PCADDR_PLAYER_WEAPON			0x00017636
#define AVP_PCADDR_PLAYER_WEAPON_RET		0x000176E2
#define AVP_PCADDR_AMP_FIRE_HUG				0x00017CF6
#define AVP_PCADDR_AMP_FIRE_HUG_RET			0x00017D62
#define AVP_PCADDR_AMP_EXPLOSION			0x00018380
#define AVP_PCADDR_AMP_EXPLOSION_RET		0x00018430
#define AVP_PCADDR_OCCUPY_SQR				0x00017860
#define AVP_PCADDR_MAKE_SPARK				0x00018932
#define AVP_PCADDR_MAKE_SPARK_RET			0x00018A26
#define AVP_PCADDR_WEP_SFX					0x00009C3A
#define AVP_PCADDR_SFX						0x00009C6C
#define AVP_PCADDR_FINISH_ANGLES			0x0000FF04
#define AVP_PCADDR_JUST_SET_PARAMS			0x00009094
#define AVP_PCADDR_COPY_VIEWPOS_A			0x0000C4EE
#define AVP_PCADDR_COPY_VIEWPOS_B			0x0001551E
#define AVP_PCADDR_RUN_NEW_FRAME			0x0000C950
#define AVP_PCADDR_RUN_FRAME_NO_SWAP		0x0000C9A2
#define AVP_PCADDR_NEXTFRAME				0x0000C4DE
#define AVP_PCADDR_LOGIC_UPDATES			0x0000C576
#define AVP_PCADDR_CALL_SCR_OVERLAY_UPDATE	0x0000D41C
#define AVP_PCADDR_SCR_OVERLAY_UPDATE		0x0000D764
#define AVP_PCADDR_SCR_UPDATED_WEAPOL		0x0000D778
#define AVP_PCADDR_INGAME_RENDER_FINISH		0x0000C5AA
#define AVP_PCADDR_KILLAMBIENT				0x00009BE2
#define AVP_PCADDR_UPPER_MAIN_LOOP			0x00008618
#define AVP_PCADDR_EXIT_MAIN_LOOP			0x0000C304

#define AVP_COLLMAP							0x0003EAE0
#define AVP_OBJMAP							0x00040AE0
#define AVP_COLLMAP_SIZE					((64 * 2) * 64)
#define AVP_OBJMAP_SIZE						((64 * 2) * 64)
#define AVP_COLLMAP_GROUP_SIZE				256
#define AVP_COLLMAP_GROUP_COUNT				(AVP_COLLMAP_SIZE / AVP_COLLMAP_GROUP_SIZE)
#define AVP_OBJMAP_GROUP_SIZE				256
#define AVP_OBJMAP_GROUP_COUNT				(AVP_OBJMAP_SIZE / AVP_COLLMAP_GROUP_SIZE)

#define AVP_PT_HUMAN						0
#define AVP_PT_ALIEN						4
#define AVP_PT_PREDATOR						8
#define AVP_AC_ALIEN						0
#define AVP_AC_PREDATOR						1
#define AVP_AC_HUMAN						2
#define AVP_AC_EGG							3
#define AVP_AC_FACEHUG						4
#define AVP_AC_ACRAWL						5
#define AVP_AC_SMART						6
#define AVP_AC_BOLT							7
#define AVP_AC_FIRE							8

#define AVP_HUWEAP_SG						(1 << 1)
#define AVP_HUWEAP_AR						(1 << 2)
#define AVP_HUWEAP_FT						(1 << 3)
#define AVP_HUWEAP_CG						(1 << 4)

#endif //_AVP_COMMON_H
