/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import java.nio.file.Path;
import java.util.Optional;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.bus.md.GenesisBus;
import omegadrive.bus.md.SvpMapper;
import omegadrive.bus.model.BaseBusProvider;
import omegadrive.bus.model.GenesisBusProvider;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.cpu.m68k.MC68000Wrapper;
import omegadrive.cpu.ssp16.Ssp16;
import omegadrive.cpu.z80.Z80CoreWrapper;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.input.InputProvider;
import omegadrive.joypad.GenesisJoypad;
import omegadrive.joypad.JoypadProvider;
import omegadrive.memory.IMemoryProvider;
import omegadrive.memory.MemoryProvider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.sound.SoundProvider;
import omegadrive.system.BaseSystem;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.GenesisVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.util.MemView;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public class Genesis
extends BaseSystem<GenesisBusProvider> {
    public static final boolean verbose = false;
    public static final int NTSC_MCLOCK_MHZ = 53693175;
    public static final int PAL_MCLOCK_MHZ = 53203424;
    protected static final int MCLK_DIVIDER = 7;
    protected static final double VDP_RATIO = 0.5714285714285714;
    protected static final int M68K_DIVIDER = 1;
    static final double[] vdpVals = new double[]{2.2857142857142856, 2.8571428571428568};
    protected static final int Z80_DIVIDER = 2;
    protected static final int FM_DIVIDER = 6;
    private static final Logger LOG = LogHelper.getLogger((String)Genesis.class.getSimpleName());
    protected Z80Provider z80;
    protected M68kProvider cpu;
    protected Ssp16 ssp16 = Ssp16.NO_SVP;
    protected UpdatableViewer memView;
    protected boolean hasSvp = this.ssp16 != Ssp16.NO_SVP;
    protected double nextVdpCycle = vdpVals[0];
    protected int next68kCycle = 1;
    protected int nextZ80Cycle = 2;
    static final int SVP_CYCLES = 128;
    static final int SVP_CYCLES_MASK = 127;
    static final int SVP_RUN_CYCLES = 192;

    protected Genesis(DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = SystemLoader.SystemType.GENESIS;
    }

    public static SystemProvider createNewInstance(DisplayWindow emuFrame) {
        return new Genesis(emuFrame);
    }

    public void init() {
        this.stateHandler = BaseStateHandler.EMPTY_STATE;
        this.joypad = GenesisJoypad.create((SystemProvider.SystemClock)this);
        this.inputProvider = InputProvider.createInstance((JoypadProvider)this.joypad);
        this.memory = MemoryProvider.createGenesisInstance();
        this.bus = this.createBus();
        this.vdp = GenesisVdpProvider.createVdp((GenesisBusProvider)((GenesisBusProvider)this.bus));
        this.cpu = MC68000Wrapper.createInstance((GenesisBusProvider)((GenesisBusProvider)this.bus));
        this.z80 = Z80CoreWrapper.createInstance((SystemLoader.SystemType)this.getSystemType(), (BaseBusProvider)this.bus);
        this.sound = SoundProvider.NO_SOUND;
        ((GenesisBusProvider)this.bus).attachDevice((Device)this).attachDevice((Device)this.memory).attachDevice((Device)this.joypad).attachDevice((Device)this.vdp).attachDevice((Device)this.cpu).attachDevice((Device)this.z80);
        this.reloadWindowState();
        this.createAndAddVdpEventListener();
    }

    protected void loop() {
        this.updateVideoMode(true);
        do {
            this.run68k();
            this.runZ80();
            this.runFM();
            if (this.hasSvp && (this.cycleCounter & 0x7F) == 0) {
                this.ssp16.ssp1601_run(192);
            }
            this.runVdp();
            ++this.cycleCounter;
        } while (!this.futureDoneFlag);
    }

    protected final void runVdp() {
        if ((double)this.cycleCounter >= this.nextVdpCycle) {
            int vdpMclk = this.vdp.runSlot();
            this.nextVdpCycle += vdpVals[vdpMclk - 4];
        }
    }

    protected final void run68k() {
        if (this.cycleCounter == this.next68kCycle) {
            boolean isRunning = ((GenesisBusProvider)this.bus).is68kRunning();
            boolean canRun = !this.cpu.isStopped() && isRunning;
            int cycleDelay = 1;
            if (canRun) {
                Md32xRuntimeData.setAccessTypeExt(S32xUtil.CpuDeviceAccess.M68K);
                cycleDelay = this.cpu.runInstruction() + Md32xRuntimeData.resetCpuDelayExt();
            }
            if (isRunning) {
                ((GenesisBusProvider)this.bus).handleVdpInterrupts68k();
            }
            cycleDelay = Math.max(1, cycleDelay);
            this.next68kCycle += 1 * cycleDelay;
            assert (Md32xRuntimeData.resetCpuDelayExt() == 0);
        }
    }

    protected final void runZ80() {
        if (this.cycleCounter == this.nextZ80Cycle) {
            int cycleDelay = 0;
            boolean running = ((GenesisBusProvider)this.bus).isZ80Running();
            if (running) {
                Md32xRuntimeData.setAccessTypeExt(S32xUtil.CpuDeviceAccess.Z80);
                cycleDelay = this.z80.executeInstruction();
                ((GenesisBusProvider)this.bus).handleVdpInterruptsZ80();
                cycleDelay += Md32xRuntimeData.resetCpuDelayExt();
            }
            cycleDelay = Math.max(1, cycleDelay);
            this.nextZ80Cycle += 2 * cycleDelay;
            assert (Md32xRuntimeData.resetCpuDelayExt() == 0);
        }
    }

    protected final void runFM() {
        if ((this.cycleCounter & 1) == 0 && this.cycleCounter % 6 == 0) {
            ((GenesisBusProvider)this.bus).getFm().tick();
        }
    }

    protected GenesisBusProvider createBus() {
        return new GenesisBus();
    }

    protected void updateVideoMode(boolean force) {
        if (force || this.videoMode != this.vdp.getVideoMode()) {
            this.videoMode = this.vdp.getVideoMode();
            double microsPerTick = this.getMicrosPerTick();
            this.sound.getFm().setMicrosPerTick(microsPerTick);
            this.targetNs = (long)(this.getRegion().getFrameIntervalMs() * (double)Util.MILLI_IN_NS);
            LOG.info("Video mode changed: {}, microsPerTick: {}", (Object)this.videoMode, (Object)microsPerTick);
        }
    }

    private double getMicrosPerTick() {
        double mclkhz = this.videoMode.isPal() ? 5.3203424E7 : 5.3693175E7;
        return 1000000.0 / (mclkhz / 42.0);
    }

    protected RegionDetector.Region getRegionInternal(IMemoryProvider memory, String regionOvr) {
        RegionDetector.Region romRegion = RegionDetector.detectRegion((IMemoryProvider)memory);
        RegionDetector.Region ovrRegion = RegionDetector.getRegion((String)regionOvr);
        if (ovrRegion != null && ovrRegion != romRegion) {
            LOG.info("Setting region override from: {} to {}", (Object)romRegion, (Object)ovrRegion);
            romRegion = ovrRegion;
        }
        return romRegion;
    }

    protected SystemProvider.RomContext createRomContext(Path rom) {
        SystemProvider.RomContext rc = new SystemProvider.RomContext();
        rc.romPath = rom;
        MdCartInfoProvider mcip = MdCartInfoProvider.createInstance((IMemoryProvider)this.memory, (Path)rc.romPath);
        rc.cartridgeInfoProvider = mcip;
        String regionOverride = Optional.ofNullable(mcip.getEntry().forceRegion).orElse(this.emuFrame.getRegionOverride());
        rc.region = this.getRegionInternal(this.memory, regionOverride);
        return rc;
    }

    public void newFrame() {
        this.checkSvp();
        this.memView.update();
        super.newFrame();
    }

    private void checkSvp() {
        this.ssp16 = SvpMapper.ssp16;
        this.hasSvp = this.ssp16 != Ssp16.NO_SVP;
    }

    protected UpdatableViewer createMemView() {
        return MemView.createInstance((GenesisBusProvider)((GenesisBusProvider)this.bus), (VdpMemoryInterface)this.vdp.getVdpMemory());
    }

    protected void resetCycleCounters(int counter) {
        this.nextZ80Cycle = Math.max(1, this.nextZ80Cycle - counter);
        this.next68kCycle = Math.max(1, this.next68kCycle - counter);
        this.nextVdpCycle = Math.max(1.0, this.nextVdpCycle - (double)counter);
    }

    protected void initAfterRomLoad() {
        super.initAfterRomLoad();
        ((GenesisBusProvider)this.bus).attachDevice((Device)this.sound);
        this.vdp.addVdpEventListener((BaseVdpAdapterEventSupport.VdpEventListener)this.sound);
        this.resetAfterRomLoad();
        this.memView = this.createMemView();
    }

    protected void resetAfterRomLoad() {
        super.resetAfterRomLoad();
        this.cpu.reset();
        this.z80.reset();
    }

    protected void handleSoftReset() {
        if (this.softReset) {
            this.cpu.softReset();
        }
        super.handleSoftReset();
    }
}

