/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.sound.sampled.AudioFormat;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.bus.model.BaseBusProvider;
import omegadrive.sound.PwmProvider;
import omegadrive.sound.SoundDevice;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.fm.MdFmProvider;
import omegadrive.sound.fm.ym2413.Ym2413Provider;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.system.Sms;
import omegadrive.system.SystemProvider;
import omegadrive.system.gb.GbSoundWrapper;
import omegadrive.system.nes.NesSoundWrapper;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Size;
import omegadrive.vdp.model.BaseVdpAdapter;
import omegadrive.vdp.model.BaseVdpProvider;
import org.slf4j.Logger;
import s32x.Md32x;
import s32x.pwm.BlipPwmProvider;
import s32x.pwm.Pwm;
import s32x.pwm.S32xPwmProvider;

public class SysUtil {
    private static final Logger LOG = LogHelper.getLogger((String)SysUtil.class.getSimpleName());
    public static final String SMD_INTERLEAVED_EXT = ".smd";
    public static final String[] mdBinaryTypes = new String[]{".md", ".bin", ".smd"};
    public static final String[] sgBinaryTypes = new String[]{".sg", ".sc"};
    public static final String[] cvBinaryTypes = new String[]{".col"};
    public static final String[] msxBinaryTypes = new String[]{".rom"};
    public static final String[] smsBinaryTypes = new String[]{".sms"};
    public static final String[] ggBinaryTypes = new String[]{".gg"};
    public static final String[] nesBinaryTypes = new String[]{".nes"};
    public static final String[] gbBinaryTypes = new String[]{".gb"};
    public static final String[] s32xBinaryTypes = new String[]{".32x", ".bin", ".md"};
    public static final String[] compressedBinaryTypes = new String[]{".gz", ".zip"};
    public static final String[] binaryTypes = (String[])Stream.of(mdBinaryTypes, s32xBinaryTypes, compressedBinaryTypes).flatMap(Stream::of).toArray(String[]::new);
    public static final BaseBusProvider NO_OP_BUS = new BaseBusProvider(){

        public int read(int address, Size size) {
            return 0;
        }

        public void write(int address, int data, Size size) {
        }

        public void writeIoPort(int port, int value) {
        }

        public int readIoPort(int port) {
            return 0;
        }

        public BaseBusProvider attachDevice(Device device) {
            return null;
        }

        public <T extends Device> Optional<T> getBusDeviceIfAny(Class<T> clazz) {
            return Optional.empty();
        }

        public <T extends Device> Set<T> getAllDevices(Class<T> clazz) {
            return Collections.emptySet();
        }
    };
    public static final BaseVdpProvider NO_OP_VDP_PROVIDER = new BaseVdpAdapter();

    public static SystemProvider createSystemProvider(Path file, DisplayWindow display, boolean debugPerf) {
        String lowerCaseName = SystemLoader.handleCompressedFiles((Path)file, (String)file.toString().toLowerCase());
        if (lowerCaseName == null) {
            LOG.error("Unable to load file: " + (Comparable)(file != null ? file.toAbsolutePath() : "null"));
            return null;
        }
        SystemProvider systemProvider = null;
        boolean is32x = Arrays.stream(s32xBinaryTypes).anyMatch(lowerCaseName::endsWith);
        if (is32x) {
            systemProvider = Md32x.createNewInstance32x(display, debugPerf);
        }
        if (systemProvider == null) {
            LOG.error("Unable to find a system to load: {}", (Object)file.toAbsolutePath());
        }
        return systemProvider;
    }

    public static Map<SoundDevice.SoundDeviceType, SoundDevice> getSoundDevices(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        HashMap<SoundDevice.SoundDeviceType, SoundDevice> m = new HashMap<SoundDevice.SoundDeviceType, SoundDevice>();
        m.put(SoundDevice.SoundDeviceType.PSG, SysUtil.getPsgProvider(systemType, region));
        m.put(SoundDevice.SoundDeviceType.FM, SysUtil.getFmProvider(systemType, region));
        m.put(SoundDevice.SoundDeviceType.PWM, SysUtil.getPwmProvider(systemType, region));
        return m;
    }

    public static SoundDevice getPwmProvider(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        return switch (systemType) {
            case SystemLoader.SystemType.S32X -> {
                if (Pwm.PWM_USE_BLIP) {
                    yield new BlipPwmProvider(region);
                }
                yield new S32xPwmProvider(region);
            }
            default -> PwmProvider.NO_SOUND;
        };
    }

    public static SoundDevice getPsgProvider(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        PsgProvider psgProvider = PsgProvider.NO_SOUND;
        switch (systemType) {
            case MSX: {
                psgProvider = PsgProvider.createAyInstance((RegionDetector.Region)region, (int)SoundProvider.SAMPLE_RATE_HZ);
                break;
            }
            case NES: 
            case GB: {
                break;
            }
            default: {
                psgProvider = PsgProvider.createSnInstance((RegionDetector.Region)region, (int)SoundProvider.SAMPLE_RATE_HZ);
            }
        }
        return psgProvider;
    }

    public static SoundDevice getFmProvider(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        FmProvider fmProvider = FmProvider.NO_SOUND;
        switch (systemType) {
            case S32X: 
            case GENESIS: {
                fmProvider = MdFmProvider.createInstance((RegionDetector.Region)region, (AudioFormat)AbstractSoundManager.audioFormat);
                break;
            }
            case SMS: {
                if (!Sms.ENABLE_FM) break;
                fmProvider = Ym2413Provider.createInstance((AudioFormat)AbstractSoundManager.audioFormat);
                break;
            }
            case NES: {
                fmProvider = new NesSoundWrapper(region);
                break;
            }
            case GB: {
                fmProvider = new GbSoundWrapper(region);
                break;
            }
        }
        return fmProvider;
    }
}

