/*
 * Decompiled with CFR 0.152.
 */
package s32x.bus;

import java.io.Serializable;
import java.nio.ByteBuffer;
import omegadrive.Device;
import omegadrive.bus.md.GenesisBus;
import omegadrive.bus.model.GenesisBusProvider;
import omegadrive.sound.PwmProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import org.slf4j.Logger;
import s32x.DmaFifo68k;
import s32x.S32XMMREG;
import s32x.bus.Sh2Bus;
import s32x.dict.S32xDict;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.util.BiosHolder;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;
import s32x.vdp.MarsVdp;

public class S32xBus
extends GenesisBus
implements Sh2Bus.MdRomAccess {
    private static final Logger LOG = LogHelper.getLogger((String)S32xBus.class.getSimpleName());
    static final boolean verboseMd = false;
    private BiosHolder.BiosData bios68k;
    private S32XMMREG s32XMMREG;
    public Sh2Context masterCtx;
    public Sh2Context slaveCtx;
    private Sh2 sh2;
    private S32xBusContext busContext = new S32xBusContext();
    private int bankSetShift;

    public S32xBus() {
        this.bankSetShift = this.busContext.bankSetValue << 20;
        Util.writeData((byte[])this.busContext.writeableHint, (Size)Size.LONG, (int)0, (int)-1);
        Gs32xStateHandler.addDevice((Device)this);
    }

    public GenesisBusProvider attachDevice(Device device) {
        if (device instanceof Sh2) {
            this.sh2 = (Sh2)device;
        } else if (device instanceof S32XMMREG) {
            this.s32XMMREG = (S32XMMREG)device;
        }
        return super.attachDevice(device);
    }

    public void setRom(ByteBuffer b) {
        this.s32XMMREG.setCart(b.capacity());
    }

    public int getBankSetValue() {
        return this.busContext.bankSetValue;
    }

    public int read(int address, Size size) {
        int res = 0;
        res = this.s32XMMREG.aden > 0 ? this.readAdapterEnOn(address & 0xFFFFFF, size) : this.readAdapterEnOff(address & 0xFFFFFF, size);
        return res & size.getMask();
    }

    public void write(int address, int data, Size size) {
        data &= size.getMask();
        address &= 0xFFFFFF;
        if (this.s32XMMREG.aden > 0) {
            this.writeAdapterEnOn(address, data, size);
        } else {
            this.writeAdapterEnOff(address, data, size);
        }
    }

    private int readAdapterEnOn(int address, Size size) {
        int res = 0;
        if (address < 256) {
            res = this.bios68k.readBuffer(address, size);
            if (address >= 112 && address < 116) {
                res = this.readHIntVector(address, size);
            }
        } else if (address >= 0x880000 && address < 0x900000) {
            if (!DmaFifo68k.rv) {
                res = super.read(address & 0x7FFFF, size);
            } else {
                LOG.warn("Ignoring read access to ROM mirror when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th((int)address), size});
            }
        } else if (address >= 0x900000 && address < 0xA00000) {
            if (!DmaFifo68k.rv) {
                res = super.read(this.bankSetShift | address & 0xFFFFF, size);
            } else {
                LOG.warn("Ignoring read access to ROM mirror bank when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th((int)address), size});
            }
        } else if (address >= 0x840000 && address < 0x860000) {
            res = this.read32xWord(address & 0x1FFFF | 0x24000000, size);
        } else if (address >= 0x860000 && address < 0x880000) {
            res = this.read32xWord(address & 0x1FFFF | 0x24020000, size);
        } else if (address >= 10572032 && address < 10572160) {
            res = this.read32xWord(address & 0x7F | 0x20004000, size);
        } else if (address >= 10572160 && address < 10572288) {
            res = this.read32xWord(address & 0x7F | 0x20004100, size);
        } else if (address >= 10572288 && address < 10572800) {
            res = this.read32xWord(address & 0x1FF | 0x20004200, size);
        } else if (address >= 10563820 && address < 10563824) {
            assert (address == 10563820);
            res = 1296126547;
        } else {
            if (!DmaFifo68k.rv && (long)address <= 0x3FFFFFL) {
                LOG.warn("Ignoring read access to ROM when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th((int)address), size});
                return size.getMask();
            }
            res = super.read(address, size);
        }
        return res;
    }

    private int readAdapterEnOff(int address, Size size) {
        int res = 0;
        res = address >= 10563820 && address < 10563824 ? 1296126547 : (address >= 10572032 && address < 10572160 ? this.read32xWord(address & 0x7F | 0x20004000, size) : super.read(address, size));
        return res;
    }

    private void writeAdapterEnOn(int address, int data, Size size) {
        if (address >= 0x840000 && address < 0x860000) {
            this.write32xWord(address & 0x1FFFF | 0x24000000, data, size);
        } else if (address >= 0x860000 && address < 0x880000) {
            this.write32xWord(address & 0x1FFFF | 0x24020000, data, size);
        } else if (address >= 10572032 && address < 10572160) {
            int addr = address & 0x7F | 0x20004000;
            this.write32xWordDirect(addr, data, size);
            this.checkBankSetRegister(addr, size);
        } else if (address >= 10572160 && address < 10572288) {
            this.write32xWord(address & 0x7F | 0x20004100, data, size);
        } else if (address >= 10572288 && address < 10572800) {
            this.write32xWord(address & 0x1FF | 0x20004200, data, size);
        } else if (address >= 0x900000 && address < 0xA00000) {
            if (!DmaFifo68k.rv) {
                super.write(address & 0xFFFFF | this.bankSetShift, data, size);
            } else {
                LOG.warn("Ignoring write access to ROM mirror bank when RV={}, addr: {}, addr68k: {}, val: {} {}", new Object[]{DmaFifo68k.rv, Util.th((int)address), Util.th((int)(address & 0x7FFFF)), Util.th((int)data), size});
            }
        } else if (address >= 0x880000 && address < 0x900000) {
            if (!DmaFifo68k.rv) {
                super.write(address & 0x7FFFF, data, size);
            } else {
                LOG.warn("Ignoring write access to ROM mirror when RV={}, addr: {}, addr68k: {}, val: {} {}", new Object[]{DmaFifo68k.rv, Util.th((int)address), Util.th((int)(address & 0x7FFFF)), Util.th((int)data), size});
            }
        } else if (address >= 112 && address < 116) {
            Util.writeData((byte[])this.busContext.writeableHint, (Size)size, (int)(address & 3), (int)data);
        } else {
            if (address < 256) {
                LOG.warn("Ignoring write access to vector rom, RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th((int)address), size});
                return;
            }
            if (!DmaFifo68k.rv && (long)address <= 0x3FFFFFL) {
                LOG.warn("Ignoring write access to ROM when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th((int)address), size});
                return;
            }
            super.write(address, data, size);
        }
    }

    private void writeAdapterEnOff(int address, int data, Size size) {
        if (address >= 10572032 && address < 10572160) {
            int addr = address & 0x7F | 0x20004000;
            this.write32xWordDirect(addr, data, size);
            this.checkBankSetRegister(addr, size);
        } else {
            super.write(address, data, size);
        }
    }

    private void checkBankSetRegister(int address, Size size) {
        S32xDict.RegSpecS32x r = S32xDict.getRegSpec(S32xUtil.CpuDeviceAccess.M68K, address);
        if (r == S32xDict.RegSpecS32x.MD_BANK_SET) {
            int val = S32xUtil.readWordFromBuffer(this.s32XMMREG.regContext, r);
            this.busContext.bankSetValue = val & 3;
            this.bankSetShift = this.busContext.bankSetValue << 20;
        }
        assert (r != S32xDict.RegSpecS32x.MD_INT_CTRL || size != Size.LONG);
    }

    private void write32xWord(int address, int data, Size size) {
        if (this.s32XMMREG.fm > 0) {
            LOG.warn("Ignoring access to S32X memory from MD when FM={}, addr: {} {}", new Object[]{this.s32XMMREG.fm, Util.th((int)address), size});
            return;
        }
        this.write32xWordDirect(address, data, size);
    }

    private void write32xWordDirect(int address, int data, Size size) {
        if (size != Size.LONG) {
            this.s32XMMREG.write(address, data, size);
        } else {
            this.s32XMMREG.write(address, data >> 16 & 0xFFFF, Size.WORD);
            this.s32XMMREG.write(address + 2, data & 0xFFFF, Size.WORD);
        }
    }

    private int read32xWord(int address, Size size) {
        if (size != Size.LONG) {
            return this.s32XMMREG.read(address, size);
        }
        int res = this.s32XMMREG.read(address, Size.WORD) << 16;
        return res | this.s32XMMREG.read(address + 2, Size.WORD) & 0xFFFF;
    }

    private int readHIntVector(int address, Size size) {
        int res = Util.readData((byte[])this.busContext.writeableHint, (Size)Size.LONG, (int)0);
        res = res != -1 ? Util.readData((byte[])this.busContext.writeableHint, (Size)size, (int)(address & 3)) : this.bios68k.readBuffer(address, size);
        return res;
    }

    @Override
    public int readRom(int address, Size size) {
        assert ((long)address < 0x3FFFFFL);
        return super.read(address, size);
    }

    public MarsVdp getMarsVdp() {
        return this.s32XMMREG.getVdp();
    }

    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        super.onVdpEvent(event, value);
        switch (event) {
            case V_BLANK_CHANGE: {
                this.s32XMMREG.setVBlank((Boolean)value);
                break;
            }
            case H_BLANK_CHANGE: {
                this.s32XMMREG.setHBlank((Boolean)value);
                break;
            }
            case VIDEO_MODE: {
                this.s32XMMREG.updateVideoMode((VideoMode)value);
            }
        }
    }

    public S32XMMREG getS32XMMREG() {
        return this.s32XMMREG;
    }

    public void setBios68k(BiosHolder.BiosData bios68k) {
        this.bios68k = bios68k;
    }

    public PwmProvider getPwm() {
        return this.soundProvider.getPwm();
    }

    public void saveContext(ByteBuffer buffer) {
        super.saveContext(buffer);
        buffer.put(Util.serializeObject((Serializable)this.busContext));
    }

    public void loadContext(ByteBuffer buffer) {
        super.loadContext(buffer);
        Serializable s = Util.deserializeObject((byte[])buffer.array(), (int)0, (int)buffer.capacity());
        assert (s instanceof S32xBusContext);
        this.busContext = (S32xBusContext)s;
        this.bankSetShift = this.busContext.bankSetValue << 20;
    }

    public void resetSh2() {
        S32xUtil.CpuDeviceAccess cpu = Md32xRuntimeData.getAccessTypeExt();
        this.sh2.reset(this.masterCtx);
        this.sh2.reset(this.slaveCtx);
        this.masterCtx.devices.sh2MMREG.reset();
        this.slaveCtx.devices.sh2MMREG.reset();
        this.getS32XMMREG().fm = 0;
        Md32xRuntimeData.setAccessTypeExt(cpu);
    }

    static class S32xBusContext
    implements Serializable {
        public final byte[] writeableHint = new byte[4];
        public int bankSetValue;

        S32xBusContext() {
        }
    }
}

