/*
 * Decompiled with CFR 0.152.
 */
package s32x.bus;

import java.nio.ByteBuffer;
import omegadrive.Device;
import omegadrive.memory.ReadableByteMemory;
import omegadrive.util.Size;
import s32x.Sh2MMREG;
import s32x.sh2.Sh2;
import s32x.sh2.cache.Sh2Cache;
import s32x.sh2.prefetch.Sh2Prefetcher;
import s32x.util.BiosHolder;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public interface Sh2Bus
extends Sh2Prefetcher,
ReadableByteMemory,
Device {
    public static final boolean SH2_MEM_ACCESS_STATS = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.memAccess.stats", "false"));
    public static final MemoryDataCtx EMPTY = new MemoryDataCtx();

    public void write(int var1, int var2, Size var3);

    public int read(int var1, Size var2);

    public void resetSh2();

    default public Sh2MMREG getSh2MMREGS(S32xUtil.CpuDeviceAccess master) {
        return null;
    }

    default public MemoryDataCtx getMemoryDataCtx() {
        return EMPTY;
    }

    @Override
    default public void fetch(Sh2.FetchResult ft, S32xUtil.CpuDeviceAccess cpu) {
        ft.opcode = this.read16(ft.pc) & 0xFFFF;
    }

    @Override
    default public int fetchDelaySlot(int pc, Sh2.FetchResult ft, S32xUtil.CpuDeviceAccess cpu) {
        return this.read16(pc) & 0xFFFF;
    }

    default public void write8(int addr, byte val) {
        this.write(addr, val, Size.BYTE);
    }

    default public void write16(int addr, int val) {
        this.write(addr, val, Size.WORD);
    }

    default public void write32(int addr, int val) {
        this.write(addr, val, Size.LONG);
    }

    default public int read8(int addr) {
        return this.read(addr, Size.BYTE);
    }

    default public int read16(int addr) {
        return this.read(addr, Size.WORD);
    }

    default public int read32(int addr) {
        return this.read(addr, Size.LONG);
    }

    default public int readMemoryUncachedNoDelay(int address, Size size) {
        int delay = Md32xRuntimeData.getCpuDelayExt();
        int res = this.read(address | 0x20000000, size);
        Md32xRuntimeData.resetCpuDelayExt(delay);
        return res;
    }

    @Override
    default public void invalidateCachePrefetch(Sh2Cache.CacheInvalidateContext ctx) {
    }

    @Override
    default public void newFrame() {
    }

    public static class MemoryDataCtx {
        public int romSize;
        public int romMask;
        public ByteBuffer rom;
        public ByteBuffer sdram;
        public BiosHolder.BiosData[] bios;
    }

    public static interface MdRomAccess {
        public int readRom(int var1, Size var2);
    }
}

