/*
 * Decompiled with CFR 0.152.
 */
package s32x.dict;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.util.RegSpec;
import s32x.util.S32xUtil;
import s32x.vdp.MarsVdp;

public class S32xDict {
    private static final Logger LOG = LogHelper.getLogger((String)S32xDict.class.getSimpleName());
    public static final int S32X_REG_SIZE = 512;
    public static final int S32X_REG_MASK = 511;
    public static final int S32X_VDP_REG_MASK = 255;
    public static S32xRegType[] s32xRegTypeMapping = new S32xRegType[512];
    public static RegSpecS32x[][] s32xRegMapping = new RegSpecS32x[S32xRegCpuType.values().length][512];
    private static final S32xRegCpuType[] cpuToRegTypeMapper = new S32xRegCpuType[S32xUtil.CpuDeviceAccess.values().length];
    public static final int P32XS_FM = 32768;
    public static final int SH2_nCART_WORD = 256;
    public static final int SH2_nCART_BYTE = 1;
    public static final int P32XS_REN_POS = 7;
    public static final int P32XS_REN = 128;
    public static final int P32XS_nRES = 2;
    public static final int MD_ADEN_BIT = 1;
    public static final int MD_ADEN_BIT_POS = 0;
    public static final int SH2_ADEN_BYTE = 2;
    public static final int SH2_ADEN_WORD = 512;
    public static final int P32XS_FULL = 128;
    public static final int P32XS_68S = 4;
    public static final int P32XS_DMA = 2;
    public static final int P32XS_RV = 1;
    public static final int INTMASK_HEN_BIT_POS = 7;
    public static final int FBCR_VBLK_BIT_POS = 15;
    public static final int FBCR_HBLK_BIT_POS = 14;
    public static final int FBCR_FRAMESEL_BIT_POS = 0;
    public static final int FBCR_nFEN_BIT_POS = 1;
    public static final int P32XV_VBLK = 32768;
    public static final int P32XV_PAL = 32768;
    public static final int P32XV_PEN = 8192;
    public static final int P32XV_PRIO = 128;
    public static final int P32XV_240 = 64;
    public static final int SH2_PC_AREAS = 256;
    public static final int SH2_PC_AREA_SHIFT = 24;
    private static final int SH2_BOOT_ROM_SIZE = 16384;
    public static final int SH2_SDRAM_SIZE = 262144;
    private static final int SH2_MAX_ROM_SIZE = 0x400000;
    public static final int SH2_SDRAM_MASK = 262143;
    private static final int SH2_ROM_MASK = 0x3FFFFF;
    public static final int SH2_CACHE_THROUGH_OFFSET = 0x20000000;
    public static final int SH2_CACHE_THROUGH_MASK = 0xFFFFFFF;
    public static final int SH2_START_BOOT_ROM = 0x20000000;
    public static final int SH2_END_BOOT_ROM = 0x20004000;
    public static final int SH2_START_SDRAM_CACHE = 0x6000000;
    public static final int SH2_START_SDRAM = 0x26000000;
    public static final int SH2_END_SDRAM_CACHE = 0x6040000;
    public static final int SH2_END_SDRAM = 637796352;
    public static final int SH2_START_ROM_CACHE = 0x2000000;
    public static final int SH2_START_ROM = 0x22000000;
    public static final int SH2_END_ROM_CACHE = 0x2400000;
    public static final int SH2_END_ROM = 0x22400000;
    public static final int SH2_START_CACHE_FLUSH = 0x60000000;
    public static final int SH2_END_CACHE_FLUSH = Integer.MIN_VALUE;
    public static final int SH2_START_DATA_ARRAY = -1073741824;
    public static final int SH2_ONCHIP_REG_MASK = -536854528;
    public static final int SH2_START_DRAM_MODE = Short.MIN_VALUE;
    public static final int SH2_END_DRAM_MODE = -16384;
    public static final int SIZE_32X_SYSREG = 256;
    public static final int SIZE_32X_VDPREG = 256;
    public static final int SIZE_32X_COLPAL = 512;
    public static final int DRAM_SIZE = 131072;
    public static final int DRAM_MASK = 131071;
    public static final int S32X_MMREG_MASK = 255;
    public static final int S32X_COLPAL_MASK = 511;
    public static final int START_32X_SYSREG_CACHE = 16384;
    public static final int END_32X_SYSREG_CACHE = 16640;
    public static final int START_32X_VDPREG_CACHE = 16640;
    public static final int END_32X_VDPREG_CACHE = 16896;
    public static final int START_32X_COLPAL_CACHE = 16896;
    public static final int END_32X_COLPAL_CACHE = 17408;
    public static final int START_32X_SYSREG = 0x20004000;
    public static final int START_32X_VDPREG = 536887552;
    public static final int START_32X_COLPAL = 0x20004200;
    public static final int END_32X_SYSREG = 536887552;
    public static final int END_32X_VDPREG = 0x20004200;
    public static final int END_32X_COLPAL = 0x20004400;
    public static final int START_DRAM_CACHE = 0x4000000;
    public static final int END_DRAM_CACHE = 0x4020000;
    public static final int START_DRAM = 0x24000000;
    public static final int END_DRAM = 0x24020000;
    public static final int START_OVER_IMAGE_CACHE = 0x4020000;
    public static final int END_OVER_IMAGE_CACHE = 0x4040000;
    public static final int START_OVER_IMAGE = 0x24020000;
    public static final int END_OVER_IMAGE = 0x24040000;
    public static final int END_DRAM_OVER_MIRROR = 604372992;
    public static final int DRAM_OVER_MIRROR_MASK = -786433;
    public static final int M68K_START_HINT_VECTOR_WRITEABLE = 112;
    public static final int M68K_END_HINT_VECTOR_WRITEABLE = 116;
    public static final int M68K_END_VECTOR_ROM = 256;
    public static final int M68K_START_FRAME_BUFFER = 0x840000;
    public static final int M68K_END_FRAME_BUFFER = 0x860000;
    public static final int M68K_START_OVERWRITE_IMAGE = 0x860000;
    public static final int M68K_END_OVERWRITE_IMAGE = 0x880000;
    public static final int M68K_START_ROM_MIRROR = 0x880000;
    public static final int M68K_END_ROM_MIRROR = 0x900000;
    public static final int M68K_START_ROM_MIRROR_BANK = 0x900000;
    public static final int M68K_END_ROM_MIRROR_BANK = 0xA00000;
    public static final int M68K_ROM_WINDOW_MASK = 524287;
    public static final int M68K_ROM_MIRROR_MASK = 1048575;
    public static final int M68K_START_MARS_ID = 10563820;
    public static final int M68K_END_MARS_ID = 10563824;
    public static final int M68K_START_32X_SYSREG = 10572032;
    public static final int M68K_END_32X_SYSREG = 10572160;
    public static final int M68K_MASK_32X_SYSREG = 127;
    public static final int M68K_START_32X_VDPREG = 10572160;
    public static final int M68K_END_32X_VDPREG = 10572288;
    public static final int M68K_MASK_32X_VDPREG = 127;
    public static final int M68K_START_32X_COLPAL = 10572288;
    public static final int M68K_END_32X_COLPAL = 10572800;
    public static final int M68K_MASK_32X_COLPAL = 511;
    public static final int SH2_SYSREG_32X_OFFSET = 0x20004000;
    public static final int SH2_VDPREG_32X_OFFSET = 536887552;
    public static final int SH2_COLPAL_32X_OFFSET = 0x20004200;
    public static Set<Integer> z80RegAccess;

    private static S32xRegCpuType getCpuTypeFromDevice(S32xRegType deviceType, String name) {
        return deviceType == S32xRegType.NONE || deviceType == S32xRegType.COMM || deviceType == S32xRegType.PWM || deviceType == S32xRegType.VDP ? S32xRegCpuType.REG_BOTH : S32xRegCpuType.valueOf("REG_" + name.split("_")[0]);
    }

    public static void checkName(S32xUtil.CpuDeviceAccess cpu, RegSpecS32x regSpec, int address, Size size) {
        if (regSpec == null) {
            LOG.warn("{} 32X mmreg unknown reg: {} {}", new Object[]{cpu, Util.th((int)address), size});
        }
    }

    public static void logAccess(S32xDictLogContext logCtx, int address, int value, Size size) {
        LOG.info("{} 32x reg {} {} ({}) {} {}", new Object[]{logCtx.cpu, logCtx.read ? "read" : "write", size, logCtx.regSpec.getName(), Util.th((int)address), !logCtx.read ? ": " + Util.th((int)value) : ""});
    }

    public static void detectRegAccess(S32xDictLogContext logCtx, int address, int value, Size size) {
        String sformat = "%s %s %s, %s(%X), %4X %s %s";
        String evenOdd = (address & 1) == 0 ? "EVEN" : "ODD";
        String type = logCtx.read ? "R" : "W";
        RegSpecS32x regSpec = logCtx.regSpec;
        String s = null;
        int currentWord = S32xUtil.readBuffer(logCtx.regArea, regSpec.addr, Size.WORD);
        value = logCtx.read ? currentWord : value;
        switch (regSpec) {
            case VDP_BITMAP_MODE: {
                s = String.format(sformat, logCtx.cpu.toString(), type, regSpec.getName(), MarsVdp.BitmapMode.vals[value & 3].name(), value & 3, value, size.name(), evenOdd);
                break;
            }
            case FBCR: {
                String s1 = "D" + logCtx.fbD + "W" + logCtx.fbW + "|H" + (value >> 14 & 1) + "V" + (value >> 15 & 1);
                s = String.format(sformat, logCtx.cpu.toString(), type, regSpec.getName(), s1, value & 3, value, size.name(), evenOdd);
                break;
            }
            case SH2_INT_MASK: {
                if (logCtx.cpu == S32xUtil.CpuDeviceAccess.M68K) {
                    s = String.format(sformat, new Object[]{logCtx.cpu, type, regSpec.getName(), "[RESET: " + ((value & 3) >> 1) + ", ADEN: " + (value & 1) + "]", value & 3, value, size.name(), evenOdd});
                    break;
                }
                s = String.format(sformat, logCtx.cpu.toString(), type, regSpec.getName(), "", value, value, size.name(), evenOdd);
                break;
            }
            case MD_BANK_SET: {
                s = String.format(sformat, logCtx.cpu.toString(), type, regSpec.getName(), "", value & 3, value, size.name(), evenOdd);
                break;
            }
            case COMM0: 
            case COMM1: 
            case COMM2: 
            case COMM3: 
            case COMM4: 
            case COMM5: 
            case COMM6: 
            case COMM7: {
                if (logCtx.read) {
                    return;
                }
                int valueMem = S32xUtil.readBuffer(logCtx.regArea, address & 0x1FF & 0xFFFFFFFE, Size.LONG);
                String s2 = S32xDict.decodeComm(valueMem);
                s = String.format(sformat, logCtx.cpu.toString(), type, regSpec.getName(), s2, value, valueMem, size.name(), evenOdd);
                break;
            }
            default: {
                s = String.format(sformat, logCtx.cpu.toString(), type, regSpec.getName(), "", value, value, size.name(), evenOdd);
            }
        }
        if (s != null) {
            LOG.info(s);
        }
    }

    public static RegSpecS32x getRegSpec(S32xRegCpuType regCpuType, int address) {
        RegSpecS32x r = s32xRegMapping[regCpuType.ordinal()][address & 0x1FF];
        if (r == null) {
            LOG.error("{} unknown register at address: {}", (Object)regCpuType, (Object)Util.th((int)address));
        }
        return r;
    }

    public static RegSpecS32x getRegSpec(S32xUtil.CpuDeviceAccess cpu, int address) {
        RegSpecS32x r = s32xRegMapping[S32xRegCpuType.REG_BOTH.ordinal()][address & 0x1FF];
        if (r != null) {
            return r;
        }
        r = s32xRegMapping[cpuToRegTypeMapper[cpu.ordinal()].ordinal()][address & 0x1FF];
        if (r == null) {
            LOG.error("{} unknown register at address: {}", (Object)cpu, (Object)Util.th((int)address));
            r = RegSpecS32x.INVALID;
        }
        assert (cpu != S32xUtil.CpuDeviceAccess.Z80 || r != RegSpecS32x.AFSAR && r != RegSpecS32x.AFDR && r != RegSpecS32x.AFLR);
        return r;
    }

    public static void logZ80Access(S32xUtil.CpuDeviceAccess cpu, RegSpecS32x r, int address, Size size, boolean read) {
        if (cpu == S32xUtil.CpuDeviceAccess.Z80 && z80RegAccess.add(address)) {
            LOG.warn("{} {} access register {} at address: {} {}", new Object[]{cpu, read ? "read" : "write", r, Util.th((int)address), size});
        }
    }

    public static String decodeComm(int valueMem) {
        Object s1 = "";
        if (valueMem > 0x10000000) {
            s1 = "'" + (char)((valueMem & 0xFF000000) >> 24) + (char)((valueMem & 0xFF0000) >> 16) + (char)((valueMem & 0xFF00) >> 8) + (char)((valueMem & 0xFF) >> 0) + "'";
        } else if ((valueMem & 0xFFFF) > 4096) {
            s1 = "'" + (char)((valueMem & 0xFF00) >> 8) + (char)((valueMem & 0xFF) >> 0) + "'";
        }
        return s1;
    }

    static {
        S32xDict.cpuToRegTypeMapper[S32xUtil.CpuDeviceAccess.MASTER.ordinal()] = S32xRegCpuType.REG_SH2;
        S32xDict.cpuToRegTypeMapper[S32xUtil.CpuDeviceAccess.SLAVE.ordinal()] = S32xRegCpuType.REG_SH2;
        S32xDict.cpuToRegTypeMapper[S32xUtil.CpuDeviceAccess.M68K.ordinal()] = S32xRegCpuType.REG_MD;
        S32xDict.cpuToRegTypeMapper[S32xUtil.CpuDeviceAccess.Z80.ordinal()] = S32xRegCpuType.REG_MD;
        z80RegAccess = new HashSet<Integer>();
    }

    public static enum S32xRegType {
        NONE,
        VDP,
        PWM,
        SYS,
        COMM,
        DMA;

    }

    public static enum S32xRegCpuType {
        REG_MD,
        REG_SH2,
        REG_BOTH;

    }

    public static class S32xDictLogContext {
        public S32xUtil.CpuDeviceAccess cpu;
        public ByteBuffer regArea;
        public RegSpecS32x regSpec;
        public int fbD;
        public int fbW;
        public boolean read;
    }

    public static enum RegSpecS32x {
        SH2_INT_MASK(S32xRegType.SYS, 0, 32911),
        SH2_STBY_CHANGE(S32xRegType.SYS, 2),
        SH2_HCOUNT_REG(S32xRegType.SYS, 4, 255),
        SH2_DREQ_CTRL(S32xRegType.DMA, 6, 0),
        SH2_DREQ_SRC_ADDR_H(S32xRegType.DMA, 8, 255),
        SH2_DREQ_SRC_ADDR_L(S32xRegType.DMA, 10, 65534),
        SH2_DREQ_DEST_ADDR_H(S32xRegType.DMA, 12, 255),
        SH2_DREQ_DEST_ADDR_L(S32xRegType.DMA, 14, 4094),
        SH2_DREQ_LEN(S32xRegType.DMA, 16),
        SH2_FIFO_REG(S32xRegType.DMA, 18),
        SH2_VRES_INT_CLEAR(S32xRegType.SYS, 20),
        SH2_VINT_CLEAR(S32xRegType.SYS, 22),
        SH2_HINT_CLEAR(S32xRegType.SYS, 24),
        SH2_CMD_INT_CLEAR(S32xRegType.SYS, 26),
        SH2_PWM_INT_CLEAR(S32xRegType.SYS, 28),
        MD_ADAPTER_CTRL(S32xRegType.SYS, 0, 32771, 128),
        MD_INT_CTRL(S32xRegType.SYS, 2, 3),
        MD_BANK_SET(S32xRegType.SYS, 4, 3),
        MD_DMAC_CTRL(S32xRegType.DMA, 6, 7),
        MD_DREQ_SRC_ADDR_H(S32xRegType.DMA, 8),
        MD_DREQ_SRC_ADDR_L(S32xRegType.DMA, 10),
        MD_DREQ_DEST_ADDR_H(S32xRegType.DMA, 12),
        MD_DREQ_DEST_ADDR_L(S32xRegType.DMA, 14),
        MD_DREQ_LEN(S32xRegType.DMA, 16),
        MD_FIFO_REG(S32xRegType.DMA, 18),
        MD_SEGA_TV(S32xRegType.SYS, 26, 1),
        COMM0(S32xRegType.COMM, 32),
        COMM1(S32xRegType.COMM, 34),
        COMM2(S32xRegType.COMM, 36),
        COMM3(S32xRegType.COMM, 38),
        COMM4(S32xRegType.COMM, 40),
        COMM5(S32xRegType.COMM, 42),
        COMM6(S32xRegType.COMM, 44),
        COMM7(S32xRegType.COMM, 46),
        PWM_CTRL(S32xRegType.PWM, 48),
        PWM_CYCLE(S32xRegType.PWM, 50, 4095),
        PWM_LCH_PW(S32xRegType.PWM, 52, 4095),
        PWM_RCH_PW(S32xRegType.PWM, 54, 4095),
        PWM_MONO(S32xRegType.PWM, 56, 4095),
        VDP_BITMAP_MODE(S32xRegType.VDP, 256),
        SSCR(S32xRegType.VDP, 258, 1),
        AFLR(S32xRegType.VDP, 260, 255),
        AFSAR(S32xRegType.VDP, 262),
        AFDR(S32xRegType.VDP, 264),
        FBCR(S32xRegType.VDP, 266, 65532),
        INVALID(S32xRegType.NONE, -1);

        public final RegSpec regSpec;
        public final S32xRegCpuType regCpuType;
        public final S32xRegType deviceType;
        public final int addr;
        public final int deviceAccessTypeDelay;

        private RegSpecS32x(S32xRegType deviceType, int addr, int writeAndMask, int writeOrMask) {
            this.deviceType = deviceType;
            this.deviceAccessTypeDelay = deviceType == S32xRegType.VDP ? 3 : 4;
            this.regCpuType = S32xDict.getCpuTypeFromDevice(deviceType, this.name());
            this.regSpec = this.createRegSpec(addr, writeAndMask, writeOrMask);
            this.addr = this.regSpec.bufferAddr;
            this.init();
        }

        private RegSpecS32x(S32xRegType deviceType, int addr) {
            this(deviceType, addr, 65535, 0);
        }

        private RegSpecS32x(S32xRegType deviceType, int addr, int writeAndMask) {
            this(deviceType, addr, writeAndMask, 0);
        }

        private RegSpec createRegSpec(int addr, int writeAndMask, int writeOrMask) {
            return this.deviceType == S32xRegType.NONE ? RegSpec.INVALID_REG : new RegSpec(this.name(), addr, this.deviceType != S32xRegType.VDP ? 511 : 255, writeAndMask, writeOrMask, Size.WORD);
        }

        private void init() {
            if (this.deviceType == S32xRegType.NONE) {
                return;
            }
            int addrLen = this.regSpec.regSize.getByteSize();
            for (int i = this.regSpec.fullAddr; i < this.regSpec.fullAddr + addrLen; ++i) {
                S32xDict.s32xRegMapping[this.regCpuType.ordinal()][i] = this;
                S32xDict.s32xRegTypeMapping[i] = this.deviceType;
                if (this.regCpuType != S32xRegCpuType.REG_BOTH) continue;
                S32xDict.s32xRegMapping[S32xRegCpuType.REG_MD.ordinal()][i] = this;
                S32xDict.s32xRegMapping[S32xRegCpuType.REG_SH2.ordinal()][i] = this;
            }
        }

        public int getAddrMask() {
            return this.regSpec.addrMask;
        }

        public String getName() {
            return this.regSpec.name;
        }
    }
}

