/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

import java.io.Serializable;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;
import s32x.sh2.Sh2Context;
import s32x.sh2.drc.Sh2Block;

public interface Sh2
extends Device {
    public static final Logger LOG = LogHelper.getLogger((String)Sh2.class.getSimpleName());
    public static final int posT = 0;
    public static final int posS = 1;
    public static final int posQ = 8;
    public static final int posM = 9;
    public static final int flagT = 1;
    public static final int flagS = 2;
    public static final int flagIMASK = 240;
    public static final int flagQ = 256;
    public static final int flagM = 512;
    public static final int SR_MASK = 1011;
    public static final int ILLEGAL_INST_VN = 4;
    public static final int STACK_LIMIT_SIZE = 4096;

    public void reset(Sh2Context var1);

    public void run(Sh2Context var1);

    public void setCtx(Sh2Context var1);

    default public void printDebugMaybe(int opcode) {
    }

    public static class Sh2Config {
        public static final Sh2Config DEFAULT_CONFIG = new Sh2Config();
        private static final AtomicReference<Sh2Config> instance = new AtomicReference<Sh2Config>(DEFAULT_CONFIG);
        public final boolean prefetchEn;
        public final boolean drcEn;
        public final boolean pollDetectEn;
        public final boolean ignoreDelays;
        public final boolean tasQuirk;

        private Sh2Config() {
            this.tasQuirk = true;
            this.ignoreDelays = false;
            this.pollDetectEn = false;
            this.drcEn = false;
            this.prefetchEn = false;
            LOG.info("Default config: {}", (Object)this);
        }

        public Sh2Config(boolean prefetchEn, boolean drcEn, boolean pollDetectEn, boolean ignoreDelays) {
            this(prefetchEn, drcEn, pollDetectEn, ignoreDelays, 1);
        }

        public Sh2Config(boolean prefetchEn, boolean drcEn, boolean pollDetectEn, boolean ignoreDelays, int tasQuirk) {
            this.prefetchEn = prefetchEn;
            this.drcEn = drcEn;
            this.pollDetectEn = pollDetectEn;
            this.ignoreDelays = ignoreDelays;
            boolean bl = this.tasQuirk = tasQuirk > 0;
            if (instance.compareAndSet(DEFAULT_CONFIG, this)) {
                LOG.info("Using config: {}", (Object)this);
            } else {
                LOG.error("Ignoring config: {}, current: {}", (Object)this, instance);
            }
        }

        public static Sh2Config get() {
            return instance.get();
        }

        public static void reset(Sh2Config config) {
            instance.set(config);
            LOG.warn("Overriding config: {}", (Object)config);
        }

        public String toString() {
            return new StringJoiner(", ", Sh2Config.class.getSimpleName() + "[", "]").add("prefetchEn=" + this.prefetchEn).add("drcEn=" + this.drcEn).add("pollDetectEn=" + this.pollDetectEn).add("ignoreDelays=" + this.ignoreDelays).toString();
        }
    }

    public static class FetchResult
    implements Serializable {
        public int pc;
        public int opcode;
        public transient Sh2Block block;

        public String toString() {
            return new StringJoiner(", ", FetchResult.class.getSimpleName() + "[", "]").add("pc=" + this.pc).add("opcode=" + this.opcode).add("block=" + this.block).toString();
        }
    }
}

