/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.StringJoiner;
import omegadrive.Device;
import omegadrive.util.Util;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.Sh2;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.sh2.drc.Sh2Block;
import s32x.util.S32xUtil;

public class Sh2Context
implements Device,
Serializable {
    static final int NUM_REG = 16;
    public static int burstCycles = 1;
    public final int[] registers = new int[16];
    public int GBR;
    public int VBR;
    public int SR;
    public int MACH;
    public int MACL;
    public int PR;
    public int PC;
    public int opcode;
    public int delayPC;
    public int cycles;
    public int cycles_ran;
    public final S32xUtil.CpuDeviceAccess cpuAccess;
    public final String sh2TypeCode;
    public boolean delaySlot;
    public final boolean debug;
    public Sh2.FetchResult fetchResult;
    public transient Sh2DeviceHelper.Sh2DeviceContext devices;

    public Sh2Context(S32xUtil.CpuDeviceAccess cpuAccess) {
        this(cpuAccess, false);
    }

    public Sh2Context(S32xUtil.CpuDeviceAccess cpuAccess, boolean debug) {
        this.cpuAccess = cpuAccess;
        this.sh2TypeCode = cpuAccess.name().substring(0, 1);
        this.fetchResult = new Sh2.FetchResult();
        this.fetchResult.block = Sh2Block.INVALID_BLOCK;
        this.debug = debug;
        Gs32xStateHandler.addDevice(this);
    }

    public void saveContext(ByteBuffer buffer) {
        super.saveContext(buffer);
        buffer.put(Util.serializeObject((Serializable)this));
    }

    public void loadContext(ByteBuffer buffer) {
        super.loadContext(buffer);
        Serializable s = Util.deserializeObject((byte[])buffer.array(), (int)0, (int)buffer.capacity());
        assert (s instanceof Sh2Context);
        this.loadContext((Sh2Context)s);
    }

    public void loadContext(Sh2Context ctx) {
        assert (ctx.cpuAccess == this.cpuAccess);
        System.arraycopy(ctx.registers, 0, this.registers, 0, this.registers.length);
        this.PC = ctx.PC;
        this.opcode = ctx.opcode;
        this.delaySlot = ctx.delaySlot;
        this.delayPC = ctx.delayPC;
        this.GBR = ctx.GBR;
        this.VBR = ctx.VBR;
        this.SR = ctx.SR;
        this.MACH = ctx.MACH;
        this.MACL = ctx.MACL;
        this.PR = ctx.PR;
        this.cycles = ctx.cycles;
        this.cycles_ran = ctx.cycles_ran;
        this.fetchResult.block = Sh2Block.INVALID_BLOCK;
        this.fetchResult.pc = 0;
        this.fetchResult.opcode = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sh2Context that = (Sh2Context)o;
        return this.GBR == that.GBR && this.VBR == that.VBR && this.SR == that.SR && this.MACH == that.MACH && this.MACL == that.MACL && this.PR == that.PR && this.PC == that.PC && this.delaySlot == that.delaySlot && this.cpuAccess == that.cpuAccess && Objects.equal((Object)this.sh2TypeCode, (Object)that.sh2TypeCode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.GBR, this.VBR, this.SR, this.MACH, this.MACL, this.PR, this.PC, this.cpuAccess, this.sh2TypeCode, this.delaySlot});
    }

    public String toString() {
        return new StringJoiner(", ", Sh2Context.class.getSimpleName() + "[", "]").add("registers=" + Arrays.toString(this.registers)).add("GBR=" + this.GBR).add("VBR=" + this.VBR).add("SR=" + this.SR).add("MACH=" + this.MACH).add("MACL=" + this.MACL).add("PR=" + this.PR).add("PC=" + this.PC).add("opcode=" + this.opcode).add("delayPC=" + this.delayPC).add("cycles=" + this.cycles).add("cycles_ran=" + this.cycles_ran).add("cpuAccess=" + this.cpuAccess).add("sh2TypeCode='" + this.sh2TypeCode + "'").add("delaySlot=" + this.delaySlot).add("debug=" + this.debug).add("fetchResult=" + this.fetchResult).toString();
    }
}

