/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import omegadrive.cpu.CpuFastDebug;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.sh2.Sh2Helper;
import s32x.sh2.Sh2Impl;

public class Sh2Debug
extends Sh2Impl
implements CpuFastDebug.CpuDebugInfoProvider {
    private static final Logger LOG = LogHelper.getLogger((String)Sh2Debug.class.getSimpleName());
    public static final Map<Integer, Integer> areaMaskMap = ImmutableMap.builder().put((Object)0, (Object)Short.MAX_VALUE).put((Object)2, (Object)0x3FFFFF).put((Object)4, (Object)262143).put((Object)6, (Object)262143).put((Object)32, (Object)Short.MAX_VALUE).put((Object)34, (Object)0x3FFFFF).put((Object)36, (Object)262143).put((Object)38, (Object)262143).put((Object)192, (Object)65535).build();
    public static final int[] pcAreaMaskMap = new int[256];
    public static final Predicate<Integer> isBranchOpcode;
    public static final Predicate<Integer> isCmpOpcode;
    public static final Predicate<Integer> isTstOpcode;
    public static final Predicate<Integer> isMovOpcode;
    private static final Predicate<Integer> isNopOpcode;
    public static final Predicate<Integer> isLoopOpcode;
    public static final Predicate<Integer> isIgnoreOpcode;
    private final CpuFastDebug[] fastDebug = new CpuFastDebug[2];
    private static CpuFastDebug.PcInfoWrapper[][] piw;

    public Sh2Debug(Sh2Bus memory) {
        super(memory);
        LOG.warn("Sh2 cpu: creating debug instance");
        this.init();
    }

    public void init() {
        this.fastDebug[0] = new CpuFastDebug((CpuFastDebug.CpuDebugInfoProvider)this, Sh2Debug.createContext());
        this.fastDebug[1] = new CpuFastDebug((CpuFastDebug.CpuDebugInfoProvider)this, Sh2Debug.createContext());
        this.fastDebug[0].debugMode = CpuFastDebug.DebugMode.NEW_INST_ONLY;
        this.fastDebug[1].debugMode = CpuFastDebug.DebugMode.NEW_INST_ONLY;
        piw = this.fastDebug[0].pcInfoWrapper;
    }

    @Override
    public final void printDebugMaybe(int opcode) {
        this.ctx.opcode = opcode;
        int n = this.ctx.cpuAccess.ordinal();
        this.fastDebug[n].isBusyLoop(this.ctx.PC & 0xFFFFFFF, this.ctx.opcode);
        this.fastDebug[n].printDebugMaybe();
        if ((this.ctx.PC & 1) > 0) {
            LOG.error("Odd PC: {}", (Object)Util.th((int)this.ctx.PC));
            throw new RuntimeException("Odd PC");
        }
    }

    public static CpuFastDebug.CpuDebugContext createContext() {
        CpuFastDebug.CpuDebugContext ctx = new CpuFastDebug.CpuDebugContext(areaMaskMap);
        ctx.pcAreaShift = 24;
        ctx.isLoopOpcode = isLoopOpcode;
        ctx.isIgnoreOpcode = isIgnoreOpcode;
        return ctx;
    }

    public String getInstructionOnly(int pc) {
        return Sh2Helper.getInstString(this.ctx.sh2TypeCode, pc, this.memory.read16(pc));
    }

    public String getInstructionOnly() {
        return Sh2Helper.getInstString(this.ctx);
    }

    public String getCpuState(String head) {
        return Sh2Helper.toDebuggingString(this.ctx);
    }

    public int getPc() {
        return this.ctx.PC;
    }

    public int getOpcode() {
        return this.ctx.opcode;
    }

    static {
        for (Map.Entry<Integer, Integer> e : areaMaskMap.entrySet()) {
            Sh2Debug.pcAreaMaskMap[e.getKey().intValue()] = e.getValue();
        }
        isBranchOpcode = op -> (op & 0xFF00) == 35072 || (op & 0xFF00) == 35584 || (op & 0xFF00) == 36608 || (op & 0xFF00) == 36096 || (op & 0xF000) == 40960;
        isCmpOpcode = op -> (op & 0xF00F) == 12288 || (op & 0xF00F) == 12288 || (op & 0xF00F) == 12290 || (op & 0xF00F) == 12291 || (op & 0xF00F) == 12294 || (op & 0xF00F) == 12295 || (op & 0xFF00) == 34816 || (op & 0xF0FF) == 16405 || (op & 0xF0FF) == 16401 || (op & 0xF00F) == 8204;
        isTstOpcode = op -> (op & 0xF00F) == 8200 || (op & 0xFF00) == 51200 || (op & 0xFF00) == 52224;
        isMovOpcode = op -> (op & 0xF00F) == 24578 || (op & 0xF00F) == 24577 || (op & 0xF00F) == 24576 || (op & 0xFF00) == 50688 || (op & 0xFF00) == 50432 || (op & 0xFF00) == 50176 || (op & 0xFF00) == 33792 || (op & 0xFF00) == 34048 || (op & 0xF000) == 20480 || (op & 0xF000) == 36864 || (op & 0xF000) == 53248;
        isNopOpcode = op -> op == 9;
        isLoopOpcode = isNopOpcode.or(isBranchOpcode).or(isCmpOpcode).or(isTstOpcode).or(isMovOpcode);
        isIgnoreOpcode = op -> (op & 0xF0FF) == 16400;
    }
}

