/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

import java.util.Arrays;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.Sh2MMREG;
import s32x.bus.Sh2Bus;
import s32x.event.PollSysEventManager;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Helper;
import s32x.sh2.Sh2Instructions;
import s32x.sh2.device.IntControl;
import s32x.sh2.drc.Ow2DrcOptimizer;
import s32x.sh2.drc.Ow2Sh2BlockRecompiler;
import s32x.sh2.drc.Sh2Block;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public class Sh2Impl
implements Sh2 {
    private static final Logger LOG = LogHelper.getLogger((String)Sh2Impl.class.getSimpleName());
    private final int tasReadOffset;
    protected Sh2Context ctx;
    protected Sh2Bus memory;
    protected final Sh2.Sh2Config sh2Config;
    protected final Sh2Instructions.Sh2InstructionWrapper[] opcodeMap;

    public Sh2Impl(Sh2Bus memory) {
        this.memory = memory;
        this.opcodeMap = Sh2Instructions.createOpcodeMap(this);
        this.sh2Config = Sh2.Sh2Config.get();
        int n = this.tasReadOffset = this.sh2Config.tasQuirk ? 0x20000000 : 0;
        if (this.sh2Config.drcEn) {
            Ow2Sh2BlockRecompiler.newInstance("" + System.currentTimeMillis());
        }
    }

    private int getIMASK() {
        return (this.ctx.SR & 0xF0) >>> 4;
    }

    private boolean acceptInterrupts(int level) {
        if (level > this.getIMASK()) {
            if (S32xUtil.assertionsEnabled) {
                boolean legal;
                Sh2Instructions.Sh2InstructionWrapper instWrapper = Sh2Instructions.instOpcodeMap[this.ctx.opcode];
                boolean bl = legal = Arrays.binarySearch((Object[])Sh2Instructions.intDisabledOpcodes, (Object)instWrapper.inst) < 0;
                if (!legal) {
                    LOG.warn("{}, {}", (Object)Util.th((int)this.ctx.PC), (Object)instWrapper.inst);
                    return false;
                }
            }
            this.processInterrupt(this.ctx, level);
            this.ctx.devices.intC.clearCurrentInterrupt();
            return true;
        }
        return false;
    }

    private void processInterrupt(Sh2Context ctx, int level) {
        assert (Md32xRuntimeData.getAccessTypeExt() == ctx.cpuAccess);
        this.push(ctx.SR);
        this.push(ctx.PC);
        ctx.SR &= 0xF0F;
        ctx.SR |= (level & 0xF) << 4;
        int vectorNum = ctx.devices.intC.getVectorNumber();
        ctx.PC = this.memory.read32(ctx.VBR + (vectorNum << 2));
        ctx.cycles -= 5;
    }

    protected final void decodeDelaySlot(int opcode) {
        this.printDebugMaybe(opcode);
        this.opcodeMap[opcode].runnable.run();
    }

    @Override
    public void run(Sh2Context ctx) {
        this.ctx = ctx;
        Sh2MMREG sh2MMREG = ctx.devices.sh2MMREG;
        IntControl intControl = ctx.devices.intC;
        PollSysEventManager instance = PollSysEventManager.instance;
        while (ctx.cycles >= 0) {
            this.decode();
            boolean res = this.acceptInterrupts(intControl.getInterruptLevel());
            ctx.cycles -= Md32xRuntimeData.resetCpuDelayExt();
            if (!res && !instance.getPoller(ctx.cpuAccess).isPollingActive()) continue;
            break;
        }
        ctx.cycles_ran = Sh2Context.burstCycles - ctx.cycles;
        ctx.cycles = Sh2Context.burstCycles;
    }

    protected final void decode() {
        if (!this.sh2Config.drcEn) {
            this.decodeSimple();
            return;
        }
        Sh2.FetchResult fr = this.ctx.fetchResult;
        fr.pc = this.ctx.PC;
        if (fr.block.prefetchPc == fr.pc) {
            this.runBlock(fr);
            return;
        }
        this.memory.fetch(fr, this.ctx.cpuAccess);
        if (this.sh2Config.prefetchEn) {
            this.runBlock(fr);
        } else {
            assert (fr.block != Sh2Block.INVALID_BLOCK);
            if (fr.block == null) {
                this.printDebugMaybe(fr.opcode);
                this.opcodeMap[fr.opcode].runnable.run();
            }
        }
    }

    private void runBlock(Sh2.FetchResult fr) {
        boolean nextBlockOk;
        Sh2Block block = fr.block;
        block.runBlock(this, this.ctx.devices.sh2MMREG);
        if (this.ctx.PC == block.prefetchPc) {
            assert (block.isValid());
            block.nextBlock = fr.block;
            ++block.poller.spinCount;
            if (this.sh2Config.pollDetectEn) {
                Ow2DrcOptimizer.handlePoll(block);
            }
            return;
        }
        boolean bl = nextBlockOk = block.nextBlock.prefetchPc == this.ctx.PC && block.nextBlock.isValid();
        if (nextBlockOk) {
            this.setNextBlock(fr, block);
        } else {
            PollSysEventManager.instance.resetPoller(this.ctx.cpuAccess);
            this.fetchNextBlock(fr);
        }
        assert (fr.block.isValid());
        block.poller.spinCount = 0;
    }

    private void setNextBlock(Sh2.FetchResult fr, Sh2Block block) {
        fr.pc = this.ctx.PC;
        fr.block = block.nextBlock;
        fr.opcode = block.prefetchWords[0];
    }

    private void fetchNextBlock(Sh2.FetchResult fr) {
        Sh2Block prevBlock = fr.block;
        fr.pc = this.ctx.PC;
        this.memory.fetch(fr, this.ctx.cpuAccess);
        assert (prevBlock != fr.block || fr.pc == fr.block.prefetchPc);
        prevBlock.nextBlock = fr.block;
    }

    protected final void decodeSimple() {
        Sh2.FetchResult fr = this.ctx.fetchResult;
        fr.pc = this.ctx.PC;
        this.memory.fetch(fr, this.ctx.cpuAccess);
        this.printDebugMaybe(fr.opcode);
        this.opcodeMap[fr.opcode].runnable.run();
    }

    @Override
    public void setCtx(Sh2Context ctx) {
        this.ctx = ctx;
    }

    public static final int RN(int x) {
        return x >> 8 & 0xF;
    }

    public static final int RM(int x) {
        return x >> 4 & 0xF;
    }

    @Override
    public void reset(Sh2Context ctx) {
        Md32xRuntimeData.setAccessTypeExt(ctx.cpuAccess);
        ctx.VBR = 0;
        ctx.PC = this.memory.read32(0);
        ctx.SR = 240;
        ctx.registers[15] = this.memory.read32(4);
        ctx.cycles = Sh2Context.burstCycles;
        LOG.info("{} Reset, PC: {}, SP: {}", new Object[]{ctx.cpuAccess, Util.th((int)ctx.PC), Util.th((int)ctx.registers[15])});
    }

    private void push(int data) {
        this.ctx.registers[15] = this.ctx.registers[15] - 4;
        this.memory.write32(this.ctx.registers[15], data);
    }

    private int pop() {
        int res = this.memory.read32(this.ctx.registers[15]);
        this.ctx.registers[15] = this.ctx.registers[15] + 4;
        return res;
    }

    protected final void ILLEGAL(int code) {
        this.push(this.ctx.SR);
        this.push(this.ctx.PC);
        LOG.error("{} illegal instruction: {}\n{}", new Object[]{this.ctx.cpuAccess, Util.th((int)code), Sh2Helper.toDebuggingString(this.ctx)});
        this.ctx.PC = this.memory.read32(this.ctx.VBR + 16);
        this.ctx.cycles -= 5;
    }

    protected final void MOVI(int code) {
        int n = code >> 8 & 0xF;
        this.ctx.registers[n] = (byte)code;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWI(int code) {
        int d = code & 0xFF;
        int n = code >> 8 & 0xF;
        int memAddr = !this.ctx.delaySlot ? this.ctx.PC + 4 + (d << 1) : this.ctx.delayPC + 2 + (d << 1);
        this.ctx.registers[n] = (short)this.memory.read16(memAddr);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLI(int code) {
        int d = code & 0xFF;
        int n = code >> 8 & 0xF;
        int memAddr = !this.ctx.delaySlot ? (this.ctx.PC & 0xFFFFFFFC) + 4 + (d << 2) : (this.ctx.delayPC + 2 & 0xFFFFFFFC) + (d << 2);
        this.ctx.registers[n] = this.memory.read32(memAddr);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOV(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBS(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.memory.write8(this.ctx.registers[n], (byte)this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWS(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.memory.write16(this.ctx.registers[n], this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLS(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.memory.write32(this.ctx.registers[n], this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBL(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (byte)this.memory.read8(this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWL(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (short)this.memory.read16(this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLL(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.memory.read32(this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBM(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 1;
        this.memory.write8(this.ctx.registers[n], (byte)this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWM(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 2;
        this.memory.write16(this.ctx.registers[n], this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLM(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 4;
        this.memory.write32(this.ctx.registers[n], this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBP(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (byte)this.memory.read8(this.ctx.registers[m]);
        if (n != m) {
            int n2 = m;
            this.ctx.registers[n2] = this.ctx.registers[n2] + 1;
        }
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWP(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (short)this.memory.read16(this.ctx.registers[m]);
        if (n != m) {
            int n2 = m;
            this.ctx.registers[n2] = this.ctx.registers[n2] + 2;
        }
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLP(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.memory.read32(this.ctx.registers[m]);
        if (n != m) {
            int n2 = m;
            this.ctx.registers[n2] = this.ctx.registers[n2] + 4;
        }
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBS4(int code) {
        int d = code >> 0 & 0xF;
        int n = Sh2Impl.RM(code);
        this.memory.write8(this.ctx.registers[n] + (d << 0), (byte)this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWS4(int code) {
        int d = code >> 0 & 0xF;
        int n = Sh2Impl.RM(code);
        this.memory.write16(this.ctx.registers[n] + (d << 1), this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLS4(int code) {
        int d = code & 0xF;
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.memory.write32(this.ctx.registers[n] + (d << 2), this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBL4(int code) {
        int d = code >> 0 & 0xF;
        int m = Sh2Impl.RM(code);
        this.ctx.registers[0] = (byte)this.memory.read8(this.ctx.registers[m] + d);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWL4(int code) {
        int d = code >> 0 & 0xF;
        int m = Sh2Impl.RM(code);
        this.ctx.registers[0] = (short)this.memory.read16(this.ctx.registers[m] + (d << 1));
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLL4(int code) {
        int d = code & 0xF;
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.memory.read32(this.ctx.registers[m] + (d << 2));
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBS0(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.memory.write8(this.ctx.registers[n] + this.ctx.registers[0], (byte)this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWS0(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.memory.write16(this.ctx.registers[n] + this.ctx.registers[0], this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLS0(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.memory.write32(this.ctx.registers[n] + this.ctx.registers[0], this.ctx.registers[m]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBL0(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (byte)this.memory.read8(this.ctx.registers[m] + this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWL0(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (short)this.memory.read16(this.ctx.registers[m] + this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLL0(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.memory.read32(this.ctx.registers[m] + this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBSG(int code) {
        int d = code & 0xFF;
        this.memory.write8(this.ctx.GBR + d, (byte)this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWSG(int code) {
        int d = code >> 0 & 0xFF;
        this.memory.write16(this.ctx.GBR + (d << 1), this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLSG(int code) {
        int d = code >> 0 & 0xFF;
        this.memory.write32(this.ctx.GBR + (d << 2), this.ctx.registers[0]);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVBLG(int code) {
        int d = code >> 0 & 0xFF;
        this.ctx.registers[0] = (byte)this.memory.read8(this.ctx.GBR + (d << 0));
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVWLG(int code) {
        int d = code >> 0 & 0xFF;
        this.ctx.registers[0] = (short)this.memory.read16(this.ctx.GBR + (d << 1));
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVLLG(int code) {
        int d = code >> 0 & 0xFF;
        this.ctx.registers[0] = this.memory.read32(this.ctx.GBR + (d << 2));
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVA(int code) {
        int d = code & 0xFF;
        int ref = (this.ctx.PC + 4 & 0xFFFFFFFC) + (d << 2);
        if (this.ctx.delaySlot) {
            ref = (this.ctx.delayPC + 2 & 0xFFFFFFFC) + (d << 2);
        }
        this.ctx.registers[0] = ref;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MOVT(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.SR & 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SWAPB(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        int temp0 = this.ctx.registers[m] & 0xFFFF0000;
        int temp1 = (this.ctx.registers[m] & 0xFF) << 8;
        this.ctx.registers[n] = (this.ctx.registers[m] & 0xFF00) >> 8;
        this.ctx.registers[n] = this.ctx.registers[n] | temp1 | temp0;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SWAPW(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        int temp = 0;
        temp = this.ctx.registers[m] >>> 16 & 0xFFFF;
        this.ctx.registers[n] = this.ctx.registers[m] << 16;
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] | temp;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void XTRCT(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (this.ctx.registers[n] & 0xFFFF0000) >>> 16 | (this.ctx.registers[m] & 0xFFFF) << 16;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ADD(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] + this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ADDI(int code) {
        int n = Sh2Impl.RN(code);
        byte b = (byte)(code & 0xFF);
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] + b;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    public final void ADDC(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        long tmp0 = (long)this.ctx.registers[n] & 0xFFFFFFFFL;
        long tmp1 = tmp0 + (long)this.ctx.registers[m] & 0xFFFFFFFFL;
        long regN = tmp1 + (long)(this.ctx.SR & 1) & 0xFFFFFFFFL;
        boolean tb = tmp0 > tmp1 || tmp1 > regN;
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR = this.ctx.SR | (tb ? 1 : 0);
        this.ctx.registers[n] = (int)regN;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    public final void ADDV(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        int d = this.ctx.registers[n] >> 31 & 1;
        int s = (this.ctx.registers[m] >> 31 & 1) + d;
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] + this.ctx.registers[m];
        int r = (this.ctx.registers[n] >> 31 & 1) + d;
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= s + 1 & r & 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPIM(int code) {
        byte i = (byte)(code & 0xFF);
        this.ctx.SR = this.ctx.registers[0] == i ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPEQ(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.registers[n] == this.ctx.registers[m] ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPHS(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.SR = ((long)this.ctx.registers[n] & 0xFFFFFFFFL) >= ((long)this.ctx.registers[m] & 0xFFFFFFFFL) ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPGE(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.registers[n] >= this.ctx.registers[m] ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPHI(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.SR = ((long)this.ctx.registers[n] & 0xFFFFFFFFL) > ((long)this.ctx.registers[m] & 0xFFFFFFFFL) ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPGT(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.registers[n] > this.ctx.registers[m] ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPPZ(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.registers[n] >= 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPPL(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.registers[n] > 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CMPSTR(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        int tmp = this.ctx.registers[n] ^ this.ctx.registers[m];
        int HH = tmp >>> 24 & 0xFF;
        int HL = tmp >>> 16 & 0xFF;
        int LH = tmp >>> 8 & 0xFF;
        int LL = tmp & 0xFF;
        this.ctx.SR &= 0xFFFFFFFE;
        if ((HH & HL & LH & LL) == 0) {
            this.ctx.SR |= 1;
        }
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void DIV1(int code) {
        Sh2Impl.DIV1(this.ctx, Sh2Impl.RN(code), Sh2Impl.RM(code));
    }

    public static final void DIV1(Sh2Context ctx, int dvd, int dvsr) {
        long udvd = (long)ctx.registers[dvd] & 0xFFFFFFFFL;
        long udvsr = (long)ctx.registers[dvsr] & 0xFFFFFFFFL;
        int old_q = ctx.SR >> 8 & 1;
        ctx.SR &= 0xFFFFFEFF;
        ctx.SR = (int)((long)ctx.SR | (udvd >> 31 & 1L) << 8);
        long r = udvd << 1 & 0xFFFFFFFFL;
        r |= (long)(ctx.SR & 1);
        r = old_q == (ctx.SR >> 9 & 1) ? (r -= udvsr) : (r += udvsr);
        ctx.registers[dvd] = (int)r;
        int qm = ctx.SR >> 8 & 1 ^ ctx.SR >> 9 & 1;
        int q = qm ^ (int)(r >> 32 & 1L);
        qm = q ^ ctx.SR >> 9 & 1;
        ctx.SR &= 0xFFFFFEFE;
        ctx.SR |= q << 8 | 1 - qm;
        --ctx.cycles;
        ctx.PC += 2;
    }

    public final void DIV0S(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.SR = (this.ctx.registers[n] & Integer.MIN_VALUE) == 0 ? (this.ctx.SR &= 0xFFFFFEFF) : (this.ctx.SR |= 0x100);
        this.ctx.SR = (this.ctx.registers[m] & Integer.MIN_VALUE) == 0 ? (this.ctx.SR &= 0xFFFFFDFF) : (this.ctx.SR |= 0x200);
        this.ctx.SR = ((this.ctx.registers[m] ^ this.ctx.registers[n]) & Integer.MIN_VALUE) != 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void DIV0U(int code) {
        this.ctx.SR &= 0xFFFFFCFE;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void DMULS(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        long mult = (long)this.ctx.registers[n] * (long)this.ctx.registers[m];
        this.ctx.MACL = (int)(mult & 0xFFFFFFFFFFFFFFFFL);
        this.ctx.MACH = (int)(mult >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void DMULU(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        long mult = ((long)this.ctx.registers[n] & 0xFFFFFFFFL) * ((long)this.ctx.registers[m] & 0xFFFFFFFFL);
        this.ctx.MACL = (int)(mult & 0xFFFFFFFFFFFFFFFFL);
        this.ctx.MACH = (int)(mult >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void DT(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 1;
        this.ctx.SR = this.ctx.registers[n] == 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void EXTSB(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (byte)this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void EXTSW(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = (short)this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void EXTUB(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.registers[m] & 0xFF;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void EXTUW(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.registers[m] & 0xFFFF;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void MACL(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        long regN = this.memory.read32(this.ctx.registers[n]);
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] + 4;
        long regM = this.memory.read32(this.ctx.registers[m]);
        int n3 = m;
        this.ctx.registers[n3] = this.ctx.registers[n3] + 4;
        long res = regM * regN;
        res += (((long)this.ctx.MACH & 0xFFFFFFFFL) << 32) + ((long)this.ctx.MACL & 0xFFFFFFFFL);
        if ((this.ctx.SR & 2) > 0) {
            if (res > 0x7FFFFFFFFFFFL) {
                res = 0x7FFFFFFFFFFFL;
            } else if (res < -140737488355328L) {
                res = -140737488355328L;
            }
        }
        this.ctx.MACH = (int)(res >> 32);
        this.ctx.MACL = (int)(res & 0xFFFFFFFFFFFFFFFFL);
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void MACW(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        short rn = (short)this.memory.read16(this.ctx.registers[n]);
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] + 2;
        short rm = (short)this.memory.read16(this.ctx.registers[m]);
        int n3 = m;
        this.ctx.registers[n3] = this.ctx.registers[n3] + 2;
        Sh2Impl.MACW(this.ctx, rn, rm);
    }

    protected static final void MACW(Sh2Context ctx, short rn, short rm) {
        if ((ctx.SR & 2) > 0) {
            long res = (long)(rm * rn) + (long)ctx.MACL;
            if (res > Integer.MAX_VALUE) {
                res = Integer.MAX_VALUE;
                ctx.MACH |= 1;
            } else if (res < Integer.MIN_VALUE) {
                res = Integer.MIN_VALUE;
                ctx.MACH |= 1;
            }
            ctx.MACL = (int)(res & 0xFFFFFFFFFFFFFFFFL);
        } else {
            long prod = rm * rn;
            long mac = (((long)ctx.MACH & 0xFFFFFFFFL) << 32) + ((long)ctx.MACL & 0xFFFFFFFFL);
            long res = prod + mac;
            ctx.MACH = (int)(res >> 32);
            ctx.MACL = (int)(res & 0xFFFFFFFFFFFFFFFFL);
            if (prod > 0L && mac > 0L && res < 0L || mac < 0L && prod < 0L && res > 0L) {
                ctx.MACH |= 1;
            }
        }
        ctx.cycles -= 2;
        ctx.PC += 2;
    }

    protected final void MULL(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.MACL = this.ctx.registers[n] * this.ctx.registers[m] & 0xFFFFFFFF;
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void MULSW(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.MACL = (short)this.ctx.registers[n] * (short)this.ctx.registers[m];
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void MULSU(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.MACL = (this.ctx.registers[n] & 0xFFFF) * (this.ctx.registers[m] & 0xFFFF);
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void NEG(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = 0 - this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void NEGC(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        long tmp = (long)(0 - this.ctx.registers[m]) & 0xFFFFFFFFL;
        long regN = tmp - (long)(this.ctx.SR & 1) & 0xFFFFFFFFL;
        this.ctx.registers[n] = (int)regN;
        this.ctx.SR &= 0xFFFFFFFE;
        if (tmp > 0L || tmp < regN) {
            this.ctx.SR |= 1;
        }
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SUB(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    public final void SUBC(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        long tmp0 = (long)this.ctx.registers[n] & 0xFFFFFFFFL;
        long tmp1 = (long)(this.ctx.registers[n] - this.ctx.registers[m]) & 0xFFFFFFFFL;
        long regN = tmp1 - (long)(this.ctx.SR & 1) & 0xFFFFFFFFL;
        this.ctx.registers[n] = (int)regN;
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR = this.ctx.SR | (tmp0 < tmp1 || tmp1 < regN ? 1 : 0);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SUBV(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        int dest = this.ctx.registers[n] >> 31 & 1;
        int src = (this.ctx.registers[m] >> 31 & 1) + dest;
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] - this.ctx.registers[m];
        int r = (this.ctx.registers[n] >> 31 & 1) + dest;
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= src & r & 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void AND(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] & this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ANDI(int code) {
        int i = code >> 0 & 0xFF;
        this.ctx.registers[0] = this.ctx.registers[0] & i;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ANDM(int code) {
        byte i = (byte)(code >> 0 & 0xFF);
        byte value = (byte)this.memory.read8(this.ctx.GBR + this.ctx.registers[0]);
        this.memory.write8(this.ctx.GBR + this.ctx.registers[0], (byte)(value & i));
        this.ctx.cycles -= 3;
        this.ctx.PC += 2;
    }

    protected final void NOT(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = ~this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void OR(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] | this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ORI(int code) {
        int i = code >> 0 & 0xFF;
        this.ctx.registers[0] = this.ctx.registers[0] | i;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ORM(int code) {
        int i = code >> 0 & 0xFF;
        int value = this.memory.read8(this.ctx.GBR + this.ctx.registers[0]);
        this.memory.write8(this.ctx.GBR + this.ctx.registers[0], (byte)(value | i));
        this.ctx.cycles -= 3;
        this.ctx.PC += 2;
    }

    public final void TAS(int code) {
        int n = Sh2Impl.RN(code);
        int value = this.memory.read8(this.tasReadOffset | this.ctx.registers[n]);
        this.ctx.SR = value == 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        this.memory.write8(this.ctx.registers[n], (byte)(value | 0x80));
        this.ctx.cycles -= 4;
        this.ctx.PC += 2;
    }

    protected final void TST(int code) {
        int m = Sh2Impl.RM(code);
        int n = Sh2Impl.RN(code);
        this.ctx.SR = (this.ctx.registers[n] & this.ctx.registers[m]) == 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    public final void TSTI(int code) {
        int i = code >> 0 & 0xFF;
        this.ctx.SR = (this.ctx.registers[0] & i) == 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void TSTM(int code) {
        int i = code >> 0 & 0xFF;
        int value = this.memory.read8(this.ctx.GBR + this.ctx.registers[0]);
        this.ctx.SR = (value & i) == 0 ? (this.ctx.SR |= 1) : (this.ctx.SR &= 0xFFFFFFFE);
        this.ctx.cycles -= 3;
        this.ctx.PC += 2;
    }

    protected final void XOR(int code) {
        int n;
        int m = Sh2Impl.RM(code);
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] ^ this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void XORI(int code) {
        int i = code >> 0 & 0xFF;
        this.ctx.registers[0] = this.ctx.registers[0] ^ i;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void XORM(int code) {
        int i = code >> 0 & 0xFF;
        int value = this.memory.read8(this.ctx.GBR + this.ctx.registers[0]);
        this.memory.write8(this.ctx.GBR + this.ctx.registers[0], (byte)(value ^ i));
        this.ctx.cycles -= 3;
        this.ctx.PC += 2;
    }

    protected final void ROTR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= this.ctx.registers[n] & 1;
        this.ctx.registers[n] = this.ctx.registers[n] >>> 1 | this.ctx.registers[n] << 31;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ROTCR(int code) {
        int n = Sh2Impl.RN(code);
        int temp = this.ctx.registers[n] & 1;
        this.ctx.registers[n] = this.ctx.registers[n] >>> 1 | (this.ctx.SR & 1) << 31;
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= temp;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    public final void ROTL(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= this.ctx.registers[n] >>> 31 & 1;
        this.ctx.registers[n] = this.ctx.registers[n] << 1 | this.ctx.registers[n] >>> 31;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void ROTCL(int code) {
        int n = Sh2Impl.RN(code);
        int msbit = this.ctx.registers[n] >>> 31 & 1;
        this.ctx.registers[n] = this.ctx.registers[n] << 1 | this.ctx.SR & 1;
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= msbit;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHAR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= this.ctx.registers[n] & 1;
        this.ctx.registers[n] = this.ctx.registers[n] >> 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHAL(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR &= 0xFFFFFFFE;
        this.ctx.SR |= this.ctx.registers[n] >>> 31 & 1;
        this.ctx.registers[n] = this.ctx.registers[n] << 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLL(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.SR & 0xFFFFFFFE | this.ctx.registers[n] >>> 31 & 1;
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] << 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.SR & 0xFFFFFFFE | this.ctx.registers[n] & 1;
        int n2 = n;
        this.ctx.registers[n2] = this.ctx.registers[n2] >>> 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLL2(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] << 2;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLR2(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] >>> 2;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLL8(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] << 8;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLR8(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] >>> 8;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLL16(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] << 16;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SHLR16(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] >>> 16;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void BF(int code) {
        if ((this.ctx.SR & 1) == 0) {
            int d = (byte)(code & 0xFF) << 1;
            this.ctx.PC += d + 4;
            this.ctx.cycles -= 3;
        } else {
            --this.ctx.cycles;
            this.ctx.PC += 2;
        }
    }

    protected final void BFS(int code) {
        if ((this.ctx.SR & 1) == 0) {
            int d = (byte)(code & 0xFF) << 1;
            int prevPc = this.ctx.PC;
            this.ctx.PC = this.ctx.PC + d + 4;
            this.delaySlot(prevPc + 2);
            this.ctx.cycles -= 2;
        } else {
            this.ctx.PC += 2;
            --this.ctx.cycles;
        }
    }

    protected final void BT(int code) {
        if ((this.ctx.SR & 1) != 0) {
            int d = (byte)(code & 0xFF) << 1;
            this.ctx.PC = this.ctx.PC + d + 4;
            this.ctx.cycles -= 3;
        } else {
            --this.ctx.cycles;
            this.ctx.PC += 2;
        }
    }

    protected final void BTS(int code) {
        if ((this.ctx.SR & 1) != 0) {
            int d = (byte)(code & 0xFF) << 1;
            int prevPc = this.ctx.PC;
            this.ctx.PC = this.ctx.PC + d + 4;
            this.delaySlot(prevPc + 2);
            this.ctx.cycles -= 2;
        } else {
            this.ctx.PC += 2;
            --this.ctx.cycles;
        }
    }

    protected final void BRA(int code) {
        int disp = (code & 0x800) == 0 ? 0xFFF & code : 0xFFFFF000 | code;
        int prevPc = this.ctx.PC;
        this.ctx.PC = this.ctx.PC + 4 + (disp << 1);
        this.delaySlot(prevPc + 2);
        this.ctx.cycles -= 2;
    }

    protected final void BSR(int code) {
        int disp = 0;
        disp = (code & 0x800) == 0 ? 0xFFF & code : 0xFFFFF000 | code;
        this.ctx.PR = this.ctx.PC + 4;
        this.ctx.PC = this.ctx.PC + (disp << 1) + 4;
        this.delaySlot(this.ctx.PR - 2);
        this.ctx.cycles -= 2;
    }

    protected final void BRAF(int code) {
        int n = Sh2Impl.RN(code);
        int prevPc = this.ctx.PC;
        this.ctx.PC += this.ctx.registers[n] + 4;
        this.delaySlot(prevPc + 2);
        this.ctx.cycles -= 2;
    }

    protected final void BSRF(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.PR = this.ctx.PC + 4;
        this.ctx.PC = this.ctx.PC + this.ctx.registers[n] + 4;
        this.delaySlot(this.ctx.PR - 2);
        this.ctx.cycles -= 2;
    }

    protected final void JMP(int code) {
        int n = Sh2Impl.RN(code);
        int prevPc = this.ctx.PC;
        this.ctx.PC = this.ctx.registers[n];
        this.delaySlot(prevPc + 2);
        this.ctx.cycles -= 2;
    }

    protected final void JSR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.PR = this.ctx.PC + 4;
        this.ctx.PC = this.ctx.registers[n];
        this.delaySlot(this.ctx.PR - 2);
        this.ctx.cycles -= 2;
    }

    protected final void RTS(int code) {
        int prevPc = this.ctx.PC;
        this.ctx.PC = this.ctx.PR;
        this.delaySlot(prevPc + 2);
        this.ctx.cycles -= 2;
    }

    protected final void RTE(int code) {
        int prevPc = this.ctx.PC;
        this.ctx.PC = this.pop();
        this.ctx.SR = this.pop() & 0x3F3;
        this.delaySlot(prevPc + 2);
        this.ctx.cycles -= 4;
    }

    private void delaySlot(int pc) {
        this.ctx.delayPC = this.ctx.PC;
        this.ctx.PC = pc;
        this.ctx.delaySlot = true;
        this.decodeDelaySlot(this.memory.fetchDelaySlot(pc, this.ctx.fetchResult, this.ctx.cpuAccess));
        this.ctx.delaySlot = false;
        this.ctx.PC = this.ctx.delayPC;
    }

    protected final void CLRMAC(int code) {
        this.ctx.MACH = 0;
        this.ctx.MACL = 0;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void CLRT(int code) {
        this.ctx.SR &= 0xFFFFFFFE;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void LDCSR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.SR = this.ctx.registers[m] & 0x3F3;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void LDCGBR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.GBR = this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void LDCVBR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.VBR = this.ctx.registers[m];
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void LDCMSR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.SR = this.memory.read32(this.ctx.registers[m]) & 0x3F3;
        int n = m;
        this.ctx.registers[n] = this.ctx.registers[n] + 4;
        this.ctx.cycles -= 3;
        this.ctx.PC += 2;
    }

    protected final void LDCMGBR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.GBR = this.memory.read32(this.ctx.registers[m]);
        int n = m;
        this.ctx.registers[n] = this.ctx.registers[n] + 4;
        this.ctx.cycles -= 3;
        this.ctx.PC += 2;
    }

    protected final void LDCMVBR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.VBR = this.memory.read32(this.ctx.registers[m]);
        int n = m;
        this.ctx.registers[n] = this.ctx.registers[n] + 4;
        this.ctx.cycles -= 3;
        this.ctx.PC += 2;
    }

    protected final void LDSMACH(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.MACH = this.ctx.registers[m];
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void LDSMACL(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.MACL = this.ctx.registers[m];
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    public final void LDSPR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.PR = this.ctx.registers[m];
        this.ctx.PC += 2;
        --this.ctx.cycles;
    }

    protected final void LDSMMACH(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.MACH = this.memory.read32(this.ctx.registers[m]);
        int n = m;
        this.ctx.registers[n] = this.ctx.registers[n] + 4;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void LDSMMACL(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.MACL = this.memory.read32(this.ctx.registers[m]);
        int n = m;
        this.ctx.registers[n] = this.ctx.registers[n] + 4;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void LDSMPR(int code) {
        int m = Sh2Impl.RN(code);
        this.ctx.PR = this.memory.read32(this.ctx.registers[m]);
        int n = m;
        this.ctx.registers[n] = this.ctx.registers[n] + 4;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void NOP(int code) {
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SETT(int code) {
        this.ctx.SR |= 1;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void SLEEP(int code) {
        this.ctx.cycles -= 4;
        LOG.info("{} exec sleep at PC: {}", (Object)this.ctx.cpuAccess, (Object)Util.th((int)this.ctx.PC));
    }

    protected final void STCSR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.SR;
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void STCGBR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.GBR;
        this.ctx.PC += 2;
        this.ctx.cycles -= 2;
    }

    protected final void STCVBR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.VBR;
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void STCMSR(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 4;
        this.memory.write32(this.ctx.registers[n], this.ctx.SR);
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void STCMGBR(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 4;
        this.memory.write32(this.ctx.registers[n], this.ctx.GBR);
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void STCMVBR(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 4;
        this.memory.write32(this.ctx.registers[n], this.ctx.VBR);
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void STSMACH(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.MACH;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void STSMACL(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.MACL;
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    public final void STSPR(int code) {
        int n = Sh2Impl.RN(code);
        this.ctx.registers[n] = this.ctx.PR;
        this.ctx.cycles -= 2;
        this.ctx.PC += 2;
    }

    protected final void STSMMACH(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 4;
        this.memory.write32(this.ctx.registers[n], this.ctx.MACH);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void STSMMACL(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 4;
        this.memory.write32(this.ctx.registers[n], this.ctx.MACL);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void STSMPR(int code) {
        int n;
        int n2 = n = Sh2Impl.RN(code);
        this.ctx.registers[n2] = this.ctx.registers[n2] - 4;
        this.memory.write32(this.ctx.registers[n], this.ctx.PR);
        --this.ctx.cycles;
        this.ctx.PC += 2;
    }

    protected final void TRAPA(int code) {
        int imm = 0xFF & code;
        this.push(this.ctx.SR);
        this.push(this.ctx.PC + 2);
        this.ctx.PC = this.memory.read32(this.ctx.VBR + (imm << 2));
        this.ctx.cycles -= 8;
    }
}

