/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.cache;

import java.io.Serializable;
import java.nio.ByteBuffer;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.sh2.cache.Sh2CacheImpl;
import s32x.util.S32xUtil;

public interface Sh2Cache
extends Device {
    public static final Logger LOG = LogHelper.getLogger((String)Sh2Cache.class.getSimpleName());
    public static final int CACHE_LINES = 64;
    public static final int CACHE_BYTES_PER_LINE = 16;
    public static final int CACHE_BYTES_PER_LINE_MASK = 15;
    public static final int CACHE_WAYS = 4;
    public static final int AREA_MASK = -536870912;
    public static final int TAG_MASK = 536869888;
    public static final int ENTRY_MASK = 1008;
    public static final int ENTRY_SHIFT = 4;
    public static final int LINE_MASK = 15;
    public static final int SH2_ADDRESS_SPACE_PARTITION_BITS = 3;
    public static final int CACHE_ADDRESS_BITS = 29;
    public static final int CACHE_USE_H3 = 0;
    public static final int CACHE_THROUGH_H3 = 1;
    public static final int CACHE_PURGE_H3 = 2;
    public static final int CACHE_ADDRESS_ARRAY_H3 = 3;
    public static final int CACHE_DATA_ARRAY_H3 = 6;
    public static final int CACHE_IO_H3 = 7;
    public static final int CACHE_USE = 0;
    public static final int CACHE_THROUGH = 0x20000000;
    public static final int CACHE_PURGE = 0x40000000;
    public static final int CACHE_ADDRESS_ARRAY = 0x60000000;
    public static final int CACHE_DATA_ARRAY = -1073741824;
    public static final int CACHE_IO = -536870912;
    public static final int CACHE_PURGE_MASK = 0x3FFFFFFF;
    public static final int CACHE_PURGE_DELAY = 2;
    public static final int DATA_ARRAY_SIZE = 4096;
    public static final int DATA_ARRAY_MASK = 4095;

    public void cacheClear();

    @Deprecated
    public int readDirect(int var1, Size var2);

    public int cacheMemoryRead(int var1, Size var2);

    public boolean cacheMemoryWrite(int var1, int var2, Size var3);

    public ByteBuffer getDataArray();

    public CacheRegContext updateState(int var1);

    public CacheRegContext getCacheContext();

    public Sh2CacheContext getSh2CacheContext();

    default public int readMemoryUncached(Sh2Bus memory, int address, Size size) {
        return memory.read(address | 0x20000000, size);
    }

    default public void writeMemoryUncached(Sh2Bus memory, int address, int value, Size size) {
        memory.write(address | 0x20000000, value, size);
    }

    public static Sh2Cache createNoCacheInstance(S32xUtil.CpuDeviceAccess cpu, final Sh2Bus memory) {
        return new Sh2CacheImpl(cpu, memory){

            @Override
            public CacheRegContext updateState(int value) {
                CacheRegContext ctx = super.updateState(value);
                if (ctx.cacheEn > 0) {
                    // empty if block
                }
                this.ca.enable = 0;
                return ctx;
            }

            @Override
            public int readDirect(int addr, Size size) {
                return memory.readMemoryUncachedNoDelay(addr, size);
            }
        };
    }

    public static class Sh2CacheContext
    implements Serializable {
        public Sh2CacheEntry ca;
        public CacheRegContext cacheContext;
        public final byte[] dataArray = new byte[4096];
    }

    public static class CacheRegContext
    implements Serializable {
        public S32xUtil.CpuDeviceAccess cpu;
        public int ccr;
        public int way;
        public int cachePurge;
        public int twoWay;
        public int dataReplaceDis;
        public int instReplaceDis;
        public int cacheEn;

        public String toString() {
            return "CacheContext{way=" + this.way + ", cachePurge=" + this.cachePurge + ", twoWay=" + this.twoWay + ", dataReplaceDis=" + this.dataReplaceDis + ", instReplaceDis=" + this.instReplaceDis + ", cacheEn=" + this.cacheEn + "}";
        }
    }

    public static class CacheInvalidateContext {
        public S32xUtil.CpuDeviceAccess cpu;
        public Sh2CacheLine line;
        public int cacheReadAddr;
        public int prevCacheAddr;
        public boolean force;
    }

    public static class Sh2CacheEntry
    implements Serializable {
        int enable;
        int[] lru = new int[64];
        Sh2CacheLine[][] way = new Sh2CacheLine[4][64];
    }

    public static class Sh2CacheLine
    implements Serializable {
        public int tag;
        public int v;
        public byte[] data = new byte[16];
    }
}

