/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.Sh2Dict;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.util.S32xUtil;

public class DivUnit
implements S32xUtil.Sh2Device {
    private static final Logger LOG = LogHelper.getLogger((String)DivUnit.class.getSimpleName());
    private static final int DIV_OVERFLOW_BIT = 0;
    private static final int DIV_OVERFLOW_INT_EN_BIT = 1;
    private static final int DIV_CYCLES = 39;
    private static final int DIV_OVF_CYCLES = 6;
    private static final String formatDiv = "%s div%d, dvd: %16X, dvsr: %08X, quotLong: %16X, quot32: %08x, rem: %08X";
    private static final String formatOvf = "%s div%d overflow, dvd: %16X, dvsr: %08X, quotLong: %16X, quot32: %08x, rem: %08X";
    private static final String formatDivBy0 = "%s div%d overflow (div by 0), dvd: %16X, dvsr: %08X";
    private static final boolean verbose = false;
    private final S32xUtil.CpuDeviceAccess cpu;
    private final ByteBuffer regs;
    private final IntControl intControl;
    private long frameCnt;
    private long cycleCnt;

    public DivUnit(S32xUtil.CpuDeviceAccess cpu, IntControl intControl, ByteBuffer regs) {
        this.cpu = cpu;
        this.regs = regs;
        this.intControl = intControl;
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 reg, int pos, int value, Size size) {
        assert (size == Size.LONG);
        S32xUtil.writeBufferRaw(this.regs, pos, value, size);
        Sh2Dict.writeBufferWithMask(this.regs, reg);
        switch (reg) {
            case DIV_DVDNTL: {
                this.div64Dsp();
                break;
            }
            case DIV_DVDNT: {
                this.div32Dsp(value);
            }
        }
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int reg, Size size) {
        return S32xUtil.readBuffer(this.regs, reg, size);
    }

    private void div64Dsp() {
        long dh = S32xUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH);
        long dl = S32xUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTL);
        long dvd = dh << 32 & 0xFFFFFFFFFFFFFFFFL | dl & 0xFFFFFFFFL;
        int dvsr = S32xUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVSR);
        if (dvsr == 0) {
            this.handleOverflow(0L, true, String.format(formatDivBy0, new Object[]{this.cpu, 64, dvd, dvsr}));
            return;
        }
        long quotL = dvd / (long)dvsr;
        int quot = (int)quotL;
        int rem = (int)(dvd - (long)(quot * dvsr));
        S32xUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH, Sh2Dict.RegSpecSh2.DIV_DVDNTUH, rem);
        if ((long)quot != quotL) {
            this.handleOverflow(quotL, false, String.format(formatOvf, new Object[]{this.cpu, 64, dvd, dvsr, quotL, quot, rem}));
            return;
        }
        S32xUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT, Sh2Dict.RegSpecSh2.DIV_DVDNTL, Sh2Dict.RegSpecSh2.DIV_DVDNTUL, quot);
        this.addCpuDelay(39);
    }

    private void div32Dsp(int value) {
        S32xUtil.writeBufferLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH, value >> 31);
        S32xUtil.writeBufferLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTL, value);
        int dvd = S32xUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT);
        int dvsr = S32xUtil.readBufferRegLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVSR);
        if (dvsr == 0) {
            this.handleOverflow(0L, true, String.format(formatDivBy0, new Object[]{this.cpu, 32, dvd, dvsr}));
            return;
        }
        int quot = dvd / dvsr;
        int rem = dvd - quot * dvsr;
        S32xUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNTH, Sh2Dict.RegSpecSh2.DIV_DVDNTUH, rem);
        S32xUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT, Sh2Dict.RegSpecSh2.DIV_DVDNTL, Sh2Dict.RegSpecSh2.DIV_DVDNTUL, quot);
        this.addCpuDelay(39);
    }

    private void checkTimings(int type, int ref) {
        assert (this.frameCnt > 0L);
        long frameCnt = 0L;
        int cycleCnt = 0;
        int diff = (int)(((long)cycleCnt - this.cycleCnt) * 3L);
        if (frameCnt == this.frameCnt && diff < ref) {
            System.out.println("div" + type + "," + diff);
        }
        this.frameCnt = frameCnt;
        this.cycleCnt = cycleCnt;
    }

    private void handleOverflow(long quot, boolean divBy0, String msg) {
        S32xUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.DIV_DVCR.addr, 0, 1, Size.LONG);
        int dvcr = Util.readBufferWord((ByteBuffer)this.regs, (int)Sh2Dict.RegSpecSh2.DIV_DVCR.addr);
        int val = quot >= 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        S32xUtil.writeBuffersLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVDNT, Sh2Dict.RegSpecSh2.DIV_DVDNTL, Sh2Dict.RegSpecSh2.DIV_DVDNTUL, val);
        this.addCpuDelay(6);
        if ((dvcr & 1) > 0) {
            this.intControl.setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType.DIV);
            LOG.info(msg);
            LOG.warn("{} DivUnit interrupt", (Object)this.cpu);
        }
    }

    private void addCpuDelay(int cycles) {
    }

    public void reset() {
        S32xUtil.writeBufferLong(this.regs, Sh2Dict.RegSpecSh2.DIV_DVCR, 0);
    }
}

