/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.util.S32xUtil;

public interface IntControl
extends S32xUtil.Sh2Device {
    public static final Logger LOG = LogHelper.getLogger((String)IntControl.class.getSimpleName());
    public static final Sh2Interrupt[] intVals = Sh2Interrupt.values();
    public static final InterruptContext LEV_0 = new InterruptContext();
    public static final int MAX_LEVEL = 17;

    default public void setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType deviceType) {
        this.setOnChipDeviceIntPending(deviceType, OnChipSubType.S_NONE);
    }

    public void setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType var1, OnChipSubType var2);

    public void setIntPending(Sh2Interrupt var1, boolean var2);

    public int readSh2IntMaskReg(int var1, Size var2);

    public void reloadSh2IntMask();

    public ByteBuffer getSh2_int_mask_regs();

    public void setIntsMasked(int var1);

    public void clearInterrupt(Sh2Interrupt var1);

    public void clearCurrentInterrupt();

    public int getVectorNumber();

    public InterruptContext getInterruptContext();

    default public int getInterruptLevel() {
        return this.getInterruptContext().level;
    }

    public static enum OnChipSubType {
        S_NONE,
        RIE,
        TIE,
        DMA_C0,
        DMA_C1,
        D_OVFI,
        ERI,
        RXI,
        TXI,
        TEI,
        ICI,
        OCI,
        OVI;

    }

    public static class InterruptContext {
        public Sh2InterruptSource source;
        public Sh2Interrupt interrupt;
        public int level = 0;
        public int intState = 0;

        public String toString() {
            return "IntCtx{source=" + this.source + ", interrupt=" + this.interrupt + ", level=" + this.level + ", intState=" + this.intState + "}";
        }
    }

    public static enum Sh2Interrupt {
        NONE_0(0),
        NONE_1(0),
        NONE_2(0),
        NONE_3(0),
        NONE_4(0),
        NONE_5(0),
        PWM_6(1),
        NONE_7(1),
        CMD_8(1),
        NONE_9(0),
        HINT_10(1),
        NONE_11(0),
        VINT_12(1),
        NONE_13(0),
        VRES_14(1),
        NONE_15(0),
        NMI_16(1);

        public final int internal;

        private Sh2Interrupt(int i) {
            this.internal = i;
        }
    }

    public static enum Sh2InterruptSource {
        NMI,
        USER_BREAK,
        IRL15,
        VRES14(Sh2Interrupt.VRES_14),
        IRL13,
        VINT12(Sh2Interrupt.VINT_12),
        IRL11,
        HINT10(Sh2Interrupt.HINT_10),
        IRL09,
        CMD08(Sh2Interrupt.CMD_8),
        IRL07,
        PWM06(Sh2Interrupt.PWM_6),
        IRL05,
        IRL04,
        IRL03,
        IRL02,
        IRL01,
        DIVU(Sh2DeviceHelper.Sh2DeviceType.DIV),
        DMAC0(Sh2DeviceHelper.Sh2DeviceType.DMA, OnChipSubType.DMA_C0),
        DMAC1(Sh2DeviceHelper.Sh2DeviceType.DMA, OnChipSubType.DMA_C1),
        WDTS(Sh2DeviceHelper.Sh2DeviceType.WDT),
        REF(Sh2DeviceHelper.Sh2DeviceType.BSC),
        SCIE(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.ERI),
        SCIR(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.RXI),
        SCIT(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.TXI),
        SCITE(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.TEI),
        FRTI(Sh2DeviceHelper.Sh2DeviceType.FRT, OnChipSubType.ICI),
        FRTO(Sh2DeviceHelper.Sh2DeviceType.FRT, OnChipSubType.OCI),
        FRTOV(Sh2DeviceHelper.Sh2DeviceType.FRT, OnChipSubType.OVI);

        public final Sh2DeviceHelper.Sh2DeviceType deviceType;
        public final OnChipSubType subType;
        public final Sh2Interrupt externalInterrupt;
        public static final Sh2InterruptSource[] vals;

        private Sh2InterruptSource(Sh2Interrupt externalInterrupt) {
            this(Sh2DeviceHelper.Sh2DeviceType.NONE, OnChipSubType.S_NONE, externalInterrupt);
        }

        private Sh2InterruptSource() {
            this(Sh2DeviceHelper.Sh2DeviceType.NONE, OnChipSubType.S_NONE, Sh2Interrupt.NONE_0);
        }

        private Sh2InterruptSource(Sh2DeviceHelper.Sh2DeviceType deviceType) {
            this(deviceType, OnChipSubType.S_NONE, Sh2Interrupt.NONE_0);
        }

        private Sh2InterruptSource(Sh2DeviceHelper.Sh2DeviceType t, OnChipSubType s) {
            this(t, s, Sh2Interrupt.NONE_0);
        }

        private Sh2InterruptSource(Sh2DeviceHelper.Sh2DeviceType t, OnChipSubType s, Sh2Interrupt externalInterrupt) {
            this.deviceType = t;
            this.subType = s;
            this.externalInterrupt = externalInterrupt;
        }

        public static Sh2InterruptSource getSh2InterruptSource(Sh2DeviceHelper.Sh2DeviceType deviceType, OnChipSubType subType) {
            for (Sh2InterruptSource s : vals) {
                if (s.deviceType != deviceType || s.subType != subType) continue;
                return s;
            }
            LOG.error("Unknown interrupt source: " + deviceType + ", " + subType);
            return null;
        }

        static {
            vals = Sh2InterruptSource.values();
        }
    }
}

