/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.S32xDict;
import s32x.dict.Sh2Dict;
import s32x.event.PollSysEventManager;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.sh2.drc.Ow2DrcOptimizer;
import s32x.util.S32xUtil;

public class IntControlImplOld
implements IntControl {
    private static final Logger LOG = LogHelper.getLogger((String)IntControlImplOld.class.getSimpleName());
    public static final int MAX_LEVEL = 17;
    private static final boolean verbose = false;
    private final Map<Sh2DeviceHelper.Sh2DeviceType, Integer> onChipDevicePriority = new HashMap<Sh2DeviceHelper.Sh2DeviceType, Integer>();
    private final Map<Integer, IntControl.Sh2Interrupt> s32xInt = new HashMap<Integer, IntControl.Sh2Interrupt>(17);
    private final boolean[] intValid = new boolean[17];
    private final boolean[] intPending = new boolean[17];
    private final boolean[] intTrigger = new boolean[17];
    private final boolean[] onChipLevels = new boolean[17];
    private final ByteBuffer sh2_int_mask = ByteBuffer.allocate(2);
    private final ByteBuffer regs;
    private int interruptLevel;
    private final S32xUtil.CpuDeviceAccess cpu;
    private int additionalIntData = 0;

    public IntControlImplOld(S32xUtil.CpuDeviceAccess cpu, ByteBuffer regs) {
        this.regs = regs;
        this.cpu = cpu;
        this.init();
    }

    public void init() {
        Arrays.fill(this.intValid, true);
        this.setIntsMasked(0);
        Arrays.stream(Sh2DeviceHelper.Sh2DeviceType.values()).forEach(d -> this.onChipDevicePriority.put((Sh2DeviceHelper.Sh2DeviceType)((Object)d), 0));
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 regSpec, int pos, int value, Size size) {
        boolean changed = S32xUtil.writeBufferRaw(this.regs, pos, value, size);
        int val = Sh2Dict.writeBufferWithMask(this.regs, regSpec);
        if (!changed) {
            return;
        }
        switch (regSpec) {
            case INTC_IPRA: {
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.DIV, val >> 12 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.DMA, val >> 8 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.WDT, val >> 4 & 0xF);
                this.onChipDevicePriority.values().forEach(lev -> {
                    this.onChipLevels[lev.intValue()] = true;
                });
                this.logOnChipIntLevel(regSpec, val);
                break;
            }
            case INTC_IPRB: {
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.SCI, val >> 12 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.FRT, val >> 8 & 0xF);
                this.onChipDevicePriority.values().forEach(lev -> {
                    this.onChipLevels[lev.intValue()] = true;
                });
                this.logOnChipIntLevel(regSpec, val);
                break;
            }
            case INTC_ICR: {
                if ((val & 1) <= 0) break;
                LOG.error("{} Not supported: IRL Interrupt vector mode: External Vector", (Object)this.cpu);
            }
        }
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int reg, Size size) {
        return S32xUtil.readBuffer(this.regs, reg, size);
    }

    private void setIntMasked(int ipt, boolean isValid) {
        boolean val = this.intValid[ipt];
        if (val != isValid) {
            this.intValid[ipt] = isValid;
            boolean isPending = this.intPending[ipt];
            boolean isTrigger = this.intTrigger[ipt];
            if (ipt == IntControl.Sh2Interrupt.CMD_8.ordinal()) {
                this.intTrigger[ipt] = isValid && isPending;
            }
            this.resetInterruptLevel();
            this.logInfo("MASK", ipt);
        }
    }

    @Override
    public void setIntsMasked(int value) {
        for (int i = 0; i < 4; ++i) {
            int imask = value & 1 << i;
            int sh2Int = 6 + (i << 1);
            this.setIntMasked(sh2Int, imask > 0);
        }
    }

    @Override
    public void reloadSh2IntMask() {
        int newVal = Util.readBufferWord((ByteBuffer)this.sh2_int_mask, (int)S32xDict.RegSpecS32x.SH2_INT_MASK.addr);
        this.setIntsMasked(newVal & 0xF);
    }

    @Override
    public void setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType deviceType, IntControl.OnChipSubType subType) {
        int data = subType == IntControl.OnChipSubType.DMA_C1 ? 1 : 0;
        data = subType == IntControl.OnChipSubType.RXI ? 1 : data;
        this.setExternalIntPending(deviceType, data, true);
    }

    @Override
    public void setIntPending(IntControl.Sh2Interrupt interrupt, boolean isPending) {
        this.setIntPending(interrupt.ordinal(), isPending);
    }

    public void setExternalIntPending(Sh2DeviceHelper.Sh2DeviceType deviceType, int intData, boolean isPending) {
        int level = this.onChipDevicePriority.get((Object)deviceType);
        if (this.interruptLevel > 0 && this.interruptLevel < level) {
            LOG.info("{} {}{} ext interrupt pending: {}, level: {}", new Object[]{this.cpu, deviceType, intData, level, this.interruptLevel});
        }
        if (level > 0) {
            this.setIntPending(level, isPending);
            this.additionalIntData = intData;
        }
    }

    @Override
    public int readSh2IntMaskReg(int pos, Size size) {
        return S32xUtil.readBuffer(this.sh2_int_mask, pos, size);
    }

    private void setIntPending(int ipt, boolean isPending) {
        boolean valid;
        boolean val = this.intPending[ipt];
        if (val != isPending && (valid = this.intValid[ipt])) {
            this.intPending[ipt] = isPending;
            boolean bl = this.intTrigger[ipt] = valid && isPending;
            if (valid && isPending) {
                this.resetInterruptLevel();
            }
            this.logInfo("PENDING", ipt);
        }
    }

    private void resetInterruptLevel() {
        boolean[] ints = this.intTrigger;
        int newLevel = 0;
        int prev = this.interruptLevel;
        for (int i = 16; i >= 0; --i) {
            if (!ints[i]) continue;
            newLevel = i;
            break;
        }
        this.interruptLevel = newLevel;
        this.fireInterruptSysEventMaybe(prev);
    }

    private void fireInterruptSysEventMaybe(int prevLevel) {
        Ow2DrcOptimizer.PollerCtx ctx;
        if (this.interruptLevel != prevLevel && this.interruptLevel > 0 && (ctx = PollSysEventManager.instance.getPoller(this.cpu)) != Ow2DrcOptimizer.NO_POLLER && (ctx.isPollingActive() || ctx.isPollingBusyLoop())) {
            PollSysEventManager.instance.fireSysEvent(this.cpu, PollSysEventManager.SysEvent.INT);
        }
    }

    @Override
    public void clearInterrupt(IntControl.Sh2Interrupt intType) {
        this.clearInterrupt(intType.ordinal());
    }

    public void clearInterrupt(int ipt) {
        this.intPending[ipt] = false;
        this.intTrigger[ipt] = false;
        this.resetInterruptLevel();
        this.logInfo("CLEAR", ipt);
    }

    @Override
    public void clearCurrentInterrupt() {
        this.clearInterrupt(this.interruptLevel);
    }

    @Override
    public int getInterruptLevel() {
        return this.interruptLevel;
    }

    @Override
    public int getVectorNumber() {
        IntControl.Sh2Interrupt intType = intVals[this.interruptLevel];
        boolean onChipLevel = this.onChipLevels[this.interruptLevel];
        if (onChipLevel && intType.internal != 0) {
            LOG.warn("{} OnChipDevice interrupt using the same level as an internal interrupt: {}", (Object)this.cpu, (Object)this.interruptLevel);
        }
        if (onChipLevel || intType.internal == 0) {
            return this.getExternalDeviceVectorNumber();
        }
        if (intType == IntControl.Sh2Interrupt.NMI_16) {
            return 11;
        }
        return 64 + (this.interruptLevel >> 1);
    }

    @Override
    public IntControl.InterruptContext getInterruptContext() {
        throw new RuntimeException("Unexpected!");
    }

    private int getExternalDeviceVectorNumber() {
        Sh2DeviceHelper.Sh2DeviceType deviceType = Sh2DeviceHelper.Sh2DeviceType.NONE;
        for (Map.Entry<Sh2DeviceHelper.Sh2DeviceType, Integer> entry : this.onChipDevicePriority.entrySet()) {
            if (this.interruptLevel != entry.getValue()) continue;
            deviceType = entry.getKey();
            break;
        }
        int vn = -1;
        switch (deviceType) {
            case DMA: {
                vn = Util.readBufferLong((ByteBuffer)this.regs, (int)(Sh2Dict.RegSpecSh2.INTC_VCRDMA0.addr + (this.additionalIntData << 3))) & 0x7F;
                break;
            }
            case WDT: {
                vn = Util.readBufferByte((ByteBuffer)this.regs, (int)Sh2Dict.RegSpecSh2.INTC_VCRWDT.addr) & 0x7F;
                break;
            }
            case DIV: {
                vn = Util.readBufferByte((ByteBuffer)this.regs, (int)Sh2Dict.RegSpecSh2.INTC_VCRDIV.addr) & 0x7F;
                break;
            }
            case SCI: {
                int pos = this.additionalIntData == 1 ? Sh2Dict.RegSpecSh2.INTC_VCRA.addr + 1 : Sh2Dict.RegSpecSh2.INTC_VCRB.addr;
                vn = Util.readBufferByte((ByteBuffer)this.regs, (int)pos) & 0x7F;
                break;
            }
            case FRT: {
                vn = Util.readBufferByte((ByteBuffer)this.regs, (int)Sh2Dict.RegSpecSh2.INTC_VCRD.addr) & 0x7F;
                break;
            }
            case NONE: {
                break;
            }
            default: {
                LOG.error("{} Unhandled interrupt for device: {}, level: {}", new Object[]{this.cpu, deviceType, this.interruptLevel});
            }
        }
        return vn;
    }

    @Override
    public ByteBuffer getSh2_int_mask_regs() {
        return this.sh2_int_mask;
    }

    private void logInfo(String action, int ipt) {
    }

    private void logOnChipIntLevel(Sh2Dict.RegSpecSh2 regSpec, int val) {
        if (regSpec == Sh2Dict.RegSpecSh2.INTC_IPRA) {
            LOG.info("{} set IPRA levels, {}:{}, {}:{}, {}:{}", new Object[]{this.cpu, Sh2DeviceHelper.Sh2DeviceType.DIV, val >> 12, Sh2DeviceHelper.Sh2DeviceType.DMA, val >> 8 & 0xF, Sh2DeviceHelper.Sh2DeviceType.WDT, val >> 4 & 0xF});
        } else if (regSpec == Sh2Dict.RegSpecSh2.INTC_IPRB) {
            LOG.info("{} set IPRB levels, {}:{}, {}:{}", new Object[]{this.cpu, Sh2DeviceHelper.Sh2DeviceType.SCI, val >> 12, Sh2DeviceHelper.Sh2DeviceType.FRT, val >> 8 & 0xF});
        }
    }
}

