/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.prefetch;

import java.util.StringJoiner;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Instructions;
import s32x.sh2.cache.Sh2Cache;
import s32x.util.S32xUtil;

public interface Sh2Prefetcher {
    public static final Logger LOG = LogHelper.getLogger((String)Sh2Prefetcher.class.getSimpleName());
    public static final boolean verbose = false;

    public void fetch(Sh2.FetchResult var1, S32xUtil.CpuDeviceAccess var2);

    public int fetchDelaySlot(int var1, Sh2.FetchResult var2, S32xUtil.CpuDeviceAccess var3);

    public void invalidateCachePrefetch(Sh2Cache.CacheInvalidateContext var1);

    default public void dataWrite(S32xUtil.CpuDeviceAccess cpu, int addr, int val, Size size) {
    }

    default public void newFrame() {
    }

    public static class Stats {
        static String format = "%s pfTot: %d, pfMissPerc: %f, pfDsMissPerc: %f";
        public long pfMiss;
        public long pfTotal;
        public long pfDsMiss;
        private final S32xUtil.CpuDeviceAccess cpu;

        public Stats(S32xUtil.CpuDeviceAccess cpu) {
            this.cpu = cpu;
        }

        public String toString() {
            return String.format(format, new Object[]{this.cpu, this.pfTotal, 1.0 * (double)this.pfMiss / (double)this.pfTotal, 1.0 * (double)this.pfDsMiss / (double)this.pfTotal});
        }

        public void addMiss() {
            if ((++this.pfMiss & 0xFFL) == 0L) {
                LOG.info(this.toString());
            }
        }

        public void addDelaySlotMiss() {
            this.addMiss();
            ++this.pfDsMiss;
        }
    }

    public static class Sh2BlockUnit
    extends Sh2Instructions.Sh2InstructionWrapper {
        public Sh2BlockUnit next;
        public int pc;

        public Sh2BlockUnit(Sh2Instructions.Sh2InstructionWrapper i) {
            super(i.opcode, i.inst, i.runnable);
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", Sh2BlockUnit.class.getSimpleName() + "[", "]").add("pc=" + this.pc).add("inst=" + this.inst).add("opcode=" + this.opcode).toString();
        }
    }
}

