/*
 * Decompiled with CFR 0.152.
 */
package s32x.util.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;

public class MemAccessStats {
    private static final Logger LOG = LogHelper.getLogger((String)MemAccessStats.class.getSimpleName());
    public static final MemAccessStats NO_STATS = new MemAccessStats();
    static final long printCnt = 0x2000000L;
    static final long printCntMask = 0x1FFFFFFL;
    long[][] readHits = Sh2Bus.SH2_MEM_ACCESS_STATS ? new long[3][256] : null;
    long[][] writeHits = Sh2Bus.SH2_MEM_ACCESS_STATS ? new long[3][256] : null;
    long cnt = 0L;
    long readCnt;
    static final Function<Map<String, Double>, String> mapToStr = m -> m.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(Objects::toString).collect(Collectors.joining("\n"));

    public void addMemHit(boolean read, int address, Size size) {
        long[][] ref = read ? this.readHits : this.writeHits;
        int idx = size.ordinal();
        long[] lArray = ref[size.ordinal()];
        int n = address >>> 24 & 0xFF;
        lArray[n] = lArray[n] + 1L;
        this.readCnt += read ? 1L : 0L;
        if ((++this.cnt & 0x1FFFFFFL) == 0L) {
            HashMap<String, Double> rm = new HashMap<String, Double>();
            HashMap<String, Double> wm = new HashMap<String, Double>();
            long writeCnt = this.cnt - this.readCnt;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < ref[i].length; ++j) {
                    if (this.readHits[i][j] > 0L) {
                        this.addStatString("read, ", this.readHits[i][j], i, j, rm);
                    }
                    if (this.writeHits[i][j] <= 0L) continue;
                    this.addStatString("write, ", this.writeHits[i][j], i, j, wm);
                }
            }
            LOG.info(Util.th((long)this.cnt) + "\n" + mapToStr.apply(rm));
            LOG.info(Util.th((long)this.cnt) + "\n" + mapToStr.apply(wm));
        }
    }

    private void addStatString(String head, long cnt, int i, int j, Map<String, Double> map) {
        if (cnt > 0L) {
            String s = head + Size.values()[i] + "," + Util.th((int)j) + "," + cnt;
            double readPerc = 100.0 * (double)cnt / (double)this.readCnt;
            double totPerc = 100.0 * (double)cnt / (double)cnt;
            map.put(s, readPerc);
        }
    }
}

